// Code generated by smithy-go-codegen DO NOT EDIT.

package autoscaling

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Completes the lifecycle action for the specified token or instance with the
// specified result. This step is a part of the procedure for adding a lifecycle
// hook to an Auto Scaling group:
//
// * (Optional) Create a Lambda function and a rule
// that allows CloudWatch Events to invoke your Lambda function when Amazon EC2
// Auto Scaling launches or terminates instances.
//
// * (Optional) Create a
// notification target and an IAM role. The target can be either an Amazon SQS
// queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish
// lifecycle notifications to the target.
//
// * Create the lifecycle hook. Specify
// whether the hook is used when the instances launch or terminate.
//
// * If you need
// more time, record the lifecycle action heartbeat to keep the instance in a
// pending state.
//
// * If you finish before the timeout period ends, complete the
// lifecycle action.
//
// For more information, see Amazon EC2 Auto Scaling lifecycle
// hooks
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in
// the Amazon EC2 Auto Scaling User Guide.
func (c *Client) CompleteLifecycleAction(ctx context.Context, params *CompleteLifecycleActionInput, optFns ...func(*Options)) (*CompleteLifecycleActionOutput, error) {
	if params == nil {
		params = &CompleteLifecycleActionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CompleteLifecycleAction", params, optFns, c.addOperationCompleteLifecycleActionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CompleteLifecycleActionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CompleteLifecycleActionInput struct {

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// The action for the group to take. This parameter can be either CONTINUE or
	// ABANDON.
	//
	// This member is required.
	LifecycleActionResult *string

	// The name of the lifecycle hook.
	//
	// This member is required.
	LifecycleHookName *string

	// The ID of the instance.
	InstanceId *string

	// A universally unique identifier (UUID) that identifies a specific lifecycle
	// action associated with an instance. Amazon EC2 Auto Scaling sends this token to
	// the notification target you specified when you created the lifecycle hook.
	LifecycleActionToken *string

	noSmithyDocumentSerde
}

type CompleteLifecycleActionOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCompleteLifecycleActionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCompleteLifecycleAction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCompleteLifecycleAction{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCompleteLifecycleActionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCompleteLifecycleAction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCompleteLifecycleAction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "autoscaling",
		OperationName: "CompleteLifecycleAction",
	}
}
