// Code generated by smithy-go-codegen DO NOT EDIT.

package mgn

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mgn/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Put source server post migration custom action.
func (c *Client) PutSourceServerAction(ctx context.Context, params *PutSourceServerActionInput, optFns ...func(*Options)) (*PutSourceServerActionOutput, error) {
	if params == nil {
		params = &PutSourceServerActionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutSourceServerAction", params, optFns, c.addOperationPutSourceServerActionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutSourceServerActionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutSourceServerActionInput struct {

	// Source server post migration custom action ID.
	//
	// This member is required.
	ActionID *string

	// Source server post migration custom action name.
	//
	// This member is required.
	ActionName *string

	// Source server post migration custom action document identifier.
	//
	// This member is required.
	DocumentIdentifier *string

	// Source server post migration custom action order.
	//
	// This member is required.
	Order *int32

	// Source server ID.
	//
	// This member is required.
	SourceServerID *string

	// Source server post migration custom account ID.
	AccountID *string

	// Source server post migration custom action active status.
	Active *bool

	// Source server post migration custom action category.
	Category types.ActionCategory

	// Source server post migration custom action description.
	Description *string

	// Source server post migration custom action document version.
	DocumentVersion *string

	// Source server post migration custom action external parameters.
	ExternalParameters map[string]types.SsmExternalParameter

	// Source server post migration custom action must succeed for cutover.
	MustSucceedForCutover *bool

	// Source server post migration custom action parameters.
	Parameters map[string][]types.SsmParameterStoreParameter

	// Source server post migration custom action timeout in seconds.
	TimeoutSeconds *int32

	noSmithyDocumentSerde
}

type PutSourceServerActionOutput struct {

	// Source server post migration custom action ID.
	ActionID *string

	// Source server post migration custom action name.
	ActionName *string

	// Source server post migration custom action active status.
	Active *bool

	// Source server post migration custom action category.
	Category types.ActionCategory

	// Source server post migration custom action description.
	Description *string

	// Source server post migration custom action document identifier.
	DocumentIdentifier *string

	// Source server post migration custom action document version.
	DocumentVersion *string

	// Source server post migration custom action external parameters.
	ExternalParameters map[string]types.SsmExternalParameter

	// Source server post migration custom action must succeed for cutover.
	MustSucceedForCutover *bool

	// Source server post migration custom action order.
	Order *int32

	// Source server post migration custom action parameters.
	Parameters map[string][]types.SsmParameterStoreParameter

	// Source server post migration custom action timeout in seconds.
	TimeoutSeconds *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutSourceServerActionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutSourceServerAction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutSourceServerAction{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutSourceServerAction"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutSourceServerActionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutSourceServerAction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutSourceServerAction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutSourceServerAction",
	}
}
