// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This operation is used with the Amazon GameLift Servers FleetIQ solution and
//
// game server groups.
//
// Updates information about a registered game server to help Amazon GameLift
// Servers FleetIQ track game server availability. This operation is called by a
// game server process that is running on an instance in a game server group.
//
// Use this operation to update the following types of game server information.
// You can make all three types of updates in the same request:
//
//   - To update the game server's utilization status from AVAILABLE (when the game
//     server is available to be claimed) to UTILIZED (when the game server is
//     currently hosting games). Identify the game server and game server group and
//     specify the new utilization status. You can't change the status from to
//     UTILIZED to AVAILABLE .
//
//   - To report health status, identify the game server and game server group and
//     set health check to HEALTHY . If a game server does not report health status
//     for a certain length of time, the game server is no longer considered healthy.
//     As a result, it will be eventually deregistered from the game server group to
//     avoid affecting utilization metrics. The best practice is to report health every
//     60 seconds.
//
//   - To change game server metadata, provide updated game server data.
//
// Once a game server is successfully updated, the relevant statuses and
// timestamps are updated.
//
// # Learn more
//
// [Amazon GameLift Servers FleetIQ Guide]
//
// [Amazon GameLift Servers FleetIQ Guide]: https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html
func (c *Client) UpdateGameServer(ctx context.Context, params *UpdateGameServerInput, optFns ...func(*Options)) (*UpdateGameServerOutput, error) {
	if params == nil {
		params = &UpdateGameServerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGameServer", params, optFns, c.addOperationUpdateGameServerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGameServerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGameServerInput struct {

	// A unique identifier for the game server group where the game server is running.
	//
	// This member is required.
	GameServerGroupName *string

	// A custom string that uniquely identifies the game server to update.
	//
	// This member is required.
	GameServerId *string

	// A set of custom game server properties, formatted as a single string value.
	// This data is passed to a game client or service when it requests information on
	// game servers.
	GameServerData *string

	// Indicates health status of the game server. A request that includes this
	// parameter updates the game server's LastHealthCheckTime timestamp.
	HealthCheck types.GameServerHealthCheck

	// Indicates if the game server is available or is currently hosting gameplay. You
	// can update a game server status from AVAILABLE to UTILIZED , but you can't
	// change a the status from UTILIZED to AVAILABLE .
	UtilizationStatus types.GameServerUtilizationStatus

	noSmithyDocumentSerde
}

type UpdateGameServerOutput struct {

	// Object that describes the newly updated game server.
	GameServer *types.GameServer

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGameServerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateGameServer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateGameServer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGameServer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateGameServerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGameServer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateGameServer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGameServer",
	}
}
