// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an S3 access point and attaches it to an Amazon FSx volume. For FSx for
// OpenZFS file systems, the volume must be hosted on a high-availability file
// system, either Single-AZ or Multi-AZ. For more information, see [Accessing your data using Amazon S3 access points]. in the Amazon
// FSx for OpenZFS User Guide.
//
// The requester requires the following permissions to perform these actions:
//
//   - fsx:CreateAndAttachS3AccessPoint
//
//   - s3:CreateAccessPoint
//
//   - s3:GetAccessPoint
//
//   - s3:PutAccessPointPolicy
//
//   - s3:DeleteAccessPoint
//
// The following actions are related to CreateAndAttachS3AccessPoint :
//
// # DescribeS3AccessPointAttachments
//
// # DetachAndDeleteS3AccessPoint
//
// [Accessing your data using Amazon S3 access points]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/s3accesspoints-for-FSx.html
func (c *Client) CreateAndAttachS3AccessPoint(ctx context.Context, params *CreateAndAttachS3AccessPointInput, optFns ...func(*Options)) (*CreateAndAttachS3AccessPointOutput, error) {
	if params == nil {
		params = &CreateAndAttachS3AccessPointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAndAttachS3AccessPoint", params, optFns, c.addOperationCreateAndAttachS3AccessPointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAndAttachS3AccessPointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAndAttachS3AccessPointInput struct {

	// The name you want to assign to this S3 access point.
	//
	// This member is required.
	Name *string

	// The type of S3 access point you want to create. Only OpenZFS is supported.
	//
	// This member is required.
	Type types.S3AccessPointAttachmentType

	// (Optional) An idempotency token for resource creation, in a string of up to 63
	// ASCII characters. This token is automatically filled on your behalf when you use
	// the Command Line Interface (CLI) or an Amazon Web Services SDK.
	ClientRequestToken *string

	// Specifies the configuration to use when creating and attaching an S3 access
	// point to an FSx for OpenZFS volume.
	OpenZFSConfiguration *types.CreateAndAttachS3AccessPointOpenZFSConfiguration

	// Specifies the virtual private cloud (VPC) configuration if you're creating an
	// access point that is restricted to a VPC. For more information, see [Creating access points restricted to a virtual private cloud].
	//
	// [Creating access points restricted to a virtual private cloud]: https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/access-points-vpc.html
	S3AccessPoint *types.CreateAndAttachS3AccessPointS3Configuration

	noSmithyDocumentSerde
}

type CreateAndAttachS3AccessPointOutput struct {

	// Describes the configuration of the S3 access point created.
	S3AccessPointAttachment *types.S3AccessPointAttachment

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAndAttachS3AccessPointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateAndAttachS3AccessPoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateAndAttachS3AccessPoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAndAttachS3AccessPoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAndAttachS3AccessPointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAndAttachS3AccessPointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAndAttachS3AccessPoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAndAttachS3AccessPoint struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAndAttachS3AccessPoint) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAndAttachS3AccessPoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAndAttachS3AccessPointInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAndAttachS3AccessPointInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAndAttachS3AccessPointMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAndAttachS3AccessPoint{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAndAttachS3AccessPoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAndAttachS3AccessPoint",
	}
}
