// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

//	The summary of the rewards granted as a result of activities completed.
//
// The following types satisfy this interface:
//
//	ActivityRewardMemberCredit
type ActivityReward interface {
	isActivityReward()
}

// The credits gained by activity rewards.
type ActivityRewardMemberCredit struct {
	Value MonetaryAmount

	noSmithyDocumentSerde
}

func (*ActivityRewardMemberCredit) isActivityReward() {}

// The summary of activities.
type ActivitySummary struct {

	//  A unique identifier that identifies the activity.
	//
	// This member is required.
	ActivityId *string

	//  The reward for the activity.
	//
	// This member is required.
	Reward ActivityReward

	//  The current status of the activity.
	//
	// This member is required.
	Status ActivityStatus

	//  The title of the activity.
	//
	// This member is required.
	Title *string

	noSmithyDocumentSerde
}

// Contains the specifications for the filters to use for your request.
type DimensionValues struct {

	// The name of the dimension that you want to filter on.
	//
	// This member is required.
	Key Dimension

	// The match options that you can use to filter your results. You can specify only
	// one of these values in the array.
	//
	// This member is required.
	MatchOptions []MatchOption

	// The metadata values you can specify to filter upon, so that the results all
	// match at least one of the specified values.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Use Expression to filter in the GetFreeTierUsage API operation.
//
// You can use the following patterns:
//
//   - Simple dimension values ( Dimensions root operator)
//
//   - Complex expressions with logical operators ( AND , NOT , and OR root
//     operators).
//
// For simple dimension values, you can set the dimension name, values, and match
// type for the filters that you plan to use.
//
// # Example for simple dimension values
//
// You can filter to match exactly for REGION==us-east-1 OR REGION==us-west-1 .
//
// The corresponding Expression appears like the following: { "Dimensions": {
// "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ], "MatchOptions":
// ["EQUALS"] } }
//
// As shown in the previous example, lists of dimension values are combined with OR
// when you apply the filter.
//
// For complex expressions with logical operators, you can have nested expressions
// to use the logical operators and specify advanced filtering.
//
// # Example for complex expressions with logical operators
//
// You can filter by ((REGION == us-east-1 OR REGION == us-west-1) OR (SERVICE
// CONTAINS AWSLambda)) AND (USAGE_TYPE !CONTAINS DataTransfer) .
//
// The corresponding Expression appears like the following: { "And": [ {"Or": [
// {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ],
// "MatchOptions": ["EQUALS"] }}, {"Dimensions": { "Key": "SERVICE", "Values":
// ["AWSLambda"], "MatchOptions": ["CONTAINS"] } } ]}, {"Not": {"Dimensions": {
// "Key": "USAGE_TYPE", "Values": ["DataTransfer"], "MatchOptions": ["CONTAINS"]
// }}} ] }
//
// In the following Contents, you must specify exactly one of the following root
// operators.
type Expression struct {

	// Return results that match all Expressions that you specified in the array.
	And []Expression

	// The specific dimension, values, and match type to filter objects with.
	Dimensions *DimensionValues

	// Return results that don’t match the Expression that you specified.
	Not *Expression

	// Return results that match any of the Expressions that you specified. in the
	// array.
	Or []Expression

	noSmithyDocumentSerde
}

// Consists of a Amazon Web Services Free Tier offer’s metadata and your data
// usage for the offer.
type FreeTierUsage struct {

	// Describes the actual usage accrued month-to-day (MTD) that you've used so far.
	ActualUsageAmount float64

	// The description of the Free Tier offer.
	Description *string

	// Describes the forecasted usage by the month that you're expected to use.
	ForecastedUsageAmount float64

	// Describes the type of the Free Tier offer. For example, the offer can be "12
	// Months Free" , "Always Free" , and "Free Trial" .
	FreeTierType *string

	// Describes the maximum usage allowed in Free Tier.
	Limit float64

	// Describes usageType more granularly with the specific Amazon Web Services
	// service API operation. For example, this can be the RunInstances API operation
	// for Amazon Elastic Compute Cloud.
	Operation *string

	// Describes the Amazon Web Services Region for which this offer is applicable
	Region *string

	// The name of the Amazon Web Services service providing the Free Tier offer. For
	// example, this can be Amazon Elastic Compute Cloud.
	Service *string

	// Describes the unit of the usageType , such as Hrs .
	Unit *string

	// Describes the usage details of the offer. For example, this might be
	// Global-BoxUsage:freetrial .
	UsageType *string

	noSmithyDocumentSerde
}

// The monetary amount of the credit.
type MonetaryAmount struct {

	//  The aggregated monetary amount of credits earned.
	//
	// This member is required.
	Amount float64

	//  The unit that the monetary amount is given in.
	//
	// This member is required.
	Unit CurrencyCode

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isActivityReward() {}
