// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates and initializes a browser session in Amazon Bedrock. The session
// enables agents to navigate and interact with web content, extract information
// from websites, and perform web-based tasks as part of their response generation.
//
// To create a session, you must specify a browser identifier and a name. You can
// also configure the viewport dimensions to control the visible area of web
// content. The session remains active until it times out or you explicitly stop it
// using the StopBrowserSession operation.
//
// The following operations are related to StartBrowserSession :
//
// [GetBrowserSession]
//
// [UpdateBrowserStream]
//
// [StopBrowserSession]
//
// [UpdateBrowserStream]: https://docs.aws.amazon.com/API_UpdateBrowserStream.html
// [GetBrowserSession]: https://docs.aws.amazon.com/API_GetBrowserSession.html
// [StopBrowserSession]: https://docs.aws.amazon.com/API_StopBrowserSession.html
func (c *Client) StartBrowserSession(ctx context.Context, params *StartBrowserSessionInput, optFns ...func(*Options)) (*StartBrowserSessionOutput, error) {
	if params == nil {
		params = &StartBrowserSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartBrowserSession", params, optFns, c.addOperationStartBrowserSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartBrowserSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartBrowserSessionInput struct {

	// The unique identifier of the browser to use for this session. This identifier
	// specifies which browser environment to initialize for the session.
	//
	// This member is required.
	BrowserIdentifier *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. This parameter helps prevent
	// the creation of duplicate sessions if there are temporary network issues.
	ClientToken *string

	// The name of the browser session. This name helps you identify and manage the
	// session. The name does not need to be unique.
	Name *string

	// The time in seconds after which the session automatically terminates if there
	// is no activity. The default value is 3600 seconds (1 hour). The minimum allowed
	// value is 60 seconds, and the maximum allowed value is 28800 seconds (8 hours).
	SessionTimeoutSeconds *int32

	// The dimensions of the browser viewport for this session. This determines the
	// visible area of the web content and affects how web pages are rendered. If not
	// specified, Amazon Bedrock uses a default viewport size.
	ViewPort *types.ViewPort

	noSmithyDocumentSerde
}

type StartBrowserSessionOutput struct {

	// The identifier of the browser.
	//
	// This member is required.
	BrowserIdentifier *string

	// The timestamp when the browser session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the created browser session.
	//
	// This member is required.
	SessionId *string

	// The streams associated with this browser session. These include the automation
	// stream and live view stream.
	Streams *types.BrowserSessionStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartBrowserSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartBrowserSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartBrowserSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartBrowserSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartBrowserSessionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartBrowserSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartBrowserSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartBrowserSession struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartBrowserSession) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartBrowserSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartBrowserSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartBrowserSessionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartBrowserSessionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartBrowserSession{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartBrowserSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartBrowserSession",
	}
}
