// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches for and retrieves memory records from an AgentCore Memory resource
// based on specified search criteria. We recommend using pagination to ensure that
// the operation returns quickly and successfully.
//
// To use this operation, you must have the bedrock-agentcore:RetrieveMemoryRecords
// permission.
func (c *Client) RetrieveMemoryRecords(ctx context.Context, params *RetrieveMemoryRecordsInput, optFns ...func(*Options)) (*RetrieveMemoryRecordsOutput, error) {
	if params == nil {
		params = &RetrieveMemoryRecordsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RetrieveMemoryRecords", params, optFns, c.addOperationRetrieveMemoryRecordsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RetrieveMemoryRecordsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RetrieveMemoryRecordsInput struct {

	// The identifier of the AgentCore Memory resource from which to retrieve memory
	// records.
	//
	// This member is required.
	MemoryId *string

	// The namespace to filter memory records by. If specified, only memory records in
	// this namespace are searched.
	//
	// This member is required.
	Namespace *string

	// The search criteria to use for finding relevant memory records. This includes
	// the search query, memory strategy ID, and other search parameters.
	//
	// This member is required.
	SearchCriteria *types.SearchCriteria

	// The maximum number of results to return in a single call. Minimum value of 1,
	// maximum value of 100. Default is 20.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type RetrieveMemoryRecordsOutput struct {

	// The list of memory record summaries that match the search criteria, ordered by
	// relevance.
	//
	// This member is required.
	MemoryRecordSummaries []types.MemoryRecordSummary

	// The token to use in a subsequent request to get the next set of results. This
	// value is null when there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRetrieveMemoryRecordsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRetrieveMemoryRecords{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRetrieveMemoryRecords{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RetrieveMemoryRecords"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRetrieveMemoryRecordsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRetrieveMemoryRecords(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// RetrieveMemoryRecordsPaginatorOptions is the paginator options for
// RetrieveMemoryRecords
type RetrieveMemoryRecordsPaginatorOptions struct {
	// The maximum number of results to return in a single call. Minimum value of 1,
	// maximum value of 100. Default is 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// RetrieveMemoryRecordsPaginator is a paginator for RetrieveMemoryRecords
type RetrieveMemoryRecordsPaginator struct {
	options   RetrieveMemoryRecordsPaginatorOptions
	client    RetrieveMemoryRecordsAPIClient
	params    *RetrieveMemoryRecordsInput
	nextToken *string
	firstPage bool
}

// NewRetrieveMemoryRecordsPaginator returns a new RetrieveMemoryRecordsPaginator
func NewRetrieveMemoryRecordsPaginator(client RetrieveMemoryRecordsAPIClient, params *RetrieveMemoryRecordsInput, optFns ...func(*RetrieveMemoryRecordsPaginatorOptions)) *RetrieveMemoryRecordsPaginator {
	if params == nil {
		params = &RetrieveMemoryRecordsInput{}
	}

	options := RetrieveMemoryRecordsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &RetrieveMemoryRecordsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *RetrieveMemoryRecordsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next RetrieveMemoryRecords page.
func (p *RetrieveMemoryRecordsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*RetrieveMemoryRecordsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.RetrieveMemoryRecords(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// RetrieveMemoryRecordsAPIClient is a client that implements the
// RetrieveMemoryRecords operation.
type RetrieveMemoryRecordsAPIClient interface {
	RetrieveMemoryRecords(context.Context, *RetrieveMemoryRecordsInput, ...func(*Options)) (*RetrieveMemoryRecordsOutput, error)
}

var _ RetrieveMemoryRecordsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opRetrieveMemoryRecords(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RetrieveMemoryRecords",
	}
}
