// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists custom model deployments in your account. You can filter the results by
// creation time, name, status, and associated model. Use this operation to manage
// and monitor your custom model deployments.
//
// We recommend using pagination to ensure that the operation returns quickly and
// successfully.
//
// The following actions are related to the ListCustomModelDeployments operation:
//
// [CreateCustomModelDeployment]
//
// [GetCustomModelDeployment]
//
// [DeleteCustomModelDeployment]
//
// [GetCustomModelDeployment]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html
// [CreateCustomModelDeployment]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html
// [DeleteCustomModelDeployment]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html
func (c *Client) ListCustomModelDeployments(ctx context.Context, params *ListCustomModelDeploymentsInput, optFns ...func(*Options)) (*ListCustomModelDeploymentsOutput, error) {
	if params == nil {
		params = &ListCustomModelDeploymentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCustomModelDeployments", params, optFns, c.addOperationListCustomModelDeploymentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCustomModelDeploymentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCustomModelDeploymentsInput struct {

	// Filters deployments created after the specified date and time.
	CreatedAfter *time.Time

	// Filters deployments created before the specified date and time.
	CreatedBefore *time.Time

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// Filters deployments by the Amazon Resource Name (ARN) of the associated custom
	// model.
	ModelArnEquals *string

	// Filters deployments whose names contain the specified string.
	NameContains *string

	// The token for the next set of results. Use this token to retrieve additional
	// results when the response is truncated.
	NextToken *string

	// The field to sort the results by. The only supported value is CreationTime .
	SortBy types.SortModelsBy

	// The sort order for the results. Valid values are Ascending and Descending .
	// Default is Descending .
	SortOrder types.SortOrder

	// Filters deployments by status. Valid values are CREATING , ACTIVE , and FAILED .
	StatusEquals types.CustomModelDeploymentStatus

	noSmithyDocumentSerde
}

type ListCustomModelDeploymentsOutput struct {

	// A list of custom model deployment summaries.
	ModelDeploymentSummaries []types.CustomModelDeploymentSummary

	// The token for the next set of results. This value is null when there are no
	// more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCustomModelDeploymentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCustomModelDeployments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCustomModelDeployments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCustomModelDeployments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCustomModelDeployments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCustomModelDeploymentsPaginatorOptions is the paginator options for
// ListCustomModelDeployments
type ListCustomModelDeploymentsPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCustomModelDeploymentsPaginator is a paginator for
// ListCustomModelDeployments
type ListCustomModelDeploymentsPaginator struct {
	options   ListCustomModelDeploymentsPaginatorOptions
	client    ListCustomModelDeploymentsAPIClient
	params    *ListCustomModelDeploymentsInput
	nextToken *string
	firstPage bool
}

// NewListCustomModelDeploymentsPaginator returns a new
// ListCustomModelDeploymentsPaginator
func NewListCustomModelDeploymentsPaginator(client ListCustomModelDeploymentsAPIClient, params *ListCustomModelDeploymentsInput, optFns ...func(*ListCustomModelDeploymentsPaginatorOptions)) *ListCustomModelDeploymentsPaginator {
	if params == nil {
		params = &ListCustomModelDeploymentsInput{}
	}

	options := ListCustomModelDeploymentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCustomModelDeploymentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCustomModelDeploymentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCustomModelDeployments page.
func (p *ListCustomModelDeploymentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCustomModelDeploymentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCustomModelDeployments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCustomModelDeploymentsAPIClient is a client that implements the
// ListCustomModelDeployments operation.
type ListCustomModelDeploymentsAPIClient interface {
	ListCustomModelDeployments(context.Context, *ListCustomModelDeploymentsInput, ...func(*Options)) (*ListCustomModelDeploymentsOutput, error)
}

var _ ListCustomModelDeploymentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCustomModelDeployments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCustomModelDeployments",
	}
}
