// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a test for an Automated Reasoning policy. Tests validate that your
// policy works as expected by providing sample inputs and expected outcomes. Use
// tests to verify policy behavior before deploying to production.
func (c *Client) CreateAutomatedReasoningPolicyTestCase(ctx context.Context, params *CreateAutomatedReasoningPolicyTestCaseInput, optFns ...func(*Options)) (*CreateAutomatedReasoningPolicyTestCaseOutput, error) {
	if params == nil {
		params = &CreateAutomatedReasoningPolicyTestCaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAutomatedReasoningPolicyTestCase", params, optFns, c.addOperationCreateAutomatedReasoningPolicyTestCaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAutomatedReasoningPolicyTestCaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAutomatedReasoningPolicyTestCaseInput struct {

	// The expected result of the Automated Reasoning check. Valid values include: ,
	// TOO_COMPLEX, and NO_TRANSLATIONS.
	//
	//   - VALID - The claims are true. The claims are implied by the premises and the
	//   Automated Reasoning policy. Given the Automated Reasoning policy and premises,
	//   it is not possible for these claims to be false. In other words, there are no
	//   alternative answers that are true that contradict the claims.
	//
	//   - INVALID - The claims are false. The claims are not implied by the premises
	//   and Automated Reasoning policy. Furthermore, there exists different claims that
	//   are consistent with the premises and Automated Reasoning policy.
	//
	//   - SATISFIABLE - The claims can be true or false. It depends on what
	//   assumptions are made for the claim to be implied from the premises and Automated
	//   Reasoning policy rules. In this situation, different assumptions can make input
	//   claims false and alternative claims true.
	//
	//   - IMPOSSIBLE - Automated Reasoning can’t make a statement about the claims.
	//   This can happen if the premises are logically incorrect, or if there is a
	//   conflict within the Automated Reasoning policy itself.
	//
	//   - TRANSLATION_AMBIGUOUS - Detected an ambiguity in the translation meant it
	//   would be unsound to continue with validity checking. Additional context or
	//   follow-up questions might be needed to get translation to succeed.
	//
	//   - TOO_COMPLEX - The input contains too much information for Automated
	//   Reasoning to process within its latency limits.
	//
	//   - NO_TRANSLATIONS - Identifies that some or all of the input prompt wasn't
	//   translated into logic. This can happen if the input isn't relevant to the
	//   Automated Reasoning policy, or if the policy doesn't have variables to model
	//   relevant input. If Automated Reasoning can't translate anything, you get a
	//   single NO_TRANSLATIONS finding. You might also see a NO_TRANSLATIONS (along
	//   with other findings) if some part of the validation isn't translated.
	//
	// This member is required.
	ExpectedAggregatedFindingsResult types.AutomatedReasoningCheckResult

	// The output content that's validated by the Automated Reasoning policy. This
	// represents the foundation model response that will be checked for accuracy.
	//
	// This member is required.
	GuardContent *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to
	// create the test.
	//
	// This member is required.
	PolicyArn *string

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error.
	ClientRequestToken *string

	// The minimum confidence level for logic validation. Content that meets the
	// threshold is considered a high-confidence finding that can be validated.
	ConfidenceThreshold *float64

	// The input query or prompt that generated the content. This provides context for
	// the validation.
	QueryContent *string

	noSmithyDocumentSerde
}

type CreateAutomatedReasoningPolicyTestCaseOutput struct {

	// The Amazon Resource Name (ARN) of the policy for which the test was created.
	//
	// This member is required.
	PolicyArn *string

	// The unique identifier of the created test.
	//
	// This member is required.
	TestCaseId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAutomatedReasoningPolicyTestCaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAutomatedReasoningPolicyTestCase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAutomatedReasoningPolicyTestCase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAutomatedReasoningPolicyTestCase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAutomatedReasoningPolicyTestCaseMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAutomatedReasoningPolicyTestCaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAutomatedReasoningPolicyTestCase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAutomatedReasoningPolicyTestCase struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAutomatedReasoningPolicyTestCase) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAutomatedReasoningPolicyTestCase) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAutomatedReasoningPolicyTestCaseInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAutomatedReasoningPolicyTestCaseInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAutomatedReasoningPolicyTestCaseMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAutomatedReasoningPolicyTestCase{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAutomatedReasoningPolicyTestCase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAutomatedReasoningPolicyTestCase",
	}
}
