// Code generated by smithy-go-codegen DO NOT EDIT.

package backupsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backupsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This operation retrieves metadata of a search job, including its progress.
func (c *Client) GetSearchJob(ctx context.Context, params *GetSearchJobInput, optFns ...func(*Options)) (*GetSearchJobOutput, error) {
	if params == nil {
		params = &GetSearchJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSearchJob", params, optFns, c.addOperationGetSearchJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSearchJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSearchJobInput struct {

	// Required unique string that specifies the search job.
	//
	// This member is required.
	SearchJobIdentifier *string

	noSmithyDocumentSerde
}

type GetSearchJobOutput struct {

	// The date and time that a search job was created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	//
	// This member is required.
	CreationTime *time.Time

	// Item Filters represent all input item properties specified when the search was
	// created.
	//
	// This member is required.
	ItemFilters *types.ItemFilters

	// The unique string that identifies the Amazon Resource Name (ARN) of the
	// specified search job.
	//
	// This member is required.
	SearchJobArn *string

	// The unique string that identifies the specified search job.
	//
	// This member is required.
	SearchJobIdentifier *string

	// The search scope is all backup properties input into a search.
	//
	// This member is required.
	SearchScope *types.SearchScope

	// The current status of the specified search job.
	//
	// A search job may have one of the following statuses: RUNNING ; COMPLETED ;
	// STOPPED ; FAILED ; TIMED_OUT ; or EXPIRED .
	//
	// This member is required.
	Status types.SearchJobState

	// The date and time that a search job completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionTime *time.Time

	// Returns numbers representing BackupsScannedCount, ItemsScanned, and
	// ItemsMatched.
	CurrentSearchProgress *types.CurrentSearchProgress

	// The encryption key for the specified search job.
	//
	// Example:
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab .
	EncryptionKeyArn *string

	// Returned name of the specified search job.
	Name *string

	// Returned summary of the specified search job scope, including:
	//
	//   - TotalBackupsToScanCount, the number of recovery points returned by the
	//   search.
	//
	//   - TotalItemsToScanCount, the number of items returned by the search.
	SearchScopeSummary *types.SearchScopeSummary

	// A status message will be returned for either a earch job with a status of
	// ERRORED or a status of COMPLETED jobs with issues.
	//
	// For example, a message may say that a search contained recovery points unable
	// to be scanned because of a permissions issue.
	StatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSearchJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSearchJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSearchJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSearchJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetSearchJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSearchJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSearchJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSearchJob",
	}
}
