// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribestreaming

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go-v2/service/transcribestreaming/types"
	"github.com/aws/smithy-go/middleware"
	smithysync "github.com/aws/smithy-go/sync"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"sync"
	"time"
)

// Starts a bidirectional HTTP/2 stream, where audio is streamed to Amazon Web
// Services HealthScribe and the transcription results are streamed to your
// application.
//
// When you start a stream, you first specify the stream configuration in a
// MedicalScribeConfigurationEvent . This event includes channel definitions,
// encryption settings, and post-stream analytics settings, such as the output
// configuration for aggregated transcript and clinical note generation. These are
// additional streaming session configurations beyond those provided in your
// initial start request headers. Whether you are starting a new session or
// resuming an existing session, your first event must be a
// MedicalScribeConfigurationEvent .
//
// After you send a MedicalScribeConfigurationEvent , you start AudioEvents and
// Amazon Web Services HealthScribe responds with real-time transcription results.
// When you are finished, to start processing the results with the post-stream
// analytics, send a MedicalScribeSessionControlEvent with a Type of END_OF_SESSION
// and Amazon Web Services HealthScribe starts the analytics.
//
// You can pause or resume streaming. To pause streaming, complete the input
// stream without sending the MedicalScribeSessionControlEvent . To resume
// streaming, call the StartMedicalScribeStream and specify the same SessionId you
// used to start the stream.
//
// The following parameters are required:
//
//   - language-code
//
//   - media-encoding
//
//   - media-sample-rate-hertz
//
// For more information on streaming with Amazon Web Services HealthScribe, see [Amazon Web Services HealthScribe].
//
// [Amazon Web Services HealthScribe]: https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html
func (c *Client) StartMedicalScribeStream(ctx context.Context, params *StartMedicalScribeStreamInput, optFns ...func(*Options)) (*StartMedicalScribeStreamOutput, error) {
	if params == nil {
		params = &StartMedicalScribeStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartMedicalScribeStream", params, optFns, c.addOperationStartMedicalScribeStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartMedicalScribeStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartMedicalScribeStreamInput struct {

	// Specify the language code for your HealthScribe streaming session.
	//
	// This member is required.
	LanguageCode types.MedicalScribeLanguageCode

	// Specify the encoding used for the input audio.
	//
	// Supported formats are:
	//
	//   - FLAC
	//
	//   - OPUS-encoded audio in an Ogg container
	//
	//   - PCM (only signed 16-bit little-endian audio formats, which does not include
	//   WAV)
	//
	// For more information, see [Media formats].
	//
	// [Media formats]: https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio
	//
	// This member is required.
	MediaEncoding types.MedicalScribeMediaEncoding

	// Specify the sample rate of the input audio (in hertz). Amazon Web Services
	// HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you
	// specify must match that of your audio.
	//
	// This member is required.
	MediaSampleRateHertz *int32

	// Specify an identifier for your streaming session (in UUID format). If you don't
	// include a SessionId in your request, Amazon Web Services HealthScribe generates
	// an ID and returns it in the response.
	SessionId *string

	noSmithyDocumentSerde
}

type StartMedicalScribeStreamOutput struct {

	// The Language Code that you specified in your request. Same as provided in the
	// StartMedicalScribeStreamRequest .
	LanguageCode types.MedicalScribeLanguageCode

	// The Media Encoding you specified in your request. Same as provided in the
	// StartMedicalScribeStreamRequest
	MediaEncoding types.MedicalScribeMediaEncoding

	// The sample rate (in hertz) that you specified in your request. Same as provided
	// in the StartMedicalScribeStreamRequest
	MediaSampleRateHertz *int32

	// The unique identifier for your streaming request.
	RequestId *string

	// The identifier (in UUID format) for your streaming session.
	//
	// If you already started streaming, this is same ID as the one you specified in
	// your initial StartMedicalScribeStreamRequest .
	SessionId *string

	eventStream *StartMedicalScribeStreamEventStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

// GetStream returns the type to interact with the event stream.
func (o *StartMedicalScribeStreamOutput) GetStream() *StartMedicalScribeStreamEventStream {
	return o.eventStream
}

func (c *Client) addOperationStartMedicalScribeStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartMedicalScribeStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartMedicalScribeStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartMedicalScribeStream"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addEventStreamStartMedicalScribeStreamMiddleware(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddRequireMinimumProtocol(stack, 2, 0); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addStreamingEventsPayload(stack); err != nil {
		return err
	}
	if err = addContentSHA256Header(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = eventstreamapi.AddInitializeStreamWriter(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartMedicalScribeStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartMedicalScribeStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartMedicalScribeStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartMedicalScribeStream",
	}
}

// StartMedicalScribeStreamEventStream provides the event stream handling for the StartMedicalScribeStream operation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewStartMedicalScribeStreamEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type StartMedicalScribeStreamEventStream struct {
	// MedicalScribeInputStreamWriter is the EventStream writer for the
	// MedicalScribeInputStream events. This value is automatically set by the SDK when
	// the API call is made Use this member when unit testing your code with the SDK to
	// mock out the EventStream Writer.
	//
	// Must not be nil.
	Writer MedicalScribeInputStreamWriter

	// MedicalScribeResultStreamReader is the EventStream reader for the
	// MedicalScribeResultStream events. This value is automatically set by the SDK
	// when the API call is made Use this member when unit testing your code with the
	// SDK to mock out the EventStream Reader.
	//
	// Must not be nil.
	Reader MedicalScribeResultStreamReader

	done      chan struct{}
	closeOnce sync.Once
	err       *smithysync.OnceErr
}

// NewStartMedicalScribeStreamEventStream initializes an StartMedicalScribeStreamEventStream.
// This function should only be used for testing and mocking the StartMedicalScribeStreamEventStream
// stream within your application.
//
// The Writer member must be set before writing events to the stream.
//
// The Reader member must be set before reading events from the stream.
func NewStartMedicalScribeStreamEventStream(optFns ...func(*StartMedicalScribeStreamEventStream)) *StartMedicalScribeStreamEventStream {
	es := &StartMedicalScribeStreamEventStream{
		done: make(chan struct{}),
		err:  smithysync.NewOnceErr(),
	}
	for _, fn := range optFns {
		fn(es)
	}
	return es
}

// Send writes the event to the stream blocking until the event is written.
// Returns an error if the event was not written.
func (es *StartMedicalScribeStreamEventStream) Send(ctx context.Context, event types.MedicalScribeInputStream) error {
	return es.Writer.Send(ctx, event)
}

// Events returns a channel to read events from.
func (es *StartMedicalScribeStreamEventStream) Events() <-chan types.MedicalScribeResultStream {
	return es.Reader.Events()
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer and reader, and no more events can be
// sent or received.
func (es *StartMedicalScribeStreamEventStream) Close() error {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *StartMedicalScribeStreamEventStream) safeClose() {
	close(es.done)

	t := time.NewTicker(time.Second)
	defer t.Stop()
	writeCloseDone := make(chan error)
	go func() {
		if err := es.Writer.Close(); err != nil {
			es.err.SetError(err)
		}
		close(writeCloseDone)
	}()
	select {
	case <-t.C:
	case <-writeCloseDone:
	}

	es.Reader.Close()
}

// Err returns any error that occurred while reading or writing EventStream Events
// from the service API's response. Returns nil if there were no errors.
func (es *StartMedicalScribeStreamEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}

	if err := es.Writer.Err(); err != nil {
		return err
	}

	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

func (es *StartMedicalScribeStreamEventStream) waitStreamClose() {
	type errorSet interface {
		ErrorSet() <-chan struct{}
	}

	var inputErrCh <-chan struct{}
	if v, ok := es.Writer.(errorSet); ok {
		inputErrCh = v.ErrorSet()
	}

	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(errorSet); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-inputErrCh:
		es.err.SetError(es.Writer.Err())
		es.Close()

	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()

	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()

	}
}
