// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a Redshift-managed VPC endpoint.
func (c *Client) CreateEndpointAccess(ctx context.Context, params *CreateEndpointAccessInput, optFns ...func(*Options)) (*CreateEndpointAccessOutput, error) {
	if params == nil {
		params = &CreateEndpointAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEndpointAccess", params, optFns, c.addOperationCreateEndpointAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEndpointAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEndpointAccessInput struct {

	// The Redshift-managed VPC endpoint name.
	//
	// An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z,
	// 0-9, and hyphen(-). The first character must be a letter. The name can't contain
	// two consecutive hyphens or end with a hyphen.
	//
	// This member is required.
	EndpointName *string

	// The subnet group from which Amazon Redshift chooses the subnet to deploy the
	// endpoint.
	//
	// This member is required.
	SubnetGroupName *string

	// The cluster identifier of the cluster to access.
	ClusterIdentifier *string

	// The Amazon Web Services account ID of the owner of the cluster. This is only
	// required if the cluster is in another Amazon Web Services account.
	ResourceOwner *string

	// The security group that defines the ports, protocols, and sources for inbound
	// traffic that you are authorizing into your endpoint.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

// Describes a Redshift-managed VPC endpoint.
type CreateEndpointAccessOutput struct {

	// The DNS address of the endpoint.
	Address *string

	// The cluster identifier of the cluster associated with the endpoint.
	ClusterIdentifier *string

	// The time (UTC) that the endpoint was created.
	EndpointCreateTime *time.Time

	// The name of the endpoint.
	EndpointName *string

	// The status of the endpoint.
	EndpointStatus *string

	// The port number on which the cluster accepts incoming connections.
	Port *int32

	// The Amazon Web Services account ID of the owner of the cluster.
	ResourceOwner *string

	// The subnet group name where Amazon Redshift chooses to deploy the endpoint.
	SubnetGroupName *string

	// The connection endpoint for connecting to an Amazon Redshift cluster through
	// the proxy.
	VpcEndpoint *types.VpcEndpoint

	// The security groups associated with the endpoint.
	VpcSecurityGroups []types.VpcSecurityGroupMembership

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEndpointAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateEndpointAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateEndpointAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEndpointAccess"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEndpointAccessValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEndpointAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateEndpointAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEndpointAccess",
	}
}
