// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates an issuer script mac for EMV payment cards that use offline PINs as
// the cardholder verification method (CVM).
//
// This operation generates an authenticated issuer script response by appending
// the incoming message data (APDU command) with the target encrypted PIN block in
// ISO2 format. The command structure and method to send the issuer script update
// to the card is not defined by this operation and is typically determined by the
// applicable payment card scheme.
//
// The primary inputs to this operation include the incoming new encrypted
// pinblock, PIN encryption key (PEK), issuer master key (IMK), primary account
// number (PAN), and the payment card derivation method.
//
// The operation uses two issuer master keys - secure messaging for
// confidentiality (IMK-SMC) and secure messaging for integrity (IMK-SMI). The SMC
// key is used to internally derive a key to secure the pin, while SMI key is used
// to internally derive a key to authenticate the script reponse as per the [EMV 4.4 - Book 2 - Security and Key Management]
// specification.
//
// This operation supports Amex, EMV2000, EMVCommon, Mastercard and Visa
// derivation methods, each requiring specific input parameters. Users must follow
// the specific derivation method and input parameters defined by the respective
// payment card scheme.
//
// Use GenerateMac operation when sending a script update to an EMV card that does not
// involve PIN change. When assigning IAM permissions, it is important to
// understand that EncryptDatausing EMV keys and GenerateMac perform similar functions to this command.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// # EncryptData
//
// # GenerateMac
//
// [EMV 4.4 - Book 2 - Security and Key Management]: https://www.emvco.com/specifications/
func (c *Client) GenerateMacEmvPinChange(ctx context.Context, params *GenerateMacEmvPinChangeInput, optFns ...func(*Options)) (*GenerateMacEmvPinChangeOutput, error) {
	if params == nil {
		params = &GenerateMacEmvPinChangeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateMacEmvPinChange", params, optFns, c.addOperationGenerateMacEmvPinChangeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateMacEmvPinChangeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateMacEmvPinChangeInput struct {

	// The attributes and data values to derive payment card specific confidentiality
	// and integrity keys.
	//
	// This member is required.
	DerivationMethodAttributes types.DerivationMethodAttributes

	// The message data is the APDU command from the card reader or terminal. The
	// target encrypted PIN block, after translation to ISO2 format, is appended to
	// this message data to generate an issuer script response.
	//
	// This member is required.
	MessageData *string

	// The incoming new encrypted PIN block data for offline pin change on an EMV card.
	//
	// This member is required.
	NewEncryptedPinBlock *string

	// The keyARN of the PEK protecting the incoming new encrypted PIN block.
	//
	// This member is required.
	NewPinPekIdentifier *string

	// The PIN encoding format of the incoming new encrypted PIN block as specified in
	// ISO 9564.
	//
	// This member is required.
	PinBlockFormat types.PinBlockFormatForEmvPinChange

	// The keyARN of the issuer master key (IMK-SMC) used to protect the PIN block
	// data in the issuer script response.
	//
	// This member is required.
	SecureMessagingConfidentialityKeyIdentifier *string

	// The keyARN of the issuer master key (IMK-SMI) used to authenticate the issuer
	// script response.
	//
	// This member is required.
	SecureMessagingIntegrityKeyIdentifier *string

	noSmithyDocumentSerde
}

type GenerateMacEmvPinChangeOutput struct {

	// Returns the incoming new encrpted PIN block.
	//
	// This member is required.
	EncryptedPinBlock *string

	// Returns the mac of the issuer script containing message data and appended
	// target encrypted pin block in ISO2 format.
	//
	// This member is required.
	Mac *string

	// Returns the keyArn of the PEK protecting the incoming new encrypted PIN block.
	//
	// This member is required.
	NewPinPekArn *string

	// The key check value (KCV) of the PEK uprotecting the incoming new encrypted PIN
	// block.
	//
	// This member is required.
	NewPinPekKeyCheckValue *string

	// Returns the keyArn of the IMK-SMC used by the operation.
	//
	// This member is required.
	SecureMessagingConfidentialityKeyArn *string

	// The key check value (KCV) of the SMC issuer master key used by the operation.
	//
	// This member is required.
	SecureMessagingConfidentialityKeyCheckValue *string

	// Returns the keyArn of the IMK-SMI used by the operation.
	//
	// This member is required.
	SecureMessagingIntegrityKeyArn *string

	// The key check value (KCV) of the SMI issuer master key used by the operation.
	//
	// This member is required.
	SecureMessagingIntegrityKeyCheckValue *string

	// The attribute values used for Amex and Visa derivation methods.
	VisaAmexDerivationOutputs *types.VisaAmexDerivationOutputs

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateMacEmvPinChangeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGenerateMacEmvPinChange{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGenerateMacEmvPinChange{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateMacEmvPinChange"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGenerateMacEmvPinChangeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateMacEmvPinChange(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateMacEmvPinChange(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateMacEmvPinChange",
	}
}
