// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The CreateEngagement action allows you to create an Engagement , which serves as
// a collaborative space between different parties such as AWS Partners and AWS
// Sellers. This action automatically adds the caller's AWS account as an active
// member of the newly created Engagement .
func (c *Client) CreateEngagement(ctx context.Context, params *CreateEngagementInput, optFns ...func(*Options)) (*CreateEngagementOutput, error) {
	if params == nil {
		params = &CreateEngagementInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEngagement", params, optFns, c.addOperationCreateEngagementMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEngagementOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEngagementInput struct {

	// The CreateEngagementRequest$Catalog parameter specifies the catalog related to
	// the engagement. Accepted values are AWS and Sandbox , which determine the
	// environment in which the engagement is managed.
	//
	// This member is required.
	Catalog *string

	// The CreateEngagementRequest$ClientToken parameter specifies a unique,
	// case-sensitive identifier to ensure that the request is handled exactly once.
	// The value must not exceed sixty-four alphanumeric characters.
	//
	// This member is required.
	ClientToken *string

	// Provides a description of the Engagement .
	//
	// This member is required.
	Description *string

	// Specifies the title of the Engagement .
	//
	// This member is required.
	Title *string

	// The Contexts field is a required array of objects, with a maximum of 5 contexts
	// allowed, specifying detailed information about customer projects associated with
	// the Engagement. Each context object contains a Type field indicating the
	// context type, which must be CustomerProject in this version, and a Payload
	// field containing the CustomerProject details. The CustomerProject object is
	// composed of two main components: Customer and Project . The Customer object
	// includes information such as CompanyName , WebsiteUrl , Industry , and
	// CountryCode , providing essential details about the customer. The Project
	// object contains Title , BusinessProblem , and TargetCompletionDate , offering
	// insights into the specific project associated with the customer. This structure
	// allows comprehensive context to be included within the Engagement, facilitating
	// effective collaboration between parties by providing relevant customer and
	// project information.
	Contexts []types.EngagementContextDetails

	noSmithyDocumentSerde
}

type CreateEngagementOutput struct {

	// The Amazon Resource Name (ARN) that identifies the engagement.
	Arn *string

	// Unique identifier assigned to the newly created engagement.
	Id *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEngagementMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateEngagement{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateEngagement{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEngagement"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateEngagementMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEngagementValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEngagement(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateEngagement struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateEngagement) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateEngagement) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateEngagementInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateEngagementInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateEngagementMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateEngagement{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateEngagement(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEngagement",
	}
}
