// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new NotificationConfiguration .
func (c *Client) CreateNotificationConfiguration(ctx context.Context, params *CreateNotificationConfigurationInput, optFns ...func(*Options)) (*CreateNotificationConfigurationOutput, error) {
	if params == nil {
		params = &CreateNotificationConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateNotificationConfiguration", params, optFns, c.addOperationCreateNotificationConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateNotificationConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateNotificationConfigurationInput struct {

	// The description of the NotificationConfiguration .
	//
	// This member is required.
	Description *string

	// The name of the NotificationConfiguration . Supports RFC 3986's unreserved
	// characters.
	//
	// This member is required.
	Name *string

	// The aggregation preference of the NotificationConfiguration .
	//
	//   - Values:
	//
	//   - LONG
	//
	//   - Aggregate notifications for long periods of time (12 hours).
	//
	//   - SHORT
	//
	//   - Aggregate notifications for short periods of time (5 minutes).
	//
	//   - NONE
	//
	//   - Don't aggregate notifications.
	AggregationDuration types.AggregationDuration

	// A map of tags assigned to a resource. A tag is a string-to-string map of
	// key-value pairs.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateNotificationConfigurationOutput struct {

	// The Amazon Resource Name (ARN) of the NotificationConfiguration .
	//
	// This member is required.
	Arn *string

	// The current status of this NotificationConfiguration .
	//
	// This member is required.
	Status types.NotificationConfigurationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateNotificationConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateNotificationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateNotificationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateNotificationConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateNotificationConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateNotificationConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateNotificationConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateNotificationConfiguration",
	}
}
