// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Create a ChannelPlacementGroup in the specified Cluster. As part of the create
// operation, you specify the Nodes to attach the group to.After you create a
// ChannelPlacementGroup, you add Channels to the group (you do this by modifying
// the Channels to add them to a specific group). You now have an association of
// Channels to ChannelPlacementGroup, and ChannelPlacementGroup to Nodes. This
// association means that all the Channels in the group are able to run on any of
// the Nodes associated with the group.
func (c *Client) CreateChannelPlacementGroup(ctx context.Context, params *CreateChannelPlacementGroupInput, optFns ...func(*Options)) (*CreateChannelPlacementGroupOutput, error) {
	if params == nil {
		params = &CreateChannelPlacementGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateChannelPlacementGroup", params, optFns, c.addOperationCreateChannelPlacementGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateChannelPlacementGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A request to create a channel placement group.
type CreateChannelPlacementGroupInput struct {

	// The ID of the cluster.
	//
	// This member is required.
	ClusterId *string

	// Specify a name that is unique in the Cluster. You can't change the name. Names
	// are case-sensitive.
	Name *string

	// An array of one ID for the Node that you want to associate with the
	// ChannelPlacementGroup. (You can't associate more than one Node with the
	// ChannelPlacementGroup.) The Node and the ChannelPlacementGroup must be in the
	// same Cluster.
	Nodes []string

	// An ID that you assign to a create request. This ID ensures idempotency when
	// creating resources. the request.
	RequestId *string

	// A collection of key-value pairs.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Placeholder documentation for CreateChannelPlacementGroupResponse
type CreateChannelPlacementGroupOutput struct {

	// The ARN of this ChannelPlacementGroup. It is automatically assigned when the
	// ChannelPlacementGroup is created.
	Arn *string

	// Used in ListChannelPlacementGroupsResult
	Channels []string

	// The ID of the Cluster that the Node belongs to.
	ClusterId *string

	// The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the
	// resource-id portion of the ARN.
	Id *string

	// The name that you specified for the ChannelPlacementGroup.
	Name *string

	// An array with one item, which is the single Node that is associated with the
	// ChannelPlacementGroup.
	Nodes []string

	// The current state of the ChannelPlacementGroup.
	State types.ChannelPlacementGroupState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateChannelPlacementGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateChannelPlacementGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateChannelPlacementGroupMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateChannelPlacementGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateChannelPlacementGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateChannelPlacementGroup struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateChannelPlacementGroup) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateChannelPlacementGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateChannelPlacementGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateChannelPlacementGroupInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateChannelPlacementGroupMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateChannelPlacementGroup{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateChannelPlacementGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateChannelPlacementGroup",
	}
}
