// Code generated by smithy-go-codegen DO NOT EDIT.

package machinelearning

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/machinelearning/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson11_serializeOpAddTags struct {
}

func (*awsAwsjson11_serializeOpAddTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.AddTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateBatchPrediction struct {
}

func (*awsAwsjson11_serializeOpCreateBatchPrediction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateBatchPrediction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBatchPredictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateBatchPrediction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateBatchPredictionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataSourceFromRDS struct {
}

func (*awsAwsjson11_serializeOpCreateDataSourceFromRDS) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataSourceFromRDS) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceFromRDSInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateDataSourceFromRDS")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDataSourceFromRDSInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataSourceFromRedshift struct {
}

func (*awsAwsjson11_serializeOpCreateDataSourceFromRedshift) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataSourceFromRedshift) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceFromRedshiftInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateDataSourceFromRedshift")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDataSourceFromRedshiftInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataSourceFromS3 struct {
}

func (*awsAwsjson11_serializeOpCreateDataSourceFromS3) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataSourceFromS3) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceFromS3Input)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateDataSourceFromS3")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDataSourceFromS3Input(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateEvaluation struct {
}

func (*awsAwsjson11_serializeOpCreateEvaluation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateEvaluation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEvaluationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateEvaluation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateEvaluationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateMLModel struct {
}

func (*awsAwsjson11_serializeOpCreateMLModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateMLModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMLModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateMLModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateMLModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateRealtimeEndpoint struct {
}

func (*awsAwsjson11_serializeOpCreateRealtimeEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateRealtimeEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRealtimeEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.CreateRealtimeEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateRealtimeEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteBatchPrediction struct {
}

func (*awsAwsjson11_serializeOpDeleteBatchPrediction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteBatchPrediction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBatchPredictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DeleteBatchPrediction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteBatchPredictionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDataSource struct {
}

func (*awsAwsjson11_serializeOpDeleteDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DeleteDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteEvaluation struct {
}

func (*awsAwsjson11_serializeOpDeleteEvaluation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteEvaluation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEvaluationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DeleteEvaluation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteEvaluationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMLModel struct {
}

func (*awsAwsjson11_serializeOpDeleteMLModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMLModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMLModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DeleteMLModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMLModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteRealtimeEndpoint struct {
}

func (*awsAwsjson11_serializeOpDeleteRealtimeEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteRealtimeEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRealtimeEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DeleteRealtimeEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteRealtimeEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTags struct {
}

func (*awsAwsjson11_serializeOpDeleteTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DeleteTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeBatchPredictions struct {
}

func (*awsAwsjson11_serializeOpDescribeBatchPredictions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeBatchPredictions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBatchPredictionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DescribeBatchPredictions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeBatchPredictionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeDataSources struct {
}

func (*awsAwsjson11_serializeOpDescribeDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DescribeDataSources")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeDataSourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEvaluations struct {
}

func (*awsAwsjson11_serializeOpDescribeEvaluations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEvaluations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEvaluationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DescribeEvaluations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEvaluationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeMLModels struct {
}

func (*awsAwsjson11_serializeOpDescribeMLModels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeMLModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMLModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DescribeMLModels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeMLModelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeTags struct {
}

func (*awsAwsjson11_serializeOpDescribeTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.DescribeTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetBatchPrediction struct {
}

func (*awsAwsjson11_serializeOpGetBatchPrediction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetBatchPrediction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBatchPredictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.GetBatchPrediction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetBatchPredictionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDataSource struct {
}

func (*awsAwsjson11_serializeOpGetDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.GetDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetEvaluation struct {
}

func (*awsAwsjson11_serializeOpGetEvaluation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetEvaluation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEvaluationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.GetEvaluation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetEvaluationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMLModel struct {
}

func (*awsAwsjson11_serializeOpGetMLModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMLModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.GetMLModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMLModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPredict struct {
}

func (*awsAwsjson11_serializeOpPredict) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPredict) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PredictInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.Predict")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPredictInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateBatchPrediction struct {
}

func (*awsAwsjson11_serializeOpUpdateBatchPrediction) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateBatchPrediction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBatchPredictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.UpdateBatchPrediction")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateBatchPredictionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDataSource struct {
}

func (*awsAwsjson11_serializeOpUpdateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.UpdateDataSource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateEvaluation struct {
}

func (*awsAwsjson11_serializeOpUpdateEvaluation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateEvaluation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEvaluationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.UpdateEvaluation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateEvaluationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateMLModel struct {
}

func (*awsAwsjson11_serializeOpUpdateMLModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateMLModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMLModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonML_20141212.UpdateMLModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateMLModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentEDPSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRDSDatabase(v *types.RDSDatabase, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.InstanceIdentifier != nil {
		ok := object.Key("InstanceIdentifier")
		ok.String(*v.InstanceIdentifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRDSDatabaseCredentials(v *types.RDSDatabaseCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRDSDataSpec(v *types.RDSDataSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseCredentials != nil {
		ok := object.Key("DatabaseCredentials")
		if err := awsAwsjson11_serializeDocumentRDSDatabaseCredentials(v.DatabaseCredentials, ok); err != nil {
			return err
		}
	}

	if v.DatabaseInformation != nil {
		ok := object.Key("DatabaseInformation")
		if err := awsAwsjson11_serializeDocumentRDSDatabase(v.DatabaseInformation, ok); err != nil {
			return err
		}
	}

	if v.DataRearrangement != nil {
		ok := object.Key("DataRearrangement")
		ok.String(*v.DataRearrangement)
	}

	if v.DataSchema != nil {
		ok := object.Key("DataSchema")
		ok.String(*v.DataSchema)
	}

	if v.DataSchemaUri != nil {
		ok := object.Key("DataSchemaUri")
		ok.String(*v.DataSchemaUri)
	}

	if v.ResourceRole != nil {
		ok := object.Key("ResourceRole")
		ok.String(*v.ResourceRole)
	}

	if v.S3StagingLocation != nil {
		ok := object.Key("S3StagingLocation")
		ok.String(*v.S3StagingLocation)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentEDPSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SelectSqlQuery != nil {
		ok := object.Key("SelectSqlQuery")
		ok.String(*v.SelectSqlQuery)
	}

	if v.ServiceRole != nil {
		ok := object.Key("ServiceRole")
		ok.String(*v.ServiceRole)
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecord(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRedshiftDatabase(v *types.RedshiftDatabase, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterIdentifier != nil {
		ok := object.Key("ClusterIdentifier")
		ok.String(*v.ClusterIdentifier)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftDatabaseCredentials(v *types.RedshiftDatabaseCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftDataSpec(v *types.RedshiftDataSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseCredentials != nil {
		ok := object.Key("DatabaseCredentials")
		if err := awsAwsjson11_serializeDocumentRedshiftDatabaseCredentials(v.DatabaseCredentials, ok); err != nil {
			return err
		}
	}

	if v.DatabaseInformation != nil {
		ok := object.Key("DatabaseInformation")
		if err := awsAwsjson11_serializeDocumentRedshiftDatabase(v.DatabaseInformation, ok); err != nil {
			return err
		}
	}

	if v.DataRearrangement != nil {
		ok := object.Key("DataRearrangement")
		ok.String(*v.DataRearrangement)
	}

	if v.DataSchema != nil {
		ok := object.Key("DataSchema")
		ok.String(*v.DataSchema)
	}

	if v.DataSchemaUri != nil {
		ok := object.Key("DataSchemaUri")
		ok.String(*v.DataSchemaUri)
	}

	if v.S3StagingLocation != nil {
		ok := object.Key("S3StagingLocation")
		ok.String(*v.S3StagingLocation)
	}

	if v.SelectSqlQuery != nil {
		ok := object.Key("SelectSqlQuery")
		ok.String(*v.SelectSqlQuery)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DataSpec(v *types.S3DataSpec, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataLocationS3 != nil {
		ok := object.Key("DataLocationS3")
		ok.String(*v.DataLocationS3)
	}

	if v.DataRearrangement != nil {
		ok := object.Key("DataRearrangement")
		ok.String(*v.DataRearrangement)
	}

	if v.DataSchema != nil {
		ok := object.Key("DataSchema")
		ok.String(*v.DataSchema)
	}

	if v.DataSchemaLocationS3 != nil {
		ok := object.Key("DataSchemaLocationS3")
		ok.String(*v.DataSchemaLocationS3)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTrainingParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentAddTagsInput(v *AddTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		ok.String(*v.ResourceId)
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateBatchPredictionInput(v *CreateBatchPredictionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchPredictionDataSourceId != nil {
		ok := object.Key("BatchPredictionDataSourceId")
		ok.String(*v.BatchPredictionDataSourceId)
	}

	if v.BatchPredictionId != nil {
		ok := object.Key("BatchPredictionId")
		ok.String(*v.BatchPredictionId)
	}

	if v.BatchPredictionName != nil {
		ok := object.Key("BatchPredictionName")
		ok.String(*v.BatchPredictionName)
	}

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	if v.OutputUri != nil {
		ok := object.Key("OutputUri")
		ok.String(*v.OutputUri)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDataSourceFromRDSInput(v *CreateDataSourceFromRDSInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeStatistics {
		ok := object.Key("ComputeStatistics")
		ok.Boolean(v.ComputeStatistics)
	}

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceName != nil {
		ok := object.Key("DataSourceName")
		ok.String(*v.DataSourceName)
	}

	if v.RDSData != nil {
		ok := object.Key("RDSData")
		if err := awsAwsjson11_serializeDocumentRDSDataSpec(v.RDSData, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDataSourceFromRedshiftInput(v *CreateDataSourceFromRedshiftInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeStatistics {
		ok := object.Key("ComputeStatistics")
		ok.Boolean(v.ComputeStatistics)
	}

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceName != nil {
		ok := object.Key("DataSourceName")
		ok.String(*v.DataSourceName)
	}

	if v.DataSpec != nil {
		ok := object.Key("DataSpec")
		if err := awsAwsjson11_serializeDocumentRedshiftDataSpec(v.DataSpec, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDataSourceFromS3Input(v *CreateDataSourceFromS3Input, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeStatistics {
		ok := object.Key("ComputeStatistics")
		ok.Boolean(v.ComputeStatistics)
	}

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceName != nil {
		ok := object.Key("DataSourceName")
		ok.String(*v.DataSourceName)
	}

	if v.DataSpec != nil {
		ok := object.Key("DataSpec")
		if err := awsAwsjson11_serializeDocumentS3DataSpec(v.DataSpec, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateEvaluationInput(v *CreateEvaluationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EvaluationDataSourceId != nil {
		ok := object.Key("EvaluationDataSourceId")
		ok.String(*v.EvaluationDataSourceId)
	}

	if v.EvaluationId != nil {
		ok := object.Key("EvaluationId")
		ok.String(*v.EvaluationId)
	}

	if v.EvaluationName != nil {
		ok := object.Key("EvaluationName")
		ok.String(*v.EvaluationName)
	}

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateMLModelInput(v *CreateMLModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	if v.MLModelName != nil {
		ok := object.Key("MLModelName")
		ok.String(*v.MLModelName)
	}

	if len(v.MLModelType) > 0 {
		ok := object.Key("MLModelType")
		ok.String(string(v.MLModelType))
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentTrainingParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Recipe != nil {
		ok := object.Key("Recipe")
		ok.String(*v.Recipe)
	}

	if v.RecipeUri != nil {
		ok := object.Key("RecipeUri")
		ok.String(*v.RecipeUri)
	}

	if v.TrainingDataSourceId != nil {
		ok := object.Key("TrainingDataSourceId")
		ok.String(*v.TrainingDataSourceId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateRealtimeEndpointInput(v *CreateRealtimeEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteBatchPredictionInput(v *DeleteBatchPredictionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchPredictionId != nil {
		ok := object.Key("BatchPredictionId")
		ok.String(*v.BatchPredictionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDataSourceInput(v *DeleteDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteEvaluationInput(v *DeleteEvaluationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EvaluationId != nil {
		ok := object.Key("EvaluationId")
		ok.String(*v.EvaluationId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMLModelInput(v *DeleteMLModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteRealtimeEndpointInput(v *DeleteRealtimeEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTagsInput(v *DeleteTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		ok.String(*v.ResourceId)
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeBatchPredictionsInput(v *DescribeBatchPredictionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EQ != nil {
		ok := object.Key("EQ")
		ok.String(*v.EQ)
	}

	if len(v.FilterVariable) > 0 {
		ok := object.Key("FilterVariable")
		ok.String(string(v.FilterVariable))
	}

	if v.GE != nil {
		ok := object.Key("GE")
		ok.String(*v.GE)
	}

	if v.GT != nil {
		ok := object.Key("GT")
		ok.String(*v.GT)
	}

	if v.LE != nil {
		ok := object.Key("LE")
		ok.String(*v.LE)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.LT != nil {
		ok := object.Key("LT")
		ok.String(*v.LT)
	}

	if v.NE != nil {
		ok := object.Key("NE")
		ok.String(*v.NE)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeDataSourcesInput(v *DescribeDataSourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EQ != nil {
		ok := object.Key("EQ")
		ok.String(*v.EQ)
	}

	if len(v.FilterVariable) > 0 {
		ok := object.Key("FilterVariable")
		ok.String(string(v.FilterVariable))
	}

	if v.GE != nil {
		ok := object.Key("GE")
		ok.String(*v.GE)
	}

	if v.GT != nil {
		ok := object.Key("GT")
		ok.String(*v.GT)
	}

	if v.LE != nil {
		ok := object.Key("LE")
		ok.String(*v.LE)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.LT != nil {
		ok := object.Key("LT")
		ok.String(*v.LT)
	}

	if v.NE != nil {
		ok := object.Key("NE")
		ok.String(*v.NE)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEvaluationsInput(v *DescribeEvaluationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EQ != nil {
		ok := object.Key("EQ")
		ok.String(*v.EQ)
	}

	if len(v.FilterVariable) > 0 {
		ok := object.Key("FilterVariable")
		ok.String(string(v.FilterVariable))
	}

	if v.GE != nil {
		ok := object.Key("GE")
		ok.String(*v.GE)
	}

	if v.GT != nil {
		ok := object.Key("GT")
		ok.String(*v.GT)
	}

	if v.LE != nil {
		ok := object.Key("LE")
		ok.String(*v.LE)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.LT != nil {
		ok := object.Key("LT")
		ok.String(*v.LT)
	}

	if v.NE != nil {
		ok := object.Key("NE")
		ok.String(*v.NE)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeMLModelsInput(v *DescribeMLModelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EQ != nil {
		ok := object.Key("EQ")
		ok.String(*v.EQ)
	}

	if len(v.FilterVariable) > 0 {
		ok := object.Key("FilterVariable")
		ok.String(string(v.FilterVariable))
	}

	if v.GE != nil {
		ok := object.Key("GE")
		ok.String(*v.GE)
	}

	if v.GT != nil {
		ok := object.Key("GT")
		ok.String(*v.GT)
	}

	if v.LE != nil {
		ok := object.Key("LE")
		ok.String(*v.LE)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.LT != nil {
		ok := object.Key("LT")
		ok.String(*v.LT)
	}

	if v.NE != nil {
		ok := object.Key("NE")
		ok.String(*v.NE)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeTagsInput(v *DescribeTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		ok.String(*v.ResourceId)
	}

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetBatchPredictionInput(v *GetBatchPredictionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchPredictionId != nil {
		ok := object.Key("BatchPredictionId")
		ok.String(*v.BatchPredictionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataSourceInput(v *GetDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.Verbose {
		ok := object.Key("Verbose")
		ok.Boolean(v.Verbose)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetEvaluationInput(v *GetEvaluationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EvaluationId != nil {
		ok := object.Key("EvaluationId")
		ok.String(*v.EvaluationId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMLModelInput(v *GetMLModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	if v.Verbose {
		ok := object.Key("Verbose")
		ok.Boolean(v.Verbose)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPredictInput(v *PredictInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	if v.PredictEndpoint != nil {
		ok := object.Key("PredictEndpoint")
		ok.String(*v.PredictEndpoint)
	}

	if v.Record != nil {
		ok := object.Key("Record")
		if err := awsAwsjson11_serializeDocumentRecord(v.Record, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateBatchPredictionInput(v *UpdateBatchPredictionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchPredictionId != nil {
		ok := object.Key("BatchPredictionId")
		ok.String(*v.BatchPredictionId)
	}

	if v.BatchPredictionName != nil {
		ok := object.Key("BatchPredictionName")
		ok.String(*v.BatchPredictionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDataSourceInput(v *UpdateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceName != nil {
		ok := object.Key("DataSourceName")
		ok.String(*v.DataSourceName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateEvaluationInput(v *UpdateEvaluationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EvaluationId != nil {
		ok := object.Key("EvaluationId")
		ok.String(*v.EvaluationId)
	}

	if v.EvaluationName != nil {
		ok := object.Key("EvaluationName")
		ok.String(*v.EvaluationName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateMLModelInput(v *UpdateMLModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MLModelId != nil {
		ok := object.Key("MLModelId")
		ok.String(*v.MLModelId)
	}

	if v.MLModelName != nil {
		ok := object.Key("MLModelName")
		ok.String(*v.MLModelName)
	}

	if v.ScoreThreshold != nil {
		ok := object.Key("ScoreThreshold")
		switch {
		case math.IsNaN(float64(*v.ScoreThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ScoreThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ScoreThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ScoreThreshold)

		}
	}

	return nil
}
