// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List schemas associated with a managed thing.
func (c *Client) ListManagedThingSchemas(ctx context.Context, params *ListManagedThingSchemasInput, optFns ...func(*Options)) (*ListManagedThingSchemasOutput, error) {
	if params == nil {
		params = &ListManagedThingSchemasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedThingSchemas", params, optFns, c.addOperationListManagedThingSchemasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedThingSchemasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedThingSchemasInput struct {

	// The managed thing id.
	//
	// This member is required.
	Identifier *string

	// Filter on a capability id.
	CapabilityIdFilter *string

	// Filter on an endpoint id.
	EndpointIdFilter *string

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListManagedThingSchemasOutput struct {

	// The list of managed thing schemas.
	Items []types.ManagedThingSchemaListItem

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedThingSchemasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedThingSchemas{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedThingSchemas{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedThingSchemas"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListManagedThingSchemasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedThingSchemas(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListManagedThingSchemasPaginatorOptions is the paginator options for
// ListManagedThingSchemas
type ListManagedThingSchemasPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedThingSchemasPaginator is a paginator for ListManagedThingSchemas
type ListManagedThingSchemasPaginator struct {
	options   ListManagedThingSchemasPaginatorOptions
	client    ListManagedThingSchemasAPIClient
	params    *ListManagedThingSchemasInput
	nextToken *string
	firstPage bool
}

// NewListManagedThingSchemasPaginator returns a new
// ListManagedThingSchemasPaginator
func NewListManagedThingSchemasPaginator(client ListManagedThingSchemasAPIClient, params *ListManagedThingSchemasInput, optFns ...func(*ListManagedThingSchemasPaginatorOptions)) *ListManagedThingSchemasPaginator {
	if params == nil {
		params = &ListManagedThingSchemasInput{}
	}

	options := ListManagedThingSchemasPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedThingSchemasPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedThingSchemasPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedThingSchemas page.
func (p *ListManagedThingSchemasPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedThingSchemasOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedThingSchemas(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedThingSchemasAPIClient is a client that implements the
// ListManagedThingSchemas operation.
type ListManagedThingSchemasAPIClient interface {
	ListManagedThingSchemas(context.Context, *ListManagedThingSchemasInput, ...func(*Options)) (*ListManagedThingSchemasOutput, error)
}

var _ ListManagedThingSchemasAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedThingSchemas(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedThingSchemas",
	}
}
