// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"math"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type awsRestjson1_deserializeOpCalculateIsolines struct {
}

func (*awsRestjson1_deserializeOpCalculateIsolines) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCalculateIsolines) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCalculateIsolines(response, &metadata)
	}
	output := &CalculateIsolinesOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsCalculateIsolinesOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCalculateIsolinesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCalculateIsolines(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsCalculateIsolinesOutput(v *CalculateIsolinesOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("x-amz-geo-pricing-bucket"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PricingBucket = ptr.String(headerValues[0])
	}

	return nil
}
func awsRestjson1_deserializeOpDocumentCalculateIsolinesOutput(v **CalculateIsolinesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CalculateIsolinesOutput
	if *v == nil {
		sv = &CalculateIsolinesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ArrivalTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.ArrivalTime = ptr.String(jtv)
			}

		case "DepartureTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.DepartureTime = ptr.String(jtv)
			}

		case "IsolineGeometryFormat":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GeometryFormat to be of type string, got %T instead", value)
				}
				sv.IsolineGeometryFormat = types.GeometryFormat(jtv)
			}

		case "Isolines":
			if err := awsRestjson1_deserializeDocumentIsolineList(&sv.Isolines, value); err != nil {
				return err
			}

		case "SnappedDestination":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.SnappedDestination, value); err != nil {
				return err
			}

		case "SnappedOrigin":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.SnappedOrigin, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCalculateRouteMatrix struct {
}

func (*awsRestjson1_deserializeOpCalculateRouteMatrix) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCalculateRouteMatrix) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCalculateRouteMatrix(response, &metadata)
	}
	output := &CalculateRouteMatrixOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsCalculateRouteMatrixOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCalculateRouteMatrixOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCalculateRouteMatrix(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsCalculateRouteMatrixOutput(v *CalculateRouteMatrixOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("x-amz-geo-pricing-bucket"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PricingBucket = ptr.String(headerValues[0])
	}

	return nil
}
func awsRestjson1_deserializeOpDocumentCalculateRouteMatrixOutput(v **CalculateRouteMatrixOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CalculateRouteMatrixOutput
	if *v == nil {
		sv = &CalculateRouteMatrixOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ErrorCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ErrorCount = ptr.Int32(int32(i64))
			}

		case "RouteMatrix":
			if err := awsRestjson1_deserializeDocumentRouteMatrix(&sv.RouteMatrix, value); err != nil {
				return err
			}

		case "RoutingBoundary":
			if err := awsRestjson1_deserializeDocumentRouteMatrixBoundary(&sv.RoutingBoundary, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCalculateRoutes struct {
}

func (*awsRestjson1_deserializeOpCalculateRoutes) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCalculateRoutes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCalculateRoutes(response, &metadata)
	}
	output := &CalculateRoutesOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsCalculateRoutesOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCalculateRoutesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCalculateRoutes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsCalculateRoutesOutput(v *CalculateRoutesOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("x-amz-geo-pricing-bucket"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PricingBucket = ptr.String(headerValues[0])
	}

	return nil
}
func awsRestjson1_deserializeOpDocumentCalculateRoutesOutput(v **CalculateRoutesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CalculateRoutesOutput
	if *v == nil {
		sv = &CalculateRoutesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LegGeometryFormat":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GeometryFormat to be of type string, got %T instead", value)
				}
				sv.LegGeometryFormat = types.GeometryFormat(jtv)
			}

		case "Notices":
			if err := awsRestjson1_deserializeDocumentRouteResponseNoticeList(&sv.Notices, value); err != nil {
				return err
			}

		case "Routes":
			if err := awsRestjson1_deserializeDocumentRouteList(&sv.Routes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpOptimizeWaypoints struct {
}

func (*awsRestjson1_deserializeOpOptimizeWaypoints) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpOptimizeWaypoints) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorOptimizeWaypoints(response, &metadata)
	}
	output := &OptimizeWaypointsOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsOptimizeWaypointsOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentOptimizeWaypointsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorOptimizeWaypoints(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsOptimizeWaypointsOutput(v *OptimizeWaypointsOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("x-amz-geo-pricing-bucket"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PricingBucket = ptr.String(headerValues[0])
	}

	return nil
}
func awsRestjson1_deserializeOpDocumentOptimizeWaypointsOutput(v **OptimizeWaypointsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *OptimizeWaypointsOutput
	if *v == nil {
		sv = &OptimizeWaypointsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Connections":
			if err := awsRestjson1_deserializeDocumentWaypointOptimizationConnectionList(&sv.Connections, value); err != nil {
				return err
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "ImpedingWaypoints":
			if err := awsRestjson1_deserializeDocumentWaypointOptimizationImpedingWaypointList(&sv.ImpedingWaypoints, value); err != nil {
				return err
			}

		case "OptimizedWaypoints":
			if err := awsRestjson1_deserializeDocumentWaypointOptimizationOptimizedWaypointList(&sv.OptimizedWaypoints, value); err != nil {
				return err
			}

		case "TimeBreakdown":
			if err := awsRestjson1_deserializeDocumentWaypointOptimizationTimeBreakdown(&sv.TimeBreakdown, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpSnapToRoads struct {
}

func (*awsRestjson1_deserializeOpSnapToRoads) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpSnapToRoads) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorSnapToRoads(response, &metadata)
	}
	output := &SnapToRoadsOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsSnapToRoadsOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentSnapToRoadsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorSnapToRoads(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsSnapToRoadsOutput(v *SnapToRoadsOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("x-amz-geo-pricing-bucket"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PricingBucket = ptr.String(headerValues[0])
	}

	return nil
}
func awsRestjson1_deserializeOpDocumentSnapToRoadsOutput(v **SnapToRoadsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *SnapToRoadsOutput
	if *v == nil {
		sv = &SnapToRoadsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Notices":
			if err := awsRestjson1_deserializeDocumentRoadSnapNoticeList(&sv.Notices, value); err != nil {
				return err
			}

		case "SnappedGeometry":
			if err := awsRestjson1_deserializeDocumentRoadSnapSnappedGeometry(&sv.SnappedGeometry, value); err != nil {
				return err
			}

		case "SnappedGeometryFormat":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GeometryFormat to be of type string, got %T instead", value)
				}
				sv.SnappedGeometryFormat = types.GeometryFormat(jtv)
			}

		case "SnappedTracePoints":
			if err := awsRestjson1_deserializeDocumentRoadSnapSnappedTracePointList(&sv.SnappedTracePoints, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeErrorAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AccessDeniedException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentAccessDeniedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInternalServerException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InternalServerException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInternalServerException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorThrottlingException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ThrottlingException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentThrottlingException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorValidationException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ValidationException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentValidationException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeDocumentAccessDeniedException(v **types.AccessDeniedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AccessDeniedException
	if *v == nil {
		sv = &types.AccessDeniedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentBoundingBox(v *[]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []float64
	if *v == nil {
		cv = []float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col float64
		if value != nil {
			switch jtv := value.(type) {
			case json.Number:
				f64, err := jtv.Float64()
				if err != nil {
					return err
				}
				col = f64

			case string:
				var f64 float64
				switch {
				case strings.EqualFold(jtv, "NaN"):
					f64 = math.NaN()

				case strings.EqualFold(jtv, "Infinity"):
					f64 = math.Inf(1)

				case strings.EqualFold(jtv, "-Infinity"):
					f64 = math.Inf(-1)

				default:
					return fmt.Errorf("unknown JSON number value: %s", jtv)

				}
				col = f64

			default:
				return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

			}
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentCircle(v **types.Circle, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Circle
	if *v == nil {
		sv = &types.Circle{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Center":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.Center, value); err != nil {
				return err
			}

		case "Radius":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Radius = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Radius = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIndexList(v *[]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []int32
	if *v == nil {
		cv = []int32{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			col = int32(i64)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentInternalServerException(v **types.InternalServerException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InternalServerException
	if *v == nil {
		sv = &types.InternalServerException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIsoline(v **types.Isoline, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Isoline
	if *v == nil {
		sv = &types.Isoline{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Connections":
			if err := awsRestjson1_deserializeDocumentIsolineConnectionList(&sv.Connections, value); err != nil {
				return err
			}

		case "DistanceThreshold":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DistanceThreshold = i64
			}

		case "Geometries":
			if err := awsRestjson1_deserializeDocumentIsolineShapeGeometryList(&sv.Geometries, value); err != nil {
				return err
			}

		case "TimeThreshold":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TimeThreshold = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIsolineConnection(v **types.IsolineConnection, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IsolineConnection
	if *v == nil {
		sv = &types.IsolineConnection{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FromPolygonIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FromPolygonIndex = ptr.Int32(int32(i64))
			}

		case "Geometry":
			if err := awsRestjson1_deserializeDocumentIsolineConnectionGeometry(&sv.Geometry, value); err != nil {
				return err
			}

		case "ToPolygonIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ToPolygonIndex = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIsolineConnectionGeometry(v **types.IsolineConnectionGeometry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IsolineConnectionGeometry
	if *v == nil {
		sv = &types.IsolineConnectionGeometry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LineString":
			if err := awsRestjson1_deserializeDocumentLineString(&sv.LineString, value); err != nil {
				return err
			}

		case "Polyline":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Polyline to be of type string, got %T instead", value)
				}
				sv.Polyline = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIsolineConnectionList(v *[]types.IsolineConnection, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.IsolineConnection
	if *v == nil {
		cv = []types.IsolineConnection{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.IsolineConnection
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentIsolineConnection(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentIsolineList(v *[]types.Isoline, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Isoline
	if *v == nil {
		cv = []types.Isoline{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Isoline
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentIsoline(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentIsolineShapeGeometry(v **types.IsolineShapeGeometry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IsolineShapeGeometry
	if *v == nil {
		sv = &types.IsolineShapeGeometry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Polygon":
			if err := awsRestjson1_deserializeDocumentLinearRings(&sv.Polygon, value); err != nil {
				return err
			}

		case "PolylinePolygon":
			if err := awsRestjson1_deserializeDocumentPolylineRingList(&sv.PolylinePolygon, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIsolineShapeGeometryList(v *[]types.IsolineShapeGeometry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.IsolineShapeGeometry
	if *v == nil {
		cv = []types.IsolineShapeGeometry{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.IsolineShapeGeometry
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentIsolineShapeGeometry(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentLinearRing(v *[][]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv [][]float64
	if *v == nil {
		cv = [][]float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col []float64
		if err := awsRestjson1_deserializeDocumentPosition(&col, value); err != nil {
			return err
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentLinearRings(v *[][][]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv [][][]float64
	if *v == nil {
		cv = [][][]float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col [][]float64
		if err := awsRestjson1_deserializeDocumentLinearRing(&col, value); err != nil {
			return err
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentLineString(v *[][]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv [][]float64
	if *v == nil {
		cv = [][]float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col []float64
		if err := awsRestjson1_deserializeDocumentPosition(&col, value); err != nil {
			return err
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentLocalizedString(v **types.LocalizedString, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LocalizedString
	if *v == nil {
		sv = &types.LocalizedString{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Language":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LanguageTag to be of type string, got %T instead", value)
				}
				sv.Language = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentLocalizedStringList(v *[]types.LocalizedString, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.LocalizedString
	if *v == nil {
		cv = []types.LocalizedString{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.LocalizedString
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentLocalizedString(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentPolylineRingList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected PolylineRing to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentPosition(v *[]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []float64
	if *v == nil {
		cv = []float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col float64
		if value != nil {
			switch jtv := value.(type) {
			case json.Number:
				f64, err := jtv.Float64()
				if err != nil {
					return err
				}
				col = f64

			case string:
				var f64 float64
				switch {
				case strings.EqualFold(jtv, "NaN"):
					f64 = math.NaN()

				case strings.EqualFold(jtv, "Infinity"):
					f64 = math.Inf(1)

				case strings.EqualFold(jtv, "-Infinity"):
					f64 = math.Inf(-1)

				default:
					return fmt.Errorf("unknown JSON number value: %s", jtv)

				}
				col = f64

			default:
				return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

			}
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentPosition23(v *[]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []float64
	if *v == nil {
		cv = []float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col float64
		if value != nil {
			switch jtv := value.(type) {
			case json.Number:
				f64, err := jtv.Float64()
				if err != nil {
					return err
				}
				col = f64

			case string:
				var f64 float64
				switch {
				case strings.EqualFold(jtv, "NaN"):
					f64 = math.NaN()

				case strings.EqualFold(jtv, "Infinity"):
					f64 = math.Inf(1)

				case strings.EqualFold(jtv, "-Infinity"):
					f64 = math.Inf(-1)

				default:
					return fmt.Errorf("unknown JSON number value: %s", jtv)

				}
				col = f64

			default:
				return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

			}
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoadSnapNotice(v **types.RoadSnapNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoadSnapNotice
	if *v == nil {
		sv = &types.RoadSnapNotice{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RoadSnapNoticeCode to be of type string, got %T instead", value)
				}
				sv.Code = types.RoadSnapNoticeCode(jtv)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "TracePointIndexes":
			if err := awsRestjson1_deserializeDocumentRoadSnapTracePointIndexList(&sv.TracePointIndexes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoadSnapNoticeList(v *[]types.RoadSnapNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RoadSnapNotice
	if *v == nil {
		cv = []types.RoadSnapNotice{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RoadSnapNotice
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoadSnapNotice(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoadSnapSnappedGeometry(v **types.RoadSnapSnappedGeometry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoadSnapSnappedGeometry
	if *v == nil {
		sv = &types.RoadSnapSnappedGeometry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LineString":
			if err := awsRestjson1_deserializeDocumentLineString(&sv.LineString, value); err != nil {
				return err
			}

		case "Polyline":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Polyline to be of type string, got %T instead", value)
				}
				sv.Polyline = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoadSnapSnappedTracePoint(v **types.RoadSnapSnappedTracePoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoadSnapSnappedTracePoint
	if *v == nil {
		sv = &types.RoadSnapSnappedTracePoint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Confidence":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Confidence = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Confidence = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "OriginalPosition":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.OriginalPosition, value); err != nil {
				return err
			}

		case "SnappedPosition":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.SnappedPosition, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoadSnapSnappedTracePointList(v *[]types.RoadSnapSnappedTracePoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RoadSnapSnappedTracePoint
	if *v == nil {
		cv = []types.RoadSnapSnappedTracePoint{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RoadSnapSnappedTracePoint
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoadSnapSnappedTracePoint(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoadSnapTracePointIndexList(v *[]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []int32
	if *v == nil {
		cv = []int32{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			col = int32(i64)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoute(v **types.Route, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Route
	if *v == nil {
		sv = &types.Route{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Legs":
			if err := awsRestjson1_deserializeDocumentRouteLegList(&sv.Legs, value); err != nil {
				return err
			}

		case "MajorRoadLabels":
			if err := awsRestjson1_deserializeDocumentRouteMajorRoadLabelList(&sv.MajorRoadLabels, value); err != nil {
				return err
			}

		case "Summary":
			if err := awsRestjson1_deserializeDocumentRouteSummary(&sv.Summary, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteContinueHighwayStepDetails(v **types.RouteContinueHighwayStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteContinueHighwayStepDetails
	if *v == nil {
		sv = &types.RouteContinueHighwayStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteContinueStepDetails(v **types.RouteContinueStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteContinueStepDetails
	if *v == nil {
		sv = &types.RouteContinueStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteEnterHighwayStepDetails(v **types.RouteEnterHighwayStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteEnterHighwayStepDetails
	if *v == nil {
		sv = &types.RouteEnterHighwayStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteExitStepDetails(v **types.RouteExitStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteExitStepDetails
	if *v == nil {
		sv = &types.RouteExitStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "RelativeExit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RelativeExit = ptr.Int32(int32(i64))
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryAfterTravelStep(v **types.RouteFerryAfterTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryAfterTravelStep
	if *v == nil {
		sv = &types.RouteFerryAfterTravelStep{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "Instruction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Instruction = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteFerryAfterTravelStepType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteFerryAfterTravelStepType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryAfterTravelStepList(v *[]types.RouteFerryAfterTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteFerryAfterTravelStep
	if *v == nil {
		cv = []types.RouteFerryAfterTravelStep{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteFerryAfterTravelStep
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteFerryAfterTravelStep(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryArrival(v **types.RouteFerryArrival, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryArrival
	if *v == nil {
		sv = &types.RouteFerryArrival{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Place":
			if err := awsRestjson1_deserializeDocumentRouteFerryPlace(&sv.Place, value); err != nil {
				return err
			}

		case "Time":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.Time = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryBeforeTravelStep(v **types.RouteFerryBeforeTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryBeforeTravelStep
	if *v == nil {
		sv = &types.RouteFerryBeforeTravelStep{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "Instruction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Instruction = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteFerryBeforeTravelStepType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteFerryBeforeTravelStepType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryBeforeTravelStepList(v *[]types.RouteFerryBeforeTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteFerryBeforeTravelStep
	if *v == nil {
		cv = []types.RouteFerryBeforeTravelStep{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteFerryBeforeTravelStep
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteFerryBeforeTravelStep(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryDeparture(v **types.RouteFerryDeparture, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryDeparture
	if *v == nil {
		sv = &types.RouteFerryDeparture{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Place":
			if err := awsRestjson1_deserializeDocumentRouteFerryPlace(&sv.Place, value); err != nil {
				return err
			}

		case "Time":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.Time = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryLegDetails(v **types.RouteFerryLegDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryLegDetails
	if *v == nil {
		sv = &types.RouteFerryLegDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AfterTravelSteps":
			if err := awsRestjson1_deserializeDocumentRouteFerryAfterTravelStepList(&sv.AfterTravelSteps, value); err != nil {
				return err
			}

		case "Arrival":
			if err := awsRestjson1_deserializeDocumentRouteFerryArrival(&sv.Arrival, value); err != nil {
				return err
			}

		case "BeforeTravelSteps":
			if err := awsRestjson1_deserializeDocumentRouteFerryBeforeTravelStepList(&sv.BeforeTravelSteps, value); err != nil {
				return err
			}

		case "Departure":
			if err := awsRestjson1_deserializeDocumentRouteFerryDeparture(&sv.Departure, value); err != nil {
				return err
			}

		case "Notices":
			if err := awsRestjson1_deserializeDocumentRouteFerryNoticeList(&sv.Notices, value); err != nil {
				return err
			}

		case "PassThroughWaypoints":
			if err := awsRestjson1_deserializeDocumentRoutePassThroughWaypointList(&sv.PassThroughWaypoints, value); err != nil {
				return err
			}

		case "RouteName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.RouteName = ptr.String(jtv)
			}

		case "Spans":
			if err := awsRestjson1_deserializeDocumentRouteFerrySpanList(&sv.Spans, value); err != nil {
				return err
			}

		case "Summary":
			if err := awsRestjson1_deserializeDocumentRouteFerrySummary(&sv.Summary, value); err != nil {
				return err
			}

		case "TravelSteps":
			if err := awsRestjson1_deserializeDocumentRouteFerryTravelStepList(&sv.TravelSteps, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryNotice(v **types.RouteFerryNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryNotice
	if *v == nil {
		sv = &types.RouteFerryNotice{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteFerryNoticeCode to be of type string, got %T instead", value)
				}
				sv.Code = types.RouteFerryNoticeCode(jtv)
			}

		case "Impact":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteNoticeImpact to be of type string, got %T instead", value)
				}
				sv.Impact = types.RouteNoticeImpact(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryNoticeList(v *[]types.RouteFerryNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteFerryNotice
	if *v == nil {
		cv = []types.RouteFerryNotice{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteFerryNotice
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteFerryNotice(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryOverviewSummary(v **types.RouteFerryOverviewSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryOverviewSummary
	if *v == nil {
		sv = &types.RouteFerryOverviewSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryPlace(v **types.RouteFerryPlace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryPlace
	if *v == nil {
		sv = &types.RouteFerryPlace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OriginalPosition":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.OriginalPosition, value); err != nil {
				return err
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.Position, value); err != nil {
				return err
			}

		case "WaypointIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WaypointIndex = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerrySpan(v **types.RouteFerrySpan, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerrySpan
	if *v == nil {
		sv = &types.RouteFerrySpan{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Country":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CountryCode3 to be of type string, got %T instead", value)
				}
				sv.Country = ptr.String(jtv)
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Names":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Names, value); err != nil {
				return err
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerrySpanList(v *[]types.RouteFerrySpan, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteFerrySpan
	if *v == nil {
		cv = []types.RouteFerrySpan{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteFerrySpan
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteFerrySpan(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerrySummary(v **types.RouteFerrySummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerrySummary
	if *v == nil {
		sv = &types.RouteFerrySummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Overview":
			if err := awsRestjson1_deserializeDocumentRouteFerryOverviewSummary(&sv.Overview, value); err != nil {
				return err
			}

		case "TravelOnly":
			if err := awsRestjson1_deserializeDocumentRouteFerryTravelOnlySummary(&sv.TravelOnly, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryTravelOnlySummary(v **types.RouteFerryTravelOnlySummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryTravelOnlySummary
	if *v == nil {
		sv = &types.RouteFerryTravelOnlySummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryTravelStep(v **types.RouteFerryTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteFerryTravelStep
	if *v == nil {
		sv = &types.RouteFerryTravelStep{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Instruction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Instruction = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteFerryTravelStepType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteFerryTravelStepType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteFerryTravelStepList(v *[]types.RouteFerryTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteFerryTravelStep
	if *v == nil {
		cv = []types.RouteFerryTravelStep{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteFerryTravelStep
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteFerryTravelStep(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteHazardousCargoTypeList(v *[]types.RouteHazardousCargoType, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteHazardousCargoType
	if *v == nil {
		cv = []types.RouteHazardousCargoType{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteHazardousCargoType
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteHazardousCargoType to be of type string, got %T instead", value)
			}
			col = types.RouteHazardousCargoType(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteKeepStepDetails(v **types.RouteKeepStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteKeepStepDetails
	if *v == nil {
		sv = &types.RouteKeepStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteLeg(v **types.RouteLeg, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteLeg
	if *v == nil {
		sv = &types.RouteLeg{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FerryLegDetails":
			if err := awsRestjson1_deserializeDocumentRouteFerryLegDetails(&sv.FerryLegDetails, value); err != nil {
				return err
			}

		case "Geometry":
			if err := awsRestjson1_deserializeDocumentRouteLegGeometry(&sv.Geometry, value); err != nil {
				return err
			}

		case "Language":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LanguageTag to be of type string, got %T instead", value)
				}
				sv.Language = ptr.String(jtv)
			}

		case "PedestrianLegDetails":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianLegDetails(&sv.PedestrianLegDetails, value); err != nil {
				return err
			}

		case "TravelMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteLegTravelMode to be of type string, got %T instead", value)
				}
				sv.TravelMode = types.RouteLegTravelMode(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteLegType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteLegType(jtv)
			}

		case "VehicleLegDetails":
			if err := awsRestjson1_deserializeDocumentRouteVehicleLegDetails(&sv.VehicleLegDetails, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteLegGeometry(v **types.RouteLegGeometry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteLegGeometry
	if *v == nil {
		sv = &types.RouteLegGeometry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LineString":
			if err := awsRestjson1_deserializeDocumentLineString(&sv.LineString, value); err != nil {
				return err
			}

		case "Polyline":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Polyline to be of type string, got %T instead", value)
				}
				sv.Polyline = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteLegList(v *[]types.RouteLeg, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteLeg
	if *v == nil {
		cv = []types.RouteLeg{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteLeg
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteLeg(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteList(v *[]types.Route, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Route
	if *v == nil {
		cv = []types.Route{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Route
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoute(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMajorRoadLabel(v **types.RouteMajorRoadLabel, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteMajorRoadLabel
	if *v == nil {
		sv = &types.RouteMajorRoadLabel{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RoadName":
			if err := awsRestjson1_deserializeDocumentLocalizedString(&sv.RoadName, value); err != nil {
				return err
			}

		case "RouteNumber":
			if err := awsRestjson1_deserializeDocumentRouteNumber(&sv.RouteNumber, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMajorRoadLabelList(v *[]types.RouteMajorRoadLabel, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteMajorRoadLabel
	if *v == nil {
		cv = []types.RouteMajorRoadLabel{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteMajorRoadLabel
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteMajorRoadLabel(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMatrix(v *[][]types.RouteMatrixEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv [][]types.RouteMatrixEntry
	if *v == nil {
		cv = [][]types.RouteMatrixEntry{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col []types.RouteMatrixEntry
		if err := awsRestjson1_deserializeDocumentRouteMatrixRow(&col, value); err != nil {
			return err
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMatrixAutoCircle(v **types.RouteMatrixAutoCircle, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteMatrixAutoCircle
	if *v == nil {
		sv = &types.RouteMatrixAutoCircle{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Margin":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Margin = i64
			}

		case "MaxRadius":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxRadius = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMatrixBoundary(v **types.RouteMatrixBoundary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteMatrixBoundary
	if *v == nil {
		sv = &types.RouteMatrixBoundary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Geometry":
			if err := awsRestjson1_deserializeDocumentRouteMatrixBoundaryGeometry(&sv.Geometry, value); err != nil {
				return err
			}

		case "Unbounded":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Unbounded = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMatrixBoundaryGeometry(v **types.RouteMatrixBoundaryGeometry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteMatrixBoundaryGeometry
	if *v == nil {
		sv = &types.RouteMatrixBoundaryGeometry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutoCircle":
			if err := awsRestjson1_deserializeDocumentRouteMatrixAutoCircle(&sv.AutoCircle, value); err != nil {
				return err
			}

		case "BoundingBox":
			if err := awsRestjson1_deserializeDocumentBoundingBox(&sv.BoundingBox, value); err != nil {
				return err
			}

		case "Circle":
			if err := awsRestjson1_deserializeDocumentCircle(&sv.Circle, value); err != nil {
				return err
			}

		case "Polygon":
			if err := awsRestjson1_deserializeDocumentLinearRings(&sv.Polygon, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMatrixEntry(v **types.RouteMatrixEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteMatrixEntry
	if *v == nil {
		sv = &types.RouteMatrixEntry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "Error":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteMatrixErrorCode to be of type string, got %T instead", value)
				}
				sv.Error = types.RouteMatrixErrorCode(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteMatrixRow(v *[]types.RouteMatrixEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteMatrixEntry
	if *v == nil {
		cv = []types.RouteMatrixEntry{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteMatrixEntry
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteMatrixEntry(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteNoticeDetailRange(v **types.RouteNoticeDetailRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteNoticeDetailRange
	if *v == nil {
		sv = &types.RouteNoticeDetailRange{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteNumber(v **types.RouteNumber, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteNumber
	if *v == nil {
		sv = &types.RouteNumber{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Direction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteDirection to be of type string, got %T instead", value)
				}
				sv.Direction = types.RouteDirection(jtv)
			}

		case "Language":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LanguageTag to be of type string, got %T instead", value)
				}
				sv.Language = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteNumberList(v *[]types.RouteNumber, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteNumber
	if *v == nil {
		cv = []types.RouteNumber{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteNumber
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteNumber(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePassThroughPlace(v **types.RoutePassThroughPlace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePassThroughPlace
	if *v == nil {
		sv = &types.RoutePassThroughPlace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "OriginalPosition":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.OriginalPosition, value); err != nil {
				return err
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.Position, value); err != nil {
				return err
			}

		case "WaypointIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WaypointIndex = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePassThroughWaypoint(v **types.RoutePassThroughWaypoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePassThroughWaypoint
	if *v == nil {
		sv = &types.RoutePassThroughWaypoint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Place":
			if err := awsRestjson1_deserializeDocumentRoutePassThroughPlace(&sv.Place, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePassThroughWaypointList(v *[]types.RoutePassThroughWaypoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RoutePassThroughWaypoint
	if *v == nil {
		cv = []types.RoutePassThroughWaypoint{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RoutePassThroughWaypoint
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoutePassThroughWaypoint(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianArrival(v **types.RoutePedestrianArrival, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianArrival
	if *v == nil {
		sv = &types.RoutePedestrianArrival{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Place":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianPlace(&sv.Place, value); err != nil {
				return err
			}

		case "Time":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.Time = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianDeparture(v **types.RoutePedestrianDeparture, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianDeparture
	if *v == nil {
		sv = &types.RoutePedestrianDeparture{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Place":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianPlace(&sv.Place, value); err != nil {
				return err
			}

		case "Time":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.Time = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianLegDetails(v **types.RoutePedestrianLegDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianLegDetails
	if *v == nil {
		sv = &types.RoutePedestrianLegDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arrival":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianArrival(&sv.Arrival, value); err != nil {
				return err
			}

		case "Departure":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianDeparture(&sv.Departure, value); err != nil {
				return err
			}

		case "Notices":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianNoticeList(&sv.Notices, value); err != nil {
				return err
			}

		case "PassThroughWaypoints":
			if err := awsRestjson1_deserializeDocumentRoutePassThroughWaypointList(&sv.PassThroughWaypoints, value); err != nil {
				return err
			}

		case "Spans":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianSpanList(&sv.Spans, value); err != nil {
				return err
			}

		case "Summary":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianSummary(&sv.Summary, value); err != nil {
				return err
			}

		case "TravelSteps":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianTravelStepList(&sv.TravelSteps, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianNotice(v **types.RoutePedestrianNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianNotice
	if *v == nil {
		sv = &types.RoutePedestrianNotice{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RoutePedestrianNoticeCode to be of type string, got %T instead", value)
				}
				sv.Code = types.RoutePedestrianNoticeCode(jtv)
			}

		case "Impact":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteNoticeImpact to be of type string, got %T instead", value)
				}
				sv.Impact = types.RouteNoticeImpact(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianNoticeList(v *[]types.RoutePedestrianNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RoutePedestrianNotice
	if *v == nil {
		cv = []types.RoutePedestrianNotice{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RoutePedestrianNotice
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoutePedestrianNotice(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianOverviewSummary(v **types.RoutePedestrianOverviewSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianOverviewSummary
	if *v == nil {
		sv = &types.RoutePedestrianOverviewSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianPlace(v **types.RoutePedestrianPlace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianPlace
	if *v == nil {
		sv = &types.RoutePedestrianPlace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OriginalPosition":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.OriginalPosition, value); err != nil {
				return err
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.Position, value); err != nil {
				return err
			}

		case "SideOfStreet":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSideOfStreet to be of type string, got %T instead", value)
				}
				sv.SideOfStreet = types.RouteSideOfStreet(jtv)
			}

		case "WaypointIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WaypointIndex = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianSpan(v **types.RoutePedestrianSpan, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianSpan
	if *v == nil {
		sv = &types.RoutePedestrianSpan{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BestCaseDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BestCaseDuration = i64
			}

		case "Country":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CountryCode3 to be of type string, got %T instead", value)
				}
				sv.Country = ptr.String(jtv)
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "DynamicSpeed":
			if err := awsRestjson1_deserializeDocumentRouteSpanDynamicSpeedDetails(&sv.DynamicSpeed, value); err != nil {
				return err
			}

		case "FunctionalClassification":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FunctionalClassification = ptr.Int32(int32(i64))
			}

		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Incidents":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.Incidents, value); err != nil {
				return err
			}

		case "Names":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Names, value); err != nil {
				return err
			}

		case "PedestrianAccess":
			if err := awsRestjson1_deserializeDocumentRouteSpanPedestrianAccessAttributeList(&sv.PedestrianAccess, value); err != nil {
				return err
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		case "RoadAttributes":
			if err := awsRestjson1_deserializeDocumentRouteSpanRoadAttributeList(&sv.RoadAttributes, value); err != nil {
				return err
			}

		case "RouteNumbers":
			if err := awsRestjson1_deserializeDocumentRouteNumberList(&sv.RouteNumbers, value); err != nil {
				return err
			}

		case "SpeedLimit":
			if err := awsRestjson1_deserializeDocumentRouteSpanSpeedLimitDetails(&sv.SpeedLimit, value); err != nil {
				return err
			}

		case "TypicalDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TypicalDuration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianSpanList(v *[]types.RoutePedestrianSpan, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RoutePedestrianSpan
	if *v == nil {
		cv = []types.RoutePedestrianSpan{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RoutePedestrianSpan
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoutePedestrianSpan(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianSummary(v **types.RoutePedestrianSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianSummary
	if *v == nil {
		sv = &types.RoutePedestrianSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Overview":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianOverviewSummary(&sv.Overview, value); err != nil {
				return err
			}

		case "TravelOnly":
			if err := awsRestjson1_deserializeDocumentRoutePedestrianTravelOnlySummary(&sv.TravelOnly, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianTravelOnlySummary(v **types.RoutePedestrianTravelOnlySummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianTravelOnlySummary
	if *v == nil {
		sv = &types.RoutePedestrianTravelOnlySummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianTravelStep(v **types.RoutePedestrianTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RoutePedestrianTravelStep
	if *v == nil {
		sv = &types.RoutePedestrianTravelStep{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContinueStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteContinueStepDetails(&sv.ContinueStepDetails, value); err != nil {
				return err
			}

		case "CurrentRoad":
			if err := awsRestjson1_deserializeDocumentRouteRoad(&sv.CurrentRoad, value); err != nil {
				return err
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "ExitNumber":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.ExitNumber, value); err != nil {
				return err
			}

		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Instruction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Instruction = ptr.String(jtv)
			}

		case "KeepStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteKeepStepDetails(&sv.KeepStepDetails, value); err != nil {
				return err
			}

		case "NextRoad":
			if err := awsRestjson1_deserializeDocumentRouteRoad(&sv.NextRoad, value); err != nil {
				return err
			}

		case "RoundaboutEnterStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRoundaboutEnterStepDetails(&sv.RoundaboutEnterStepDetails, value); err != nil {
				return err
			}

		case "RoundaboutExitStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRoundaboutExitStepDetails(&sv.RoundaboutExitStepDetails, value); err != nil {
				return err
			}

		case "RoundaboutPassStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRoundaboutPassStepDetails(&sv.RoundaboutPassStepDetails, value); err != nil {
				return err
			}

		case "Signpost":
			if err := awsRestjson1_deserializeDocumentRouteSignpost(&sv.Signpost, value); err != nil {
				return err
			}

		case "TurnStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteTurnStepDetails(&sv.TurnStepDetails, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RoutePedestrianTravelStepType to be of type string, got %T instead", value)
				}
				sv.Type = types.RoutePedestrianTravelStepType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRoutePedestrianTravelStepList(v *[]types.RoutePedestrianTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RoutePedestrianTravelStep
	if *v == nil {
		cv = []types.RoutePedestrianTravelStep{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RoutePedestrianTravelStep
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRoutePedestrianTravelStep(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteRampStepDetails(v **types.RouteRampStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteRampStepDetails
	if *v == nil {
		sv = &types.RouteRampStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteResponseNotice(v **types.RouteResponseNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteResponseNotice
	if *v == nil {
		sv = &types.RouteResponseNotice{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteResponseNoticeCode to be of type string, got %T instead", value)
				}
				sv.Code = types.RouteResponseNoticeCode(jtv)
			}

		case "Impact":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteNoticeImpact to be of type string, got %T instead", value)
				}
				sv.Impact = types.RouteNoticeImpact(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteResponseNoticeList(v *[]types.RouteResponseNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteResponseNotice
	if *v == nil {
		cv = []types.RouteResponseNotice{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteResponseNotice
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteResponseNotice(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteRoad(v **types.RouteRoad, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteRoad
	if *v == nil {
		sv = &types.RouteRoad{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RoadName":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.RoadName, value); err != nil {
				return err
			}

		case "RouteNumber":
			if err := awsRestjson1_deserializeDocumentRouteNumberList(&sv.RouteNumber, value); err != nil {
				return err
			}

		case "Towards":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Towards, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteRoadType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteRoadType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteRoundaboutEnterStepDetails(v **types.RouteRoundaboutEnterStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteRoundaboutEnterStepDetails
	if *v == nil {
		sv = &types.RouteRoundaboutEnterStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteRoundaboutExitStepDetails(v **types.RouteRoundaboutExitStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteRoundaboutExitStepDetails
	if *v == nil {
		sv = &types.RouteRoundaboutExitStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "RelativeExit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RelativeExit = ptr.Int32(int32(i64))
			}

		case "RoundaboutAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.RoundaboutAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.RoundaboutAngle = f64

				default:
					return fmt.Errorf("expected RoundaboutAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteRoundaboutPassStepDetails(v **types.RouteRoundaboutPassStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteRoundaboutPassStepDetails
	if *v == nil {
		sv = &types.RouteRoundaboutPassStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSignpost(v **types.RouteSignpost, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteSignpost
	if *v == nil {
		sv = &types.RouteSignpost{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Labels":
			if err := awsRestjson1_deserializeDocumentRouteSignpostLabelList(&sv.Labels, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSignpostLabel(v **types.RouteSignpostLabel, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteSignpostLabel
	if *v == nil {
		sv = &types.RouteSignpostLabel{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RouteNumber":
			if err := awsRestjson1_deserializeDocumentRouteNumber(&sv.RouteNumber, value); err != nil {
				return err
			}

		case "Text":
			if err := awsRestjson1_deserializeDocumentLocalizedString(&sv.Text, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSignpostLabelList(v *[]types.RouteSignpostLabel, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteSignpostLabel
	if *v == nil {
		cv = []types.RouteSignpostLabel{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteSignpostLabel
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteSignpostLabel(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanCarAccessAttributeList(v *[]types.RouteSpanCarAccessAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteSpanCarAccessAttribute
	if *v == nil {
		cv = []types.RouteSpanCarAccessAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteSpanCarAccessAttribute
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteSpanCarAccessAttribute to be of type string, got %T instead", value)
			}
			col = types.RouteSpanCarAccessAttribute(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanDynamicSpeedDetails(v **types.RouteSpanDynamicSpeedDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteSpanDynamicSpeedDetails
	if *v == nil {
		sv = &types.RouteSpanDynamicSpeedDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BestCaseSpeed":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.BestCaseSpeed = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.BestCaseSpeed = f64

				default:
					return fmt.Errorf("expected SpeedKilometersPerHour to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TurnDuration = i64
			}

		case "TypicalSpeed":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TypicalSpeed = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TypicalSpeed = f64

				default:
					return fmt.Errorf("expected SpeedKilometersPerHour to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanPedestrianAccessAttributeList(v *[]types.RouteSpanPedestrianAccessAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteSpanPedestrianAccessAttribute
	if *v == nil {
		cv = []types.RouteSpanPedestrianAccessAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteSpanPedestrianAccessAttribute
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteSpanPedestrianAccessAttribute to be of type string, got %T instead", value)
			}
			col = types.RouteSpanPedestrianAccessAttribute(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanRoadAttributeList(v *[]types.RouteSpanRoadAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteSpanRoadAttribute
	if *v == nil {
		cv = []types.RouteSpanRoadAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteSpanRoadAttribute
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteSpanRoadAttribute to be of type string, got %T instead", value)
			}
			col = types.RouteSpanRoadAttribute(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanScooterAccessAttributeList(v *[]types.RouteSpanScooterAccessAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteSpanScooterAccessAttribute
	if *v == nil {
		cv = []types.RouteSpanScooterAccessAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteSpanScooterAccessAttribute
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteSpanScooterAccessAttribute to be of type string, got %T instead", value)
			}
			col = types.RouteSpanScooterAccessAttribute(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanSpeedLimitDetails(v **types.RouteSpanSpeedLimitDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteSpanSpeedLimitDetails
	if *v == nil {
		sv = &types.RouteSpanSpeedLimitDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MaxSpeed":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.MaxSpeed = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.MaxSpeed = f64

				default:
					return fmt.Errorf("expected SpeedKilometersPerHour to be a JSON Number, got %T instead", value)

				}
			}

		case "Unlimited":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Unlimited = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSpanTruckAccessAttributeList(v *[]types.RouteSpanTruckAccessAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteSpanTruckAccessAttribute
	if *v == nil {
		cv = []types.RouteSpanTruckAccessAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteSpanTruckAccessAttribute
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteSpanTruckAccessAttribute to be of type string, got %T instead", value)
			}
			col = types.RouteSpanTruckAccessAttribute(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteSummary(v **types.RouteSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteSummary
	if *v == nil {
		sv = &types.RouteSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "Tolls":
			if err := awsRestjson1_deserializeDocumentRouteTollSummary(&sv.Tolls, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteToll(v **types.RouteToll, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteToll
	if *v == nil {
		sv = &types.RouteToll{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Country":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CountryCode3 to be of type string, got %T instead", value)
				}
				sv.Country = ptr.String(jtv)
			}

		case "PaymentSites":
			if err := awsRestjson1_deserializeDocumentRouteTollPaymentSiteList(&sv.PaymentSites, value); err != nil {
				return err
			}

		case "Rates":
			if err := awsRestjson1_deserializeDocumentRouteTollRateList(&sv.Rates, value); err != nil {
				return err
			}

		case "Systems":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.Systems, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollList(v *[]types.RouteToll, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteToll
	if *v == nil {
		cv = []types.RouteToll{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteToll
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteToll(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPass(v **types.RouteTollPass, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollPass
	if *v == nil {
		sv = &types.RouteTollPass{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IncludesReturnTrip":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IncludesReturnTrip = ptr.Bool(jtv)
			}

		case "SeniorPass":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.SeniorPass = ptr.Bool(jtv)
			}

		case "TransferCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TransferCount = ptr.Int32(int32(i64))
			}

		case "TripCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TripCount = ptr.Int32(int32(i64))
			}

		case "ValidityPeriod":
			if err := awsRestjson1_deserializeDocumentRouteTollPassValidityPeriod(&sv.ValidityPeriod, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPassValidityPeriod(v **types.RouteTollPassValidityPeriod, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollPassValidityPeriod
	if *v == nil {
		sv = &types.RouteTollPassValidityPeriod{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Period":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTollPassValidityPeriodType to be of type string, got %T instead", value)
				}
				sv.Period = types.RouteTollPassValidityPeriodType(jtv)
			}

		case "PeriodCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PeriodCount = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPaymentMethodList(v *[]types.RouteTollPaymentMethod, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteTollPaymentMethod
	if *v == nil {
		cv = []types.RouteTollPaymentMethod{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteTollPaymentMethod
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RouteTollPaymentMethod to be of type string, got %T instead", value)
			}
			col = types.RouteTollPaymentMethod(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPaymentSite(v **types.RouteTollPaymentSite, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollPaymentSite
	if *v == nil {
		sv = &types.RouteTollPaymentSite{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.Position, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPaymentSiteList(v *[]types.RouteTollPaymentSite, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteTollPaymentSite
	if *v == nil {
		cv = []types.RouteTollPaymentSite{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteTollPaymentSite
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteTollPaymentSite(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPrice(v **types.RouteTollPrice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollPrice
	if *v == nil {
		sv = &types.RouteTollPrice{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Currency":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CurrencyCode to be of type string, got %T instead", value)
				}
				sv.Currency = ptr.String(jtv)
			}

		case "Estimate":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Estimate = ptr.Bool(jtv)
			}

		case "PerDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PerDuration = i64
			}

		case "Range":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Range = ptr.Bool(jtv)
			}

		case "RangeValue":
			if err := awsRestjson1_deserializeDocumentRouteTollPriceValueRange(&sv.RangeValue, value); err != nil {
				return err
			}

		case "Value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPriceSummary(v **types.RouteTollPriceSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollPriceSummary
	if *v == nil {
		sv = &types.RouteTollPriceSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Currency":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CurrencyCode to be of type string, got %T instead", value)
				}
				sv.Currency = ptr.String(jtv)
			}

		case "Estimate":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Estimate = ptr.Bool(jtv)
			}

		case "Range":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Range = ptr.Bool(jtv)
			}

		case "RangeValue":
			if err := awsRestjson1_deserializeDocumentRouteTollPriceValueRange(&sv.RangeValue, value); err != nil {
				return err
			}

		case "Value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollPriceValueRange(v **types.RouteTollPriceValueRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollPriceValueRange
	if *v == nil {
		sv = &types.RouteTollPriceValueRange{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Max = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Max = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Min":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Min = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Min = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollRate(v **types.RouteTollRate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollRate
	if *v == nil {
		sv = &types.RouteTollRate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicableTimes":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.ApplicableTimes = ptr.String(jtv)
			}

		case "ConvertedPrice":
			if err := awsRestjson1_deserializeDocumentRouteTollPrice(&sv.ConvertedPrice, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "LocalPrice":
			if err := awsRestjson1_deserializeDocumentRouteTollPrice(&sv.LocalPrice, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Pass":
			if err := awsRestjson1_deserializeDocumentRouteTollPass(&sv.Pass, value); err != nil {
				return err
			}

		case "PaymentMethods":
			if err := awsRestjson1_deserializeDocumentRouteTollPaymentMethodList(&sv.PaymentMethods, value); err != nil {
				return err
			}

		case "Transponders":
			if err := awsRestjson1_deserializeDocumentRouteTransponderList(&sv.Transponders, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollRateList(v *[]types.RouteTollRate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteTollRate
	if *v == nil {
		cv = []types.RouteTollRate{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteTollRate
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteTollRate(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollSummary(v **types.RouteTollSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollSummary
	if *v == nil {
		sv = &types.RouteTollSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Total":
			if err := awsRestjson1_deserializeDocumentRouteTollPriceSummary(&sv.Total, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollSystem(v **types.RouteTollSystem, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTollSystem
	if *v == nil {
		sv = &types.RouteTollSystem{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTollSystemList(v *[]types.RouteTollSystem, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteTollSystem
	if *v == nil {
		cv = []types.RouteTollSystem{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteTollSystem
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteTollSystem(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTransponder(v **types.RouteTransponder, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTransponder
	if *v == nil {
		sv = &types.RouteTransponder{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SystemName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.SystemName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTransponderList(v *[]types.RouteTransponder, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteTransponder
	if *v == nil {
		cv = []types.RouteTransponder{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteTransponder
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteTransponder(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteTurnStepDetails(v **types.RouteTurnStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteTurnStepDetails
	if *v == nil {
		sv = &types.RouteTurnStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteUTurnStepDetails(v **types.RouteUTurnStepDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteUTurnStepDetails
	if *v == nil {
		sv = &types.RouteUTurnStepDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Intersection":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Intersection, value); err != nil {
				return err
			}

		case "SteeringDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSteeringDirection to be of type string, got %T instead", value)
				}
				sv.SteeringDirection = types.RouteSteeringDirection(jtv)
			}

		case "TurnAngle":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.TurnAngle = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.TurnAngle = f64

				default:
					return fmt.Errorf("expected TurnAngle to be a JSON Number, got %T instead", value)

				}
			}

		case "TurnIntensity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTurnIntensity to be of type string, got %T instead", value)
				}
				sv.TurnIntensity = types.RouteTurnIntensity(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleArrival(v **types.RouteVehicleArrival, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleArrival
	if *v == nil {
		sv = &types.RouteVehicleArrival{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Place":
			if err := awsRestjson1_deserializeDocumentRouteVehiclePlace(&sv.Place, value); err != nil {
				return err
			}

		case "Time":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.Time = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleDeparture(v **types.RouteVehicleDeparture, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleDeparture
	if *v == nil {
		sv = &types.RouteVehicleDeparture{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Place":
			if err := awsRestjson1_deserializeDocumentRouteVehiclePlace(&sv.Place, value); err != nil {
				return err
			}

		case "Time":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.Time = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleIncident(v **types.RouteVehicleIncident, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleIncident
	if *v == nil {
		sv = &types.RouteVehicleIncident{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.EndTime = ptr.String(jtv)
			}

		case "Severity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteVehicleIncidentSeverity to be of type string, got %T instead", value)
				}
				sv.Severity = types.RouteVehicleIncidentSeverity(jtv)
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.StartTime = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteVehicleIncidentType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteVehicleIncidentType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleIncidentList(v *[]types.RouteVehicleIncident, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteVehicleIncident
	if *v == nil {
		cv = []types.RouteVehicleIncident{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteVehicleIncident
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteVehicleIncident(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleLegDetails(v **types.RouteVehicleLegDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleLegDetails
	if *v == nil {
		sv = &types.RouteVehicleLegDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arrival":
			if err := awsRestjson1_deserializeDocumentRouteVehicleArrival(&sv.Arrival, value); err != nil {
				return err
			}

		case "Departure":
			if err := awsRestjson1_deserializeDocumentRouteVehicleDeparture(&sv.Departure, value); err != nil {
				return err
			}

		case "Incidents":
			if err := awsRestjson1_deserializeDocumentRouteVehicleIncidentList(&sv.Incidents, value); err != nil {
				return err
			}

		case "Notices":
			if err := awsRestjson1_deserializeDocumentRouteVehicleNoticeList(&sv.Notices, value); err != nil {
				return err
			}

		case "PassThroughWaypoints":
			if err := awsRestjson1_deserializeDocumentRoutePassThroughWaypointList(&sv.PassThroughWaypoints, value); err != nil {
				return err
			}

		case "Spans":
			if err := awsRestjson1_deserializeDocumentRouteVehicleSpanList(&sv.Spans, value); err != nil {
				return err
			}

		case "Summary":
			if err := awsRestjson1_deserializeDocumentRouteVehicleSummary(&sv.Summary, value); err != nil {
				return err
			}

		case "Tolls":
			if err := awsRestjson1_deserializeDocumentRouteTollList(&sv.Tolls, value); err != nil {
				return err
			}

		case "TollSystems":
			if err := awsRestjson1_deserializeDocumentRouteTollSystemList(&sv.TollSystems, value); err != nil {
				return err
			}

		case "TravelSteps":
			if err := awsRestjson1_deserializeDocumentRouteVehicleTravelStepList(&sv.TravelSteps, value); err != nil {
				return err
			}

		case "TruckRoadTypes":
			if err := awsRestjson1_deserializeDocumentTruckRoadTypeList(&sv.TruckRoadTypes, value); err != nil {
				return err
			}

		case "Zones":
			if err := awsRestjson1_deserializeDocumentRouteZoneList(&sv.Zones, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleNotice(v **types.RouteVehicleNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleNotice
	if *v == nil {
		sv = &types.RouteVehicleNotice{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteVehicleNoticeCode to be of type string, got %T instead", value)
				}
				sv.Code = types.RouteVehicleNoticeCode(jtv)
			}

		case "Details":
			if err := awsRestjson1_deserializeDocumentRouteVehicleNoticeDetailList(&sv.Details, value); err != nil {
				return err
			}

		case "Impact":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteNoticeImpact to be of type string, got %T instead", value)
				}
				sv.Impact = types.RouteNoticeImpact(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleNoticeDetail(v **types.RouteVehicleNoticeDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleNoticeDetail
	if *v == nil {
		sv = &types.RouteVehicleNoticeDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "ViolatedConstraints":
			if err := awsRestjson1_deserializeDocumentRouteViolatedConstraints(&sv.ViolatedConstraints, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleNoticeDetailList(v *[]types.RouteVehicleNoticeDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteVehicleNoticeDetail
	if *v == nil {
		cv = []types.RouteVehicleNoticeDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteVehicleNoticeDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteVehicleNoticeDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleNoticeList(v *[]types.RouteVehicleNotice, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteVehicleNotice
	if *v == nil {
		cv = []types.RouteVehicleNotice{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteVehicleNotice
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteVehicleNotice(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleOverviewSummary(v **types.RouteVehicleOverviewSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleOverviewSummary
	if *v == nil {
		sv = &types.RouteVehicleOverviewSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BestCaseDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BestCaseDuration = i64
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "TypicalDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TypicalDuration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehiclePlace(v **types.RouteVehiclePlace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehiclePlace
	if *v == nil {
		sv = &types.RouteVehiclePlace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OriginalPosition":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.OriginalPosition, value); err != nil {
				return err
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition23(&sv.Position, value); err != nil {
				return err
			}

		case "SideOfStreet":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSideOfStreet to be of type string, got %T instead", value)
				}
				sv.SideOfStreet = types.RouteSideOfStreet(jtv)
			}

		case "WaypointIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WaypointIndex = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleSpan(v **types.RouteVehicleSpan, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleSpan
	if *v == nil {
		sv = &types.RouteVehicleSpan{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BestCaseDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BestCaseDuration = i64
			}

		case "CarAccess":
			if err := awsRestjson1_deserializeDocumentRouteSpanCarAccessAttributeList(&sv.CarAccess, value); err != nil {
				return err
			}

		case "Country":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CountryCode3 to be of type string, got %T instead", value)
				}
				sv.Country = ptr.String(jtv)
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "DynamicSpeed":
			if err := awsRestjson1_deserializeDocumentRouteSpanDynamicSpeedDetails(&sv.DynamicSpeed, value); err != nil {
				return err
			}

		case "FunctionalClassification":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FunctionalClassification = ptr.Int32(int32(i64))
			}

		case "Gate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSpanGateAttribute to be of type string, got %T instead", value)
				}
				sv.Gate = types.RouteSpanGateAttribute(jtv)
			}

		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Incidents":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.Incidents, value); err != nil {
				return err
			}

		case "Names":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.Names, value); err != nil {
				return err
			}

		case "Notices":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.Notices, value); err != nil {
				return err
			}

		case "RailwayCrossing":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteSpanRailwayCrossingAttribute to be of type string, got %T instead", value)
				}
				sv.RailwayCrossing = types.RouteSpanRailwayCrossingAttribute(jtv)
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		case "RoadAttributes":
			if err := awsRestjson1_deserializeDocumentRouteSpanRoadAttributeList(&sv.RoadAttributes, value); err != nil {
				return err
			}

		case "RouteNumbers":
			if err := awsRestjson1_deserializeDocumentRouteNumberList(&sv.RouteNumbers, value); err != nil {
				return err
			}

		case "ScooterAccess":
			if err := awsRestjson1_deserializeDocumentRouteSpanScooterAccessAttributeList(&sv.ScooterAccess, value); err != nil {
				return err
			}

		case "SpeedLimit":
			if err := awsRestjson1_deserializeDocumentRouteSpanSpeedLimitDetails(&sv.SpeedLimit, value); err != nil {
				return err
			}

		case "TollSystems":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.TollSystems, value); err != nil {
				return err
			}

		case "TruckAccess":
			if err := awsRestjson1_deserializeDocumentRouteSpanTruckAccessAttributeList(&sv.TruckAccess, value); err != nil {
				return err
			}

		case "TruckRoadTypes":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.TruckRoadTypes, value); err != nil {
				return err
			}

		case "TypicalDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TypicalDuration = i64
			}

		case "Zones":
			if err := awsRestjson1_deserializeDocumentIndexList(&sv.Zones, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleSpanList(v *[]types.RouteVehicleSpan, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteVehicleSpan
	if *v == nil {
		cv = []types.RouteVehicleSpan{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteVehicleSpan
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteVehicleSpan(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleSummary(v **types.RouteVehicleSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleSummary
	if *v == nil {
		sv = &types.RouteVehicleSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Overview":
			if err := awsRestjson1_deserializeDocumentRouteVehicleOverviewSummary(&sv.Overview, value); err != nil {
				return err
			}

		case "TravelOnly":
			if err := awsRestjson1_deserializeDocumentRouteVehicleTravelOnlySummary(&sv.TravelOnly, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleTravelOnlySummary(v **types.RouteVehicleTravelOnlySummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleTravelOnlySummary
	if *v == nil {
		sv = &types.RouteVehicleTravelOnlySummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BestCaseDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BestCaseDuration = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "TypicalDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TypicalDuration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleTravelStep(v **types.RouteVehicleTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteVehicleTravelStep
	if *v == nil {
		sv = &types.RouteVehicleTravelStep{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContinueHighwayStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteContinueHighwayStepDetails(&sv.ContinueHighwayStepDetails, value); err != nil {
				return err
			}

		case "ContinueStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteContinueStepDetails(&sv.ContinueStepDetails, value); err != nil {
				return err
			}

		case "CurrentRoad":
			if err := awsRestjson1_deserializeDocumentRouteRoad(&sv.CurrentRoad, value); err != nil {
				return err
			}

		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "Duration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Duration = i64
			}

		case "EnterHighwayStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteEnterHighwayStepDetails(&sv.EnterHighwayStepDetails, value); err != nil {
				return err
			}

		case "ExitNumber":
			if err := awsRestjson1_deserializeDocumentLocalizedStringList(&sv.ExitNumber, value); err != nil {
				return err
			}

		case "ExitStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteExitStepDetails(&sv.ExitStepDetails, value); err != nil {
				return err
			}

		case "GeometryOffset":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GeometryOffset = ptr.Int32(int32(i64))
			}

		case "Instruction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Instruction = ptr.String(jtv)
			}

		case "KeepStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteKeepStepDetails(&sv.KeepStepDetails, value); err != nil {
				return err
			}

		case "NextRoad":
			if err := awsRestjson1_deserializeDocumentRouteRoad(&sv.NextRoad, value); err != nil {
				return err
			}

		case "RampStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRampStepDetails(&sv.RampStepDetails, value); err != nil {
				return err
			}

		case "RoundaboutEnterStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRoundaboutEnterStepDetails(&sv.RoundaboutEnterStepDetails, value); err != nil {
				return err
			}

		case "RoundaboutExitStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRoundaboutExitStepDetails(&sv.RoundaboutExitStepDetails, value); err != nil {
				return err
			}

		case "RoundaboutPassStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteRoundaboutPassStepDetails(&sv.RoundaboutPassStepDetails, value); err != nil {
				return err
			}

		case "Signpost":
			if err := awsRestjson1_deserializeDocumentRouteSignpost(&sv.Signpost, value); err != nil {
				return err
			}

		case "TurnStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteTurnStepDetails(&sv.TurnStepDetails, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteVehicleTravelStepType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteVehicleTravelStepType(jtv)
			}

		case "UTurnStepDetails":
			if err := awsRestjson1_deserializeDocumentRouteUTurnStepDetails(&sv.UTurnStepDetails, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteVehicleTravelStepList(v *[]types.RouteVehicleTravelStep, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteVehicleTravelStep
	if *v == nil {
		cv = []types.RouteVehicleTravelStep{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteVehicleTravelStep
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteVehicleTravelStep(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRouteViolatedConstraints(v **types.RouteViolatedConstraints, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteViolatedConstraints
	if *v == nil {
		sv = &types.RouteViolatedConstraints{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllHazardsRestricted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AllHazardsRestricted = ptr.Bool(jtv)
			}

		case "AxleCount":
			if err := awsRestjson1_deserializeDocumentRouteNoticeDetailRange(&sv.AxleCount, value); err != nil {
				return err
			}

		case "HazardousCargos":
			if err := awsRestjson1_deserializeDocumentRouteHazardousCargoTypeList(&sv.HazardousCargos, value); err != nil {
				return err
			}

		case "MaxHeight":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DimensionCentimeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxHeight = i64
			}

		case "MaxKpraLength":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DimensionCentimeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxKpraLength = i64
			}

		case "MaxLength":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DimensionCentimeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxLength = i64
			}

		case "MaxPayloadCapacity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxPayloadCapacity = i64
			}

		case "MaxWeight":
			if err := awsRestjson1_deserializeDocumentRouteWeightConstraint(&sv.MaxWeight, value); err != nil {
				return err
			}

		case "MaxWeightPerAxle":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxWeightPerAxle = i64
			}

		case "MaxWeightPerAxleGroup":
			if err := awsRestjson1_deserializeDocumentWeightPerAxleGroup(&sv.MaxWeightPerAxleGroup, value); err != nil {
				return err
			}

		case "MaxWidth":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DimensionCentimeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxWidth = i64
			}

		case "Occupancy":
			if err := awsRestjson1_deserializeDocumentRouteNoticeDetailRange(&sv.Occupancy, value); err != nil {
				return err
			}

		case "RestrictedTimes":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.RestrictedTimes = ptr.String(jtv)
			}

		case "TimeDependent":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.TimeDependent = ptr.Bool(jtv)
			}

		case "TrailerCount":
			if err := awsRestjson1_deserializeDocumentRouteNoticeDetailRange(&sv.TrailerCount, value); err != nil {
				return err
			}

		case "TravelMode":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.TravelMode = ptr.Bool(jtv)
			}

		case "TruckRoadType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.TruckRoadType = ptr.String(jtv)
			}

		case "TruckType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteTruckType to be of type string, got %T instead", value)
				}
				sv.TruckType = types.RouteTruckType(jtv)
			}

		case "TunnelRestrictionCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TunnelRestrictionCode to be of type string, got %T instead", value)
				}
				sv.TunnelRestrictionCode = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteWeightConstraint(v **types.RouteWeightConstraint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteWeightConstraint
	if *v == nil {
		sv = &types.RouteWeightConstraint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteWeightConstraintType to be of type string, got %T instead", value)
				}
				sv.Type = types.RouteWeightConstraintType(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Value = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteZone(v **types.RouteZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RouteZone
	if *v == nil {
		sv = &types.RouteZone{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Category":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RouteZoneCategory to be of type string, got %T instead", value)
				}
				sv.Category = types.RouteZoneCategory(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRouteZoneList(v *[]types.RouteZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RouteZone
	if *v == nil {
		cv = []types.RouteZone{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RouteZone
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRouteZone(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentThrottlingException(v **types.ThrottlingException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ThrottlingException
	if *v == nil {
		sv = &types.ThrottlingException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTruckRoadTypeList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected TruckRoadType to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentValidationException(v **types.ValidationException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ValidationException
	if *v == nil {
		sv = &types.ValidationException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "fieldList":
			if err := awsRestjson1_deserializeDocumentValidationExceptionFieldList(&sv.FieldList, value); err != nil {
				return err
			}

		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ValidationExceptionReason to be of type string, got %T instead", value)
				}
				sv.Reason = types.ValidationExceptionReason(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentValidationExceptionField(v **types.ValidationExceptionField, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ValidationExceptionField
	if *v == nil {
		sv = &types.ValidationExceptionField{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentValidationExceptionFieldList(v *[]types.ValidationExceptionField, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ValidationExceptionField
	if *v == nil {
		cv = []types.ValidationExceptionField{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ValidationExceptionField
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentValidationExceptionField(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationConnection(v **types.WaypointOptimizationConnection, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaypointOptimizationConnection
	if *v == nil {
		sv = &types.WaypointOptimizationConnection{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Distance":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DistanceMeters to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Distance = i64
			}

		case "From":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WaypointId to be of type string, got %T instead", value)
				}
				sv.From = ptr.String(jtv)
			}

		case "RestDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RestDuration = i64
			}

		case "To":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WaypointId to be of type string, got %T instead", value)
				}
				sv.To = ptr.String(jtv)
			}

		case "TravelDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TravelDuration = i64
			}

		case "WaitDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WaitDuration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationConnectionList(v *[]types.WaypointOptimizationConnection, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WaypointOptimizationConnection
	if *v == nil {
		cv = []types.WaypointOptimizationConnection{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WaypointOptimizationConnection
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentWaypointOptimizationConnection(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationFailedConstraint(v **types.WaypointOptimizationFailedConstraint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaypointOptimizationFailedConstraint
	if *v == nil {
		sv = &types.WaypointOptimizationFailedConstraint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Constraint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WaypointOptimizationConstraint to be of type string, got %T instead", value)
				}
				sv.Constraint = types.WaypointOptimizationConstraint(jtv)
			}

		case "Reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationFailedConstraintList(v *[]types.WaypointOptimizationFailedConstraint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WaypointOptimizationFailedConstraint
	if *v == nil {
		cv = []types.WaypointOptimizationFailedConstraint{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WaypointOptimizationFailedConstraint
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentWaypointOptimizationFailedConstraint(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationImpedingWaypoint(v **types.WaypointOptimizationImpedingWaypoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaypointOptimizationImpedingWaypoint
	if *v == nil {
		sv = &types.WaypointOptimizationImpedingWaypoint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailedConstraints":
			if err := awsRestjson1_deserializeDocumentWaypointOptimizationFailedConstraintList(&sv.FailedConstraints, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WaypointId to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.Position, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationImpedingWaypointList(v *[]types.WaypointOptimizationImpedingWaypoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WaypointOptimizationImpedingWaypoint
	if *v == nil {
		cv = []types.WaypointOptimizationImpedingWaypoint{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WaypointOptimizationImpedingWaypoint
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentWaypointOptimizationImpedingWaypoint(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationOptimizedWaypoint(v **types.WaypointOptimizationOptimizedWaypoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaypointOptimizationOptimizedWaypoint
	if *v == nil {
		sv = &types.WaypointOptimizationOptimizedWaypoint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ArrivalTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.ArrivalTime = ptr.String(jtv)
			}

		case "ClusterIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected ClusterIndex to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ClusterIndex = ptr.Int32(int32(i64))
			}

		case "DepartureTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimestampWithTimezoneOffset to be of type string, got %T instead", value)
				}
				sv.DepartureTime = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WaypointId to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Position":
			if err := awsRestjson1_deserializeDocumentPosition(&sv.Position, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationOptimizedWaypointList(v *[]types.WaypointOptimizationOptimizedWaypoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WaypointOptimizationOptimizedWaypoint
	if *v == nil {
		cv = []types.WaypointOptimizationOptimizedWaypoint{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WaypointOptimizationOptimizedWaypoint
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentWaypointOptimizationOptimizedWaypoint(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentWaypointOptimizationTimeBreakdown(v **types.WaypointOptimizationTimeBreakdown, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaypointOptimizationTimeBreakdown
	if *v == nil {
		sv = &types.WaypointOptimizationTimeBreakdown{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RestDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RestDuration = i64
			}

		case "ServiceDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ServiceDuration = i64
			}

		case "TravelDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TravelDuration = i64
			}

		case "WaitDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DurationSeconds to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WaitDuration = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWeightPerAxleGroup(v **types.WeightPerAxleGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WeightPerAxleGroup
	if *v == nil {
		sv = &types.WeightPerAxleGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Quad":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Quad = i64
			}

		case "Quint":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Quint = i64
			}

		case "Single":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Single = i64
			}

		case "Tandem":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Tandem = i64
			}

		case "Triple":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected WeightKilograms to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Triple = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}
