// Code generated by smithy-go-codegen DO NOT EDIT.

package evs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/evs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists environment VLANs that are associated with the specified environment.
func (c *Client) ListEnvironmentVlans(ctx context.Context, params *ListEnvironmentVlansInput, optFns ...func(*Options)) (*ListEnvironmentVlansOutput, error) {
	if params == nil {
		params = &ListEnvironmentVlansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEnvironmentVlans", params, optFns, c.addOperationListEnvironmentVlansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEnvironmentVlansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEnvironmentVlansInput struct {

	// A unique ID for the environment.
	//
	// This member is required.
	EnvironmentId *string

	// The maximum number of results to return. If you specify MaxResults in the
	// request, the response includes information up to the limit specified.
	MaxResults *int32

	// A unique pagination token for each page. If nextToken is returned, there are
	// more results available. Make the call again using the returned token with all
	// other arguments unchanged to retrieve the next page. Each pagination token
	// expires after 24 hours. Using an expired pagination token will return an HTTP
	// 400 InvalidToken error.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEnvironmentVlansOutput struct {

	// A list of VLANs that are associated with the specified environment.
	EnvironmentVlans []types.Vlan

	// A unique pagination token for next page results. Make the call again using this
	// token to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEnvironmentVlansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEnvironmentVlans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEnvironmentVlans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEnvironmentVlans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEnvironmentVlansValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEnvironmentVlans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEnvironmentVlansPaginatorOptions is the paginator options for
// ListEnvironmentVlans
type ListEnvironmentVlansPaginatorOptions struct {
	// The maximum number of results to return. If you specify MaxResults in the
	// request, the response includes information up to the limit specified.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEnvironmentVlansPaginator is a paginator for ListEnvironmentVlans
type ListEnvironmentVlansPaginator struct {
	options   ListEnvironmentVlansPaginatorOptions
	client    ListEnvironmentVlansAPIClient
	params    *ListEnvironmentVlansInput
	nextToken *string
	firstPage bool
}

// NewListEnvironmentVlansPaginator returns a new ListEnvironmentVlansPaginator
func NewListEnvironmentVlansPaginator(client ListEnvironmentVlansAPIClient, params *ListEnvironmentVlansInput, optFns ...func(*ListEnvironmentVlansPaginatorOptions)) *ListEnvironmentVlansPaginator {
	if params == nil {
		params = &ListEnvironmentVlansInput{}
	}

	options := ListEnvironmentVlansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEnvironmentVlansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEnvironmentVlansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEnvironmentVlans page.
func (p *ListEnvironmentVlansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEnvironmentVlansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEnvironmentVlans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEnvironmentVlansAPIClient is a client that implements the
// ListEnvironmentVlans operation.
type ListEnvironmentVlansAPIClient interface {
	ListEnvironmentVlans(context.Context, *ListEnvironmentVlansInput, ...func(*Options)) (*ListEnvironmentVlansOutput, error)
}

var _ ListEnvironmentVlansAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEnvironmentVlans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEnvironmentVlans",
	}
}
