// Code generated by smithy-go-codegen DO NOT EDIT.

package dsql

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/dsql/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// The UpdateCluster API allows you to modify both single-Region and multi-Region
// cluster configurations. With the multiRegionProperties parameter, you can add or
// modify witness Region support and manage peer relationships with clusters in
// other Regions.
//
// Note that updating multi-region clusters requires additional IAM permissions
// beyond those needed for standard cluster updates, as detailed in the Permissions
// section.
//
// # Required permissions
//
// dsql:UpdateCluster Permission to update a DSQL cluster.
//
// Resources: arn:aws:dsql:region:account-id:cluster/cluster-id
//
// dsql:PutMultiRegionProperties Permission to configure multi-Region properties
// for a cluster.
//
// Resources: arn:aws:dsql:region:account-id:cluster/cluster-id
//
// dsql:GetCluster Permission to retrieve cluster information.
//
// Resources: arn:aws:dsql:region:account-id:cluster/cluster-id
//
// dsql:AddPeerCluster Permission to add peer clusters.
//
// Resources:
//
//   - Local cluster: arn:aws:dsql:region:account-id:cluster/cluster-id
//
//   - Each peer cluster: exact ARN of each specified peer cluster
//
// dsql:RemovePeerCluster Permission to remove peer clusters. The
// dsql:RemovePeerCluster permission uses a wildcard ARN pattern to simplify
// permission management during updates.
//
// Resources: arn:aws:dsql:*:account-id:cluster/*
//
// dsql:PutWitnessRegion Permission to set a witness Region.
//
// Resources: arn:aws:dsql:region:account-id:cluster/cluster-id
//
// Condition Keys: dsql:WitnessRegion (matching the specified witness Region)
//
// This permission is checked both in the cluster Region and in the witness
// Region.
//
//   - The witness region specified in multiRegionProperties.witnessRegion cannot
//     be the same as the cluster's Region.
//
//   - When updating clusters with peer relationships, permissions are checked for
//     both adding and removing peers.
//
//   - The dsql:RemovePeerCluster permission uses a wildcard ARN pattern to
//     simplify permission management during updates.
func (c *Client) UpdateCluster(ctx context.Context, params *UpdateClusterInput, optFns ...func(*Options)) (*UpdateClusterOutput, error) {
	if params == nil {
		params = &UpdateClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateCluster", params, optFns, c.addOperationUpdateClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateClusterInput struct {

	// The ID of the cluster you want to update.
	//
	// This member is required.
	Identifier *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully. The
	// subsequent retries with the same client token return the result from the
	// original successful request and they have no additional effect.
	//
	// If you don't specify a client token, the Amazon Web Services SDK automatically
	// generates one.
	ClientToken *string

	// Specifies whether to enable deletion protection in your cluster.
	DeletionProtectionEnabled *bool

	// The KMS key that encrypts and protects the data on your cluster. You can
	// specify the ARN, ID, or alias of an existing key or have Amazon Web Services
	// create a default key for you.
	KmsEncryptionKey *string

	// The new multi-Region cluster configuration settings to be applied during an
	// update operation.
	MultiRegionProperties *types.MultiRegionProperties

	noSmithyDocumentSerde
}

// The details of the cluster after it has been updated.
type UpdateClusterOutput struct {

	// The ARN of the updated cluster.
	//
	// This member is required.
	Arn *string

	// The time of when the cluster was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The ID of the cluster to update.
	//
	// This member is required.
	Identifier *string

	// The status of the updated cluster.
	//
	// This member is required.
	Status types.ClusterStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateClusterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateCluster struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateCluster) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateClusterInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateClusterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateCluster{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateCluster",
	}
}
