// Code generated by smithy-go-codegen DO NOT EDIT.

package docdb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/docdb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Promotes the specified secondary DB cluster to be the primary DB cluster in the
// global cluster when failing over a global cluster occurs.
//
// Use this operation to respond to an unplanned event, such as a regional
// disaster in the primary region. Failing over can result in a loss of write
// transaction data that wasn't replicated to the chosen secondary before the
// failover event occurred. However, the recovery process that promotes a DB
// instance on the chosen seconday DB cluster to be the primary writer DB instance
// guarantees that the data is in a transactionally consistent state.
func (c *Client) FailoverGlobalCluster(ctx context.Context, params *FailoverGlobalClusterInput, optFns ...func(*Options)) (*FailoverGlobalClusterOutput, error) {
	if params == nil {
		params = &FailoverGlobalClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "FailoverGlobalCluster", params, optFns, c.addOperationFailoverGlobalClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*FailoverGlobalClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type FailoverGlobalClusterInput struct {

	// The identifier of the Amazon DocumentDB global cluster to apply this operation.
	// The identifier is the unique key assigned by the user when the cluster is
	// created. In other words, it's the name of the global cluster.
	//
	// Constraints:
	//
	//   - Must match the identifier of an existing global cluster.
	//
	//   - Minimum length of 1. Maximum length of 255.
	//
	// Pattern: [A-Za-z][0-9A-Za-z-:._]*
	//
	// This member is required.
	GlobalClusterIdentifier *string

	// The identifier of the secondary Amazon DocumentDB cluster that you want to
	// promote to the primary for the global cluster. Use the Amazon Resource Name
	// (ARN) for the identifier so that Amazon DocumentDB can locate the cluster in its
	// Amazon Web Services region.
	//
	// Constraints:
	//
	//   - Must match the identifier of an existing secondary cluster.
	//
	//   - Minimum length of 1. Maximum length of 255.
	//
	// Pattern: [A-Za-z][0-9A-Za-z-:._]*
	//
	// This member is required.
	TargetDbClusterIdentifier *string

	// Specifies whether to allow data loss for this global cluster operation.
	// Allowing data loss triggers a global failover operation.
	//
	// If you don't specify AllowDataLoss , the global cluster operation defaults to a
	// switchover.
	//
	// Constraints:
	//
	//   - Can't be specified together with the Switchover parameter.
	AllowDataLoss *bool

	// Specifies whether to switch over this global database cluster.
	//
	// Constraints:
	//
	//   - Can't be specified together with the AllowDataLoss parameter.
	Switchover *bool

	noSmithyDocumentSerde
}

type FailoverGlobalClusterOutput struct {

	// A data type representing an Amazon DocumentDB global cluster.
	GlobalCluster *types.GlobalCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationFailoverGlobalClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpFailoverGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpFailoverGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "FailoverGlobalCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpFailoverGlobalClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opFailoverGlobalCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opFailoverGlobalCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "FailoverGlobalCluster",
	}
}
