// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the layout to view data for a specific domain. This API can only be
// invoked from the Amazon Connect admin website.
func (c *Client) GetDomainLayout(ctx context.Context, params *GetDomainLayoutInput, optFns ...func(*Options)) (*GetDomainLayoutOutput, error) {
	if params == nil {
		params = &GetDomainLayoutInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDomainLayout", params, optFns, c.addOperationGetDomainLayoutMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDomainLayoutOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDomainLayoutInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The unique name of the layout.
	//
	// This member is required.
	LayoutDefinitionName *string

	noSmithyDocumentSerde
}

type GetDomainLayoutOutput struct {

	// The timestamp of when the layout was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The description of the layout
	//
	// This member is required.
	Description *string

	// The display name of the layout
	//
	// This member is required.
	DisplayName *string

	// The timestamp of when the layout was most recently updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// A customizable layout that can be used to view data under a Customer Profiles
	// domain.
	//
	// This member is required.
	Layout *string

	// The unique name of the layout.
	//
	// This member is required.
	LayoutDefinitionName *string

	// The type of layout that can be used to view data under a Customer Profiles
	// domain.
	//
	// This member is required.
	LayoutType types.LayoutType

	// The version used to create layout.
	//
	// This member is required.
	Version *string

	// If set to true for a layout, this layout will be used by default to view data.
	// If set to false, then the layout will not be used by default, but it can be used
	// to view data by explicitly selecting it in the console.
	IsDefault bool

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDomainLayoutMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDomainLayout{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDomainLayout{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDomainLayout"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDomainLayoutValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDomainLayout(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDomainLayout(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDomainLayout",
	}
}
