// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the cost anomaly monitor definitions for your account. You can filter
// using a list of cost anomaly monitor Amazon Resource Names (ARNs).
func (c *Client) GetAnomalyMonitors(ctx context.Context, params *GetAnomalyMonitorsInput, optFns ...func(*Options)) (*GetAnomalyMonitorsOutput, error) {
	if params == nil {
		params = &GetAnomalyMonitorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAnomalyMonitors", params, optFns, c.addOperationGetAnomalyMonitorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAnomalyMonitorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAnomalyMonitorsInput struct {

	// The number of entries that a paginated response contains.
	MaxResults *int32

	// A list of cost anomaly monitor ARNs.
	MonitorArnList []string

	// The token to retrieve the next set of results. Amazon Web Services provides the
	// token when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string

	noSmithyDocumentSerde
}

type GetAnomalyMonitorsOutput struct {

	// A list of cost anomaly monitors that includes the detailed metadata for each
	// monitor.
	//
	// This member is required.
	AnomalyMonitors []types.AnomalyMonitor

	// The token to retrieve the next set of results. Amazon Web Services provides the
	// token when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAnomalyMonitorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetAnomalyMonitors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetAnomalyMonitors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAnomalyMonitors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAnomalyMonitors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetAnomalyMonitorsPaginatorOptions is the paginator options for
// GetAnomalyMonitors
type GetAnomalyMonitorsPaginatorOptions struct {
	// The number of entries that a paginated response contains.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetAnomalyMonitorsPaginator is a paginator for GetAnomalyMonitors
type GetAnomalyMonitorsPaginator struct {
	options   GetAnomalyMonitorsPaginatorOptions
	client    GetAnomalyMonitorsAPIClient
	params    *GetAnomalyMonitorsInput
	nextToken *string
	firstPage bool
}

// NewGetAnomalyMonitorsPaginator returns a new GetAnomalyMonitorsPaginator
func NewGetAnomalyMonitorsPaginator(client GetAnomalyMonitorsAPIClient, params *GetAnomalyMonitorsInput, optFns ...func(*GetAnomalyMonitorsPaginatorOptions)) *GetAnomalyMonitorsPaginator {
	if params == nil {
		params = &GetAnomalyMonitorsInput{}
	}

	options := GetAnomalyMonitorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetAnomalyMonitorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextPageToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetAnomalyMonitorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetAnomalyMonitors page.
func (p *GetAnomalyMonitorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetAnomalyMonitorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextPageToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetAnomalyMonitors(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextPageToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetAnomalyMonitorsAPIClient is a client that implements the GetAnomalyMonitors
// operation.
type GetAnomalyMonitorsAPIClient interface {
	GetAnomalyMonitors(context.Context, *GetAnomalyMonitorsInput, ...func(*Options)) (*GetAnomalyMonitorsOutput, error)
}

var _ GetAnomalyMonitorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetAnomalyMonitors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAnomalyMonitors",
	}
}
