// Code generated by smithy-go-codegen DO NOT EDIT.

package connectcampaignsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connectcampaignsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides summary information about the integration under the specified Connect
// instance.
func (c *Client) ListConnectInstanceIntegrations(ctx context.Context, params *ListConnectInstanceIntegrationsInput, optFns ...func(*Options)) (*ListConnectInstanceIntegrationsOutput, error) {
	if params == nil {
		params = &ListConnectInstanceIntegrationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConnectInstanceIntegrations", params, optFns, c.addOperationListConnectInstanceIntegrationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConnectInstanceIntegrationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request for ListConnectInstanceIntegrations API.
type ListConnectInstanceIntegrationsInput struct {

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

// The response for ListConnectInstanceIntegrations API.
type ListConnectInstanceIntegrationsOutput struct {

	// A list of Amazon Connect Instance Integrations.
	IntegrationSummaryList []types.IntegrationSummary

	// The token for the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConnectInstanceIntegrationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConnectInstanceIntegrations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConnectInstanceIntegrations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConnectInstanceIntegrations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListConnectInstanceIntegrationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConnectInstanceIntegrations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListConnectInstanceIntegrationsPaginatorOptions is the paginator options for
// ListConnectInstanceIntegrations
type ListConnectInstanceIntegrationsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConnectInstanceIntegrationsPaginator is a paginator for
// ListConnectInstanceIntegrations
type ListConnectInstanceIntegrationsPaginator struct {
	options   ListConnectInstanceIntegrationsPaginatorOptions
	client    ListConnectInstanceIntegrationsAPIClient
	params    *ListConnectInstanceIntegrationsInput
	nextToken *string
	firstPage bool
}

// NewListConnectInstanceIntegrationsPaginator returns a new
// ListConnectInstanceIntegrationsPaginator
func NewListConnectInstanceIntegrationsPaginator(client ListConnectInstanceIntegrationsAPIClient, params *ListConnectInstanceIntegrationsInput, optFns ...func(*ListConnectInstanceIntegrationsPaginatorOptions)) *ListConnectInstanceIntegrationsPaginator {
	if params == nil {
		params = &ListConnectInstanceIntegrationsInput{}
	}

	options := ListConnectInstanceIntegrationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConnectInstanceIntegrationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConnectInstanceIntegrationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConnectInstanceIntegrations page.
func (p *ListConnectInstanceIntegrationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConnectInstanceIntegrationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConnectInstanceIntegrations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConnectInstanceIntegrationsAPIClient is a client that implements the
// ListConnectInstanceIntegrations operation.
type ListConnectInstanceIntegrationsAPIClient interface {
	ListConnectInstanceIntegrations(context.Context, *ListConnectInstanceIntegrationsInput, ...func(*Options)) (*ListConnectInstanceIntegrationsOutput, error)
}

var _ ListConnectInstanceIntegrationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConnectInstanceIntegrations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConnectInstanceIntegrations",
	}
}
