// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudsearch

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/cloudsearch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsquery_serializeOpBuildSuggesters struct {
}

func (*awsAwsquery_serializeOpBuildSuggesters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpBuildSuggesters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BuildSuggestersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("BuildSuggesters")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentBuildSuggestersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateDomain struct {
}

func (*awsAwsquery_serializeOpCreateDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateDomain")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentCreateDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDefineAnalysisScheme struct {
}

func (*awsAwsquery_serializeOpDefineAnalysisScheme) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDefineAnalysisScheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DefineAnalysisSchemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DefineAnalysisScheme")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDefineAnalysisSchemeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDefineExpression struct {
}

func (*awsAwsquery_serializeOpDefineExpression) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDefineExpression) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DefineExpressionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DefineExpression")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDefineExpressionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDefineIndexField struct {
}

func (*awsAwsquery_serializeOpDefineIndexField) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDefineIndexField) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DefineIndexFieldInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DefineIndexField")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDefineIndexFieldInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDefineSuggester struct {
}

func (*awsAwsquery_serializeOpDefineSuggester) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDefineSuggester) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DefineSuggesterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DefineSuggester")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDefineSuggesterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteAnalysisScheme struct {
}

func (*awsAwsquery_serializeOpDeleteAnalysisScheme) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteAnalysisScheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAnalysisSchemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteAnalysisScheme")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteAnalysisSchemeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteDomain struct {
}

func (*awsAwsquery_serializeOpDeleteDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteDomain")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteExpression struct {
}

func (*awsAwsquery_serializeOpDeleteExpression) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteExpression) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteExpressionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteExpression")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteExpressionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteIndexField struct {
}

func (*awsAwsquery_serializeOpDeleteIndexField) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteIndexField) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIndexFieldInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteIndexField")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteIndexFieldInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteSuggester struct {
}

func (*awsAwsquery_serializeOpDeleteSuggester) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteSuggester) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSuggesterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSuggester")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDeleteSuggesterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAnalysisSchemes struct {
}

func (*awsAwsquery_serializeOpDescribeAnalysisSchemes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAnalysisSchemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnalysisSchemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAnalysisSchemes")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAnalysisSchemesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAvailabilityOptions struct {
}

func (*awsAwsquery_serializeOpDescribeAvailabilityOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAvailabilityOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAvailabilityOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAvailabilityOptions")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAvailabilityOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeDomainEndpointOptions struct {
}

func (*awsAwsquery_serializeOpDescribeDomainEndpointOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeDomainEndpointOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDomainEndpointOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDomainEndpointOptions")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeDomainEndpointOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeDomains struct {
}

func (*awsAwsquery_serializeOpDescribeDomains) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeDomains) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDomainsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDomains")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeDomainsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeExpressions struct {
}

func (*awsAwsquery_serializeOpDescribeExpressions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeExpressions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeExpressionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeExpressions")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeExpressionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeIndexFields struct {
}

func (*awsAwsquery_serializeOpDescribeIndexFields) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeIndexFields) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIndexFieldsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeIndexFields")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeIndexFieldsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeScalingParameters struct {
}

func (*awsAwsquery_serializeOpDescribeScalingParameters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeScalingParameters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScalingParametersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScalingParameters")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeScalingParametersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeServiceAccessPolicies struct {
}

func (*awsAwsquery_serializeOpDescribeServiceAccessPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeServiceAccessPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeServiceAccessPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeServiceAccessPolicies")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeServiceAccessPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeSuggesters struct {
}

func (*awsAwsquery_serializeOpDescribeSuggesters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeSuggesters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSuggestersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSuggesters")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentDescribeSuggestersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpIndexDocuments struct {
}

func (*awsAwsquery_serializeOpIndexDocuments) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpIndexDocuments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IndexDocumentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("IndexDocuments")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentIndexDocumentsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListDomainNames struct {
}

func (*awsAwsquery_serializeOpListDomainNames) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListDomainNames) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDomainNamesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListDomainNames")
	body.Key("Version").String("2013-01-01")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateAvailabilityOptions struct {
}

func (*awsAwsquery_serializeOpUpdateAvailabilityOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateAvailabilityOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAvailabilityOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateAvailabilityOptions")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentUpdateAvailabilityOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateDomainEndpointOptions struct {
}

func (*awsAwsquery_serializeOpUpdateDomainEndpointOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateDomainEndpointOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDomainEndpointOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateDomainEndpointOptions")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentUpdateDomainEndpointOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateScalingParameters struct {
}

func (*awsAwsquery_serializeOpUpdateScalingParameters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateScalingParameters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateScalingParametersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateScalingParameters")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentUpdateScalingParametersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUpdateServiceAccessPolicies struct {
}

func (*awsAwsquery_serializeOpUpdateServiceAccessPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUpdateServiceAccessPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateServiceAccessPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateServiceAccessPolicies")
	body.Key("Version").String("2013-01-01")

	if err := awsAwsquery_serializeOpDocumentUpdateServiceAccessPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAnalysisOptions(v *types.AnalysisOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AlgorithmicStemming) > 0 {
		objectKey := object.Key("AlgorithmicStemming")
		objectKey.String(string(v.AlgorithmicStemming))
	}

	if v.JapaneseTokenizationDictionary != nil {
		objectKey := object.Key("JapaneseTokenizationDictionary")
		objectKey.String(*v.JapaneseTokenizationDictionary)
	}

	if v.StemmingDictionary != nil {
		objectKey := object.Key("StemmingDictionary")
		objectKey.String(*v.StemmingDictionary)
	}

	if v.Stopwords != nil {
		objectKey := object.Key("Stopwords")
		objectKey.String(*v.Stopwords)
	}

	if v.Synonyms != nil {
		objectKey := object.Key("Synonyms")
		objectKey.String(*v.Synonyms)
	}

	return nil
}

func awsAwsquery_serializeDocumentAnalysisScheme(v *types.AnalysisScheme, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnalysisOptions != nil {
		objectKey := object.Key("AnalysisOptions")
		if err := awsAwsquery_serializeDocumentAnalysisOptions(v.AnalysisOptions, objectKey); err != nil {
			return err
		}
	}

	if len(v.AnalysisSchemeLanguage) > 0 {
		objectKey := object.Key("AnalysisSchemeLanguage")
		objectKey.String(string(v.AnalysisSchemeLanguage))
	}

	if v.AnalysisSchemeName != nil {
		objectKey := object.Key("AnalysisSchemeName")
		objectKey.String(*v.AnalysisSchemeName)
	}

	return nil
}

func awsAwsquery_serializeDocumentDateArrayOptions(v *types.DateArrayOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SourceFields != nil {
		objectKey := object.Key("SourceFields")
		objectKey.String(*v.SourceFields)
	}

	return nil
}

func awsAwsquery_serializeDocumentDateOptions(v *types.DateOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SortEnabled != nil {
		objectKey := object.Key("SortEnabled")
		objectKey.Boolean(*v.SortEnabled)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeDocumentDocumentSuggesterOptions(v *types.DocumentSuggesterOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FuzzyMatching) > 0 {
		objectKey := object.Key("FuzzyMatching")
		objectKey.String(string(v.FuzzyMatching))
	}

	if v.SortExpression != nil {
		objectKey := object.Key("SortExpression")
		objectKey.String(*v.SortExpression)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeDocumentDomainEndpointOptions(v *types.DomainEndpointOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EnforceHTTPS != nil {
		objectKey := object.Key("EnforceHTTPS")
		objectKey.Boolean(*v.EnforceHTTPS)
	}

	if len(v.TLSSecurityPolicy) > 0 {
		objectKey := object.Key("TLSSecurityPolicy")
		objectKey.String(string(v.TLSSecurityPolicy))
	}

	return nil
}

func awsAwsquery_serializeDocumentDomainNameList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentDoubleArrayOptions(v *types.DoubleArrayOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		switch {
		case math.IsNaN(*v.DefaultValue):
			objectKey.String("NaN")

		case math.IsInf(*v.DefaultValue, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.DefaultValue, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.DefaultValue)

		}
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SourceFields != nil {
		objectKey := object.Key("SourceFields")
		objectKey.String(*v.SourceFields)
	}

	return nil
}

func awsAwsquery_serializeDocumentDoubleOptions(v *types.DoubleOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		switch {
		case math.IsNaN(*v.DefaultValue):
			objectKey.String("NaN")

		case math.IsInf(*v.DefaultValue, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.DefaultValue, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.DefaultValue)

		}
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SortEnabled != nil {
		objectKey := object.Key("SortEnabled")
		objectKey.Boolean(*v.SortEnabled)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeDocumentDynamicFieldNameList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentExpression(v *types.Expression, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ExpressionName != nil {
		objectKey := object.Key("ExpressionName")
		objectKey.String(*v.ExpressionName)
	}

	if v.ExpressionValue != nil {
		objectKey := object.Key("ExpressionValue")
		objectKey.String(*v.ExpressionValue)
	}

	return nil
}

func awsAwsquery_serializeDocumentIndexField(v *types.IndexField, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DateArrayOptions != nil {
		objectKey := object.Key("DateArrayOptions")
		if err := awsAwsquery_serializeDocumentDateArrayOptions(v.DateArrayOptions, objectKey); err != nil {
			return err
		}
	}

	if v.DateOptions != nil {
		objectKey := object.Key("DateOptions")
		if err := awsAwsquery_serializeDocumentDateOptions(v.DateOptions, objectKey); err != nil {
			return err
		}
	}

	if v.DoubleArrayOptions != nil {
		objectKey := object.Key("DoubleArrayOptions")
		if err := awsAwsquery_serializeDocumentDoubleArrayOptions(v.DoubleArrayOptions, objectKey); err != nil {
			return err
		}
	}

	if v.DoubleOptions != nil {
		objectKey := object.Key("DoubleOptions")
		if err := awsAwsquery_serializeDocumentDoubleOptions(v.DoubleOptions, objectKey); err != nil {
			return err
		}
	}

	if v.IndexFieldName != nil {
		objectKey := object.Key("IndexFieldName")
		objectKey.String(*v.IndexFieldName)
	}

	if len(v.IndexFieldType) > 0 {
		objectKey := object.Key("IndexFieldType")
		objectKey.String(string(v.IndexFieldType))
	}

	if v.IntArrayOptions != nil {
		objectKey := object.Key("IntArrayOptions")
		if err := awsAwsquery_serializeDocumentIntArrayOptions(v.IntArrayOptions, objectKey); err != nil {
			return err
		}
	}

	if v.IntOptions != nil {
		objectKey := object.Key("IntOptions")
		if err := awsAwsquery_serializeDocumentIntOptions(v.IntOptions, objectKey); err != nil {
			return err
		}
	}

	if v.LatLonOptions != nil {
		objectKey := object.Key("LatLonOptions")
		if err := awsAwsquery_serializeDocumentLatLonOptions(v.LatLonOptions, objectKey); err != nil {
			return err
		}
	}

	if v.LiteralArrayOptions != nil {
		objectKey := object.Key("LiteralArrayOptions")
		if err := awsAwsquery_serializeDocumentLiteralArrayOptions(v.LiteralArrayOptions, objectKey); err != nil {
			return err
		}
	}

	if v.LiteralOptions != nil {
		objectKey := object.Key("LiteralOptions")
		if err := awsAwsquery_serializeDocumentLiteralOptions(v.LiteralOptions, objectKey); err != nil {
			return err
		}
	}

	if v.TextArrayOptions != nil {
		objectKey := object.Key("TextArrayOptions")
		if err := awsAwsquery_serializeDocumentTextArrayOptions(v.TextArrayOptions, objectKey); err != nil {
			return err
		}
	}

	if v.TextOptions != nil {
		objectKey := object.Key("TextOptions")
		if err := awsAwsquery_serializeDocumentTextOptions(v.TextOptions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentIntArrayOptions(v *types.IntArrayOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.Long(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SourceFields != nil {
		objectKey := object.Key("SourceFields")
		objectKey.String(*v.SourceFields)
	}

	return nil
}

func awsAwsquery_serializeDocumentIntOptions(v *types.IntOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.Long(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SortEnabled != nil {
		objectKey := object.Key("SortEnabled")
		objectKey.Boolean(*v.SortEnabled)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeDocumentLatLonOptions(v *types.LatLonOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SortEnabled != nil {
		objectKey := object.Key("SortEnabled")
		objectKey.Boolean(*v.SortEnabled)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeDocumentLiteralArrayOptions(v *types.LiteralArrayOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SourceFields != nil {
		objectKey := object.Key("SourceFields")
		objectKey.String(*v.SourceFields)
	}

	return nil
}

func awsAwsquery_serializeDocumentLiteralOptions(v *types.LiteralOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.FacetEnabled != nil {
		objectKey := object.Key("FacetEnabled")
		objectKey.Boolean(*v.FacetEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SearchEnabled != nil {
		objectKey := object.Key("SearchEnabled")
		objectKey.Boolean(*v.SearchEnabled)
	}

	if v.SortEnabled != nil {
		objectKey := object.Key("SortEnabled")
		objectKey.Boolean(*v.SortEnabled)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeDocumentScalingParameters(v *types.ScalingParameters, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.DesiredInstanceType) > 0 {
		objectKey := object.Key("DesiredInstanceType")
		objectKey.String(string(v.DesiredInstanceType))
	}

	if v.DesiredPartitionCount != 0 {
		objectKey := object.Key("DesiredPartitionCount")
		objectKey.Integer(v.DesiredPartitionCount)
	}

	if v.DesiredReplicationCount != 0 {
		objectKey := object.Key("DesiredReplicationCount")
		objectKey.Integer(v.DesiredReplicationCount)
	}

	return nil
}

func awsAwsquery_serializeDocumentStandardNameList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSuggester(v *types.Suggester, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DocumentSuggesterOptions != nil {
		objectKey := object.Key("DocumentSuggesterOptions")
		if err := awsAwsquery_serializeDocumentDocumentSuggesterOptions(v.DocumentSuggesterOptions, objectKey); err != nil {
			return err
		}
	}

	if v.SuggesterName != nil {
		objectKey := object.Key("SuggesterName")
		objectKey.String(*v.SuggesterName)
	}

	return nil
}

func awsAwsquery_serializeDocumentTextArrayOptions(v *types.TextArrayOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnalysisScheme != nil {
		objectKey := object.Key("AnalysisScheme")
		objectKey.String(*v.AnalysisScheme)
	}

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.HighlightEnabled != nil {
		objectKey := object.Key("HighlightEnabled")
		objectKey.Boolean(*v.HighlightEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SourceFields != nil {
		objectKey := object.Key("SourceFields")
		objectKey.String(*v.SourceFields)
	}

	return nil
}

func awsAwsquery_serializeDocumentTextOptions(v *types.TextOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnalysisScheme != nil {
		objectKey := object.Key("AnalysisScheme")
		objectKey.String(*v.AnalysisScheme)
	}

	if v.DefaultValue != nil {
		objectKey := object.Key("DefaultValue")
		objectKey.String(*v.DefaultValue)
	}

	if v.HighlightEnabled != nil {
		objectKey := object.Key("HighlightEnabled")
		objectKey.Boolean(*v.HighlightEnabled)
	}

	if v.ReturnEnabled != nil {
		objectKey := object.Key("ReturnEnabled")
		objectKey.Boolean(*v.ReturnEnabled)
	}

	if v.SortEnabled != nil {
		objectKey := object.Key("SortEnabled")
		objectKey.Boolean(*v.SortEnabled)
	}

	if v.SourceField != nil {
		objectKey := object.Key("SourceField")
		objectKey.String(*v.SourceField)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentBuildSuggestersInput(v *BuildSuggestersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateDomainInput(v *CreateDomainInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDefineAnalysisSchemeInput(v *DefineAnalysisSchemeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnalysisScheme != nil {
		objectKey := object.Key("AnalysisScheme")
		if err := awsAwsquery_serializeDocumentAnalysisScheme(v.AnalysisScheme, objectKey); err != nil {
			return err
		}
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDefineExpressionInput(v *DefineExpressionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.Expression != nil {
		objectKey := object.Key("Expression")
		if err := awsAwsquery_serializeDocumentExpression(v.Expression, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDefineIndexFieldInput(v *DefineIndexFieldInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.IndexField != nil {
		objectKey := object.Key("IndexField")
		if err := awsAwsquery_serializeDocumentIndexField(v.IndexField, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDefineSuggesterInput(v *DefineSuggesterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.Suggester != nil {
		objectKey := object.Key("Suggester")
		if err := awsAwsquery_serializeDocumentSuggester(v.Suggester, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteAnalysisSchemeInput(v *DeleteAnalysisSchemeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnalysisSchemeName != nil {
		objectKey := object.Key("AnalysisSchemeName")
		objectKey.String(*v.AnalysisSchemeName)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteDomainInput(v *DeleteDomainInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteExpressionInput(v *DeleteExpressionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.ExpressionName != nil {
		objectKey := object.Key("ExpressionName")
		objectKey.String(*v.ExpressionName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteIndexFieldInput(v *DeleteIndexFieldInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.IndexFieldName != nil {
		objectKey := object.Key("IndexFieldName")
		objectKey.String(*v.IndexFieldName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteSuggesterInput(v *DeleteSuggesterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.SuggesterName != nil {
		objectKey := object.Key("SuggesterName")
		objectKey.String(*v.SuggesterName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAnalysisSchemesInput(v *DescribeAnalysisSchemesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnalysisSchemeNames != nil {
		objectKey := object.Key("AnalysisSchemeNames")
		if err := awsAwsquery_serializeDocumentStandardNameList(v.AnalysisSchemeNames, objectKey); err != nil {
			return err
		}
	}

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAvailabilityOptionsInput(v *DescribeAvailabilityOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeDomainEndpointOptionsInput(v *DescribeDomainEndpointOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeDomainsInput(v *DescribeDomainsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainNames != nil {
		objectKey := object.Key("DomainNames")
		if err := awsAwsquery_serializeDocumentDomainNameList(v.DomainNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeExpressionsInput(v *DescribeExpressionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.ExpressionNames != nil {
		objectKey := object.Key("ExpressionNames")
		if err := awsAwsquery_serializeDocumentStandardNameList(v.ExpressionNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeIndexFieldsInput(v *DescribeIndexFieldsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.FieldNames != nil {
		objectKey := object.Key("FieldNames")
		if err := awsAwsquery_serializeDocumentDynamicFieldNameList(v.FieldNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeScalingParametersInput(v *DescribeScalingParametersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeServiceAccessPoliciesInput(v *DescribeServiceAccessPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeSuggestersInput(v *DescribeSuggestersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Deployed != nil {
		objectKey := object.Key("Deployed")
		objectKey.Boolean(*v.Deployed)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.SuggesterNames != nil {
		objectKey := object.Key("SuggesterNames")
		if err := awsAwsquery_serializeDocumentStandardNameList(v.SuggesterNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentIndexDocumentsInput(v *IndexDocumentsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateAvailabilityOptionsInput(v *UpdateAvailabilityOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.MultiAZ != nil {
		objectKey := object.Key("MultiAZ")
		objectKey.Boolean(*v.MultiAZ)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateDomainEndpointOptionsInput(v *UpdateDomainEndpointOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainEndpointOptions != nil {
		objectKey := object.Key("DomainEndpointOptions")
		if err := awsAwsquery_serializeDocumentDomainEndpointOptions(v.DomainEndpointOptions, objectKey); err != nil {
			return err
		}
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateScalingParametersInput(v *UpdateScalingParametersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	if v.ScalingParameters != nil {
		objectKey := object.Key("ScalingParameters")
		if err := awsAwsquery_serializeDocumentScalingParameters(v.ScalingParameters, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUpdateServiceAccessPoliciesInput(v *UpdateServiceAccessPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccessPolicies != nil {
		objectKey := object.Key("AccessPolicies")
		objectKey.String(*v.AccessPolicies)
	}

	if v.DomainName != nil {
		objectKey := object.Key("DomainName")
		objectKey.String(*v.DomainName)
	}

	return nil
}
