// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about the configured model algorithm association in a
// collaboration.
func (c *Client) GetCollaborationConfiguredModelAlgorithmAssociation(ctx context.Context, params *GetCollaborationConfiguredModelAlgorithmAssociationInput, optFns ...func(*Options)) (*GetCollaborationConfiguredModelAlgorithmAssociationOutput, error) {
	if params == nil {
		params = &GetCollaborationConfiguredModelAlgorithmAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCollaborationConfiguredModelAlgorithmAssociation", params, optFns, c.addOperationGetCollaborationConfiguredModelAlgorithmAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCollaborationConfiguredModelAlgorithmAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCollaborationConfiguredModelAlgorithmAssociationInput struct {

	// The collaboration ID for the collaboration that contains the configured model
	// algorithm association that you want to return information about.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The Amazon Resource Name (ARN) of the configured model algorithm association
	// that you want to return information about.
	//
	// This member is required.
	ConfiguredModelAlgorithmAssociationArn *string

	noSmithyDocumentSerde
}

type GetCollaborationConfiguredModelAlgorithmAssociationOutput struct {

	// The collaboration ID of the collaboration that contains the configured model
	// algorithm association.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The Amazon Resource Name (ARN) of the configured model algorithm association.
	//
	// This member is required.
	ConfiguredModelAlgorithmArn *string

	// The Amazon Resource Name (ARN) of the configured model algorithm association.
	//
	// This member is required.
	ConfiguredModelAlgorithmAssociationArn *string

	// The time at which the configured model algorithm association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The account ID of the member that created the configured model algorithm
	// association.
	//
	// This member is required.
	CreatorAccountId *string

	// The membership ID of the member that created the configured model algorithm
	// association.
	//
	// This member is required.
	MembershipIdentifier *string

	// The name of the configured model algorithm association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured model algorithm association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured model algorithm association.
	Description *string

	// Information about the privacy configuration for a configured model algorithm
	// association.
	PrivacyConfiguration *types.PrivacyConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCollaborationConfiguredModelAlgorithmAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCollaborationConfiguredModelAlgorithmAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCollaborationConfiguredModelAlgorithmAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCollaborationConfiguredModelAlgorithmAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCollaborationConfiguredModelAlgorithmAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCollaborationConfiguredModelAlgorithmAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCollaborationConfiguredModelAlgorithmAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCollaborationConfiguredModelAlgorithmAssociation",
	}
}
