// Code generated by smithy-go-codegen DO NOT EDIT.

package chatbot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chatbot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
func (c *Client) ListMicrosoftTeamsChannelConfigurations(ctx context.Context, params *ListMicrosoftTeamsChannelConfigurationsInput, optFns ...func(*Options)) (*ListMicrosoftTeamsChannelConfigurationsOutput, error) {
	if params == nil {
		params = &ListMicrosoftTeamsChannelConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMicrosoftTeamsChannelConfigurations", params, optFns, c.addOperationListMicrosoftTeamsChannelConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMicrosoftTeamsChannelConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMicrosoftTeamsChannelConfigurationsInput struct {

	// The maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so that
	// the remaining results can be retrieved.
	MaxResults *int32

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string

	//  The ID of the Microsoft Teams authorized with AWS Chatbot.
	//
	// To get the team ID, you must perform the initial authorization flow with
	// Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team
	// ID from the console. For more information, see [Step 1: Configure a Microsoft Teams client]in the AWS Chatbot Administrator
	// Guide.
	//
	// [Step 1: Configure a Microsoft Teams client]: https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup
	TeamId *string

	noSmithyDocumentSerde
}

type ListMicrosoftTeamsChannelConfigurationsOutput struct {

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string

	// A list of AWS Chatbot channel configurations for Microsoft Teams.
	TeamChannelConfigurations []types.TeamsChannelConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMicrosoftTeamsChannelConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMicrosoftTeamsChannelConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMicrosoftTeamsChannelConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMicrosoftTeamsChannelConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMicrosoftTeamsChannelConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListMicrosoftTeamsChannelConfigurationsPaginatorOptions is the paginator
// options for ListMicrosoftTeamsChannelConfigurations
type ListMicrosoftTeamsChannelConfigurationsPaginatorOptions struct {
	// The maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so that
	// the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMicrosoftTeamsChannelConfigurationsPaginator is a paginator for
// ListMicrosoftTeamsChannelConfigurations
type ListMicrosoftTeamsChannelConfigurationsPaginator struct {
	options   ListMicrosoftTeamsChannelConfigurationsPaginatorOptions
	client    ListMicrosoftTeamsChannelConfigurationsAPIClient
	params    *ListMicrosoftTeamsChannelConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListMicrosoftTeamsChannelConfigurationsPaginator returns a new
// ListMicrosoftTeamsChannelConfigurationsPaginator
func NewListMicrosoftTeamsChannelConfigurationsPaginator(client ListMicrosoftTeamsChannelConfigurationsAPIClient, params *ListMicrosoftTeamsChannelConfigurationsInput, optFns ...func(*ListMicrosoftTeamsChannelConfigurationsPaginatorOptions)) *ListMicrosoftTeamsChannelConfigurationsPaginator {
	if params == nil {
		params = &ListMicrosoftTeamsChannelConfigurationsInput{}
	}

	options := ListMicrosoftTeamsChannelConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMicrosoftTeamsChannelConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMicrosoftTeamsChannelConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMicrosoftTeamsChannelConfigurations page.
func (p *ListMicrosoftTeamsChannelConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMicrosoftTeamsChannelConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMicrosoftTeamsChannelConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMicrosoftTeamsChannelConfigurationsAPIClient is a client that implements
// the ListMicrosoftTeamsChannelConfigurations operation.
type ListMicrosoftTeamsChannelConfigurationsAPIClient interface {
	ListMicrosoftTeamsChannelConfigurations(context.Context, *ListMicrosoftTeamsChannelConfigurationsInput, ...func(*Options)) (*ListMicrosoftTeamsChannelConfigurationsOutput, error)
}

var _ ListMicrosoftTeamsChannelConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMicrosoftTeamsChannelConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMicrosoftTeamsChannelConfigurations",
	}
}
