// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves all the documents contained in a data source that is connected to a
// knowledge base. For more information, see [Ingest changes directly into a knowledge base]in the Amazon Bedrock User Guide.
//
// [Ingest changes directly into a knowledge base]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html
func (c *Client) ListKnowledgeBaseDocuments(ctx context.Context, params *ListKnowledgeBaseDocumentsInput, optFns ...func(*Options)) (*ListKnowledgeBaseDocumentsOutput, error) {
	if params == nil {
		params = &ListKnowledgeBaseDocumentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListKnowledgeBaseDocuments", params, optFns, c.addOperationListKnowledgeBaseDocumentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListKnowledgeBaseDocumentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListKnowledgeBaseDocumentsInput struct {

	// The unique identifier of the data source that contains the documents.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the knowledge base that is connected to the data
	// source.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	MaxResults *int32

	// If the total number of results is greater than the maxResults value provided in
	// the request, enter the token returned in the nextToken field in the response in
	// this field to return the next batch of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListKnowledgeBaseDocumentsOutput struct {

	// A list of objects, each of which contains information about the documents that
	// were retrieved.
	//
	// This member is required.
	DocumentDetails []types.KnowledgeBaseDocumentDetail

	// If the total number of results is greater than the maxResults value provided in
	// the request, use this token when making another request in the nextToken field
	// to return the next batch of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListKnowledgeBaseDocumentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListKnowledgeBaseDocuments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListKnowledgeBaseDocuments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListKnowledgeBaseDocuments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListKnowledgeBaseDocumentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListKnowledgeBaseDocuments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListKnowledgeBaseDocumentsPaginatorOptions is the paginator options for
// ListKnowledgeBaseDocuments
type ListKnowledgeBaseDocumentsPaginatorOptions struct {
	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListKnowledgeBaseDocumentsPaginator is a paginator for
// ListKnowledgeBaseDocuments
type ListKnowledgeBaseDocumentsPaginator struct {
	options   ListKnowledgeBaseDocumentsPaginatorOptions
	client    ListKnowledgeBaseDocumentsAPIClient
	params    *ListKnowledgeBaseDocumentsInput
	nextToken *string
	firstPage bool
}

// NewListKnowledgeBaseDocumentsPaginator returns a new
// ListKnowledgeBaseDocumentsPaginator
func NewListKnowledgeBaseDocumentsPaginator(client ListKnowledgeBaseDocumentsAPIClient, params *ListKnowledgeBaseDocumentsInput, optFns ...func(*ListKnowledgeBaseDocumentsPaginatorOptions)) *ListKnowledgeBaseDocumentsPaginator {
	if params == nil {
		params = &ListKnowledgeBaseDocumentsInput{}
	}

	options := ListKnowledgeBaseDocumentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListKnowledgeBaseDocumentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListKnowledgeBaseDocumentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListKnowledgeBaseDocuments page.
func (p *ListKnowledgeBaseDocumentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListKnowledgeBaseDocumentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListKnowledgeBaseDocuments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListKnowledgeBaseDocumentsAPIClient is a client that implements the
// ListKnowledgeBaseDocuments operation.
type ListKnowledgeBaseDocumentsAPIClient interface {
	ListKnowledgeBaseDocuments(context.Context, *ListKnowledgeBaseDocumentsInput, ...func(*Options)) (*ListKnowledgeBaseDocumentsOutput, error)
}

var _ ListKnowledgeBaseDocumentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListKnowledgeBaseDocuments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListKnowledgeBaseDocuments",
	}
}
