// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a consumable resource.
func (c *Client) UpdateConsumableResource(ctx context.Context, params *UpdateConsumableResourceInput, optFns ...func(*Options)) (*UpdateConsumableResourceOutput, error) {
	if params == nil {
		params = &UpdateConsumableResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateConsumableResource", params, optFns, c.addOperationUpdateConsumableResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateConsumableResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateConsumableResourceInput struct {

	// The name or ARN of the consumable resource to be updated.
	//
	// This member is required.
	ConsumableResource *string

	// If this parameter is specified and two update requests with identical payloads
	// and clientToken s are received, these requests are considered the same request
	// and the second request is rejected. A clientToken is valid for 8 hours or until
	// one hour after the consumable resource is deleted, whichever is less.
	ClientToken *string

	// Indicates how the quantity of the consumable resource will be updated. Must be
	// one of:
	//
	//   - SET
	//
	// Sets the quantity of the resource to the value specified by the quantity
	//   parameter.
	//
	//   - ADD
	//
	// Increases the quantity of the resource by the value specified by the quantity
	//   parameter.
	//
	//   - REMOVE
	//
	// Reduces the quantity of the resource by the value specified by the quantity
	//   parameter.
	Operation *string

	// The change in the total quantity of the consumable resource. The operation
	// parameter determines whether the value specified here will be the new total
	// quantity, or the amount by which the total quantity will be increased or
	// reduced. Must be a non-negative value.
	Quantity *int64

	noSmithyDocumentSerde
}

type UpdateConsumableResourceOutput struct {

	// The Amazon Resource Name (ARN) of the consumable resource.
	//
	// This member is required.
	ConsumableResourceArn *string

	// The name of the consumable resource to be updated.
	//
	// This member is required.
	ConsumableResourceName *string

	// The total amount of the consumable resource that is available.
	TotalQuantity *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateConsumableResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateConsumableResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateConsumableResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateConsumableResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateConsumableResourceMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateConsumableResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateConsumableResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateConsumableResource struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateConsumableResource) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateConsumableResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateConsumableResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateConsumableResourceInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateConsumableResourceMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateConsumableResource{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateConsumableResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateConsumableResource",
	}
}
