// Code generated by smithy-go-codegen DO NOT EDIT.

package backupsearch

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/backupsearch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpGetSearchJob struct {
}

func (*validateOpGetSearchJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetSearchJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetSearchJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetSearchJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetSearchResultExportJob struct {
}

func (*validateOpGetSearchResultExportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetSearchResultExportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetSearchResultExportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetSearchResultExportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListSearchJobBackups struct {
}

func (*validateOpListSearchJobBackups) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListSearchJobBackups) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListSearchJobBackupsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListSearchJobBackupsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListSearchJobResults struct {
}

func (*validateOpListSearchJobResults) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListSearchJobResults) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListSearchJobResultsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListSearchJobResultsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartSearchJob struct {
}

func (*validateOpStartSearchJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartSearchJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartSearchJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartSearchJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartSearchResultExportJob struct {
}

func (*validateOpStartSearchResultExportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartSearchResultExportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartSearchResultExportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartSearchResultExportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopSearchJob struct {
}

func (*validateOpStopSearchJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopSearchJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopSearchJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopSearchJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpGetSearchJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetSearchJob{}, middleware.After)
}

func addOpGetSearchResultExportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetSearchResultExportJob{}, middleware.After)
}

func addOpListSearchJobBackupsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListSearchJobBackups{}, middleware.After)
}

func addOpListSearchJobResultsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListSearchJobResults{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartSearchJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartSearchJob{}, middleware.After)
}

func addOpStartSearchResultExportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartSearchResultExportJob{}, middleware.After)
}

func addOpStopSearchJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopSearchJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateEBSItemFilter(v *types.EBSItemFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EBSItemFilter"}
	if v.FilePaths != nil {
		if err := validateStringConditionList(v.FilePaths); err != nil {
			invalidParams.AddNested("FilePaths", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sizes != nil {
		if err := validateLongConditionList(v.Sizes); err != nil {
			invalidParams.AddNested("Sizes", err.(smithy.InvalidParamsError))
		}
	}
	if v.CreationTimes != nil {
		if err := validateTimeConditionList(v.CreationTimes); err != nil {
			invalidParams.AddNested("CreationTimes", err.(smithy.InvalidParamsError))
		}
	}
	if v.LastModificationTimes != nil {
		if err := validateTimeConditionList(v.LastModificationTimes); err != nil {
			invalidParams.AddNested("LastModificationTimes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEBSItemFilters(v []types.EBSItemFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EBSItemFilters"}
	for i := range v {
		if err := validateEBSItemFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportSpecification(v types.ExportSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportSpecification"}
	switch uv := v.(type) {
	case *types.ExportSpecificationMemberS3ExportSpecification:
		if err := validateS3ExportSpecification(&uv.Value); err != nil {
			invalidParams.AddNested("[s3ExportSpecification]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateItemFilters(v *types.ItemFilters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ItemFilters"}
	if v.S3ItemFilters != nil {
		if err := validateS3ItemFilters(v.S3ItemFilters); err != nil {
			invalidParams.AddNested("S3ItemFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.EBSItemFilters != nil {
		if err := validateEBSItemFilters(v.EBSItemFilters); err != nil {
			invalidParams.AddNested("EBSItemFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLongCondition(v *types.LongCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LongCondition"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLongConditionList(v []types.LongCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LongConditionList"}
	for i := range v {
		if err := validateLongCondition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ExportSpecification(v *types.S3ExportSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ExportSpecification"}
	if v.DestinationBucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationBucket"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ItemFilter(v *types.S3ItemFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ItemFilter"}
	if v.ObjectKeys != nil {
		if err := validateStringConditionList(v.ObjectKeys); err != nil {
			invalidParams.AddNested("ObjectKeys", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sizes != nil {
		if err := validateLongConditionList(v.Sizes); err != nil {
			invalidParams.AddNested("Sizes", err.(smithy.InvalidParamsError))
		}
	}
	if v.CreationTimes != nil {
		if err := validateTimeConditionList(v.CreationTimes); err != nil {
			invalidParams.AddNested("CreationTimes", err.(smithy.InvalidParamsError))
		}
	}
	if v.VersionIds != nil {
		if err := validateStringConditionList(v.VersionIds); err != nil {
			invalidParams.AddNested("VersionIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.ETags != nil {
		if err := validateStringConditionList(v.ETags); err != nil {
			invalidParams.AddNested("ETags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ItemFilters(v []types.S3ItemFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ItemFilters"}
	for i := range v {
		if err := validateS3ItemFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchScope(v *types.SearchScope) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchScope"}
	if v.BackupResourceTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupResourceTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStringCondition(v *types.StringCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StringCondition"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStringConditionList(v []types.StringCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StringConditionList"}
	for i := range v {
		if err := validateStringCondition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTimeCondition(v *types.TimeCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TimeCondition"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTimeConditionList(v []types.TimeCondition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TimeConditionList"}
	for i := range v {
		if err := validateTimeCondition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetSearchJobInput(v *GetSearchJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetSearchJobInput"}
	if v.SearchJobIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SearchJobIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetSearchResultExportJobInput(v *GetSearchResultExportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetSearchResultExportJobInput"}
	if v.ExportJobIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExportJobIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListSearchJobBackupsInput(v *ListSearchJobBackupsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListSearchJobBackupsInput"}
	if v.SearchJobIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SearchJobIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListSearchJobResultsInput(v *ListSearchJobResultsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListSearchJobResultsInput"}
	if v.SearchJobIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SearchJobIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartSearchJobInput(v *StartSearchJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartSearchJobInput"}
	if v.SearchScope == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SearchScope"))
	} else if v.SearchScope != nil {
		if err := validateSearchScope(v.SearchScope); err != nil {
			invalidParams.AddNested("SearchScope", err.(smithy.InvalidParamsError))
		}
	}
	if v.ItemFilters != nil {
		if err := validateItemFilters(v.ItemFilters); err != nil {
			invalidParams.AddNested("ItemFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartSearchResultExportJobInput(v *StartSearchResultExportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartSearchResultExportJobInput"}
	if v.SearchJobIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SearchJobIdentifier"))
	}
	if v.ExportSpecification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExportSpecification"))
	} else if v.ExportSpecification != nil {
		if err := validateExportSpecification(v.ExportSpecification); err != nil {
			invalidParams.AddNested("ExportSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopSearchJobInput(v *StopSearchJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopSearchJobInput"}
	if v.SearchJobIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SearchJobIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
