// Code generated by smithy-go-codegen DO NOT EDIT.

package backupsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backupsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operations starts a job to export the results of search job to a
// designated S3 bucket.
func (c *Client) StartSearchResultExportJob(ctx context.Context, params *StartSearchResultExportJobInput, optFns ...func(*Options)) (*StartSearchResultExportJobOutput, error) {
	if params == nil {
		params = &StartSearchResultExportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartSearchResultExportJob", params, optFns, c.addOperationStartSearchResultExportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartSearchResultExportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartSearchResultExportJobInput struct {

	// This specification contains a required string of the destination bucket;
	// optionally, you can include the destination prefix.
	//
	// This member is required.
	ExportSpecification types.ExportSpecification

	// The unique string that specifies the search job.
	//
	// This member is required.
	SearchJobIdentifier *string

	// Include this parameter to allow multiple identical calls for idempotency.
	//
	// A client token is valid for 8 hours after the first request that uses it is
	// completed. After this time, any request with the same token is treated as a new
	// request.
	ClientToken *string

	// This parameter specifies the role ARN used to start the search results export
	// jobs.
	RoleArn *string

	// Optional tags to include. A tag is a key-value pair you can use to manage,
	// filter, and search for your resources. Allowed characters include UTF-8 letters,
	// numbers, spaces, and the following characters: + - = . _ : /.
	Tags map[string]*string

	noSmithyDocumentSerde
}

type StartSearchResultExportJobOutput struct {

	// This is the unique identifier that specifies the new export job.
	//
	// This member is required.
	ExportJobIdentifier *string

	// This is the unique ARN (Amazon Resource Name) that belongs to the new export
	// job.
	ExportJobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartSearchResultExportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartSearchResultExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartSearchResultExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartSearchResultExportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartSearchResultExportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartSearchResultExportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartSearchResultExportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartSearchResultExportJob",
	}
}
