// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the SourceApiAssociationSummary data.
func (c *Client) ListSourceApiAssociations(ctx context.Context, params *ListSourceApiAssociationsInput, optFns ...func(*Options)) (*ListSourceApiAssociationsOutput, error) {
	if params == nil {
		params = &ListSourceApiAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSourceApiAssociations", params, optFns, c.addOperationListSourceApiAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSourceApiAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSourceApiAssociationsInput struct {

	// The API ID.
	//
	// This member is required.
	ApiId *string

	// The maximum number of results that you want the request to return.
	MaxResults int32

	// An identifier that was returned from the previous call to this operation, which
	// you can use to return the next set of items in the list.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSourceApiAssociationsOutput struct {

	// An identifier that was returned from the previous call to this operation, which
	// you can use to return the next set of items in the list.
	NextToken *string

	// The SourceApiAssociationSummary object data.
	SourceApiAssociationSummaries []types.SourceApiAssociationSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSourceApiAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSourceApiAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSourceApiAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSourceApiAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListSourceApiAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSourceApiAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSourceApiAssociationsPaginatorOptions is the paginator options for
// ListSourceApiAssociations
type ListSourceApiAssociationsPaginatorOptions struct {
	// The maximum number of results that you want the request to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSourceApiAssociationsPaginator is a paginator for ListSourceApiAssociations
type ListSourceApiAssociationsPaginator struct {
	options   ListSourceApiAssociationsPaginatorOptions
	client    ListSourceApiAssociationsAPIClient
	params    *ListSourceApiAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListSourceApiAssociationsPaginator returns a new
// ListSourceApiAssociationsPaginator
func NewListSourceApiAssociationsPaginator(client ListSourceApiAssociationsAPIClient, params *ListSourceApiAssociationsInput, optFns ...func(*ListSourceApiAssociationsPaginatorOptions)) *ListSourceApiAssociationsPaginator {
	if params == nil {
		params = &ListSourceApiAssociationsInput{}
	}

	options := ListSourceApiAssociationsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSourceApiAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSourceApiAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSourceApiAssociations page.
func (p *ListSourceApiAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSourceApiAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSourceApiAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSourceApiAssociationsAPIClient is a client that implements the
// ListSourceApiAssociations operation.
type ListSourceApiAssociationsAPIClient interface {
	ListSourceApiAssociations(context.Context, *ListSourceApiAssociationsInput, ...func(*Options)) (*ListSourceApiAssociationsOutput, error)
}

var _ ListSourceApiAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSourceApiAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSourceApiAssociations",
	}
}
