// Code generated by smithy-go-codegen DO NOT EDIT.

package smithyrpcv2cborquerycompatible

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/smithyrpcv2cborquerycompatible/types"
	smithy "github.com/aws/smithy-go"
	smithycbor "github.com/aws/smithy-go/encoding/cbor"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type smithyRpcv2cbor_deserializeOpGetItem struct {
}

func (*smithyRpcv2cbor_deserializeOpGetItem) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpGetItem) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorGetItem(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &GetItemOutput{}

	return out, metadata, nil
}
func deserializeCBOR_ItemNotFound(v smithycbor.Value) (*types.ItemNotFound, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ItemNotFound{}
	for key, sv := range av {
		_, _ = key, sv

	}
	return ds, nil
}
func rpc2_deserializeOpErrorGetItem(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {
	case "smithy.protocoltests.rpcv2Cbor#ItemNotFound":
		verr, err := deserializeCBOR_ItemNotFound(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.protocoltests.rpcv2Cbor#ItemNotFound: %w", err),
				Snapshot: payload,
			}
		}
		if qtype := getAwsQueryErrorCode(resp); len(qtype) > 0 {
			verr.ErrorCodeOverride = ptr.String(qtype)
		}
		return verr
	default:
		if qtype := getAwsQueryErrorCode(resp); len(qtype) > 0 {
			typ = qtype
		}
		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}
func getProtocolErrorInfo(payload []byte) (typ, msg string, v smithycbor.Value, err error) {
	v, err = smithycbor.Decode(payload)
	if err != nil {
		return "", "", nil, fmt.Errorf("decode: %w", err)
	}

	mv, ok := v.(smithycbor.Map)
	if !ok {
		return "", "", nil, fmt.Errorf("unexpected payload type %T", v)
	}

	if ctyp, ok := mv["__type"]; ok {
		if ttyp, ok := ctyp.(smithycbor.String); ok {
			typ = string(ttyp)
		}
	}

	if cmsg, ok := mv["message"]; ok {
		if tmsg, ok := cmsg.(smithycbor.String); ok {
			msg = string(tmsg)
		}
	}

	return typ, msg, mv, nil
}
func getAwsQueryErrorCode(resp *smithyhttp.Response) string {
	header := resp.Header.Get("x-amzn-query-error")
	if header == "" {
		return ""
	}

	parts := strings.Split(header, ";")
	if len(parts) != 2 {
		return ""
	}

	return parts[0]
}
