// Code generated by smithy-go-codegen DO NOT EDIT.

package workmail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workmail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the mailbox export jobs started for the specified organization within the
// last seven days.
func (c *Client) ListMailboxExportJobs(ctx context.Context, params *ListMailboxExportJobsInput, optFns ...func(*Options)) (*ListMailboxExportJobsOutput, error) {
	if params == nil {
		params = &ListMailboxExportJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMailboxExportJobs", params, optFns, c.addOperationListMailboxExportJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMailboxExportJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMailboxExportJobsInput struct {

	// The organization ID.
	//
	// This member is required.
	OrganizationId *string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// The token to use to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMailboxExportJobsOutput struct {

	// The mailbox export job details.
	Jobs []types.MailboxExportJob

	// The token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMailboxExportJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListMailboxExportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListMailboxExportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMailboxExportJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListMailboxExportJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMailboxExportJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMailboxExportJobsAPIClient is a client that implements the
// ListMailboxExportJobs operation.
type ListMailboxExportJobsAPIClient interface {
	ListMailboxExportJobs(context.Context, *ListMailboxExportJobsInput, ...func(*Options)) (*ListMailboxExportJobsOutput, error)
}

var _ ListMailboxExportJobsAPIClient = (*Client)(nil)

// ListMailboxExportJobsPaginatorOptions is the paginator options for
// ListMailboxExportJobs
type ListMailboxExportJobsPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMailboxExportJobsPaginator is a paginator for ListMailboxExportJobs
type ListMailboxExportJobsPaginator struct {
	options   ListMailboxExportJobsPaginatorOptions
	client    ListMailboxExportJobsAPIClient
	params    *ListMailboxExportJobsInput
	nextToken *string
	firstPage bool
}

// NewListMailboxExportJobsPaginator returns a new ListMailboxExportJobsPaginator
func NewListMailboxExportJobsPaginator(client ListMailboxExportJobsAPIClient, params *ListMailboxExportJobsInput, optFns ...func(*ListMailboxExportJobsPaginatorOptions)) *ListMailboxExportJobsPaginator {
	if params == nil {
		params = &ListMailboxExportJobsInput{}
	}

	options := ListMailboxExportJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMailboxExportJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMailboxExportJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMailboxExportJobs page.
func (p *ListMailboxExportJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMailboxExportJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListMailboxExportJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListMailboxExportJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMailboxExportJobs",
	}
}
