// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about an existing retriever used by an Amazon Q application.
func (c *Client) GetRetriever(ctx context.Context, params *GetRetrieverInput, optFns ...func(*Options)) (*GetRetrieverOutput, error) {
	if params == nil {
		params = &GetRetrieverInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRetriever", params, optFns, c.addOperationGetRetrieverMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRetrieverOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRetrieverInput struct {

	// The identifier of the Amazon Q application using the retriever.
	//
	// This member is required.
	ApplicationId *string

	// The identifier of the retriever.
	//
	// This member is required.
	RetrieverId *string

	noSmithyDocumentSerde
}

type GetRetrieverOutput struct {

	// The identifier of the Amazon Q application using the retriever.
	ApplicationId *string

	// Provides information on how the retriever used for your Amazon Q application is
	// configured.
	Configuration types.RetrieverConfiguration

	// The Unix timestamp when the retriever was created.
	CreatedAt *time.Time

	// The name of the retriever.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
	RetrieverArn *string

	// The identifier of the retriever.
	RetrieverId *string

	// The Amazon Resource Name (ARN) of the role with the permission to access the
	// retriever and required resources.
	RoleArn *string

	// The status of the retriever.
	Status types.RetrieverStatus

	// The type of the retriever.
	Type types.RetrieverType

	// The Unix timestamp when the retriever was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRetrieverMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRetriever{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRetriever{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRetriever"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetRetrieverValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRetriever(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRetriever(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRetriever",
	}
}
