// Code generated by smithy-go-codegen DO NOT EDIT.

package personalize

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/personalize/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a campaign to deploy a retrained solution version with an existing
// campaign, change your campaign's minProvisionedTPS , or modify your campaign's
// configuration, such as the exploration configuration. To update a campaign, the
// campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using
// the DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
// operation. You can still get recommendations from a campaign while an update is
// in progress. The campaign will use the previous solution version and campaign
// configuration to generate recommendations until the latest campaign update
// status is Active . For more information about updating a campaign, including
// code samples, see Updating a campaign (https://docs.aws.amazon.com/personalize/latest/dg/update-campaigns.html)
// . For more information about campaigns, see Creating a campaign (https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html)
// .
func (c *Client) UpdateCampaign(ctx context.Context, params *UpdateCampaignInput, optFns ...func(*Options)) (*UpdateCampaignOutput, error) {
	if params == nil {
		params = &UpdateCampaignInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateCampaign", params, optFns, c.addOperationUpdateCampaignMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateCampaignOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateCampaignInput struct {

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// This member is required.
	CampaignArn *string

	// The configuration details of a campaign.
	CampaignConfig *types.CampaignConfig

	// Specifies the requested minimum provisioned transactions (recommendations) per
	// second that Amazon Personalize will support. A high minProvisionedTPS will
	// increase your bill. We recommend starting with 1 for minProvisionedTPS (the
	// default). Track your usage using Amazon CloudWatch metrics, and increase the
	// minProvisionedTPS as necessary.
	MinProvisionedTPS *int32

	// The ARN of a new solution version to deploy.
	SolutionVersionArn *string

	noSmithyDocumentSerde
}

type UpdateCampaignOutput struct {

	// The same campaign ARN as given in the request.
	CampaignArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateCampaignMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateCampaign{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateCampaign{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateCampaign"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateCampaignValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateCampaign(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateCampaign(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateCampaign",
	}
}
