// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/document"
	smithydocument "github.com/aws/smithy-go/document"
)

// Contains information about the action group being invoked.
type ActionGroupInvocationInput struct {

	// The name of the action group.
	ActionGroupName *string

	// The path to the API to call, based off the action group.
	ApiPath *string

	// The parameters in the Lambda input event.
	Parameters []Parameter

	// The parameters in the request body for the Lambda input event.
	RequestBody *RequestBody

	// The API method being used, based off the action group.
	Verb *string

	noSmithyDocumentSerde
}

// Contains the JSON-formatted string returned by the API invoked by the action
// group.
type ActionGroupInvocationOutput struct {

	// The JSON-formatted string returned by the API invoked by the action group.
	Text *string

	noSmithyDocumentSerde
}

// Contains citations for a part of an agent response.
type Attribution struct {

	// A list of citations and related information for a part of an agent response.
	Citations []Citation

	noSmithyDocumentSerde
}

// An object containing a segment of the generated response that is based on a
// source in the knowledge base, alongside information about the source. This data
// type is used in the following API operations:
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the citations field
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the citations field
type Citation struct {

	// Contains the generated response and metadata
	GeneratedResponsePart *GeneratedResponsePart

	// Contains metadata about the sources cited for the generated response.
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// Contains information about the failure of the interaction.
type FailureTrace struct {

	// The reason the interaction failed.
	FailureReason *string

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Specifies the name that the metadata attribute must match and the value to
// which to compare the value of the metadata attribute. For more information, see
// Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html)
// . This data type is used in the following API operations:
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
type FilterAttribute struct {

	// The name that the metadata attribute must match.
	//
	// This member is required.
	Key *string

	// The value to whcih to compare the value of the metadata attribute.
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// Contains details about the response to the user.
type FinalResponse struct {

	// The text in the response to the user.
	Text *string

	noSmithyDocumentSerde
}

// Contains metadata about a part of the generated response that is accompanied by
// a citation. This data type is used in the following API operations:
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the generatedResponsePart field
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the generatedResponsePart field
type GeneratedResponsePart struct {

	// Contains metadata about a textual part of the generated response that is
	// accompanied by a citation.
	TextResponsePart *TextResponsePart

	noSmithyDocumentSerde
}

// Contains configurations for response generation based on the knowledge base
// query results. This data type is used in the following API operations:
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
type GenerationConfiguration struct {

	// Contains the template for the prompt that's sent to the model for response
	// generation.
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// Specifications about the inference parameters that were provided alongside the
// prompt. These are specified in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
// object that was set when the agent was created or updated. For more information,
// see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html)
// .
type InferenceConfiguration struct {

	// The maximum number of tokens allowed in the generated response.
	MaximumLength *int32

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []string

	// The likelihood of the model selecting higher-probability options while
	// generating a response. A lower value makes the model more likely to choose
	// higher-probability options, while a higher value makes the model more likely to
	// choose lower-probability options.
	Temperature *float32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK is
	// the number of most-likely candidates from which the model chooses the next token
	// in the sequence. For example, if you set topK to 50, the model selects the next
	// token from among the top 50 most likely choices.
	TopK *int32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top P
	// determines the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topP to 80, the model only
	// selects the next token from the top 80% of the probability distribution of next
	// tokens.
	TopP *float32

	noSmithyDocumentSerde
}

// Contains information pertaining to the action group or knowledge base that is
// being invoked.
type InvocationInput struct {

	// Contains information about the action group to be invoked.
	ActionGroupInvocationInput *ActionGroupInvocationInput

	// Specifies whether the agent is invoking an action group or a knowledge base.
	InvocationType InvocationType

	// Contains details about the knowledge base to look up and the query to be made.
	KnowledgeBaseLookupInput *KnowledgeBaseLookupInput

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Contains details about the knowledge base to look up and the query to be made.
type KnowledgeBaseLookupInput struct {

	// The unique identifier of the knowledge base to look up.
	KnowledgeBaseId *string

	// The query made to the knowledge base.
	Text *string

	noSmithyDocumentSerde
}

// Contains details about the results from looking up the knowledge base.
type KnowledgeBaseLookupOutput struct {

	// Contains metadata about the sources cited for the generated response.
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// Contains the query made to the knowledge base. This data type is used in the
// following API operations:
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the retrievalQuery field
type KnowledgeBaseQuery struct {

	// The text of the query made to the knowledge base.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains configurations for the knowledge base query and retrieval process. For
// more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html)
// . This data type is used in the following API operations:
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the retrievalConfiguration field
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the retrievalConfiguration field
type KnowledgeBaseRetrievalConfiguration struct {

	// Contains details about how the results from the vector search should be
	// returned. For more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html)
	// .
	//
	// This member is required.
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration

	noSmithyDocumentSerde
}

// Details about a result from querying the knowledge base. This data type is used
// in the following API operations:
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the retrievalResults field
type KnowledgeBaseRetrievalResult struct {

	// Contains a chunk of text from a data source in the knowledge base.
	//
	// This member is required.
	Content *RetrievalResultContent

	// Contains information about the location of the data source.
	Location *RetrievalResultLocation

	// Contains metadata attributes and their values for the file in the data source.
	// For more information, see Metadata and filtering (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata)
	// .
	Metadata map[string]document.Interface

	// The level of relevance of the result to the query.
	Score *float64

	noSmithyDocumentSerde
}

// Contains details about the resource being queried. This data type is used in
// the following API operations:
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the knowledgeBaseConfiguration field
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the knowledgeBaseConfiguration field
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {

	// The unique identifier of the knowledge base that is queried and the foundation
	// model used for generation.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The ARN of the foundation model used to generate a response.
	//
	// This member is required.
	ModelArn *string

	// Contains configurations for response generation based on the knowwledge base
	// query results.
	GenerationConfiguration *GenerationConfiguration

	// Contains configurations for how to retrieve and return the knowledge base query.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Configurations for how to perform the search query and return results. For more
// information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html)
// . This data type is used in the following API operations:
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the vectorSearchConfiguration field
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the vectorSearchConfiguration field
type KnowledgeBaseVectorSearchConfiguration struct {

	// Specifies the filters to use on the metadata in the knowledge base data sources
	// before returning results. For more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html)
	// .
	Filter RetrievalFilter

	// The number of source chunks to retrieve.
	NumberOfResults *int32

	// By default, Amazon Bedrock decides a search strategy for you. If you're using
	// an Amazon OpenSearch Serverless vector store that contains a filterable text
	// field, you can specify whether to query the knowledge base with a HYBRID search
	// using both vector embeddings and raw text, or SEMANTIC search using only vector
	// embeddings. For other vector store configurations, only SEMANTIC search is
	// available. For more information, see Test a knowledge base (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html)
	// .
	OverrideSearchType SearchType

	noSmithyDocumentSerde
}

// The input for the pre-processing step.
//   - The type matches the agent step.
//   - The text contains the prompt.
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
//     object that was set when the agent was created or updated.
type ModelInvocationInput struct {

	// Specifications about the inference parameters that were provided alongside the
	// prompt. These are specified in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// object that was set when the agent was created or updated. For more information,
	// see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html)
	// .
	InferenceConfiguration *InferenceConfiguration

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence.
	OverrideLambda *string

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined by the
	// promptType .
	ParserMode CreationMode

	// Specifies whether the default prompt template was OVERRIDDEN . If it was, the
	// basePromptTemplate that was set in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// object when the agent was created or updated is used instead.
	PromptCreationMode CreationMode

	// The text that prompted the agent at this step.
	Text *string

	// The unique identifier of the trace.
	TraceId *string

	// The step in the agent sequence.
	Type PromptType

	noSmithyDocumentSerde
}

// Contains the result or output of an action group or knowledge base, or the
// response to the user.
type Observation struct {

	// Contains the JSON-formatted string returned by the API invoked by the action
	// group.
	ActionGroupInvocationOutput *ActionGroupInvocationOutput

	// Contains details about the response to the user.
	FinalResponse *FinalResponse

	// Contains details about the results from looking up the knowledge base.
	KnowledgeBaseLookupOutput *KnowledgeBaseLookupOutput

	// Contains details about the response to reprompt the input.
	RepromptResponse *RepromptResponse

	// The unique identifier of the trace.
	TraceId *string

	// Specifies what kind of information the agent returns in the observation. The
	// following values are possible.
	//   - ACTION_GROUP – The agent returns the result of an action group.
	//   - KNOWLEDGE_BASE – The agent returns information from a knowledge base.
	//   - FINISH – The agent returns a final response to the user with no follow-up.
	//   - ASK_USER – The agent asks the user a question.
	//   - REPROMPT – The agent prompts the user again for the same information.
	Type Type

	noSmithyDocumentSerde
}

// Details about the orchestration step, in which the agent determines the order
// in which actions are executed and which knowledge bases are retrieved.
//
// The following types satisfy this interface:
//
//	OrchestrationTraceMemberInvocationInput
//	OrchestrationTraceMemberModelInvocationInput
//	OrchestrationTraceMemberObservation
//	OrchestrationTraceMemberRationale
type OrchestrationTrace interface {
	isOrchestrationTrace()
}

// Contains information pertaining to the action group or knowledge base that is
// being invoked.
type OrchestrationTraceMemberInvocationInput struct {
	Value InvocationInput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberInvocationInput) isOrchestrationTrace() {}

// The input for the orchestration step.
//   - The type is ORCHESTRATION .
//   - The text contains the prompt.
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
//     object that was set when the agent was created or updated.
type OrchestrationTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberModelInvocationInput) isOrchestrationTrace() {}

// Details about the observation (the output of the action group Lambda or
// knowledge base) made by the agent.
type OrchestrationTraceMemberObservation struct {
	Value Observation

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberObservation) isOrchestrationTrace() {}

// Details about the reasoning, based on the input, that the agent uses to justify
// carrying out an action group or getting information from a knowledge base.
type OrchestrationTraceMemberRationale struct {
	Value Rationale

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberRationale) isOrchestrationTrace() {}

// A parameter in the Lambda input event.
type Parameter struct {

	// The name of the parameter.
	Name *string

	// The type of the parameter.
	Type *string

	// The value of the parameter.
	Value *string

	noSmithyDocumentSerde
}

// Contains a part of an agent response and citations for it.
type PayloadPart struct {

	// Contains citations for a part of an agent response.
	Attribution *Attribution

	// A part of the agent response in bytes.
	Bytes []byte

	noSmithyDocumentSerde
}

// The foundation model output from the post-processing step.
type PostProcessingModelInvocationOutput struct {

	// Details about the response from the Lambda parsing of the output of the
	// post-processing step.
	ParsedResponse *PostProcessingParsedResponse

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Details about the response from the Lambda parsing of the output from the
// post-processing step.
type PostProcessingParsedResponse struct {

	// The text returned by the parser.
	Text *string

	noSmithyDocumentSerde
}

// Details about the post-processing step, in which the agent shapes the response.
//
// The following types satisfy this interface:
//
//	PostProcessingTraceMemberModelInvocationInput
//	PostProcessingTraceMemberModelInvocationOutput
type PostProcessingTrace interface {
	isPostProcessingTrace()
}

// The input for the post-processing step.
//   - The type is POST_PROCESSING .
//   - The text contains the prompt.
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
//     object that was set when the agent was created or updated.
type PostProcessingTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*PostProcessingTraceMemberModelInvocationInput) isPostProcessingTrace() {}

// The foundation model output from the post-processing step.
type PostProcessingTraceMemberModelInvocationOutput struct {
	Value PostProcessingModelInvocationOutput

	noSmithyDocumentSerde
}

func (*PostProcessingTraceMemberModelInvocationOutput) isPostProcessingTrace() {}

// The foundation model output from the pre-processing step.
type PreProcessingModelInvocationOutput struct {

	// Details about the response from the Lambda parsing of the output of the
	// pre-processing step.
	ParsedResponse *PreProcessingParsedResponse

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Details about the response from the Lambda parsing of the output from the
// pre-processing step.
type PreProcessingParsedResponse struct {

	// Whether the user input is valid or not. If false , the agent doesn't proceed to
	// orchestration.
	IsValid *bool

	// The text returned by the parsing of the pre-processing step, explaining the
	// steps that the agent plans to take in orchestration, if the user input is valid.
	Rationale *string

	noSmithyDocumentSerde
}

// Details about the pre-processing step, in which the agent contextualizes and
// categorizes user inputs.
//
// The following types satisfy this interface:
//
//	PreProcessingTraceMemberModelInvocationInput
//	PreProcessingTraceMemberModelInvocationOutput
type PreProcessingTrace interface {
	isPreProcessingTrace()
}

// The input for the pre-processing step.
//   - The type is PRE_PROCESSING .
//   - The text contains the prompt.
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
//     object that was set when the agent was created or updated.
type PreProcessingTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*PreProcessingTraceMemberModelInvocationInput) isPreProcessingTrace() {}

// The foundation model output from the pre-processing step.
type PreProcessingTraceMemberModelInvocationOutput struct {
	Value PreProcessingModelInvocationOutput

	noSmithyDocumentSerde
}

func (*PreProcessingTraceMemberModelInvocationOutput) isPreProcessingTrace() {}

// Contains the template for the prompt that's sent to the model for response
// generation. For more information, see Knowledge base prompt templates (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt)
// . This data type is used in the following API operations:
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the filter field
type PromptTemplate struct {

	// The template for the prompt that's sent to the model for response generation.
	// You can include prompt placeholders, which become replaced before the prompt is
	// sent to the model to provide instructions and context to the model. In addition,
	// you can include XML tags to delineate meaningful sections of the prompt
	// template. For more information, see the following resources:
	//   - Knowledge base prompt templates (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt)
	//   - Use XML tags with Anthropic Claude models (https://docs.anthropic.com/claude/docs/use-xml-tags)
	TextPromptTemplate *string

	noSmithyDocumentSerde
}

// Contains the reasoning, based on the input, that the agent uses to justify
// carrying out an action group or getting information from a knowledge base.
type Rationale struct {

	// The reasoning or thought process of the agent, based on the input.
	Text *string

	// The unique identifier of the trace step.
	TraceId *string

	noSmithyDocumentSerde
}

// Contains details about the agent's response to reprompt the input.
type RepromptResponse struct {

	// Specifies what output is prompting the agent to reprompt the input.
	Source Source

	// The text reprompting the input.
	Text *string

	noSmithyDocumentSerde
}

// The parameters in the request body for the Lambda input event.
type RequestBody struct {

	// The content in the request body.
	Content map[string][]Parameter

	noSmithyDocumentSerde
}

// The response from invoking the agent and associated citations and trace
// information.
//
// The following types satisfy this interface:
//
//	ResponseStreamMemberChunk
//	ResponseStreamMemberTrace
type ResponseStream interface {
	isResponseStream()
}

// Contains a part of an agent response and citations for it.
type ResponseStreamMemberChunk struct {
	Value PayloadPart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberChunk) isResponseStream() {}

// Contains information about the agent and session, alongside the agent's
// reasoning process and results from calling API actions and querying knowledge
// bases and metadata about the trace. You can use the trace to understand how the
// agent arrived at the response it provided the customer. For more information,
// see Trace events (https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html)
// .
type ResponseStreamMemberTrace struct {
	Value TracePart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberTrace) isResponseStream() {}

// Specifies the filters to use on the metadata attributes in the knowledge base
// data sources before returning results. For more information, see Query
// configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html)
// . This data type is used in the following API operations:
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the filter field
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the filter field
//
// The following types satisfy this interface:
//
//	RetrievalFilterMemberAndAll
//	RetrievalFilterMemberEquals
//	RetrievalFilterMemberGreaterThan
//	RetrievalFilterMemberGreaterThanOrEquals
//	RetrievalFilterMemberIn
//	RetrievalFilterMemberLessThan
//	RetrievalFilterMemberLessThanOrEquals
//	RetrievalFilterMemberNotEquals
//	RetrievalFilterMemberNotIn
//	RetrievalFilterMemberOrAll
//	RetrievalFilterMemberStartsWith
type RetrievalFilter interface {
	isRetrievalFilter()
}

// Knowledge base data sources whose metadata attributes fulfill all the filter
// conditions inside this list are returned.
type RetrievalFilterMemberAndAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberAndAll) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value matches the value in this object are returned.
type RetrievalFilterMemberEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberEquals) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value is greater than the value in this object are
// returned.
type RetrievalFilterMemberGreaterThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThan) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value is greater than or equal to the value in this
// object are returned.
type RetrievalFilterMemberGreaterThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value is in the list specified in the value in this
// object are returned.
type RetrievalFilterMemberIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberIn) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value is less than the value in this object are
// returned.
type RetrievalFilterMemberLessThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThan) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value is less than or equal to the value in this
// object are returned.
type RetrievalFilterMemberLessThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value doesn't match the value in this object are
// returned.
type RetrievalFilterMemberNotEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotEquals) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value isn't in the list specified in the value in
// this object are returned.
type RetrievalFilterMemberNotIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotIn) isRetrievalFilter() {}

// Knowledge base data sources whose metadata attributes fulfill at least one of
// the filter conditions inside this list are returned.
type RetrievalFilterMemberOrAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberOrAll) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value starts with the value in this object are
// returned. This filter is currently only supported for Amazon OpenSearch
// Serverless vector stores.
type RetrievalFilterMemberStartsWith struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStartsWith) isRetrievalFilter() {}

// Contains the cited text from the data source. This data type is used in the
// following API operations:
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the content field
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the content field
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the content field
type RetrievalResultContent struct {

	// The cited text from the data source.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains information about the location of the data source. This data type is
// used in the following API operations:
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the location field
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the location field
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the locatino field
type RetrievalResultLocation struct {

	// The type of the location of the data source.
	//
	// This member is required.
	Type RetrievalResultLocationType

	// Contains the S3 location of the data source.
	S3Location *RetrievalResultS3Location

	noSmithyDocumentSerde
}

// Contains the S3 location of the data source. This data type is used in the
// following API operations:
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the s3Location field
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the s3Location field
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the s3Location field
type RetrievalResultS3Location struct {

	// The S3 URI of the data source.
	Uri *string

	noSmithyDocumentSerde
}

// Contains details about the resource being queried. This data type is used in
// the following API operations:
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the retrieveAndGenerateConfiguration field
type RetrieveAndGenerateConfiguration struct {

	// The type of resource that is queried by the request.
	//
	// This member is required.
	Type RetrieveAndGenerateType

	// Contains details about the resource being queried.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

// Contains the query made to the knowledge base. This data type is used in the
// following API operations:
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the input field
type RetrieveAndGenerateInput struct {

	// The query made to the knowledge base.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains the response generated from querying the knowledge base. This data
// type is used in the following API operations:
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the output field
type RetrieveAndGenerateOutput struct {

	// The response generated from querying the knowledge base.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains configuration about the session with the knowledge base. This data
// type is used in the following API operations:
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the sessionConfiguration field
type RetrieveAndGenerateSessionConfiguration struct {

	// The ARN of the KMS key encrypting the session.
	//
	// This member is required.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains metadata about a source cited for the generated response. This data
// type is used in the following API operations:
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the retrievedReferences field
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the retrievedReferences field
type RetrievedReference struct {

	// Contains the cited text from the data source.
	Content *RetrievalResultContent

	// Contains information about the location of the data source.
	Location *RetrievalResultLocation

	// Contains metadata attributes and their values for the file in the data source.
	// For more information, see Metadata and filtering (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata)
	// .
	Metadata map[string]document.Interface

	noSmithyDocumentSerde
}

// Contains parameters that specify various attributes that persist across a
// session or prompt. You can define session state attributes as key-value pairs
// when writing a Lambda function (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html)
// for an action group or pass them when making an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
// request. Use session state attributes to control and provide conversational
// context for your agent and to help customize your agent's behavior. For more
// information, see Control session context (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html)
// .
type SessionState struct {

	// Contains attributes that persist across a prompt and the values of those
	// attributes. These attributes replace the $prompt_session_attributes$
	// placeholder variable in the orchestration prompt template. For more information,
	// see Prompt template placeholder variables (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html)
	// .
	PromptSessionAttributes map[string]string

	// Contains attributes that persist across a session and the values of those
	// attributes.
	SessionAttributes map[string]string

	noSmithyDocumentSerde
}

// Contains information about where the text with a citation begins and ends in
// the generated output. This data type is used in the following API operations:
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the span field
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the span field
type Span struct {

	// Where the text with a citation ends in the generated output.
	End *int32

	// Where the text with a citation starts in the generated output.
	Start *int32

	noSmithyDocumentSerde
}

// Contains the part of the generated text that contains a citation, alongside
// where it begins and ends. This data type is used in the following API
// operations:
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the textResponsePart field
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the textResponsePart field
type TextResponsePart struct {

	// Contains information about where the text with a citation begins and ends in
	// the generated output.
	Span *Span

	// The part of the generated text that contains a citation.
	Text *string

	noSmithyDocumentSerde
}

// Contains one part of the agent's reasoning process and results from calling API
// actions and querying knowledge bases. You can use the trace to understand how
// the agent arrived at the response it provided the customer. For more
// information, see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement)
// .
//
// The following types satisfy this interface:
//
//	TraceMemberFailureTrace
//	TraceMemberOrchestrationTrace
//	TraceMemberPostProcessingTrace
//	TraceMemberPreProcessingTrace
type Trace interface {
	isTrace()
}

// Contains information about the failure of the interaction.
type TraceMemberFailureTrace struct {
	Value FailureTrace

	noSmithyDocumentSerde
}

func (*TraceMemberFailureTrace) isTrace() {}

// Details about the orchestration step, in which the agent determines the order
// in which actions are executed and which knowledge bases are retrieved.
type TraceMemberOrchestrationTrace struct {
	Value OrchestrationTrace

	noSmithyDocumentSerde
}

func (*TraceMemberOrchestrationTrace) isTrace() {}

// Details about the post-processing step, in which the agent shapes the response..
type TraceMemberPostProcessingTrace struct {
	Value PostProcessingTrace

	noSmithyDocumentSerde
}

func (*TraceMemberPostProcessingTrace) isTrace() {}

// Details about the pre-processing step, in which the agent contextualizes and
// categorizes user inputs.
type TraceMemberPreProcessingTrace struct {
	Value PreProcessingTrace

	noSmithyDocumentSerde
}

func (*TraceMemberPreProcessingTrace) isTrace() {}

// Contains information about the agent and session, alongside the agent's
// reasoning process and results from calling API actions and querying knowledge
// bases and metadata about the trace. You can use the trace to understand how the
// agent arrived at the response it provided the customer. For more information,
// see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement)
// .
type TracePart struct {

	// The unique identifier of the alias of the agent.
	AgentAliasId *string

	// The unique identifier of the agent.
	AgentId *string

	// The unique identifier of the session with the agent.
	SessionId *string

	// Contains one part of the agent's reasoning process and results from calling API
	// actions and querying knowledge bases. You can use the trace to understand how
	// the agent arrived at the response it provided the customer. For more
	// information, see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement)
	// .
	Trace Trace

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isOrchestrationTrace()  {}
func (*UnknownUnionMember) isPostProcessingTrace() {}
func (*UnknownUnionMember) isPreProcessingTrace()  {}
func (*UnknownUnionMember) isResponseStream()      {}
func (*UnknownUnionMember) isRetrievalFilter()     {}
func (*UnknownUnionMember) isTrace()               {}
