// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains details about the Lambda function containing the business logic that
// is carried out upon invoking the action.
//
// The following types satisfy this interface:
//
//	ActionGroupExecutorMemberLambda
type ActionGroupExecutor interface {
	isActionGroupExecutor()
}

// The ARN of the Lambda function containing the business logic that is carried
// out upon invoking the action.
type ActionGroupExecutorMemberLambda struct {
	Value string

	noSmithyDocumentSerde
}

func (*ActionGroupExecutorMemberLambda) isActionGroupExecutor() {}

// Contains details about an action group.
type ActionGroupSummary struct {

	// The unique identifier of the action group.
	//
	// This member is required.
	ActionGroupId *string

	// The name of the action group.
	//
	// This member is required.
	ActionGroupName *string

	// Specifies whether the action group is available for the agent to invoke or not
	// when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// This member is required.
	ActionGroupState ActionGroupState

	// The time at which the action group was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the action group.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about an agent.
type Agent struct {

	// The ARN of the agent.
	//
	// This member is required.
	AgentArn *string

	// The unique identifier of the agent.
	//
	// This member is required.
	AgentId *string

	// The name of the agent.
	//
	// This member is required.
	AgentName *string

	// The ARN of the IAM role with permissions to call API operations on the agent.
	// The ARN must begin with AmazonBedrockExecutionRoleForAgents_ .
	//
	// This member is required.
	AgentResourceRoleArn *string

	// The status of the agent and whether it is ready for use. The following statuses
	// are possible:
	//   - CREATING – The agent is being created.
	//   - PREPARING – The agent is being prepared.
	//   - PREPARED – The agent is prepared and ready to be invoked.
	//   - NOT_PREPARED – The agent has been created but not yet prepared.
	//   - FAILED – The agent API operation failed.
	//   - UPDATING – The agent is being updated.
	//   - DELETING – The agent is being deleted.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The version of the agent.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the agent was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The number of seconds for which Amazon Bedrock keeps information about a user's
	// conversation with the agent. A user interaction remains active for the amount of
	// time specified. If no conversation occurs during this time, the session expires
	// and Amazon Bedrock deletes any data provided before the timeout.
	//
	// This member is required.
	IdleSessionTTLInSeconds *int32

	// The time at which the agent was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see
	// Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// .
	ClientToken *string

	// The ARN of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string

	// The description of the agent.
	Description *string

	// Contains reasons that the agent-related API that you invoked failed.
	FailureReasons []string

	// The foundation model used for orchestration by the agent.
	FoundationModel *string

	// Instructions that tell the agent what it should do and how it should interact
	// with users.
	Instruction *string

	// The time at which the agent was last prepared.
	PreparedAt *time.Time

	// Contains configurations to override prompt templates in different parts of an
	// agent sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html)
	// .
	PromptOverrideConfiguration *PromptOverrideConfiguration

	// Contains recommended actions to take for the agent-related API that you invoked
	// to succeed.
	RecommendedActions []string

	noSmithyDocumentSerde
}

// Contains details about an action group.
type AgentActionGroup struct {

	// The unique identifier of the action group.
	//
	// This member is required.
	ActionGroupId *string

	// The name of the action group.
	//
	// This member is required.
	ActionGroupName *string

	// Specifies whether the action group is available for the agent to invoke or not
	// when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// This member is required.
	ActionGroupState ActionGroupState

	// The unique identifier of the agent to which the action group belongs.
	//
	// This member is required.
	AgentId *string

	// The version of the agent to which the action group belongs.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the action group was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time at which the action group was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The ARN of the Lambda function containing the business logic that is carried
	// out upon invoking the action.
	ActionGroupExecutor ActionGroupExecutor

	// Contains either details about the S3 object containing the OpenAPI schema for
	// the action group or the JSON or YAML-formatted payload defining the schema. For
	// more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html)
	// .
	ApiSchema APISchema

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see
	// Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// .
	ClientToken *string

	// The description of the action group.
	Description *string

	// If this field is set as AMAZON.UserInput , the agent can request the user for
	// additional information when trying to complete a task. The description ,
	// apiSchema , and actionGroupExecutor fields must be blank for this action group.
	// During orchestration, if the agent determines that it needs to invoke an API in
	// an action group, but doesn't have enough information to complete the API
	// request, it will invoke this action group instead and return an Observation (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionSignature ActionGroupSignature

	noSmithyDocumentSerde
}

// Contains details about an alias of an agent.
type AgentAlias struct {

	// The ARN of the alias of the agent.
	//
	// This member is required.
	AgentAliasArn *string

	// The unique identifier of the alias of the agent.
	//
	// This member is required.
	AgentAliasId *string

	// The name of the alias of the agent.
	//
	// This member is required.
	AgentAliasName *string

	// The status of the alias of the agent and whether it is ready for use. The
	// following statuses are possible:
	//   - CREATING – The agent alias is being created.
	//   - PREPARED – The agent alias is finished being created or updated and is
	//   ready to be invoked.
	//   - FAILED – The agent alias API operation failed.
	//   - UPDATING – The agent alias is being updated.
	//   - DELETING – The agent alias is being deleted.
	//
	// This member is required.
	AgentAliasStatus AgentAliasStatus

	// The unique identifier of the agent.
	//
	// This member is required.
	AgentId *string

	// The time at which the alias of the agent was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Contains details about the routing configuration of the alias.
	//
	// This member is required.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	// The time at which the alias was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Contains details about the history of the alias.
	AgentAliasHistoryEvents []AgentAliasHistoryEvent

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see
	// Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// .
	ClientToken *string

	// The description of the alias of the agent.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about the history of the alias.
type AgentAliasHistoryEvent struct {

	// The date that the alias stopped being associated to the version in the
	// routingConfiguration object
	EndDate *time.Time

	// Contains details about the version of the agent with which the alias is
	// associated.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	// The date that the alias began being associated to the version in the
	// routingConfiguration object.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// Contains details about the routing configuration of the alias.
type AgentAliasRoutingConfigurationListItem struct {

	// The version of the agent with which the alias is associated.
	//
	// This member is required.
	AgentVersion *string

	noSmithyDocumentSerde
}

// Contains details about an alias of an agent.
type AgentAliasSummary struct {

	// Contains details about
	//
	// This member is required.
	AgentAliasId *string

	// The name of the alias.
	//
	// This member is required.
	AgentAliasName *string

	// The status of the alias.
	//
	// This member is required.
	AgentAliasStatus AgentAliasStatus

	// The time at which the alias of the agent was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time at which the alias was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the alias.
	Description *string

	// Contains details about the version of the agent with which the alias is
	// associated.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	noSmithyDocumentSerde
}

// Contains details about a knowledge base that is associated with an agent.
type AgentKnowledgeBase struct {

	// The unique identifier of the agent with which the knowledge base is associated.
	//
	// This member is required.
	AgentId *string

	// The version of the agent with which the knowledge base is associated.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the association between the agent and the knowledge base was
	// created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The description of the association between the agent and the knowledge base.
	//
	// This member is required.
	Description *string

	// The unique identifier of the association between the agent and the knowledge
	// base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Specifies whether to use the knowledge base or not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// This member is required.
	KnowledgeBaseState KnowledgeBaseState

	// The time at which the association between the agent and the knowledge base was
	// last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains details about a knowledge base associated with an agent.
type AgentKnowledgeBaseSummary struct {

	// The unique identifier of the knowledge base associated with an agent.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Specifies whether the agent uses the knowledge base or not when sending an
	// InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// This member is required.
	KnowledgeBaseState KnowledgeBaseState

	// The time at which the knowledge base associated with an agent was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the knowledge base associated with an agent.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about an agent.
type AgentSummary struct {

	// The unique identifier of the agent.
	//
	// This member is required.
	AgentId *string

	// The name of the agent.
	//
	// This member is required.
	AgentName *string

	// The status of the agent.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The time at which the agent was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the agent.
	Description *string

	// The latest version of the agent.
	LatestAgentVersion *string

	noSmithyDocumentSerde
}

// Contains details about a version of an agent.
type AgentVersion struct {

	// The ARN of the agent that the version belongs to.
	//
	// This member is required.
	AgentArn *string

	// The unique identifier of the agent that the version belongs to.
	//
	// This member is required.
	AgentId *string

	// The name of the agent that the version belongs to.
	//
	// This member is required.
	AgentName *string

	// The ARN of the IAM role with permissions to invoke API operations on the agent.
	// The ARN must begin with AmazonBedrockExecutionRoleForAgents_ .
	//
	// This member is required.
	AgentResourceRoleArn *string

	// The status of the agent that the version belongs to.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The time at which the version was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The number of seconds for which Amazon Bedrock keeps information about a user's
	// conversation with the agent. A user interaction remains active for the amount of
	// time specified. If no conversation occurs during this time, the session expires
	// and Amazon Bedrock deletes any data provided before the timeout.
	//
	// This member is required.
	IdleSessionTTLInSeconds *int32

	// The time at which the version was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version number.
	//
	// This member is required.
	Version *string

	// The ARN of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string

	// The description of the version.
	Description *string

	// A list of reasons that the API operation on the version failed.
	FailureReasons []string

	// The foundation model that the version invokes.
	FoundationModel *string

	// The instructions provided to the agent.
	Instruction *string

	// Contains configurations to override prompt templates in different parts of an
	// agent sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html)
	// .
	PromptOverrideConfiguration *PromptOverrideConfiguration

	// A list of recommended actions to take for the failed API operation on the
	// version to succeed.
	RecommendedActions []string

	noSmithyDocumentSerde
}

// Contains details about a version of an agent.
type AgentVersionSummary struct {

	// The name of the agent to which the version belongs.
	//
	// This member is required.
	AgentName *string

	// The status of the agent to which the version belongs.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The version of the agent.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the version was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time at which the version was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the version of the agent.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about the OpenAPI schema for the action group. For more
// information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html)
// . You can either include the schema directly in the payload field or you can
// upload it to an S3 bucket and specify the S3 bucket location in the s3 field.
//
// The following types satisfy this interface:
//
//	APISchemaMemberPayload
//	APISchemaMemberS3
type APISchema interface {
	isAPISchema()
}

// The JSON or YAML-formatted payload defining the OpenAPI schema for the action
// group. For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html)
// .
type APISchemaMemberPayload struct {
	Value string

	noSmithyDocumentSerde
}

func (*APISchemaMemberPayload) isAPISchema() {}

// Contains details about the S3 object containing the OpenAPI schema for the
// action group. For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html)
// .
type APISchemaMemberS3 struct {
	Value S3Identifier

	noSmithyDocumentSerde
}

func (*APISchemaMemberS3) isAPISchema() {}

// Details about how to chunk the documents in the data source. A chunk refers to
// an excerpt from a data source that is returned when the knowledge base that it
// belongs to is queried.
type ChunkingConfiguration struct {

	// Knowledge base can split your source data into chunks. A chunk refers to an
	// excerpt from a data source that is returned when the knowledge base that it
	// belongs to is queried. You have the following options for chunking your data. If
	// you opt for NONE , then you may want to pre-process your files by splitting them
	// up such that each file corresponds to a chunk.
	//   - FIXED_SIZE – Amazon Bedrock splits your source data into chunks of the
	//   approximate size that you set in the fixedSizeChunkingConfiguration .
	//   - NONE – Amazon Bedrock treats each file as one chunk. If you choose this
	//   option, you may want to pre-process your documents by splitting them into
	//   separate files.
	//
	// This member is required.
	ChunkingStrategy ChunkingStrategy

	// Configurations for when you choose fixed-size chunking. If you set the
	// chunkingStrategy as NONE , exclude this field.
	FixedSizeChunkingConfiguration *FixedSizeChunkingConfiguration

	noSmithyDocumentSerde
}

// Contains details about a data source.
type DataSource struct {

	// The time at which the data source was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Contains details about how the data source is stored.
	//
	// This member is required.
	DataSourceConfiguration *DataSourceConfiguration

	// The unique identifier of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the data source.
	//
	// This member is required.
	Name *string

	// The status of the data source. The following statuses are possible:
	//   - Available – The data source has been created and is ready for ingestion
	//   into the knowledge base.
	//   - Deleting – The data source is being deleted.
	//
	// This member is required.
	Status DataSourceStatus

	// The time at which the data source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the data source.
	Description *string

	// Contains details about the configuration of the server-side encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration

	noSmithyDocumentSerde
}

// Contains details about how a data source is stored.
type DataSourceConfiguration struct {

	// The type of storage for the data source.
	//
	// This member is required.
	Type DataSourceType

	// Contains details about the configuration of the S3 object containing the data
	// source.
	S3Configuration *S3DataSourceConfiguration

	noSmithyDocumentSerde
}

// Contains details about a data source.
type DataSourceSummary struct {

	// The unique identifier of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the data source.
	//
	// This member is required.
	Name *string

	// The status of the data source.
	//
	// This member is required.
	Status DataSourceStatus

	// The time at which the data source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the data source.
	Description *string

	noSmithyDocumentSerde
}

// Configurations for when you choose fixed-size chunking. If you set the
// chunkingStrategy as NONE , exclude this field.
type FixedSizeChunkingConfiguration struct {

	// The maximum number of tokens to include in a chunk.
	//
	// This member is required.
	MaxTokens *int32

	// The percentage of overlap between adjacent chunks of a data source.
	//
	// This member is required.
	OverlapPercentage *int32

	noSmithyDocumentSerde
}

// Contains inference parameters to use when the agent invokes a foundation model
// in the part of the agent sequence defined by the promptType . For more
// information, see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html)
// .
type InferenceConfiguration struct {

	// The maximum number of tokens to allow in the generated response.
	MaximumLength *int32

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []string

	// The likelihood of the model selecting higher-probability options while
	// generating a response. A lower value makes the model more likely to choose
	// higher-probability options, while a higher value makes the model more likely to
	// choose lower-probability options.
	Temperature *float32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK is
	// the number of most-likely candidates from which the model chooses the next token
	// in the sequence. For example, if you set topK to 50, the model selects the next
	// token from among the top 50 most likely choices.
	TopK *int32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top P
	// determines the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topP to 80, the model only
	// selects the next token from the top 80% of the probability distribution of next
	// tokens.
	TopP *float32

	noSmithyDocumentSerde
}

// Contains details about an ingestion job, which converts a data source to
// embeddings for a vector store in knowledge base. This data type is used in the
// following API operations:
//   - StartIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html#API_agent_StartIngestionJob_ResponseSyntax)
//   - GetIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html#API_agent_GetIngestionJob_ResponseSyntax)
//   - ListIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJob.html#API_agent_ListIngestionJob_ResponseSyntax)
type IngestionJob struct {

	// The unique identifier of the ingested data source.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the ingestion job.
	//
	// This member is required.
	IngestionJobId *string

	// The unique identifier of the knowledge base to which the data source is being
	// added.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The time at which the ingestion job started.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of the ingestion job.
	//
	// This member is required.
	Status IngestionJobStatus

	// The time at which the ingestion job was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the ingestion job.
	Description *string

	// A list of reasons that the ingestion job failed.
	FailureReasons []string

	// Contains statistics about the ingestion job.
	Statistics *IngestionJobStatistics

	noSmithyDocumentSerde
}

// Defines a filter by which to filter the results.
type IngestionJobFilter struct {

	// The attribute by which to filter the results.
	//
	// This member is required.
	Attribute IngestionJobFilterAttribute

	// The operation to carry out between the attribute and the values.
	//
	// This member is required.
	Operator IngestionJobFilterOperator

	// A list of values for the attribute.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Parameters by which to sort the results.
type IngestionJobSortBy struct {

	// The attribute by which to sort the results.
	//
	// This member is required.
	Attribute IngestionJobSortByAttribute

	// The order by which to sort the results.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Contains the statistics for the ingestion job.
type IngestionJobStatistics struct {

	// The number of source documents that was deleted.
	NumberOfDocumentsDeleted int64

	// The number of source documents that failed to be ingested.
	NumberOfDocumentsFailed int64

	// The total number of source documents that were scanned. Includes new, updated,
	// and unchanged documents.
	NumberOfDocumentsScanned int64

	// The number of metadata files that were updated or deleted.
	NumberOfMetadataDocumentsModified int64

	// The total number of metadata files that were scanned. Includes new, updated,
	// and unchanged files.
	NumberOfMetadataDocumentsScanned int64

	// The number of modified source documents in the data source that were
	// successfully indexed.
	NumberOfModifiedDocumentsIndexed int64

	// The number of new source documents in the data source that were successfully
	// indexed.
	NumberOfNewDocumentsIndexed int64

	noSmithyDocumentSerde
}

// Contains details about an ingestion job.
type IngestionJobSummary struct {

	// The unique identifier of the data source in the ingestion job.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the ingestion job.
	//
	// This member is required.
	IngestionJobId *string

	// The unique identifier of the knowledge base to which the data source is added.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The time at which the ingestion job was started.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of the ingestion job.
	//
	// This member is required.
	Status IngestionJobStatus

	// The time at which the ingestion job was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the ingestion job.
	Description *string

	// Contains statistics for the ingestion job.
	Statistics *IngestionJobStatistics

	noSmithyDocumentSerde
}

// Contains information about a knowledge base.
type KnowledgeBase struct {

	// The time at which the knowledge base was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ARN of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseArn *string

	// Contains details about the embeddings configuration of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the knowledge base.
	//
	// This member is required.
	Name *string

	// The ARN of the IAM role with permissions to invoke API operations on the
	// knowledge base. The ARN must begin with
	// AmazonBedrockExecutionRoleForKnowledgeBase_ .
	//
	// This member is required.
	RoleArn *string

	// The status of the knowledge base. The following statuses are possible:
	//   - CREATING – The knowledge base is being created.
	//   - ACTIVE – The knowledge base is ready to be queried.
	//   - DELETING – The knowledge base is being deleted.
	//   - UPDATING – The knowledge base is being updated.
	//   - FAILED – The knowledge base API operation failed.
	//
	// This member is required.
	Status KnowledgeBaseStatus

	// Contains details about the storage configuration of the knowledge base.
	//
	// This member is required.
	StorageConfiguration *StorageConfiguration

	// The time at which the knowledge base was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the knowledge base.
	Description *string

	// A list of reasons that the API operation on the knowledge base failed.
	FailureReasons []string

	noSmithyDocumentSerde
}

// Contains details about the embeddings configuration of the knowledge base.
type KnowledgeBaseConfiguration struct {

	// The type of data that the data source is converted into for the knowledge base.
	//
	// This member is required.
	Type KnowledgeBaseType

	// Contains details about the embeddings model that'sused to convert the data
	// source.
	VectorKnowledgeBaseConfiguration *VectorKnowledgeBaseConfiguration

	noSmithyDocumentSerde
}

// Contains details about a knowledge base.
type KnowledgeBaseSummary struct {

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the knowledge base.
	//
	// This member is required.
	Name *string

	// The status of the knowledge base.
	//
	// This member is required.
	Status KnowledgeBaseStatus

	// The time at which the knowledge base was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the knowledge base.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Amazon OpenSearch Service. For more information, see Create a vector index in
// Amazon OpenSearch Service (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html)
// .
type OpenSearchServerlessConfiguration struct {

	// The ARN of the OpenSearch Service vector store.
	//
	// This member is required.
	CollectionArn *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *OpenSearchServerlessFieldMapping

	// The name of the vector store.
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type OpenSearchServerlessFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Pinecone. For more information, see Create a vector index in Pinecone (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html)
// .
type PineconeConfiguration struct {

	// The endpoint URL for your index management page.
	//
	// This member is required.
	ConnectionString *string

	// The ARN of the secret that you created in Secrets Manager that is linked to
	// your Pinecone API key.
	//
	// This member is required.
	CredentialsSecretArn *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *PineconeFieldMapping

	// The namespace to be used to write new data to your database.
	Namespace *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type PineconeFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	noSmithyDocumentSerde
}

// Contains configurations to override a prompt template in one part of an agent
// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html)
// .
type PromptConfiguration struct {

	// Defines the prompt template with which to replace the default prompt template.
	// You can use placeholder variables in the base prompt template to customize the
	// prompt. For more information, see Prompt template placeholder variables (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html)
	// .
	BasePromptTemplate *string

	// Contains inference parameters to use when the agent invokes a foundation model
	// in the part of the agent sequence defined by the promptType . For more
	// information, see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html)
	// .
	InferenceConfiguration *InferenceConfiguration

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined by the
	// promptType . If you set the field as OVERRIDEN , the overrideLambda field in
	// the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// must be specified with the ARN of a Lambda function.
	ParserMode CreationMode

	// Specifies whether to override the default prompt template for this promptType .
	// Set this value to OVERRIDDEN to use the prompt that you provide in the
	// basePromptTemplate . If you leave it as DEFAULT , the agent uses a default
	// prompt template.
	PromptCreationMode CreationMode

	// Specifies whether to allow the agent to carry out the step specified in the
	// promptType . If you set this value to DISABLED , the agent skips that step. The
	// default state for each promptType is as follows.
	//   - PRE_PROCESSING – ENABLED
	//   - ORCHESTRATION – ENABLED
	//   - KNOWLEDGE_BASE_RESPONSE_GENERATION – ENABLED
	//   - POST_PROCESSING – DISABLED
	PromptState PromptState

	// The step in the agent sequence that this prompt configuration applies to.
	PromptType PromptType

	noSmithyDocumentSerde
}

// Contains configurations to override prompts in different parts of an agent
// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html)
// .
type PromptOverrideConfiguration struct {

	// Contains configurations to override a prompt template in one part of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html)
	// .
	//
	// This member is required.
	PromptConfigurations []PromptConfiguration

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence. If you specify this field, at least one
	// of the promptConfigurations must contain a parserMode value that is set to
	// OVERRIDDEN .
	OverrideLambda *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Amazon RDS. For more information, see Create a vector index in Amazon RDS (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html)
// .
type RdsConfiguration struct {

	// The ARN of the secret that you created in Secrets Manager that is linked to
	// your Amazon RDS database.
	//
	// This member is required.
	CredentialsSecretArn *string

	// The name of your Amazon RDS database.
	//
	// This member is required.
	DatabaseName *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *RdsFieldMapping

	// The ARN of the vector store.
	//
	// This member is required.
	ResourceArn *string

	// The name of the table in the database.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type RdsFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the ID for each entry.
	//
	// This member is required.
	PrimaryKeyField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in Redis
// Enterprise Cloud. For more information, see Create a vector index in Redis
// Enterprise Cloud (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html)
// .
type RedisEnterpriseCloudConfiguration struct {

	// The ARN of the secret that you created in Secrets Manager that is linked to
	// your Redis Enterprise Cloud database.
	//
	// This member is required.
	CredentialsSecretArn *string

	// The endpoint URL of the Redis Enterprise Cloud database.
	//
	// This member is required.
	Endpoint *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *RedisEnterpriseCloudFieldMapping

	// The name of the vector index.
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type RedisEnterpriseCloudFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains information about the S3 configuration of the data source.
type S3DataSourceConfiguration struct {

	// The ARN of the bucket that contains the data source.
	//
	// This member is required.
	BucketArn *string

	// A list of S3 prefixes that define the object containing the data sources. For
	// more information, see Organizing objects using prefixes (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html)
	// .
	InclusionPrefixes []string

	noSmithyDocumentSerde
}

// Contains information about the S3 object containing the resource.
type S3Identifier struct {

	// The name of the S3 bucket.
	S3BucketName *string

	// The S3 object key containing the resource.
	S3ObjectKey *string

	noSmithyDocumentSerde
}

// Contains the configuration for server-side encryption.
type ServerSideEncryptionConfiguration struct {

	// The ARN of the KMS key used to encrypt the resource.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains the storage configuration of the knowledge base.
type StorageConfiguration struct {

	// The vector store service in which the knowledge base is stored.
	//
	// This member is required.
	Type KnowledgeBaseStorageType

	// Contains the storage configuration of the knowledge base in Amazon OpenSearch
	// Service.
	OpensearchServerlessConfiguration *OpenSearchServerlessConfiguration

	// Contains the storage configuration of the knowledge base in Pinecone.
	PineconeConfiguration *PineconeConfiguration

	// Contains details about the storage configuration of the knowledge base in
	// Amazon RDS. For more information, see Create a vector index in Amazon RDS (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html)
	// .
	RdsConfiguration *RdsConfiguration

	// Contains the storage configuration of the knowledge base in Redis Enterprise
	// Cloud.
	RedisEnterpriseCloudConfiguration *RedisEnterpriseCloudConfiguration

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// validation error.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains details about how to ingest the documents in a data source.
type VectorIngestionConfiguration struct {

	// Details about how to chunk the documents in the data source. A chunk refers to
	// an excerpt from a data source that is returned when the knowledge base that it
	// belongs to is queried.
	ChunkingConfiguration *ChunkingConfiguration

	noSmithyDocumentSerde
}

// Contains details about the model used to create vector embeddings for the
// knowledge base.
type VectorKnowledgeBaseConfiguration struct {

	// The ARN of the model used to create vector embeddings for the knowledge base.
	//
	// This member is required.
	EmbeddingModelArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isActionGroupExecutor() {}
func (*UnknownUnionMember) isAPISchema()           {}
