// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Verifies an endpoint owner's intent to receive messages by validating the token
// sent to the endpoint by an earlier Subscribe action. If the token is valid, the
// action creates a new subscription and returns its Amazon Resource Name (ARN).
// This call requires an AWS signature only when the AuthenticateOnUnsubscribe flag
// is set to "true".
func (c *Client) ConfirmSubscription(ctx context.Context, params *ConfirmSubscriptionInput, optFns ...func(*Options)) (*ConfirmSubscriptionOutput, error) {
	if params == nil {
		params = &ConfirmSubscriptionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ConfirmSubscription", params, optFns, c.addOperationConfirmSubscriptionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ConfirmSubscriptionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input for ConfirmSubscription action.
type ConfirmSubscriptionInput struct {

	// Short-lived token sent to an endpoint during the Subscribe action.
	//
	// This member is required.
	Token *string

	// The ARN of the topic for which you wish to confirm a subscription.
	//
	// This member is required.
	TopicArn *string

	// Disallows unauthenticated unsubscribes of the subscription. If the value of this
	// parameter is true and the request has an Amazon Web Services signature, then
	// only the topic owner and the subscription owner can unsubscribe the endpoint.
	// The unsubscribe action requires Amazon Web Services authentication.
	AuthenticateOnUnsubscribe *string

	noSmithyDocumentSerde
}

// Response for ConfirmSubscriptions action.
type ConfirmSubscriptionOutput struct {

	// The ARN of the created subscription.
	SubscriptionArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationConfirmSubscriptionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpConfirmSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpConfirmSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpConfirmSubscriptionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opConfirmSubscription(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opConfirmSubscription(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sns",
		OperationName: "ConfirmSubscription",
	}
}
