// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Automatically deletes Amazon Security Lake to stop collecting security data.
// When you delete Amazon Security Lake from your account, Security Lake is
// disabled in all Regions. Also, this API automatically takes steps to remove the
// account from Security Lake . This operation disables security data collection
// from sources, deletes data stored, and stops making data accessible to
// subscribers. Security Lake also deletes all the existing settings and resources
// that it stores or maintains for your Amazon Web Services account in the current
// Region, including security log and event data. The DeleteDatalake operation does
// not delete the Amazon S3 bucket, which is owned by your Amazon Web Services
// account. For more information, see the Amazon Security Lake User Guide
// (https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html).
func (c *Client) DeleteDatalakeAutoEnable(ctx context.Context, params *DeleteDatalakeAutoEnableInput, optFns ...func(*Options)) (*DeleteDatalakeAutoEnableOutput, error) {
	if params == nil {
		params = &DeleteDatalakeAutoEnableInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteDatalakeAutoEnable", params, optFns, c.addOperationDeleteDatalakeAutoEnableMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteDatalakeAutoEnableOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteDatalakeAutoEnableInput struct {

	// Delete Amazon Security Lake with the specified configuration settings to stop
	// ingesting security data for new accounts in Security Lake.
	//
	// This member is required.
	RemoveFromConfigurationForNewAccounts []types.AutoEnableNewRegionConfiguration

	noSmithyDocumentSerde
}

type DeleteDatalakeAutoEnableOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteDatalakeAutoEnableMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteDatalakeAutoEnable{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteDatalakeAutoEnable{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteDatalakeAutoEnableValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteDatalakeAutoEnable(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteDatalakeAutoEnable(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "DeleteDatalakeAutoEnable",
	}
}
