// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDeleteEarthObservationJob struct {
}

func (*validateOpDeleteEarthObservationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteEarthObservationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteEarthObservationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteEarthObservationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVectorEnrichmentJob struct {
}

func (*validateOpDeleteVectorEnrichmentJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVectorEnrichmentJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVectorEnrichmentJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVectorEnrichmentJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpExportEarthObservationJob struct {
}

func (*validateOpExportEarthObservationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpExportEarthObservationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ExportEarthObservationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpExportEarthObservationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpExportVectorEnrichmentJob struct {
}

func (*validateOpExportVectorEnrichmentJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpExportVectorEnrichmentJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ExportVectorEnrichmentJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpExportVectorEnrichmentJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetEarthObservationJob struct {
}

func (*validateOpGetEarthObservationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetEarthObservationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetEarthObservationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetEarthObservationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetRasterDataCollection struct {
}

func (*validateOpGetRasterDataCollection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetRasterDataCollection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetRasterDataCollectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetRasterDataCollectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTile struct {
}

func (*validateOpGetTile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetVectorEnrichmentJob struct {
}

func (*validateOpGetVectorEnrichmentJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetVectorEnrichmentJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetVectorEnrichmentJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetVectorEnrichmentJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSearchRasterDataCollection struct {
}

func (*validateOpSearchRasterDataCollection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSearchRasterDataCollection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SearchRasterDataCollectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSearchRasterDataCollectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartEarthObservationJob struct {
}

func (*validateOpStartEarthObservationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartEarthObservationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartEarthObservationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartEarthObservationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartVectorEnrichmentJob struct {
}

func (*validateOpStartVectorEnrichmentJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartVectorEnrichmentJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartVectorEnrichmentJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartVectorEnrichmentJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopEarthObservationJob struct {
}

func (*validateOpStopEarthObservationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopEarthObservationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopEarthObservationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopEarthObservationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopVectorEnrichmentJob struct {
}

func (*validateOpStopVectorEnrichmentJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopVectorEnrichmentJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopVectorEnrichmentJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopVectorEnrichmentJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDeleteEarthObservationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteEarthObservationJob{}, middleware.After)
}

func addOpDeleteVectorEnrichmentJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVectorEnrichmentJob{}, middleware.After)
}

func addOpExportEarthObservationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpExportEarthObservationJob{}, middleware.After)
}

func addOpExportVectorEnrichmentJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpExportVectorEnrichmentJob{}, middleware.After)
}

func addOpGetEarthObservationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetEarthObservationJob{}, middleware.After)
}

func addOpGetRasterDataCollectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetRasterDataCollection{}, middleware.After)
}

func addOpGetTileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTile{}, middleware.After)
}

func addOpGetVectorEnrichmentJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetVectorEnrichmentJob{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpSearchRasterDataCollectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSearchRasterDataCollection{}, middleware.After)
}

func addOpStartEarthObservationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartEarthObservationJob{}, middleware.After)
}

func addOpStartVectorEnrichmentJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartVectorEnrichmentJob{}, middleware.After)
}

func addOpStopEarthObservationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopEarthObservationJob{}, middleware.After)
}

func addOpStopVectorEnrichmentJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopVectorEnrichmentJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateAreaOfInterest(v types.AreaOfInterest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AreaOfInterest"}
	switch uv := v.(type) {
	case *types.AreaOfInterestMemberAreaOfInterestGeometry:
		if err := validateAreaOfInterestGeometry(uv.Value); err != nil {
			invalidParams.AddNested("[AreaOfInterestGeometry]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAreaOfInterestGeometry(v types.AreaOfInterestGeometry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AreaOfInterestGeometry"}
	switch uv := v.(type) {
	case *types.AreaOfInterestGeometryMemberMultiPolygonGeometry:
		if err := validateMultiPolygonGeometryInput(&uv.Value); err != nil {
			invalidParams.AddNested("[MultiPolygonGeometry]", err.(smithy.InvalidParamsError))
		}

	case *types.AreaOfInterestGeometryMemberPolygonGeometry:
		if err := validatePolygonGeometryInput(&uv.Value); err != nil {
			invalidParams.AddNested("[PolygonGeometry]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBandMathConfigInput(v *types.BandMathConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BandMathConfigInput"}
	if v.CustomIndices != nil {
		if err := validateCustomIndicesInput(v.CustomIndices); err != nil {
			invalidParams.AddNested("CustomIndices", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomIndicesInput(v *types.CustomIndicesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomIndicesInput"}
	if v.Operations != nil {
		if err := validateOperationsListInput(v.Operations); err != nil {
			invalidParams.AddNested("Operations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEoCloudCoverInput(v *types.EoCloudCoverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EoCloudCoverInput"}
	if v.LowerBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LowerBound"))
	}
	if v.UpperBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpperBound"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEojDataSourceConfigInput(v types.EojDataSourceConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EojDataSourceConfigInput"}
	switch uv := v.(type) {
	case *types.EojDataSourceConfigInputMemberS3Data:
		if err := validateS3DataInput(&uv.Value); err != nil {
			invalidParams.AddNested("[S3Data]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportS3DataInput(v *types.ExportS3DataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportS3DataInput"}
	if v.S3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportVectorEnrichmentJobOutputConfig(v *types.ExportVectorEnrichmentJobOutputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportVectorEnrichmentJobOutputConfig"}
	if v.S3Data == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Data"))
	} else if v.S3Data != nil {
		if err := validateVectorEnrichmentJobS3Data(v.S3Data); err != nil {
			invalidParams.AddNested("S3Data", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputConfigInput(v *types.InputConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputConfigInput"}
	if v.DataSourceConfig != nil {
		if err := validateEojDataSourceConfigInput(v.DataSourceConfig); err != nil {
			invalidParams.AddNested("DataSourceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.RasterDataCollectionQuery != nil {
		if err := validateRasterDataCollectionQueryInput(v.RasterDataCollectionQuery); err != nil {
			invalidParams.AddNested("RasterDataCollectionQuery", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobConfigInput(v types.JobConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobConfigInput"}
	switch uv := v.(type) {
	case *types.JobConfigInputMemberBandMathConfig:
		if err := validateBandMathConfigInput(&uv.Value); err != nil {
			invalidParams.AddNested("[BandMathConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.JobConfigInputMemberResamplingConfig:
		if err := validateResamplingConfigInput(&uv.Value); err != nil {
			invalidParams.AddNested("[ResamplingConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.JobConfigInputMemberStackConfig:
		if err := validateStackConfigInput(&uv.Value); err != nil {
			invalidParams.AddNested("[StackConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.JobConfigInputMemberTemporalStatisticsConfig:
		if err := validateTemporalStatisticsConfigInput(&uv.Value); err != nil {
			invalidParams.AddNested("[TemporalStatisticsConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.JobConfigInputMemberZonalStatisticsConfig:
		if err := validateZonalStatisticsConfigInput(&uv.Value); err != nil {
			invalidParams.AddNested("[ZonalStatisticsConfig]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLandsatCloudCoverLandInput(v *types.LandsatCloudCoverLandInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LandsatCloudCoverLandInput"}
	if v.LowerBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LowerBound"))
	}
	if v.UpperBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpperBound"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMapMatchingConfig(v *types.MapMatchingConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MapMatchingConfig"}
	if v.IdAttributeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IdAttributeName"))
	}
	if v.YAttributeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("YAttributeName"))
	}
	if v.XAttributeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("XAttributeName"))
	}
	if v.TimestampAttributeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimestampAttributeName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMultiPolygonGeometryInput(v *types.MultiPolygonGeometryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MultiPolygonGeometryInput"}
	if v.Coordinates == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Coordinates"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOperation(v *types.Operation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Operation"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Equation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Equation"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOperationsListInput(v []types.Operation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OperationsListInput"}
	for i := range v {
		if err := validateOperation(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputConfigInput(v *types.OutputConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputConfigInput"}
	if v.S3Data == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Data"))
	} else if v.S3Data != nil {
		if err := validateExportS3DataInput(v.S3Data); err != nil {
			invalidParams.AddNested("S3Data", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputResolutionResamplingInput(v *types.OutputResolutionResamplingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputResolutionResamplingInput"}
	if v.UserDefined == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UserDefined"))
	} else if v.UserDefined != nil {
		if err := validateUserDefined(v.UserDefined); err != nil {
			invalidParams.AddNested("UserDefined", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputResolutionStackInput(v *types.OutputResolutionStackInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputResolutionStackInput"}
	if v.UserDefined != nil {
		if err := validateUserDefined(v.UserDefined); err != nil {
			invalidParams.AddNested("UserDefined", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePlatformInput(v *types.PlatformInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PlatformInput"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePolygonGeometryInput(v *types.PolygonGeometryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PolygonGeometryInput"}
	if v.Coordinates == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Coordinates"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProperty(v types.Property) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Property"}
	switch uv := v.(type) {
	case *types.PropertyMemberEoCloudCover:
		if err := validateEoCloudCoverInput(&uv.Value); err != nil {
			invalidParams.AddNested("[EoCloudCover]", err.(smithy.InvalidParamsError))
		}

	case *types.PropertyMemberLandsatCloudCoverLand:
		if err := validateLandsatCloudCoverLandInput(&uv.Value); err != nil {
			invalidParams.AddNested("[LandsatCloudCoverLand]", err.(smithy.InvalidParamsError))
		}

	case *types.PropertyMemberPlatform:
		if err := validatePlatformInput(&uv.Value); err != nil {
			invalidParams.AddNested("[Platform]", err.(smithy.InvalidParamsError))
		}

	case *types.PropertyMemberViewOffNadir:
		if err := validateViewOffNadirInput(&uv.Value); err != nil {
			invalidParams.AddNested("[ViewOffNadir]", err.(smithy.InvalidParamsError))
		}

	case *types.PropertyMemberViewSunAzimuth:
		if err := validateViewSunAzimuthInput(&uv.Value); err != nil {
			invalidParams.AddNested("[ViewSunAzimuth]", err.(smithy.InvalidParamsError))
		}

	case *types.PropertyMemberViewSunElevation:
		if err := validateViewSunElevationInput(&uv.Value); err != nil {
			invalidParams.AddNested("[ViewSunElevation]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePropertyFilter(v *types.PropertyFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PropertyFilter"}
	if v.Property == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Property"))
	} else if v.Property != nil {
		if err := validateProperty(v.Property); err != nil {
			invalidParams.AddNested("Property", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePropertyFilters(v *types.PropertyFilters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PropertyFilters"}
	if v.Properties != nil {
		if err := validatePropertyFiltersList(v.Properties); err != nil {
			invalidParams.AddNested("Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePropertyFiltersList(v []types.PropertyFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PropertyFiltersList"}
	for i := range v {
		if err := validatePropertyFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRasterDataCollectionQueryInput(v *types.RasterDataCollectionQueryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RasterDataCollectionQueryInput"}
	if v.RasterDataCollectionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RasterDataCollectionArn"))
	}
	if v.TimeRangeFilter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRangeFilter"))
	} else if v.TimeRangeFilter != nil {
		if err := validateTimeRangeFilterInput(v.TimeRangeFilter); err != nil {
			invalidParams.AddNested("TimeRangeFilter", err.(smithy.InvalidParamsError))
		}
	}
	if v.AreaOfInterest != nil {
		if err := validateAreaOfInterest(v.AreaOfInterest); err != nil {
			invalidParams.AddNested("AreaOfInterest", err.(smithy.InvalidParamsError))
		}
	}
	if v.PropertyFilters != nil {
		if err := validatePropertyFilters(v.PropertyFilters); err != nil {
			invalidParams.AddNested("PropertyFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRasterDataCollectionQueryWithBandFilterInput(v *types.RasterDataCollectionQueryWithBandFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RasterDataCollectionQueryWithBandFilterInput"}
	if v.TimeRangeFilter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRangeFilter"))
	} else if v.TimeRangeFilter != nil {
		if err := validateTimeRangeFilterInput(v.TimeRangeFilter); err != nil {
			invalidParams.AddNested("TimeRangeFilter", err.(smithy.InvalidParamsError))
		}
	}
	if v.AreaOfInterest != nil {
		if err := validateAreaOfInterest(v.AreaOfInterest); err != nil {
			invalidParams.AddNested("AreaOfInterest", err.(smithy.InvalidParamsError))
		}
	}
	if v.PropertyFilters != nil {
		if err := validatePropertyFilters(v.PropertyFilters); err != nil {
			invalidParams.AddNested("PropertyFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResamplingConfigInput(v *types.ResamplingConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResamplingConfigInput"}
	if v.OutputResolution == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputResolution"))
	} else if v.OutputResolution != nil {
		if err := validateOutputResolutionResamplingInput(v.OutputResolution); err != nil {
			invalidParams.AddNested("OutputResolution", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReverseGeocodingConfig(v *types.ReverseGeocodingConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReverseGeocodingConfig"}
	if v.YAttributeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("YAttributeName"))
	}
	if v.XAttributeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("XAttributeName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3DataInput(v *types.S3DataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3DataInput"}
	if v.S3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Uri"))
	}
	if len(v.MetadataProvider) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataProvider"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStackConfigInput(v *types.StackConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StackConfigInput"}
	if v.OutputResolution != nil {
		if err := validateOutputResolutionStackInput(v.OutputResolution); err != nil {
			invalidParams.AddNested("OutputResolution", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTemporalStatisticsConfigInput(v *types.TemporalStatisticsConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TemporalStatisticsConfigInput"}
	if v.Statistics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Statistics"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTimeRangeFilterInput(v *types.TimeRangeFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TimeRangeFilterInput"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUserDefined(v *types.UserDefined) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UserDefined"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if len(v.Unit) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Unit"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorEnrichmentJobConfig(v types.VectorEnrichmentJobConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorEnrichmentJobConfig"}
	switch uv := v.(type) {
	case *types.VectorEnrichmentJobConfigMemberMapMatchingConfig:
		if err := validateMapMatchingConfig(&uv.Value); err != nil {
			invalidParams.AddNested("[MapMatchingConfig]", err.(smithy.InvalidParamsError))
		}

	case *types.VectorEnrichmentJobConfigMemberReverseGeocodingConfig:
		if err := validateReverseGeocodingConfig(&uv.Value); err != nil {
			invalidParams.AddNested("[ReverseGeocodingConfig]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorEnrichmentJobDataSourceConfigInput(v types.VectorEnrichmentJobDataSourceConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorEnrichmentJobDataSourceConfigInput"}
	switch uv := v.(type) {
	case *types.VectorEnrichmentJobDataSourceConfigInputMemberS3Data:
		if err := validateVectorEnrichmentJobS3Data(&uv.Value); err != nil {
			invalidParams.AddNested("[S3Data]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorEnrichmentJobInputConfig(v *types.VectorEnrichmentJobInputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorEnrichmentJobInputConfig"}
	if len(v.DocumentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DocumentType"))
	}
	if v.DataSourceConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSourceConfig"))
	} else if v.DataSourceConfig != nil {
		if err := validateVectorEnrichmentJobDataSourceConfigInput(v.DataSourceConfig); err != nil {
			invalidParams.AddNested("DataSourceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorEnrichmentJobS3Data(v *types.VectorEnrichmentJobS3Data) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorEnrichmentJobS3Data"}
	if v.S3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateViewOffNadirInput(v *types.ViewOffNadirInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ViewOffNadirInput"}
	if v.LowerBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LowerBound"))
	}
	if v.UpperBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpperBound"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateViewSunAzimuthInput(v *types.ViewSunAzimuthInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ViewSunAzimuthInput"}
	if v.LowerBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LowerBound"))
	}
	if v.UpperBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpperBound"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateViewSunElevationInput(v *types.ViewSunElevationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ViewSunElevationInput"}
	if v.LowerBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LowerBound"))
	}
	if v.UpperBound == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpperBound"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateZonalStatisticsConfigInput(v *types.ZonalStatisticsConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ZonalStatisticsConfigInput"}
	if v.ZoneS3Path == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ZoneS3Path"))
	}
	if v.Statistics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Statistics"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteEarthObservationJobInput(v *DeleteEarthObservationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteEarthObservationJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVectorEnrichmentJobInput(v *DeleteVectorEnrichmentJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVectorEnrichmentJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpExportEarthObservationJobInput(v *ExportEarthObservationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportEarthObservationJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.ExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRoleArn"))
	}
	if v.OutputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputConfig"))
	} else if v.OutputConfig != nil {
		if err := validateOutputConfigInput(v.OutputConfig); err != nil {
			invalidParams.AddNested("OutputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpExportVectorEnrichmentJobInput(v *ExportVectorEnrichmentJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportVectorEnrichmentJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.ExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRoleArn"))
	}
	if v.OutputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputConfig"))
	} else if v.OutputConfig != nil {
		if err := validateExportVectorEnrichmentJobOutputConfig(v.OutputConfig); err != nil {
			invalidParams.AddNested("OutputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetEarthObservationJobInput(v *GetEarthObservationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetEarthObservationJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetRasterDataCollectionInput(v *GetRasterDataCollectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetRasterDataCollectionInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTileInput(v *GetTileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTileInput"}
	if v.X == nil {
		invalidParams.Add(smithy.NewErrParamRequired("X"))
	}
	if v.Y == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Y"))
	}
	if v.Z == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Z"))
	}
	if v.ImageAssets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageAssets"))
	}
	if len(v.Target) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Target"))
	}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetVectorEnrichmentJobInput(v *GetVectorEnrichmentJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetVectorEnrichmentJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSearchRasterDataCollectionInput(v *SearchRasterDataCollectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchRasterDataCollectionInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.RasterDataCollectionQuery == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RasterDataCollectionQuery"))
	} else if v.RasterDataCollectionQuery != nil {
		if err := validateRasterDataCollectionQueryWithBandFilterInput(v.RasterDataCollectionQuery); err != nil {
			invalidParams.AddNested("RasterDataCollectionQuery", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartEarthObservationJobInput(v *StartEarthObservationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartEarthObservationJobInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.InputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfig"))
	} else if v.InputConfig != nil {
		if err := validateInputConfigInput(v.InputConfig); err != nil {
			invalidParams.AddNested("InputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.JobConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobConfig"))
	} else if v.JobConfig != nil {
		if err := validateJobConfigInput(v.JobConfig); err != nil {
			invalidParams.AddNested("JobConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartVectorEnrichmentJobInput(v *StartVectorEnrichmentJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartVectorEnrichmentJobInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.InputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfig"))
	} else if v.InputConfig != nil {
		if err := validateVectorEnrichmentJobInputConfig(v.InputConfig); err != nil {
			invalidParams.AddNested("InputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.JobConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobConfig"))
	} else if v.JobConfig != nil {
		if err := validateVectorEnrichmentJobConfig(v.JobConfig); err != nil {
			invalidParams.AddNested("JobConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopEarthObservationJobInput(v *StopEarthObservationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopEarthObservationJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopVectorEnrichmentJobInput(v *StopVectorEnrichmentJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopVectorEnrichmentJobInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
