// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisanalytics

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalytics/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAddApplicationCloudWatchLoggingOption struct {
}

func (*validateOpAddApplicationCloudWatchLoggingOption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddApplicationCloudWatchLoggingOption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddApplicationCloudWatchLoggingOptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddApplicationCloudWatchLoggingOptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddApplicationInput struct {
}

func (*validateOpAddApplicationInput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddApplicationInput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddApplicationInputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddApplicationInputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddApplicationInputProcessingConfiguration struct {
}

func (*validateOpAddApplicationInputProcessingConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddApplicationInputProcessingConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddApplicationInputProcessingConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddApplicationInputProcessingConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddApplicationOutput struct {
}

func (*validateOpAddApplicationOutput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddApplicationOutput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddApplicationOutputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddApplicationOutputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddApplicationReferenceDataSource struct {
}

func (*validateOpAddApplicationReferenceDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddApplicationReferenceDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddApplicationReferenceDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddApplicationReferenceDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateApplication struct {
}

func (*validateOpCreateApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplicationCloudWatchLoggingOption struct {
}

func (*validateOpDeleteApplicationCloudWatchLoggingOption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplicationCloudWatchLoggingOption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationCloudWatchLoggingOptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationCloudWatchLoggingOptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplication struct {
}

func (*validateOpDeleteApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplicationInputProcessingConfiguration struct {
}

func (*validateOpDeleteApplicationInputProcessingConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplicationInputProcessingConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationInputProcessingConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationInputProcessingConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplicationOutput struct {
}

func (*validateOpDeleteApplicationOutput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplicationOutput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationOutputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationOutputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplicationReferenceDataSource struct {
}

func (*validateOpDeleteApplicationReferenceDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplicationReferenceDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationReferenceDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationReferenceDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeApplication struct {
}

func (*validateOpDescribeApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDiscoverInputSchema struct {
}

func (*validateOpDiscoverInputSchema) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDiscoverInputSchema) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DiscoverInputSchemaInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDiscoverInputSchemaInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartApplication struct {
}

func (*validateOpStartApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopApplication struct {
}

func (*validateOpStopApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateApplication struct {
}

func (*validateOpUpdateApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAddApplicationCloudWatchLoggingOptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddApplicationCloudWatchLoggingOption{}, middleware.After)
}

func addOpAddApplicationInputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddApplicationInput{}, middleware.After)
}

func addOpAddApplicationInputProcessingConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddApplicationInputProcessingConfiguration{}, middleware.After)
}

func addOpAddApplicationOutputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddApplicationOutput{}, middleware.After)
}

func addOpAddApplicationReferenceDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddApplicationReferenceDataSource{}, middleware.After)
}

func addOpCreateApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApplication{}, middleware.After)
}

func addOpDeleteApplicationCloudWatchLoggingOptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplicationCloudWatchLoggingOption{}, middleware.After)
}

func addOpDeleteApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplication{}, middleware.After)
}

func addOpDeleteApplicationInputProcessingConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplicationInputProcessingConfiguration{}, middleware.After)
}

func addOpDeleteApplicationOutputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplicationOutput{}, middleware.After)
}

func addOpDeleteApplicationReferenceDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplicationReferenceDataSource{}, middleware.After)
}

func addOpDescribeApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeApplication{}, middleware.After)
}

func addOpDiscoverInputSchemaValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDiscoverInputSchema{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartApplication{}, middleware.After)
}

func addOpStopApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopApplication{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateApplication{}, middleware.After)
}

func validateApplicationUpdate(v *types.ApplicationUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApplicationUpdate"}
	if v.InputUpdates != nil {
		if err := validateInputUpdates(v.InputUpdates); err != nil {
			invalidParams.AddNested("InputUpdates", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutputUpdates != nil {
		if err := validateOutputUpdates(v.OutputUpdates); err != nil {
			invalidParams.AddNested("OutputUpdates", err.(smithy.InvalidParamsError))
		}
	}
	if v.ReferenceDataSourceUpdates != nil {
		if err := validateReferenceDataSourceUpdates(v.ReferenceDataSourceUpdates); err != nil {
			invalidParams.AddNested("ReferenceDataSourceUpdates", err.(smithy.InvalidParamsError))
		}
	}
	if v.CloudWatchLoggingOptionUpdates != nil {
		if err := validateCloudWatchLoggingOptionUpdates(v.CloudWatchLoggingOptionUpdates); err != nil {
			invalidParams.AddNested("CloudWatchLoggingOptionUpdates", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchLoggingOption(v *types.CloudWatchLoggingOption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchLoggingOption"}
	if v.LogStreamARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogStreamARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchLoggingOptions(v []types.CloudWatchLoggingOption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchLoggingOptions"}
	for i := range v {
		if err := validateCloudWatchLoggingOption(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchLoggingOptionUpdate(v *types.CloudWatchLoggingOptionUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchLoggingOptionUpdate"}
	if v.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchLoggingOptionUpdates(v []types.CloudWatchLoggingOptionUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchLoggingOptionUpdates"}
	for i := range v {
		if err := validateCloudWatchLoggingOptionUpdate(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCSVMappingParameters(v *types.CSVMappingParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CSVMappingParameters"}
	if v.RecordRowDelimiter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordRowDelimiter"))
	}
	if v.RecordColumnDelimiter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordColumnDelimiter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestinationSchema(v *types.DestinationSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DestinationSchema"}
	if len(v.RecordFormatType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RecordFormatType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInput(v *types.Input) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Input"}
	if v.NamePrefix == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NamePrefix"))
	}
	if v.InputProcessingConfiguration != nil {
		if err := validateInputProcessingConfiguration(v.InputProcessingConfiguration); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.KinesisStreamsInput != nil {
		if err := validateKinesisStreamsInput(v.KinesisStreamsInput); err != nil {
			invalidParams.AddNested("KinesisStreamsInput", err.(smithy.InvalidParamsError))
		}
	}
	if v.KinesisFirehoseInput != nil {
		if err := validateKinesisFirehoseInput(v.KinesisFirehoseInput); err != nil {
			invalidParams.AddNested("KinesisFirehoseInput", err.(smithy.InvalidParamsError))
		}
	}
	if v.InputSchema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputSchema"))
	} else if v.InputSchema != nil {
		if err := validateSourceSchema(v.InputSchema); err != nil {
			invalidParams.AddNested("InputSchema", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputConfiguration(v *types.InputConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputConfiguration"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.InputStartingPositionConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputStartingPositionConfiguration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputConfigurations(v []types.InputConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputConfigurations"}
	for i := range v {
		if err := validateInputConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputLambdaProcessor(v *types.InputLambdaProcessor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputLambdaProcessor"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputProcessingConfiguration(v *types.InputProcessingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputProcessingConfiguration"}
	if v.InputLambdaProcessor == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputLambdaProcessor"))
	} else if v.InputLambdaProcessor != nil {
		if err := validateInputLambdaProcessor(v.InputLambdaProcessor); err != nil {
			invalidParams.AddNested("InputLambdaProcessor", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputProcessingConfigurationUpdate(v *types.InputProcessingConfigurationUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputProcessingConfigurationUpdate"}
	if v.InputLambdaProcessorUpdate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputLambdaProcessorUpdate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputs(v []types.Input) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Inputs"}
	for i := range v {
		if err := validateInput(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputSchemaUpdate(v *types.InputSchemaUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputSchemaUpdate"}
	if v.RecordFormatUpdate != nil {
		if err := validateRecordFormat(v.RecordFormatUpdate); err != nil {
			invalidParams.AddNested("RecordFormatUpdate", err.(smithy.InvalidParamsError))
		}
	}
	if v.RecordColumnUpdates != nil {
		if err := validateRecordColumns(v.RecordColumnUpdates); err != nil {
			invalidParams.AddNested("RecordColumnUpdates", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputUpdate(v *types.InputUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputUpdate"}
	if v.InputId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputId"))
	}
	if v.InputProcessingConfigurationUpdate != nil {
		if err := validateInputProcessingConfigurationUpdate(v.InputProcessingConfigurationUpdate); err != nil {
			invalidParams.AddNested("InputProcessingConfigurationUpdate", err.(smithy.InvalidParamsError))
		}
	}
	if v.InputSchemaUpdate != nil {
		if err := validateInputSchemaUpdate(v.InputSchemaUpdate); err != nil {
			invalidParams.AddNested("InputSchemaUpdate", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputUpdates(v []types.InputUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputUpdates"}
	for i := range v {
		if err := validateInputUpdate(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJSONMappingParameters(v *types.JSONMappingParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JSONMappingParameters"}
	if v.RecordRowPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordRowPath"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKinesisFirehoseInput(v *types.KinesisFirehoseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KinesisFirehoseInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKinesisFirehoseOutput(v *types.KinesisFirehoseOutput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KinesisFirehoseOutput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKinesisStreamsInput(v *types.KinesisStreamsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KinesisStreamsInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKinesisStreamsOutput(v *types.KinesisStreamsOutput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KinesisStreamsOutput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaOutput(v *types.LambdaOutput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaOutput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMappingParameters(v *types.MappingParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MappingParameters"}
	if v.JSONMappingParameters != nil {
		if err := validateJSONMappingParameters(v.JSONMappingParameters); err != nil {
			invalidParams.AddNested("JSONMappingParameters", err.(smithy.InvalidParamsError))
		}
	}
	if v.CSVMappingParameters != nil {
		if err := validateCSVMappingParameters(v.CSVMappingParameters); err != nil {
			invalidParams.AddNested("CSVMappingParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutput(v *types.Output) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Output"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.KinesisStreamsOutput != nil {
		if err := validateKinesisStreamsOutput(v.KinesisStreamsOutput); err != nil {
			invalidParams.AddNested("KinesisStreamsOutput", err.(smithy.InvalidParamsError))
		}
	}
	if v.KinesisFirehoseOutput != nil {
		if err := validateKinesisFirehoseOutput(v.KinesisFirehoseOutput); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutput", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaOutput != nil {
		if err := validateLambdaOutput(v.LambdaOutput); err != nil {
			invalidParams.AddNested("LambdaOutput", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationSchema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationSchema"))
	} else if v.DestinationSchema != nil {
		if err := validateDestinationSchema(v.DestinationSchema); err != nil {
			invalidParams.AddNested("DestinationSchema", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputs(v []types.Output) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Outputs"}
	for i := range v {
		if err := validateOutput(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputUpdate(v *types.OutputUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputUpdate"}
	if v.OutputId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputId"))
	}
	if v.DestinationSchemaUpdate != nil {
		if err := validateDestinationSchema(v.DestinationSchemaUpdate); err != nil {
			invalidParams.AddNested("DestinationSchemaUpdate", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputUpdates(v []types.OutputUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputUpdates"}
	for i := range v {
		if err := validateOutputUpdate(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRecordColumn(v *types.RecordColumn) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RecordColumn"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.SqlType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SqlType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRecordColumns(v []types.RecordColumn) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RecordColumns"}
	for i := range v {
		if err := validateRecordColumn(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRecordFormat(v *types.RecordFormat) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RecordFormat"}
	if len(v.RecordFormatType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RecordFormatType"))
	}
	if v.MappingParameters != nil {
		if err := validateMappingParameters(v.MappingParameters); err != nil {
			invalidParams.AddNested("MappingParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReferenceDataSource(v *types.ReferenceDataSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReferenceDataSource"}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.S3ReferenceDataSource != nil {
		if err := validateS3ReferenceDataSource(v.S3ReferenceDataSource); err != nil {
			invalidParams.AddNested("S3ReferenceDataSource", err.(smithy.InvalidParamsError))
		}
	}
	if v.ReferenceSchema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReferenceSchema"))
	} else if v.ReferenceSchema != nil {
		if err := validateSourceSchema(v.ReferenceSchema); err != nil {
			invalidParams.AddNested("ReferenceSchema", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReferenceDataSourceUpdate(v *types.ReferenceDataSourceUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReferenceDataSourceUpdate"}
	if v.ReferenceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReferenceId"))
	}
	if v.ReferenceSchemaUpdate != nil {
		if err := validateSourceSchema(v.ReferenceSchemaUpdate); err != nil {
			invalidParams.AddNested("ReferenceSchemaUpdate", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReferenceDataSourceUpdates(v []types.ReferenceDataSourceUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReferenceDataSourceUpdates"}
	for i := range v {
		if err := validateReferenceDataSourceUpdate(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Configuration(v *types.S3Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Configuration"}
	if v.RoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleARN"))
	}
	if v.BucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketARN"))
	}
	if v.FileKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ReferenceDataSource(v *types.S3ReferenceDataSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ReferenceDataSource"}
	if v.BucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketARN"))
	}
	if v.FileKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileKey"))
	}
	if v.ReferenceRoleARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReferenceRoleARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSourceSchema(v *types.SourceSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SourceSchema"}
	if v.RecordFormat == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordFormat"))
	} else if v.RecordFormat != nil {
		if err := validateRecordFormat(v.RecordFormat); err != nil {
			invalidParams.AddNested("RecordFormat", err.(smithy.InvalidParamsError))
		}
	}
	if v.RecordColumns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordColumns"))
	} else if v.RecordColumns != nil {
		if err := validateRecordColumns(v.RecordColumns); err != nil {
			invalidParams.AddNested("RecordColumns", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTags(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tags"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddApplicationCloudWatchLoggingOptionInput(v *AddApplicationCloudWatchLoggingOptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddApplicationCloudWatchLoggingOptionInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.CloudWatchLoggingOption == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudWatchLoggingOption"))
	} else if v.CloudWatchLoggingOption != nil {
		if err := validateCloudWatchLoggingOption(v.CloudWatchLoggingOption); err != nil {
			invalidParams.AddNested("CloudWatchLoggingOption", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddApplicationInputInput(v *AddApplicationInputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddApplicationInputInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.Input == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Input"))
	} else if v.Input != nil {
		if err := validateInput(v.Input); err != nil {
			invalidParams.AddNested("Input", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddApplicationInputProcessingConfigurationInput(v *AddApplicationInputProcessingConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddApplicationInputProcessingConfigurationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.InputId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputId"))
	}
	if v.InputProcessingConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputProcessingConfiguration"))
	} else if v.InputProcessingConfiguration != nil {
		if err := validateInputProcessingConfiguration(v.InputProcessingConfiguration); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddApplicationOutputInput(v *AddApplicationOutputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddApplicationOutputInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.Output == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Output"))
	} else if v.Output != nil {
		if err := validateOutput(v.Output); err != nil {
			invalidParams.AddNested("Output", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddApplicationReferenceDataSourceInput(v *AddApplicationReferenceDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddApplicationReferenceDataSourceInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.ReferenceDataSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReferenceDataSource"))
	} else if v.ReferenceDataSource != nil {
		if err := validateReferenceDataSource(v.ReferenceDataSource); err != nil {
			invalidParams.AddNested("ReferenceDataSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApplicationInput(v *CreateApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApplicationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.Inputs != nil {
		if err := validateInputs(v.Inputs); err != nil {
			invalidParams.AddNested("Inputs", err.(smithy.InvalidParamsError))
		}
	}
	if v.Outputs != nil {
		if err := validateOutputs(v.Outputs); err != nil {
			invalidParams.AddNested("Outputs", err.(smithy.InvalidParamsError))
		}
	}
	if v.CloudWatchLoggingOptions != nil {
		if err := validateCloudWatchLoggingOptions(v.CloudWatchLoggingOptions); err != nil {
			invalidParams.AddNested("CloudWatchLoggingOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationCloudWatchLoggingOptionInput(v *DeleteApplicationCloudWatchLoggingOptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationCloudWatchLoggingOptionInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationInput(v *DeleteApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CreateTimestamp == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CreateTimestamp"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationInputProcessingConfigurationInput(v *DeleteApplicationInputProcessingConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationInputProcessingConfigurationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.InputId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationOutputInput(v *DeleteApplicationOutputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationOutputInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.OutputId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationReferenceDataSourceInput(v *DeleteApplicationReferenceDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationReferenceDataSourceInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.ReferenceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReferenceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeApplicationInput(v *DescribeApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeApplicationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDiscoverInputSchemaInput(v *DiscoverInputSchemaInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DiscoverInputSchemaInput"}
	if v.S3Configuration != nil {
		if err := validateS3Configuration(v.S3Configuration); err != nil {
			invalidParams.AddNested("S3Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.InputProcessingConfiguration != nil {
		if err := validateInputProcessingConfiguration(v.InputProcessingConfiguration); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartApplicationInput(v *StartApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartApplicationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.InputConfigurations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfigurations"))
	} else if v.InputConfigurations != nil {
		if err := validateInputConfigurations(v.InputConfigurations); err != nil {
			invalidParams.AddNested("InputConfigurations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopApplicationInput(v *StopApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopApplicationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateApplicationInput(v *UpdateApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateApplicationInput"}
	if v.ApplicationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationName"))
	}
	if v.CurrentApplicationVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if v.ApplicationUpdate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationUpdate"))
	} else if v.ApplicationUpdate != nil {
		if err := validateApplicationUpdate(v.ApplicationUpdate); err != nil {
			invalidParams.AddNested("ApplicationUpdate", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
