// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the definitions of some or all of the tables in a given Database.
func (c *Client) GetTables(ctx context.Context, params *GetTablesInput, optFns ...func(*Options)) (*GetTablesOutput, error) {
	if params == nil {
		params = &GetTablesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTables", params, optFns, c.addOperationGetTablesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTablesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTablesInput struct {

	// The database in the catalog whose tables to list. For Hive compatibility, this
	// name is entirely lowercase.
	//
	// This member is required.
	DatabaseName *string

	// The ID of the Data Catalog where the tables reside. If none is provided, the
	// Amazon Web Services account ID is used by default.
	CatalogId *string

	// A regular expression pattern. If present, only those tables whose names match
	// the pattern are returned.
	Expression *string

	// The maximum number of tables to return in a single response.
	MaxResults *int32

	// A continuation token, included if this is a continuation call.
	NextToken *string

	// The time as of when to read the table contents. If not set, the most recent
	// transaction commit time will be used. Cannot be specified along with
	// TransactionId.
	QueryAsOfTime *time.Time

	// The transaction ID at which to read the table contents.
	TransactionId *string

	noSmithyDocumentSerde
}

type GetTablesOutput struct {

	// A continuation token, present if the current list segment is not the last.
	NextToken *string

	// A list of the requested Table objects.
	TableList []types.Table

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTablesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetTables{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetTables{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetTablesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTables(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetTablesAPIClient is a client that implements the GetTables operation.
type GetTablesAPIClient interface {
	GetTables(context.Context, *GetTablesInput, ...func(*Options)) (*GetTablesOutput, error)
}

var _ GetTablesAPIClient = (*Client)(nil)

// GetTablesPaginatorOptions is the paginator options for GetTables
type GetTablesPaginatorOptions struct {
	// The maximum number of tables to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetTablesPaginator is a paginator for GetTables
type GetTablesPaginator struct {
	options   GetTablesPaginatorOptions
	client    GetTablesAPIClient
	params    *GetTablesInput
	nextToken *string
	firstPage bool
}

// NewGetTablesPaginator returns a new GetTablesPaginator
func NewGetTablesPaginator(client GetTablesAPIClient, params *GetTablesInput, optFns ...func(*GetTablesPaginatorOptions)) *GetTablesPaginator {
	if params == nil {
		params = &GetTablesInput{}
	}

	options := GetTablesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetTablesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetTablesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetTables page.
func (p *GetTablesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetTablesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetTables(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetTables(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "glue",
		OperationName: "GetTables",
	}
}
