// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The specified Amazon Resource Name (ARN) does not exist in the AWS account.
type ActorDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ActorDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ActorDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ActorDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ActorDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *ActorDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The content for the approval rule is empty. You must provide some content for an
// approval rule. The content cannot be null.
type ApprovalRuleContentRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleContentRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleContentRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleContentRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleContentRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleContentRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified approval rule does not exist.
type ApprovalRuleDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An approval rule with that name already exists. Approval rule names must be
// unique within the scope of a pull request.
type ApprovalRuleNameAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleNameAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleNameAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleNameAlreadyExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleNameAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleNameAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An approval rule name is required, but was not specified.
type ApprovalRuleNameRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleNameRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleNameRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleNameRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The content for the approval rule template is empty. You must provide some
// content for an approval rule template. The content cannot be null.
type ApprovalRuleTemplateContentRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleTemplateContentRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleTemplateContentRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleTemplateContentRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleTemplateContentRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleTemplateContentRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified approval rule template does not exist. Verify that the name is
// correct and that you are signed in to the AWS Region where the template was
// created, and then try again.
type ApprovalRuleTemplateDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleTemplateDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleTemplateDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleTemplateDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleTemplateDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleTemplateDoesNotExistException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The approval rule template is associated with one or more repositories. You
// cannot delete a template that is associated with a repository. Remove all
// associations, and then try again.
type ApprovalRuleTemplateInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleTemplateInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleTemplateInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleTemplateInUseException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleTemplateInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleTemplateInUseException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You cannot create an approval rule template with that name because a template
// with that name already exists in this AWS Region for your AWS account. Approval
// rule template names must be unique.
type ApprovalRuleTemplateNameAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleTemplateNameAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleTemplateNameAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleTemplateNameAlreadyExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleTemplateNameAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleTemplateNameAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An approval rule template name is required, but was not specified.
type ApprovalRuleTemplateNameRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalRuleTemplateNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalRuleTemplateNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalRuleTemplateNameRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalRuleTemplateNameRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalRuleTemplateNameRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An approval state is required, but was not specified.
type ApprovalStateRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApprovalStateRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApprovalStateRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApprovalStateRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ApprovalStateRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApprovalStateRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon Resource Name (ARN) does not exist in the AWS account.
type AuthorDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "AuthorDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The before commit ID and the after commit ID are the same, which is not valid.
// The before commit ID and the after commit ID must be different commit IDs.
type BeforeCommitIdAndAfterCommitIdAreSameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BeforeCommitIdAndAfterCommitIdAreSameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BeforeCommitIdAndAfterCommitIdAreSameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BeforeCommitIdAndAfterCommitIdAreSameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BeforeCommitIdAndAfterCommitIdAreSameException"
	}
	return *e.ErrorCodeOverride
}
func (e *BeforeCommitIdAndAfterCommitIdAreSameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified blob does not exist.
type BlobIdDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BlobIdDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BlobIdDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BlobIdDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BlobIdDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *BlobIdDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A blob ID is required, but was not specified.
type BlobIdRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BlobIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BlobIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BlobIdRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BlobIdRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *BlobIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified branch does not exist.
type BranchDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BranchDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BranchDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BranchDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BranchDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *BranchDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot create the branch with the specified name because the commit conflicts
// with an existing branch with the same name. Branch names must be unique.
type BranchNameExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BranchNameExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BranchNameExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BranchNameExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BranchNameExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *BranchNameExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified branch name is not valid because it is a tag name. Enter the name
// of a branch in the repository. For a list of valid branch names, use
// ListBranches.
type BranchNameIsTagNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BranchNameIsTagNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BranchNameIsTagNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BranchNameIsTagNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BranchNameIsTagNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *BranchNameIsTagNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A branch name is required, but was not specified.
type BranchNameRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BranchNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BranchNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BranchNameRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "BranchNameRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *BranchNameRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The approval rule cannot be deleted from the pull request because it was created
// by an approval rule template and applied to the pull request automatically.
type CannotDeleteApprovalRuleFromTemplateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CannotDeleteApprovalRuleFromTemplateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CannotDeleteApprovalRuleFromTemplateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CannotDeleteApprovalRuleFromTemplateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CannotDeleteApprovalRuleFromTemplateException"
	}
	return *e.ErrorCodeOverride
}
func (e *CannotDeleteApprovalRuleFromTemplateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The approval rule cannot be modified for the pull request because it was created
// by an approval rule template and applied to the pull request automatically.
type CannotModifyApprovalRuleFromTemplateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CannotModifyApprovalRuleFromTemplateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CannotModifyApprovalRuleFromTemplateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CannotModifyApprovalRuleFromTemplateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CannotModifyApprovalRuleFromTemplateException"
	}
	return *e.ErrorCodeOverride
}
func (e *CannotModifyApprovalRuleFromTemplateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A client request token is required. A client request token is an unique,
// client-generated idempotency token that, when provided in a request, ensures the
// request cannot be repeated with a changed parameter. If a request is received
// with the same parameters and a token is included, the request returns
// information about the initial request that used that token.
type ClientRequestTokenRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClientRequestTokenRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClientRequestTokenRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClientRequestTokenRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ClientRequestTokenRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ClientRequestTokenRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The comment is empty. You must provide some content for a comment. The content
// cannot be null.
type CommentContentRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommentContentRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommentContentRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommentContentRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommentContentRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommentContentRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The comment is too large. Comments are limited to 1,000 characters.
type CommentContentSizeLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommentContentSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommentContentSizeLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommentContentSizeLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommentContentSizeLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommentContentSizeLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This comment has already been deleted. You cannot edit or delete a deleted
// comment.
type CommentDeletedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommentDeletedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommentDeletedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommentDeletedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommentDeletedException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommentDeletedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No comment exists with the provided ID. Verify that you have used the correct
// ID, and then try again.
type CommentDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommentDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommentDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommentDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommentDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommentDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The comment ID is missing or null. A comment ID is required.
type CommentIdRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommentIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommentIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommentIdRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommentIdRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommentIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot modify or delete this comment. Only comment authors can modify or
// delete their comments.
type CommentNotCreatedByCallerException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommentNotCreatedByCallerException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommentNotCreatedByCallerException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommentNotCreatedByCallerException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommentNotCreatedByCallerException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommentNotCreatedByCallerException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified commit does not exist or no commit was specified, and the
// specified repository has no default branch.
type CommitDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified commit ID does not exist.
type CommitIdDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitIdDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitIdDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitIdDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitIdDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitIdDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A commit ID was not specified.
type CommitIdRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitIdRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitIdRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of allowed commit IDs in a batch request is 100. Verify that
// your batch requests contains no more than 100 commit IDs, and then try again.
type CommitIdsLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitIdsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitIdsLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitIdsLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitIdsLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitIdsLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A list of commit IDs is required, but was either not specified or the list was
// empty.
type CommitIdsListRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitIdsListRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitIdsListRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitIdsListRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitIdsListRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitIdsListRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit message is too long. Provide a shorter string.
type CommitMessageLengthExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitMessageLengthExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitMessageLengthExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitMessageLengthExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitMessageLengthExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitMessageLengthExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A commit was not specified.
type CommitRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CommitRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CommitRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CommitRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CommitRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *CommitRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The merge cannot be completed because the target branch has been modified.
// Another user might have modified the target branch while the merge was in
// progress. Wait a few minutes, and then try again.
type ConcurrentReferenceUpdateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentReferenceUpdateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentReferenceUpdateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentReferenceUpdateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ConcurrentReferenceUpdateException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentReferenceUpdateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified branch is the default branch for the repository, and cannot be
// deleted. To delete this branch, you must first set another branch as the default
// branch.
type DefaultBranchCannotBeDeletedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DefaultBranchCannotBeDeletedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DefaultBranchCannotBeDeletedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DefaultBranchCannotBeDeletedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DefaultBranchCannotBeDeletedException"
	}
	return *e.ErrorCodeOverride
}
func (e *DefaultBranchCannotBeDeletedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A file cannot be added to the repository because the specified path name has the
// same name as a file that already exists in this repository. Either provide a
// different name for the file, or specify a different path for the file.
type DirectoryNameConflictsWithFileNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DirectoryNameConflictsWithFileNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DirectoryNameConflictsWithFileNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DirectoryNameConflictsWithFileNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DirectoryNameConflictsWithFileNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *DirectoryNameConflictsWithFileNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An encryption integrity check failed.
type EncryptionIntegrityChecksFailedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EncryptionIntegrityChecksFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EncryptionIntegrityChecksFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EncryptionIntegrityChecksFailedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EncryptionIntegrityChecksFailedException"
	}
	return *e.ErrorCodeOverride
}
func (e *EncryptionIntegrityChecksFailedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultServer
}

// An encryption key could not be accessed.
type EncryptionKeyAccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EncryptionKeyAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EncryptionKeyAccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EncryptionKeyAccessDeniedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EncryptionKeyAccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *EncryptionKeyAccessDeniedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The encryption key is disabled.
type EncryptionKeyDisabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EncryptionKeyDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EncryptionKeyDisabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EncryptionKeyDisabledException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EncryptionKeyDisabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *EncryptionKeyDisabledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No encryption key was found.
type EncryptionKeyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EncryptionKeyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EncryptionKeyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EncryptionKeyNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EncryptionKeyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *EncryptionKeyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The encryption key is not available.
type EncryptionKeyUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EncryptionKeyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EncryptionKeyUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EncryptionKeyUnavailableException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EncryptionKeyUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *EncryptionKeyUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because both a source file and file content have
// been specified for the same file. You cannot provide both. Either specify a
// source file or provide the file content directly.
type FileContentAndSourceFileSpecifiedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileContentAndSourceFileSpecifiedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileContentAndSourceFileSpecifiedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileContentAndSourceFileSpecifiedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileContentAndSourceFileSpecifiedException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileContentAndSourceFileSpecifiedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The file cannot be added because it is empty. Empty files cannot be added to the
// repository with this API.
type FileContentRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileContentRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileContentRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileContentRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileContentRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileContentRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The file cannot be added because it is too large. The maximum file size is 6 MB,
// and the combined file content change size is 7 MB. Consider making these changes
// using a Git client.
type FileContentSizeLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileContentSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileContentSizeLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileContentSizeLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileContentSizeLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileContentSizeLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified file does not exist. Verify that you have used the correct file
// name, full path, and extension.
type FileDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because no files have been specified as added,
// updated, or changed (PutFile or DeleteFile) for the commit.
type FileEntryRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileEntryRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileEntryRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileEntryRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileEntryRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileEntryRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because no file mode has been specified. A file
// mode is required to update mode permissions for a file.
type FileModeRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileModeRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileModeRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileModeRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileModeRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileModeRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A file cannot be added to the repository because the specified file name has the
// same name as a directory in this repository. Either provide another name for the
// file, or add the file in a directory that does not match the file name.
type FileNameConflictsWithDirectoryNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileNameConflictsWithDirectoryNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileNameConflictsWithDirectoryNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileNameConflictsWithDirectoryNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileNameConflictsWithDirectoryNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileNameConflictsWithDirectoryNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The commit cannot be created because a specified file path points to a
// submodule. Verify that the destination files have valid file paths that do not
// point to a submodule.
type FilePathConflictsWithSubmodulePathException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FilePathConflictsWithSubmodulePathException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FilePathConflictsWithSubmodulePathException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FilePathConflictsWithSubmodulePathException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FilePathConflictsWithSubmodulePathException"
	}
	return *e.ErrorCodeOverride
}
func (e *FilePathConflictsWithSubmodulePathException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified file exceeds the file size limit for AWS CodeCommit. For more
// information about limits in AWS CodeCommit, see AWS CodeCommit User Guide
// (https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html).
type FileTooLargeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FileTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FileTooLargeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FileTooLargeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FileTooLargeException"
	}
	return *e.ErrorCodeOverride
}
func (e *FileTooLargeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because at least one of the overall changes in the
// commit results in a folder whose contents exceed the limit of 6 MB. Either
// reduce the number and size of your changes, or split the changes across multiple
// folders.
type FolderContentSizeLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FolderContentSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FolderContentSizeLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FolderContentSizeLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FolderContentSizeLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *FolderContentSizeLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified folder does not exist. Either the folder name is not correct, or
// you did not enter the full path to the folder.
type FolderDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FolderDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FolderDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FolderDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "FolderDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *FolderDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The client request token is not valid. Either the token is not in a valid
// format, or the token has been used in a previous request and cannot be reused.
type IdempotencyParameterMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IdempotencyParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotencyParameterMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotencyParameterMismatchException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "IdempotencyParameterMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *IdempotencyParameterMismatchException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Amazon Resource Name (ARN) is not valid. Make sure that you have provided
// the full ARN for the user who initiated the change for the pull request, and
// then try again.
type InvalidActorArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidActorArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidActorArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidActorArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidActorArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidActorArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The content for the approval rule is not valid.
type InvalidApprovalRuleContentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidApprovalRuleContentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApprovalRuleContentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApprovalRuleContentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidApprovalRuleContentException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidApprovalRuleContentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The name for the approval rule is not valid.
type InvalidApprovalRuleNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidApprovalRuleNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApprovalRuleNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApprovalRuleNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidApprovalRuleNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidApprovalRuleNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The content of the approval rule template is not valid.
type InvalidApprovalRuleTemplateContentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidApprovalRuleTemplateContentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApprovalRuleTemplateContentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApprovalRuleTemplateContentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidApprovalRuleTemplateContentException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidApprovalRuleTemplateContentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The description for the approval rule template is not valid because it exceeds
// the maximum characters allowed for a description. For more information about
// limits in AWS CodeCommit, see AWS CodeCommit User Guide
// (https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html).
type InvalidApprovalRuleTemplateDescriptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidApprovalRuleTemplateDescriptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApprovalRuleTemplateDescriptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApprovalRuleTemplateDescriptionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidApprovalRuleTemplateDescriptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidApprovalRuleTemplateDescriptionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The name of the approval rule template is not valid. Template names must be
// between 1 and 100 valid characters in length. For more information about limits
// in AWS CodeCommit, see AWS CodeCommit User Guide
// (https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html).
type InvalidApprovalRuleTemplateNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidApprovalRuleTemplateNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApprovalRuleTemplateNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApprovalRuleTemplateNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidApprovalRuleTemplateNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidApprovalRuleTemplateNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The state for the approval is not valid. Valid values include APPROVE and
// REVOKE.
type InvalidApprovalStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidApprovalStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApprovalStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApprovalStateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidApprovalStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidApprovalStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon Resource Name (ARN) is not valid. Make sure that you have provided
// the full ARN for the author of the pull request, and then try again.
type InvalidAuthorArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAuthorArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAuthorArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAuthorArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidAuthorArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAuthorArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified blob is not valid.
type InvalidBlobIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidBlobIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidBlobIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidBlobIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidBlobIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidBlobIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified reference name is not valid.
type InvalidBranchNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidBranchNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidBranchNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidBranchNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidBranchNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidBranchNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The client request token is not valid.
type InvalidClientRequestTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClientRequestTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClientRequestTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClientRequestTokenException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidClientRequestTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClientRequestTokenException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The comment ID is not in a valid format. Make sure that you have provided the
// full comment ID.
type InvalidCommentIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCommentIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCommentIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCommentIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidCommentIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCommentIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified commit is not valid.
type InvalidCommitException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCommitException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCommitException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCommitException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidCommitException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCommitException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified commit ID is not valid.
type InvalidCommitIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCommitIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCommitIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCommitIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidCommitIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCommitIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified conflict detail level is not valid.
type InvalidConflictDetailLevelException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidConflictDetailLevelException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidConflictDetailLevelException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidConflictDetailLevelException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidConflictDetailLevelException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidConflictDetailLevelException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified conflict resolution list is not valid.
type InvalidConflictResolutionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidConflictResolutionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidConflictResolutionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidConflictResolutionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidConflictResolutionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidConflictResolutionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified conflict resolution strategy is not valid.
type InvalidConflictResolutionStrategyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidConflictResolutionStrategyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidConflictResolutionStrategyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidConflictResolutionStrategyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidConflictResolutionStrategyException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidConflictResolutionStrategyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified continuation token is not valid.
type InvalidContinuationTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidContinuationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidContinuationTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidContinuationTokenException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidContinuationTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidContinuationTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified deletion parameter is not valid.
type InvalidDeletionParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDeletionParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeletionParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeletionParameterException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidDeletionParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDeletionParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request description is not valid. Descriptions cannot be more than
// 1,000 characters.
type InvalidDescriptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDescriptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDescriptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDescriptionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidDescriptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDescriptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The destination commit specifier is not valid. You must provide a valid branch
// name, tag, or full commit ID.
type InvalidDestinationCommitSpecifierException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDestinationCommitSpecifierException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDestinationCommitSpecifierException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDestinationCommitSpecifierException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidDestinationCommitSpecifierException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDestinationCommitSpecifierException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified email address either contains one or more characters that are not
// allowed, or it exceeds the maximum number of characters allowed for an email
// address.
type InvalidEmailException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEmailException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEmailException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEmailException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidEmailException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEmailException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The location of the file is not valid. Make sure that you include the file name
// and extension.
type InvalidFileLocationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFileLocationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFileLocationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFileLocationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidFileLocationException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFileLocationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified file mode permission is not valid. For a list of valid file mode
// permissions, see PutFile.
type InvalidFileModeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFileModeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFileModeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFileModeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidFileModeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFileModeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The position is not valid. Make sure that the line number exists in the version
// of the file you want to comment on.
type InvalidFilePositionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFilePositionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFilePositionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFilePositionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidFilePositionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFilePositionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified value for the number of conflict files to return is not valid.
type InvalidMaxConflictFilesException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMaxConflictFilesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMaxConflictFilesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMaxConflictFilesException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidMaxConflictFilesException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMaxConflictFilesException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified value for the number of merge hunks to return is not valid.
type InvalidMaxMergeHunksException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMaxMergeHunksException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMaxMergeHunksException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMaxMergeHunksException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidMaxMergeHunksException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMaxMergeHunksException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified number of maximum results is not valid.
type InvalidMaxResultsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMaxResultsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMaxResultsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidMaxResultsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMaxResultsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified merge option is not valid for this operation. Not all merge
// strategies are supported for all operations.
type InvalidMergeOptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMergeOptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMergeOptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMergeOptionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidMergeOptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMergeOptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified sort order is not valid.
type InvalidOrderException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOrderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOrderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOrderException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidOrderException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOrderException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The override status is not valid. Valid statuses are OVERRIDE and REVOKE.
type InvalidOverrideStatusException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOverrideStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOverrideStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOverrideStatusException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidOverrideStatusException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOverrideStatusException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The parent commit ID is not valid. The commit ID cannot be empty, and must match
// the head commit ID for the branch of the repository where you want to add or
// update a file.
type InvalidParentCommitIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParentCommitIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParentCommitIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParentCommitIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidParentCommitIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParentCommitIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified path is not valid.
type InvalidPathException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPathException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPathException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPathException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidPathException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPathException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request event type is not valid.
type InvalidPullRequestEventTypeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPullRequestEventTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPullRequestEventTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPullRequestEventTypeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidPullRequestEventTypeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPullRequestEventTypeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The pull request ID is not valid. Make sure that you have provided the full ID
// and that the pull request is in the specified repository, and then try again.
type InvalidPullRequestIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPullRequestIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPullRequestIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPullRequestIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidPullRequestIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPullRequestIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request status is not valid. The only valid values are OPEN and CLOSED.
type InvalidPullRequestStatusException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPullRequestStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPullRequestStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPullRequestStatusException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidPullRequestStatusException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPullRequestStatusException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request status update is not valid. The only valid update is from OPEN
// to CLOSED.
type InvalidPullRequestStatusUpdateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPullRequestStatusUpdateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPullRequestStatusUpdateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPullRequestStatusUpdateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidPullRequestStatusUpdateException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPullRequestStatusUpdateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Amazon Resource Name (ARN) of the user or identity is not valid.
type InvalidReactionUserArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReactionUserArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReactionUserArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReactionUserArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidReactionUserArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReactionUserArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The value of the reaction is not valid. For more information, see the AWS
// CodeCommit User Guide
// (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html).
type InvalidReactionValueException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReactionValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReactionValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReactionValueException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidReactionValueException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReactionValueException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified reference name format is not valid. Reference names must conform
// to the Git references format (for example, refs/heads/master). For more
// information, see Git Internals - Git References
// (https://git-scm.com/book/en/v2/Git-Internals-Git-References) or consult your
// Git documentation.
type InvalidReferenceNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReferenceNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReferenceNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReferenceNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidReferenceNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReferenceNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Either the enum is not in a valid format, or the specified file version enum is
// not valid in respect to the current file version.
type InvalidRelativeFileVersionEnumException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRelativeFileVersionEnumException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRelativeFileVersionEnumException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRelativeFileVersionEnumException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRelativeFileVersionEnumException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRelativeFileVersionEnumException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Automerge was specified for resolving the conflict, but the replacement type is
// not valid or content is missing.
type InvalidReplacementContentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReplacementContentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReplacementContentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReplacementContentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidReplacementContentException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReplacementContentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Automerge was specified for resolving the conflict, but the specified
// replacement type is not valid.
type InvalidReplacementTypeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReplacementTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReplacementTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReplacementTypeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidReplacementTypeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReplacementTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified repository description is not valid.
type InvalidRepositoryDescriptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryDescriptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryDescriptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryDescriptionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryDescriptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryDescriptionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A specified repository name is not valid. This exception occurs only when a
// specified repository name is not valid. Other exceptions occur when a required
// repository parameter is missing, or when a specified repository does not exist.
type InvalidRepositoryNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more branch names specified for the trigger is not valid.
type InvalidRepositoryTriggerBranchNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryTriggerBranchNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryTriggerBranchNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryTriggerBranchNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryTriggerBranchNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryTriggerBranchNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The custom data provided for the trigger is not valid.
type InvalidRepositoryTriggerCustomDataException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryTriggerCustomDataException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryTriggerCustomDataException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryTriggerCustomDataException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryTriggerCustomDataException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryTriggerCustomDataException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Amazon Resource Name (ARN) for the trigger is not valid for the specified
// destination. The most common reason for this error is that the ARN does not meet
// the requirements for the service type.
type InvalidRepositoryTriggerDestinationArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryTriggerDestinationArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryTriggerDestinationArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryTriggerDestinationArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryTriggerDestinationArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryTriggerDestinationArnException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// One or more events specified for the trigger is not valid. Check to make sure
// that all events specified match the requirements for allowed events.
type InvalidRepositoryTriggerEventsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryTriggerEventsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryTriggerEventsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryTriggerEventsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryTriggerEventsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryTriggerEventsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The name of the trigger is not valid.
type InvalidRepositoryTriggerNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryTriggerNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryTriggerNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryTriggerNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryTriggerNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryTriggerNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The AWS Region for the trigger target does not match the AWS Region for the
// repository. Triggers must be created in the same Region as the target for the
// trigger.
type InvalidRepositoryTriggerRegionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRepositoryTriggerRegionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRepositoryTriggerRegionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRepositoryTriggerRegionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRepositoryTriggerRegionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRepositoryTriggerRegionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The value for the resource ARN is not valid. For more information about
// resources in AWS CodeCommit, see CodeCommit Resources and Operations
// (https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats)
// in the AWS CodeCommit User Guide.
type InvalidResourceArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidResourceArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResourceArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The revision ID is not valid. Use GetPullRequest to determine the value.
type InvalidRevisionIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRevisionIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRevisionIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRevisionIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRevisionIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRevisionIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The SHA-256 hash signature for the rule content is not valid.
type InvalidRuleContentSha256Exception struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRuleContentSha256Exception) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRuleContentSha256Exception) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRuleContentSha256Exception) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidRuleContentSha256Exception"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRuleContentSha256Exception) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified sort by value is not valid.
type InvalidSortByException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSortByException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSortByException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSortByException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidSortByException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSortByException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The source commit specifier is not valid. You must provide a valid branch name,
// tag, or full commit ID.
type InvalidSourceCommitSpecifierException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSourceCommitSpecifierException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSourceCommitSpecifierException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSourceCommitSpecifierException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidSourceCommitSpecifierException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSourceCommitSpecifierException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified tag is not valid. Key names cannot be prefixed with aws:.
type InvalidSystemTagUsageException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSystemTagUsageException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSystemTagUsageException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSystemTagUsageException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidSystemTagUsageException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSystemTagUsageException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The list of tags is not valid.
type InvalidTagKeysListException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTagKeysListException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagKeysListException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagKeysListException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTagKeysListException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTagKeysListException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The map of tags is not valid.
type InvalidTagsMapException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTagsMapException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagsMapException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagsMapException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTagsMapException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTagsMapException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified target branch is not valid.
type InvalidTargetBranchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetBranchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetBranchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetBranchException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTargetBranchException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTargetBranchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target for the pull request is not valid. A target must contain the full
// values for the repository name, source branch, and destination branch for the
// pull request.
type InvalidTargetException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTargetException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTargetException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The targets for the pull request is not valid or not in a valid format. Targets
// are a list of target objects. Each target object must contain the full values
// for the repository name, source branch, and destination branch for a pull
// request.
type InvalidTargetsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTargetsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTargetsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The title of the pull request is not valid. Pull request titles cannot exceed
// 100 characters in length.
type InvalidTitleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTitleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTitleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTitleException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTitleException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTitleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request cannot be merged automatically into the destination branch. You
// must manually merge the branches and resolve any conflicts.
type ManualMergeRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ManualMergeRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ManualMergeRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ManualMergeRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ManualMergeRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ManualMergeRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of branches for the trigger was exceeded.
type MaximumBranchesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumBranchesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumBranchesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumBranchesExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumBranchesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumBranchesExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of allowed conflict resolution entries was exceeded.
type MaximumConflictResolutionEntriesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumConflictResolutionEntriesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumConflictResolutionEntriesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumConflictResolutionEntriesExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumConflictResolutionEntriesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumConflictResolutionEntriesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of files to load exceeds the allowed limit.
type MaximumFileContentToLoadExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumFileContentToLoadExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumFileContentToLoadExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumFileContentToLoadExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumFileContentToLoadExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumFileContentToLoadExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of specified files to change as part of this commit exceeds the
// maximum number of files that can be changed in a single commit. Consider using a
// Git client for these changes.
type MaximumFileEntriesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumFileEntriesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumFileEntriesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumFileEntriesExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumFileEntriesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumFileEntriesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of items to compare between the source or destination branches and
// the merge base has exceeded the maximum allowed.
type MaximumItemsToCompareExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumItemsToCompareExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumItemsToCompareExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumItemsToCompareExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumItemsToCompareExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumItemsToCompareExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of approvals required for the approval rule exceeds the maximum
// number allowed.
type MaximumNumberOfApprovalsExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumNumberOfApprovalsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumNumberOfApprovalsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumNumberOfApprovalsExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumNumberOfApprovalsExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumNumberOfApprovalsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You cannot create the pull request because the repository has too many open pull
// requests. The maximum number of open pull requests for a repository is 1,000.
// Close one or more open pull requests, and then try again.
type MaximumOpenPullRequestsExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumOpenPullRequestsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumOpenPullRequestsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumOpenPullRequestsExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumOpenPullRequestsExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumOpenPullRequestsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of allowed repository names was exceeded. Currently, this
// number is 100.
type MaximumRepositoryNamesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumRepositoryNamesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumRepositoryNamesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumRepositoryNamesExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumRepositoryNamesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumRepositoryNamesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of triggers allowed for the repository was exceeded.
type MaximumRepositoryTriggersExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumRepositoryTriggersExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumRepositoryTriggersExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumRepositoryTriggersExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumRepositoryTriggersExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumRepositoryTriggersExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of approval rule templates for a repository has been
// exceeded. You cannot associate more than 25 approval rule templates with a
// repository.
type MaximumRuleTemplatesAssociatedWithRepositoryException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumRuleTemplatesAssociatedWithRepositoryException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumRuleTemplatesAssociatedWithRepositoryException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumRuleTemplatesAssociatedWithRepositoryException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumRuleTemplatesAssociatedWithRepositoryException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumRuleTemplatesAssociatedWithRepositoryException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A merge option or stategy is required, and none was provided.
type MergeOptionRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MergeOptionRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MergeOptionRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MergeOptionRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MergeOptionRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *MergeOptionRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// More than one conflict resolution entries exists for the conflict. A conflict
// can have only one conflict resolution entry.
type MultipleConflictResolutionEntriesException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MultipleConflictResolutionEntriesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MultipleConflictResolutionEntriesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MultipleConflictResolutionEntriesException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MultipleConflictResolutionEntriesException"
	}
	return *e.ErrorCodeOverride
}
func (e *MultipleConflictResolutionEntriesException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You cannot include more than one repository in a pull request. Make sure you
// have specified only one repository name in your request, and then try again.
type MultipleRepositoriesInPullRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MultipleRepositoriesInPullRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MultipleRepositoriesInPullRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MultipleRepositoriesInPullRequestException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MultipleRepositoriesInPullRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *MultipleRepositoriesInPullRequestException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The user name is not valid because it has exceeded the character limit for
// author names.
type NameLengthExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NameLengthExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NameLengthExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NameLengthExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NameLengthExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *NameLengthExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because no changes will be made to the repository
// as a result of this commit. A commit must contain at least one change.
type NoChangeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoChangeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoChangeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoChangeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NoChangeException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoChangeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The approval rule cannot be added. The pull request has the maximum number of
// approval rules associated with it.
type NumberOfRulesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NumberOfRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NumberOfRulesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NumberOfRulesExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NumberOfRulesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *NumberOfRulesExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of approval rule templates has been exceeded for this AWS
// Region.
type NumberOfRuleTemplatesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NumberOfRuleTemplatesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NumberOfRuleTemplatesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NumberOfRuleTemplatesExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NumberOfRuleTemplatesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *NumberOfRuleTemplatesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The pull request has already had its approval rules set to override.
type OverrideAlreadySetException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OverrideAlreadySetException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OverrideAlreadySetException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OverrideAlreadySetException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "OverrideAlreadySetException"
	}
	return *e.ErrorCodeOverride
}
func (e *OverrideAlreadySetException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An override status is required, but no value was provided. Valid values include
// OVERRIDE and REVOKE.
type OverrideStatusRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OverrideStatusRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OverrideStatusRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OverrideStatusRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "OverrideStatusRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *OverrideStatusRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The parent commit ID is not valid because it does not exist. The specified
// parent commit ID does not exist in the specified branch of the repository.
type ParentCommitDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParentCommitDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParentCommitDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParentCommitDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ParentCommitDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *ParentCommitDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The file could not be added because the provided parent commit ID is not the
// current tip of the specified branch. To view the full commit ID of the current
// head of the branch, use GetBranch.
type ParentCommitIdOutdatedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParentCommitIdOutdatedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParentCommitIdOutdatedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParentCommitIdOutdatedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ParentCommitIdOutdatedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ParentCommitIdOutdatedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A parent commit ID is required. To view the full commit ID of a branch in a
// repository, use GetBranch or a Git command (for example, git pull or git log).
type ParentCommitIdRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParentCommitIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParentCommitIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParentCommitIdRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ParentCommitIdRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ParentCommitIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified path does not exist.
type PathDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PathDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PathDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PathDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PathDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *PathDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The folderPath for a location cannot be null.
type PathRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PathRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PathRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PathRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PathRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *PathRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request status cannot be updated because it is already closed.
type PullRequestAlreadyClosedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PullRequestAlreadyClosedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PullRequestAlreadyClosedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PullRequestAlreadyClosedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PullRequestAlreadyClosedException"
	}
	return *e.ErrorCodeOverride
}
func (e *PullRequestAlreadyClosedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pull request cannot be merged because one or more approval rules applied to
// the pull request have conditions that have not been met.
type PullRequestApprovalRulesNotSatisfiedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PullRequestApprovalRulesNotSatisfiedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PullRequestApprovalRulesNotSatisfiedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PullRequestApprovalRulesNotSatisfiedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PullRequestApprovalRulesNotSatisfiedException"
	}
	return *e.ErrorCodeOverride
}
func (e *PullRequestApprovalRulesNotSatisfiedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The approval cannot be applied because the user approving the pull request
// matches the user who created the pull request. You cannot approve a pull request
// that you created.
type PullRequestCannotBeApprovedByAuthorException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PullRequestCannotBeApprovedByAuthorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PullRequestCannotBeApprovedByAuthorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PullRequestCannotBeApprovedByAuthorException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PullRequestCannotBeApprovedByAuthorException"
	}
	return *e.ErrorCodeOverride
}
func (e *PullRequestCannotBeApprovedByAuthorException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The pull request ID could not be found. Make sure that you have specified the
// correct repository name and pull request ID, and then try again.
type PullRequestDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PullRequestDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PullRequestDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PullRequestDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PullRequestDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *PullRequestDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A pull request ID is required, but none was provided.
type PullRequestIdRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PullRequestIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PullRequestIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PullRequestIdRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PullRequestIdRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *PullRequestIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A pull request status is required, but none was provided.
type PullRequestStatusRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PullRequestStatusRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PullRequestStatusRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PullRequestStatusRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PullRequestStatusRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *PullRequestStatusRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The commit cannot be created because one or more files specified in the commit
// reference both a file and a folder.
type PutFileEntryConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PutFileEntryConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PutFileEntryConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PutFileEntryConflictException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PutFileEntryConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *PutFileEntryConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of reactions has been exceeded. Reactions are limited to one reaction
// per user for each individual comment ID.
type ReactionLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReactionLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReactionLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReactionLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReactionLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReactionLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A reaction value is required.
type ReactionValueRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReactionValueRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReactionValueRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReactionValueRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReactionValueRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReactionValueRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified reference does not exist. You must provide a full commit ID.
type ReferenceDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReferenceDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReferenceDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReferenceDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReferenceDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReferenceDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A reference name is required, but none was provided.
type ReferenceNameRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReferenceNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReferenceNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReferenceNameRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReferenceNameRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReferenceNameRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified reference is not a supported type.
type ReferenceTypeNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReferenceTypeNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReferenceTypeNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReferenceTypeNotSupportedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReferenceTypeNotSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReferenceTypeNotSupportedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// USE_NEW_CONTENT was specified, but no replacement content has been provided.
type ReplacementContentRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplacementContentRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplacementContentRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplacementContentRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReplacementContentRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplacementContentRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A replacement type is required.
type ReplacementTypeRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplacementTypeRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplacementTypeRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplacementTypeRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReplacementTypeRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplacementTypeRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified repository does not exist.
type RepositoryDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A repository resource limit was exceeded.
type RepositoryLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified repository name already exists.
type RepositoryNameExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryNameExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryNameExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryNameExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryNameExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryNameExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A repository name is required, but was not specified.
type RepositoryNameRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryNameRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryNameRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryNameRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// At least one repository name object is required, but was not specified.
type RepositoryNamesRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryNamesRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryNamesRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryNamesRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryNamesRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryNamesRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The repository does not contain any pull requests with that pull request ID. Use
// GetPullRequest to verify the correct repository name for the pull request ID.
type RepositoryNotAssociatedWithPullRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryNotAssociatedWithPullRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryNotAssociatedWithPullRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryNotAssociatedWithPullRequestException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryNotAssociatedWithPullRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryNotAssociatedWithPullRequestException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// At least one branch name is required, but was not specified in the trigger
// configuration.
type RepositoryTriggerBranchNameListRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryTriggerBranchNameListRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryTriggerBranchNameListRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryTriggerBranchNameListRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryTriggerBranchNameListRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryTriggerBranchNameListRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A destination ARN for the target service for the trigger is required, but was
// not specified.
type RepositoryTriggerDestinationArnRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryTriggerDestinationArnRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryTriggerDestinationArnRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryTriggerDestinationArnRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryTriggerDestinationArnRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryTriggerDestinationArnRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// At least one event for the trigger is required, but was not specified.
type RepositoryTriggerEventsListRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryTriggerEventsListRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryTriggerEventsListRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryTriggerEventsListRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryTriggerEventsListRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryTriggerEventsListRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A name for the trigger is required, but was not specified.
type RepositoryTriggerNameRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryTriggerNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryTriggerNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryTriggerNameRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryTriggerNameRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryTriggerNameRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The list of triggers for the repository is required, but was not specified.
type RepositoryTriggersListRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RepositoryTriggersListRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RepositoryTriggersListRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RepositoryTriggersListRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RepositoryTriggersListRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RepositoryTriggersListRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required.
// For a list of valid resources in AWS CodeCommit, see CodeCommit Resources and
// Operations
// (https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats)
// in the AWS CodeCommit User Guide.
type ResourceArnRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceArnRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceArnRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceArnRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ResourceArnRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceArnRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because one of the changes specifies copying or
// moving a .gitkeep file.
type RestrictedSourceFileException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RestrictedSourceFileException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RestrictedSourceFileException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RestrictedSourceFileException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RestrictedSourceFileException"
	}
	return *e.ErrorCodeOverride
}
func (e *RestrictedSourceFileException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A revision ID is required, but was not provided.
type RevisionIdRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RevisionIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RevisionIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RevisionIdRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RevisionIdRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *RevisionIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The revision ID provided in the request does not match the current revision ID.
// Use GetPullRequest to retrieve the current revision ID.
type RevisionNotCurrentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RevisionNotCurrentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RevisionNotCurrentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RevisionNotCurrentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "RevisionNotCurrentException"
	}
	return *e.ErrorCodeOverride
}
func (e *RevisionNotCurrentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The file was not added or updated because the content of the file is exactly the
// same as the content of that file in the repository and branch that you
// specified.
type SameFileContentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SameFileContentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SameFileContentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SameFileContentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "SameFileContentException"
	}
	return *e.ErrorCodeOverride
}
func (e *SameFileContentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The commit cannot be created because one or more changes in this commit
// duplicate actions in the same file path. For example, you cannot make the same
// delete request to the same file in the same file path twice, or make a delete
// request and a move request to the same file as part of the same commit.
type SamePathRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SamePathRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SamePathRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SamePathRequestException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "SamePathRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *SamePathRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The source branch and destination branch for the pull request are the same. You
// must specify different branches for the source and destination.
type SourceAndDestinationAreSameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceAndDestinationAreSameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceAndDestinationAreSameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceAndDestinationAreSameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "SourceAndDestinationAreSameException"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceAndDestinationAreSameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The commit cannot be created because no source files or file content have been
// specified for the commit.
type SourceFileOrContentRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceFileOrContentRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceFileOrContentRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceFileOrContentRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "SourceFileOrContentRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceFileOrContentRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A list of tag keys is required. The list cannot be empty or null.
type TagKeysListRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagKeysListRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagKeysListRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagKeysListRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TagKeysListRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagKeysListRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tag policy is not valid.
type TagPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagPolicyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TagPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagPolicyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A map of tags is required.
type TagsMapRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagsMapRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagsMapRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagsMapRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TagsMapRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagsMapRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A pull request target is required. It cannot be empty or null. A pull request
// target must contain the full values for the repository name, source branch, and
// destination branch for the pull request.
type TargetRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TargetRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TargetRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TargetRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TargetRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *TargetRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An array of target objects is required. It cannot be empty or null.
type TargetsRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TargetsRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TargetsRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TargetsRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TargetsRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *TargetsRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tip of the source branch in the destination repository does not match the
// tip of the source branch specified in your request. The pull request might have
// been updated. Make sure that you have the latest changes.
type TipOfSourceReferenceIsDifferentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TipOfSourceReferenceIsDifferentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TipOfSourceReferenceIsDifferentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TipOfSourceReferenceIsDifferentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TipOfSourceReferenceIsDifferentException"
	}
	return *e.ErrorCodeOverride
}
func (e *TipOfSourceReferenceIsDifferentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The divergence between the tips of the provided commit specifiers is too great
// to determine whether there might be any merge conflicts. Locally compare the
// specifiers using git diff or a diff tool.
type TipsDivergenceExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TipsDivergenceExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TipsDivergenceExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TipsDivergenceExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TipsDivergenceExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *TipsDivergenceExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A pull request title is required. It cannot be empty or null.
type TitleRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TitleRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TitleRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TitleRequiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TitleRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *TitleRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of tags for an AWS CodeCommit resource has been exceeded.
type TooManyTagsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TooManyTagsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
