// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// This exception is thrown when you start a new import and a previous import is
// still in progress.
type AccountHasOngoingImportException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountHasOngoingImportException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountHasOngoingImportException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountHasOngoingImportException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "AccountHasOngoingImportException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountHasOngoingImportException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified account is not found or not part of
// an organization.
type AccountNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "AccountNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified account is not registered as the
// CloudTrail delegated administrator.
type AccountNotRegisteredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountNotRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountNotRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountNotRegisteredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "AccountNotRegisteredException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountNotRegisteredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the account is already registered as the
// CloudTrail delegated administrator.
type AccountRegisteredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountRegisteredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "AccountRegisteredException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountRegisteredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the management account of an organization is
// registered as the CloudTrail delegated administrator.
type CannotDelegateManagementAccountException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CannotDelegateManagementAccountException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CannotDelegateManagementAccountException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CannotDelegateManagementAccountException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CannotDelegateManagementAccountException"
	}
	return *e.ErrorCodeOverride
}
func (e *CannotDelegateManagementAccountException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the provided channel already exists.
type ChannelAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelAlreadyExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified value of ChannelARN is not valid.
type ChannelARNInvalidException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelARNInvalidException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelARNInvalidException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelARNInvalidException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelARNInvalidException"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelARNInvalidException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified event data store cannot yet be
// deleted because it is in use by a channel.
type ChannelExistsForEDSException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelExistsForEDSException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelExistsForEDSException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelExistsForEDSException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelExistsForEDSException"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelExistsForEDSException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the maximum number of channels limit is exceeded.
type ChannelMaxLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelMaxLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelMaxLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelMaxLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelMaxLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelMaxLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when CloudTrail cannot find the specified channel.
type ChannelNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when trusted access has not been enabled between
// CloudTrail and Organizations. For more information, see Enabling Trusted Access
// with Other Amazon Web Services Services
// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
// and Prepare For Creating a Trail For Your Organization
// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
type CloudTrailAccessNotEnabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudTrailAccessNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudTrailAccessNotEnabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudTrailAccessNotEnabledException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CloudTrailAccessNotEnabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudTrailAccessNotEnabledException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when an operation is called with a trail ARN that is
// not valid. The following is the format of a trail ARN.
// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail This exception is also
// thrown when you call AddTags or RemoveTags on a trail, event data store, or
// channel with a resource ARN that is not valid. The following is the format of an
// event data store ARN:
// arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE
// The following is the format of a channel ARN:
// arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890
type CloudTrailARNInvalidException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudTrailARNInvalidException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudTrailARNInvalidException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudTrailARNInvalidException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CloudTrailARNInvalidException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudTrailARNInvalidException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when a call results in the InvalidClientTokenId error
// code. This can occur when you are creating or updating a trail to send
// notifications to an Amazon SNS topic that is in a suspended Amazon Web Services
// account.
type CloudTrailInvalidClientTokenIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudTrailInvalidClientTokenIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudTrailInvalidClientTokenIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudTrailInvalidClientTokenIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CloudTrailInvalidClientTokenIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudTrailInvalidClientTokenIdException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Cannot set a CloudWatch Logs delivery for this region.
type CloudWatchLogsDeliveryUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudWatchLogsDeliveryUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudWatchLogsDeliveryUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudWatchLogsDeliveryUnavailableException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "CloudWatchLogsDeliveryUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudWatchLogsDeliveryUnavailableException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the specified resource is not ready for an
// operation. This can occur when you try to run an operation on a resource before
// CloudTrail has time to fully load the resource, or because another operation is
// modifying the resource. If this exception occurs, wait a few minutes, and then
// try the operation again.
type ConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConflictException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the maximum number of CloudTrail delegated
// administrators is reached.
type DelegatedAdminAccountLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DelegatedAdminAccountLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DelegatedAdminAccountLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DelegatedAdminAccountLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DelegatedAdminAccountLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *DelegatedAdminAccountLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An event data store with that name already exists.
type EventDataStoreAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventDataStoreAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventDataStoreAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventDataStoreAlreadyExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EventDataStoreAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *EventDataStoreAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified event data store ARN is not valid or does not map to an event data
// store in your account.
type EventDataStoreARNInvalidException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventDataStoreARNInvalidException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventDataStoreARNInvalidException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventDataStoreARNInvalidException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EventDataStoreARNInvalidException"
	}
	return *e.ErrorCodeOverride
}
func (e *EventDataStoreARNInvalidException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when you try to update or delete an event data store
// that currently has an import in progress.
type EventDataStoreHasOngoingImportException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventDataStoreHasOngoingImportException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventDataStoreHasOngoingImportException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventDataStoreHasOngoingImportException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EventDataStoreHasOngoingImportException"
	}
	return *e.ErrorCodeOverride
}
func (e *EventDataStoreHasOngoingImportException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your account has used the maximum number of event data stores.
type EventDataStoreMaxLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventDataStoreMaxLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventDataStoreMaxLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventDataStoreMaxLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EventDataStoreMaxLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *EventDataStoreMaxLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified event data store was not found.
type EventDataStoreNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventDataStoreNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventDataStoreNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventDataStoreNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EventDataStoreNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *EventDataStoreNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The event data store cannot be deleted because termination protection is enabled
// for it.
type EventDataStoreTerminationProtectedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventDataStoreTerminationProtectedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventDataStoreTerminationProtectedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventDataStoreTerminationProtectedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EventDataStoreTerminationProtectedException"
	}
	return *e.ErrorCodeOverride
}
func (e *EventDataStoreTerminationProtectedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified import was not found.
type ImportNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ImportNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ImportNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ImportNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ImportNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ImportNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The event data store is inactive.
type InactiveEventDataStoreException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InactiveEventDataStoreException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InactiveEventDataStoreException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InactiveEventDataStoreException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InactiveEventDataStoreException"
	}
	return *e.ErrorCodeOverride
}
func (e *InactiveEventDataStoreException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified query cannot be canceled because it is in the FINISHED, FAILED,
// TIMED_OUT, or CANCELLED state.
type InactiveQueryException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InactiveQueryException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InactiveQueryException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InactiveQueryException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InactiveQueryException"
	}
	return *e.ErrorCodeOverride
}
func (e *InactiveQueryException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// If you run GetInsightSelectors on a trail that does not have Insights events
// enabled, the operation throws the exception InsightNotEnabledException.
type InsightNotEnabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsightNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsightNotEnabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsightNotEnabledException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InsightNotEnabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsightNotEnabledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the IAM user or role that is used to create the
// organization resource lacks one or more required permissions for creating an
// organization resource in a required service.
type InsufficientDependencyServiceAccessPermissionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientDependencyServiceAccessPermissionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientDependencyServiceAccessPermissionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientDependencyServiceAccessPermissionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InsufficientDependencyServiceAccessPermissionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientDependencyServiceAccessPermissionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the policy on the S3 bucket or KMS key does not
// have sufficient permissions for the operation.
type InsufficientEncryptionPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientEncryptionPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientEncryptionPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientEncryptionPolicyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InsufficientEncryptionPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientEncryptionPolicyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the policy on the S3 bucket is not sufficient.
type InsufficientS3BucketPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientS3BucketPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientS3BucketPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientS3BucketPolicyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InsufficientS3BucketPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientS3BucketPolicyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the policy on the Amazon SNS topic is not
// sufficient.
type InsufficientSnsTopicPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientSnsTopicPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientSnsTopicPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientSnsTopicPolicyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InsufficientSnsTopicPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientSnsTopicPolicyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the provided CloudWatch Logs log group is not
// valid.
type InvalidCloudWatchLogsLogGroupArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCloudWatchLogsLogGroupArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCloudWatchLogsLogGroupArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCloudWatchLogsLogGroupArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidCloudWatchLogsLogGroupArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCloudWatchLogsLogGroupArnException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the provided role is not valid.
type InvalidCloudWatchLogsRoleArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCloudWatchLogsRoleArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCloudWatchLogsRoleArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCloudWatchLogsRoleArnException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidCloudWatchLogsRoleArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCloudWatchLogsRoleArnException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A date range for the query was specified that is not valid. Be sure that the
// start time is chronologically before the end time. For more information about
// writing a query, see Create or edit a query
// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html)
// in the CloudTrail User Guide.
type InvalidDateRangeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDateRangeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDateRangeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDateRangeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidDateRangeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDateRangeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Occurs if an event category that is not valid is specified as a value of
// EventCategory.
type InvalidEventCategoryException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEventCategoryException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEventCategoryException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEventCategoryException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidEventCategoryException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEventCategoryException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when event categories of specified event data stores
// are not valid.
type InvalidEventDataStoreCategoryException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEventDataStoreCategoryException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEventDataStoreCategoryException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEventDataStoreCategoryException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidEventDataStoreCategoryException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEventDataStoreCategoryException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The event data store is not in a status that supports the operation.
type InvalidEventDataStoreStatusException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEventDataStoreStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEventDataStoreStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEventDataStoreStatusException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidEventDataStoreStatusException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEventDataStoreStatusException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the PutEventSelectors operation is called with a
// number of event selectors, advanced event selectors, or data resources that is
// not valid. The combination of event selectors or advanced event selectors and
// data resources is not valid. A trail can have up to 5 event selectors. If a
// trail uses advanced event selectors, a maximum of 500 total values for all
// conditions in all advanced event selectors is allowed. A trail is limited to 250
// data resources. These data resources can be distributed across event selectors,
// but the overall total cannot exceed 250. You can:
//
// * Specify a valid number of
// event selectors (1 to 5) for a trail.
//
// * Specify a valid number of data
// resources (1 to 250) for an event selector. The limit of number of resources on
// an individual event selector is configurable up to 250. However, this upper
// limit is allowed only if the total number of data resources does not exceed 250
// across all event selectors for a trail.
//
// * Specify up to 500 values for all
// conditions in all advanced event selectors for a trail.
//
// * Specify a valid value
// for a parameter. For example, specifying the ReadWriteType parameter with a
// value of read-only is not valid.
type InvalidEventSelectorsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEventSelectorsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEventSelectorsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEventSelectorsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidEventSelectorsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEventSelectorsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when an operation is called on a trail from a region
// other than the region in which the trail was created.
type InvalidHomeRegionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidHomeRegionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidHomeRegionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidHomeRegionException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidHomeRegionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidHomeRegionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the provided source S3 bucket is not valid for
// import.
type InvalidImportSourceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidImportSourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidImportSourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidImportSourceException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidImportSourceException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidImportSourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The formatting or syntax of the InsightSelectors JSON statement in your
// PutInsightSelectors or GetInsightSelectors request is not valid, or the
// specified insight type in the InsightSelectors statement is not a valid insight
// type.
type InvalidInsightSelectorsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInsightSelectorsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInsightSelectorsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInsightSelectorsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidInsightSelectorsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInsightSelectorsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the KMS key ARN is not valid.
type InvalidKmsKeyIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidKmsKeyIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidKmsKeyIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidKmsKeyIdException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidKmsKeyIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidKmsKeyIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Occurs when a lookup attribute is specified that is not valid.
type InvalidLookupAttributesException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidLookupAttributesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLookupAttributesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLookupAttributesException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidLookupAttributesException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidLookupAttributesException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown if the limit specified is not valid.
type InvalidMaxResultsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMaxResultsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMaxResultsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidMaxResultsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMaxResultsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A token that is not valid, or a token that was previously used in a request with
// different parameters. This exception is thrown if the token is not valid.
type InvalidNextTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidNextTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the combination of parameters provided is not
// valid.
type InvalidParameterCombinationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterCombinationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterCombinationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidParameterCombinationException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterCombinationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request includes a parameter that is not valid.
type InvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The query that was submitted has validation errors, or uses incorrect syntax or
// unsupported keywords. For more information about writing a query, see Create or
// edit a query
// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html)
// in the CloudTrail User Guide.
type InvalidQueryStatementException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidQueryStatementException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidQueryStatementException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidQueryStatementException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidQueryStatementException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidQueryStatementException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The query status is not valid for the operation.
type InvalidQueryStatusException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidQueryStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidQueryStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidQueryStatusException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidQueryStatusException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidQueryStatusException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the provided S3 bucket name is not valid.
type InvalidS3BucketNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3BucketNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3BucketNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3BucketNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidS3BucketNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3BucketNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the provided S3 prefix is not valid.
type InvalidS3PrefixException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3PrefixException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3PrefixException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3PrefixException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidS3PrefixException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3PrefixException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the provided SNS topic name is not valid.
type InvalidSnsTopicNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSnsTopicNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSnsTopicNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSnsTopicNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidSnsTopicNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSnsTopicNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified value of Source is not valid.
type InvalidSourceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSourceException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidSourceException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified tag key or values are not valid. It
// can also occur if there are duplicate tags or too many tags on the resource.
type InvalidTagParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTagParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagParameterException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTagParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTagParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Occurs if the timestamp values are not valid. Either the start time occurs after
// the end time, or the time range is outside the range of possible values.
type InvalidTimeRangeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTimeRangeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTimeRangeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTimeRangeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTimeRangeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Reserved for future use.
type InvalidTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTokenException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the provided trail name is not valid. Trail names
// must meet the following requirements:
//
// * Contain only ASCII letters (a-z, A-Z),
// numbers (0-9), periods (.), underscores (_), or dashes (-)
//
// * Start with a
// letter or number, and end with a letter or number
//
// * Be between 3 and 128
// characters
//
// * Have no adjacent periods, underscores or dashes. Names like
// my-_namespace and my--namespace are not valid.
//
// * Not be in IP address format
// (for example, 192.168.5.4)
type InvalidTrailNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTrailNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTrailNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTrailNameException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidTrailNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTrailNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when there is an issue with the specified KMS key and
// the trail or event data store can't be updated.
type KmsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KmsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KmsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KmsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "KmsException"
	}
	return *e.ErrorCodeOverride
}
func (e *KmsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is no longer in use.
type KmsKeyDisabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KmsKeyDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KmsKeyDisabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KmsKeyDisabledException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "KmsKeyDisabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *KmsKeyDisabledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the KMS key does not exist, when the S3 bucket and
// the KMS key are not in the same region, or when the KMS key associated with the
// Amazon SNS topic either does not exist or is not in the same region.
type KmsKeyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KmsKeyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KmsKeyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KmsKeyNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "KmsKeyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *KmsKeyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You are already running the maximum number of concurrent queries. Wait a minute
// for some queries to finish, and then run the query again.
type MaxConcurrentQueriesException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxConcurrentQueriesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxConcurrentQueriesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxConcurrentQueriesException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaxConcurrentQueriesException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxConcurrentQueriesException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the maximum number of trails is reached.
type MaximumNumberOfTrailsExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaximumNumberOfTrailsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaximumNumberOfTrailsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaximumNumberOfTrailsExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MaximumNumberOfTrailsExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaximumNumberOfTrailsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the management account does not have a
// service-linked role.
type NoManagementAccountSLRExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoManagementAccountSLRExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoManagementAccountSLRExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoManagementAccountSLRExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NoManagementAccountSLRExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoManagementAccountSLRExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the account making the request is not the
// organization's management account.
type NotOrganizationManagementAccountException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NotOrganizationManagementAccountException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotOrganizationManagementAccountException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotOrganizationManagementAccountException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NotOrganizationManagementAccountException"
	}
	return *e.ErrorCodeOverride
}
func (e *NotOrganizationManagementAccountException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the Amazon Web Services account making the request
// to create or update an organization trail or event data store is not the
// management account for an organization in Organizations. For more information,
// see Prepare For Creating a Trail For Your Organization
// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html)
// or Create an event data store
// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html).
type NotOrganizationMasterAccountException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NotOrganizationMasterAccountException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotOrganizationMasterAccountException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotOrganizationMasterAccountException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NotOrganizationMasterAccountException"
	}
	return *e.ErrorCodeOverride
}
func (e *NotOrganizationMasterAccountException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the requested operation is not permitted.
type OperationNotPermittedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotPermittedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotPermittedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "OperationNotPermittedException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationNotPermittedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when Organizations is not configured to support all
// features. All features must be enabled in Organizations to support creating an
// organization trail or event data store.
type OrganizationNotInAllFeaturesModeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationNotInAllFeaturesModeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationNotInAllFeaturesModeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationNotInAllFeaturesModeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "OrganizationNotInAllFeaturesModeException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationNotInAllFeaturesModeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the request is made from an Amazon Web Services
// account that is not a member of an organization. To make this request, sign in
// using the credentials of an account that belongs to an organization.
type OrganizationsNotInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationsNotInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationsNotInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationsNotInUseException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "OrganizationsNotInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationsNotInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The query ID does not exist or does not map to a query.
type QueryIdNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *QueryIdNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *QueryIdNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *QueryIdNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "QueryIdNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *QueryIdNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the provided resource does not exist, or the ARN
// format of the resource is not valid. The following is the valid format for a
// resource ARN: arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel.
type ResourceARNNotValidException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceARNNotValidException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceARNNotValidException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceARNNotValidException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ResourceARNNotValidException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceARNNotValidException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified resource is not found.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified resource policy is not found.
type ResourcePolicyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ResourcePolicyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the resouce-based policy has syntax errors, or
// contains a principal that is not valid. The following are requirements for the
// resource policy:
//
// * Contains only one action: cloudtrail-data:PutAuditEvents
//
// *
// Contains at least one statement. The policy can have a maximum of 20
// statements.
//
// * Each statement contains at least one principal. A statement can
// have a maximum of 50 principals.
type ResourcePolicyNotValidException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyNotValidException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyNotValidException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyNotValidException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ResourcePolicyNotValidException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyNotValidException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified resource type is not supported by
// CloudTrail.
type ResourceTypeNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceTypeNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceTypeNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceTypeNotSupportedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ResourceTypeNotSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceTypeNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified S3 bucket does not exist.
type S3BucketDoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *S3BucketDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *S3BucketDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *S3BucketDoesNotExistException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "S3BucketDoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *S3BucketDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of tags per trail, event data store, or channel has exceeded the
// permitted amount. Currently, the limit is 50.
type TagsLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagsLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagsLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TagsLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagsLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the specified trail already exists.
type TrailAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TrailAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrailAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrailAlreadyExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TrailAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TrailAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the trail with the given name is not found.
type TrailNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TrailNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrailNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrailNotFoundException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TrailNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *TrailNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is no longer in use.
type TrailNotProvidedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TrailNotProvidedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrailNotProvidedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrailNotProvidedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "TrailNotProvidedException"
	}
	return *e.ErrorCodeOverride
}
func (e *TrailNotProvidedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is thrown when the requested operation is not supported.
type UnsupportedOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "UnsupportedOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
