// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new configured table resource.
func (c *Client) CreateConfiguredTable(ctx context.Context, params *CreateConfiguredTableInput, optFns ...func(*Options)) (*CreateConfiguredTableOutput, error) {
	if params == nil {
		params = &CreateConfiguredTableInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateConfiguredTable", params, optFns, c.addOperationCreateConfiguredTableMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateConfiguredTableOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateConfiguredTableInput struct {

	// The columns of the underlying table that can be used by collaborations or
	// analysis rules.
	//
	// This member is required.
	AllowedColumns []string

	// The analysis method for the configured tables. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// This member is required.
	AnalysisMethod types.AnalysisMethod

	// The name of the configured table.
	//
	// This member is required.
	Name *string

	// A reference to the AWS Glue table being configured.
	//
	// This member is required.
	TableReference types.TableReference

	// A description for the configured table.
	Description *string

	noSmithyDocumentSerde
}

type CreateConfiguredTableOutput struct {

	// The created configured table.
	//
	// This member is required.
	ConfiguredTable *types.ConfiguredTable

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateConfiguredTableMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateConfiguredTable{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateConfiguredTable{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateConfiguredTableValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateConfiguredTable(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateConfiguredTable(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cleanrooms",
		OperationName: "CreateConfiguredTable",
	}
}
