// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all channels associated with a specified channel flow. You can associate a
// channel flow with multiple channels, but you can only associate a channel with
// one channel flow. This is a developer API.
func (c *Client) ListChannelsAssociatedWithChannelFlow(ctx context.Context, params *ListChannelsAssociatedWithChannelFlowInput, optFns ...func(*Options)) (*ListChannelsAssociatedWithChannelFlowOutput, error) {
	if params == nil {
		params = &ListChannelsAssociatedWithChannelFlowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChannelsAssociatedWithChannelFlow", params, optFns, c.addOperationListChannelsAssociatedWithChannelFlowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChannelsAssociatedWithChannelFlowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChannelsAssociatedWithChannelFlowInput struct {

	// The ARN of the channel flow.
	//
	// This member is required.
	ChannelFlowArn *string

	// The maximum number of channels that you want to return.
	MaxResults *int32

	// The token passed by previous API calls until all requested channels are
	// returned.
	NextToken *string

	noSmithyDocumentSerde
}

type ListChannelsAssociatedWithChannelFlowOutput struct {

	// The information about each channel.
	Channels []types.ChannelAssociatedWithFlowSummary

	// The token passed by previous API calls until all requested channels are
	// returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChannelsAssociatedWithChannelFlowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChannelsAssociatedWithChannelFlow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChannelsAssociatedWithChannelFlow{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListChannelsAssociatedWithChannelFlowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChannelsAssociatedWithChannelFlow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListChannelsAssociatedWithChannelFlowAPIClient is a client that implements the
// ListChannelsAssociatedWithChannelFlow operation.
type ListChannelsAssociatedWithChannelFlowAPIClient interface {
	ListChannelsAssociatedWithChannelFlow(context.Context, *ListChannelsAssociatedWithChannelFlowInput, ...func(*Options)) (*ListChannelsAssociatedWithChannelFlowOutput, error)
}

var _ ListChannelsAssociatedWithChannelFlowAPIClient = (*Client)(nil)

// ListChannelsAssociatedWithChannelFlowPaginatorOptions is the paginator options
// for ListChannelsAssociatedWithChannelFlow
type ListChannelsAssociatedWithChannelFlowPaginatorOptions struct {
	// The maximum number of channels that you want to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChannelsAssociatedWithChannelFlowPaginator is a paginator for
// ListChannelsAssociatedWithChannelFlow
type ListChannelsAssociatedWithChannelFlowPaginator struct {
	options   ListChannelsAssociatedWithChannelFlowPaginatorOptions
	client    ListChannelsAssociatedWithChannelFlowAPIClient
	params    *ListChannelsAssociatedWithChannelFlowInput
	nextToken *string
	firstPage bool
}

// NewListChannelsAssociatedWithChannelFlowPaginator returns a new
// ListChannelsAssociatedWithChannelFlowPaginator
func NewListChannelsAssociatedWithChannelFlowPaginator(client ListChannelsAssociatedWithChannelFlowAPIClient, params *ListChannelsAssociatedWithChannelFlowInput, optFns ...func(*ListChannelsAssociatedWithChannelFlowPaginatorOptions)) *ListChannelsAssociatedWithChannelFlowPaginator {
	if params == nil {
		params = &ListChannelsAssociatedWithChannelFlowInput{}
	}

	options := ListChannelsAssociatedWithChannelFlowPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChannelsAssociatedWithChannelFlowPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChannelsAssociatedWithChannelFlowPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChannelsAssociatedWithChannelFlow page.
func (p *ListChannelsAssociatedWithChannelFlowPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChannelsAssociatedWithChannelFlowOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListChannelsAssociatedWithChannelFlow(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListChannelsAssociatedWithChannelFlow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "chime",
		OperationName: "ListChannelsAssociatedWithChannelFlow",
	}
}
