// Code generated by smithy-go-codegen DO NOT EDIT.

package appflow

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appflow/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateConnectorProfile struct {
}

func (*awsRestjson1_serializeOpCreateConnectorProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConnectorProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConnectorProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/create-connector-profile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConnectorProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConnectorProfileInput(v *CreateConnectorProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConnectorProfileInput(v *CreateConnectorProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConnectionMode) > 0 {
		ok := object.Key("connectionMode")
		ok.String(string(v.ConnectionMode))
	}

	if v.ConnectorLabel != nil {
		ok := object.Key("connectorLabel")
		ok.String(*v.ConnectorLabel)
	}

	if v.ConnectorProfileConfig != nil {
		ok := object.Key("connectorProfileConfig")
		if err := awsRestjson1_serializeDocumentConnectorProfileConfig(v.ConnectorProfileConfig, ok); err != nil {
			return err
		}
	}

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	if v.KmsArn != nil {
		ok := object.Key("kmsArn")
		ok.String(*v.KmsArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateFlow struct {
}

func (*awsRestjson1_serializeOpCreateFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/create-flow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFlowInput(v *CreateFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFlowInput(v *CreateFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DestinationFlowConfigList != nil {
		ok := object.Key("destinationFlowConfigList")
		if err := awsRestjson1_serializeDocumentDestinationFlowConfigList(v.DestinationFlowConfigList, ok); err != nil {
			return err
		}
	}

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	if v.KmsArn != nil {
		ok := object.Key("kmsArn")
		ok.String(*v.KmsArn)
	}

	if v.MetadataCatalogConfig != nil {
		ok := object.Key("metadataCatalogConfig")
		if err := awsRestjson1_serializeDocumentMetadataCatalogConfig(v.MetadataCatalogConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceFlowConfig != nil {
		ok := object.Key("sourceFlowConfig")
		if err := awsRestjson1_serializeDocumentSourceFlowConfig(v.SourceFlowConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Tasks != nil {
		ok := object.Key("tasks")
		if err := awsRestjson1_serializeDocumentTasks(v.Tasks, ok); err != nil {
			return err
		}
	}

	if v.TriggerConfig != nil {
		ok := object.Key("triggerConfig")
		if err := awsRestjson1_serializeDocumentTriggerConfig(v.TriggerConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConnectorProfile struct {
}

func (*awsRestjson1_serializeOpDeleteConnectorProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConnectorProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConnectorProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/delete-connector-profile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteConnectorProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConnectorProfileInput(v *DeleteConnectorProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteConnectorProfileInput(v *DeleteConnectorProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if v.ForceDelete {
		ok := object.Key("forceDelete")
		ok.Boolean(v.ForceDelete)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFlow struct {
}

func (*awsRestjson1_serializeOpDeleteFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/delete-flow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFlowInput(v *DeleteFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteFlowInput(v *DeleteFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	if v.ForceDelete {
		ok := object.Key("forceDelete")
		ok.Boolean(v.ForceDelete)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConnector struct {
}

func (*awsRestjson1_serializeOpDescribeConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/describe-connector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeConnectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConnectorInput(v *DescribeConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeConnectorInput(v *DescribeConnectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorLabel != nil {
		ok := object.Key("connectorLabel")
		ok.String(*v.ConnectorLabel)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConnectorEntity struct {
}

func (*awsRestjson1_serializeOpDescribeConnectorEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConnectorEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConnectorEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/describe-connector-entity")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeConnectorEntityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConnectorEntityInput(v *DescribeConnectorEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeConnectorEntityInput(v *DescribeConnectorEntityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiVersion != nil {
		ok := object.Key("apiVersion")
		ok.String(*v.ApiVersion)
	}

	if v.ConnectorEntityName != nil {
		ok := object.Key("connectorEntityName")
		ok.String(*v.ConnectorEntityName)
	}

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConnectorProfiles struct {
}

func (*awsRestjson1_serializeOpDescribeConnectorProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConnectorProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConnectorProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/describe-connector-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeConnectorProfilesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConnectorProfilesInput(v *DescribeConnectorProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeConnectorProfilesInput(v *DescribeConnectorProfilesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorLabel != nil {
		ok := object.Key("connectorLabel")
		ok.String(*v.ConnectorLabel)
	}

	if v.ConnectorProfileNames != nil {
		ok := object.Key("connectorProfileNames")
		if err := awsRestjson1_serializeDocumentConnectorProfileNameList(v.ConnectorProfileNames, ok); err != nil {
			return err
		}
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConnectors struct {
}

func (*awsRestjson1_serializeOpDescribeConnectors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConnectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConnectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/describe-connectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeConnectorsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConnectorsInput(v *DescribeConnectorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeConnectorsInput(v *DescribeConnectorsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorTypes != nil {
		ok := object.Key("connectorTypes")
		if err := awsRestjson1_serializeDocumentConnectorTypeList(v.ConnectorTypes, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlow struct {
}

func (*awsRestjson1_serializeOpDescribeFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/describe-flow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowInput(v *DescribeFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeFlowInput(v *DescribeFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlowExecutionRecords struct {
}

func (*awsRestjson1_serializeOpDescribeFlowExecutionRecords) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlowExecutionRecords) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowExecutionRecordsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/describe-flow-execution-records")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeFlowExecutionRecordsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowExecutionRecordsInput(v *DescribeFlowExecutionRecordsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeFlowExecutionRecordsInput(v *DescribeFlowExecutionRecordsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConnectorEntities struct {
}

func (*awsRestjson1_serializeOpListConnectorEntities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConnectorEntities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConnectorEntitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-connector-entities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListConnectorEntitiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConnectorEntitiesInput(v *ListConnectorEntitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListConnectorEntitiesInput(v *ListConnectorEntitiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiVersion != nil {
		ok := object.Key("apiVersion")
		ok.String(*v.ApiVersion)
	}

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	if v.EntitiesPath != nil {
		ok := object.Key("entitiesPath")
		ok.String(*v.EntitiesPath)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConnectors struct {
}

func (*awsRestjson1_serializeOpListConnectors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConnectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConnectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-connectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListConnectorsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConnectorsInput(v *ListConnectorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListConnectorsInput(v *ListConnectorsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFlows struct {
}

func (*awsRestjson1_serializeOpListFlows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFlows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFlowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-flows")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListFlowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFlowsInput(v *ListFlowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListFlowsInput(v *ListFlowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRegisterConnector struct {
}

func (*awsRestjson1_serializeOpRegisterConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/register-connector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterConnectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterConnectorInput(v *RegisterConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterConnectorInput(v *RegisterConnectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorLabel != nil {
		ok := object.Key("connectorLabel")
		ok.String(*v.ConnectorLabel)
	}

	if v.ConnectorProvisioningConfig != nil {
		ok := object.Key("connectorProvisioningConfig")
		if err := awsRestjson1_serializeDocumentConnectorProvisioningConfig(v.ConnectorProvisioningConfig, ok); err != nil {
			return err
		}
	}

	if len(v.ConnectorProvisioningType) > 0 {
		ok := object.Key("connectorProvisioningType")
		ok.String(string(v.ConnectorProvisioningType))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpStartFlow struct {
}

func (*awsRestjson1_serializeOpStartFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/start-flow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartFlowInput(v *StartFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartFlowInput(v *StartFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	return nil
}

type awsRestjson1_serializeOpStopFlow struct {
}

func (*awsRestjson1_serializeOpStopFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/stop-flow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopFlowInput(v *StopFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopFlowInput(v *StopFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUnregisterConnector struct {
}

func (*awsRestjson1_serializeOpUnregisterConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUnregisterConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnregisterConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/unregister-connector")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUnregisterConnectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUnregisterConnectorInput(v *UnregisterConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUnregisterConnectorInput(v *UnregisterConnectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorLabel != nil {
		ok := object.Key("connectorLabel")
		ok.String(*v.ConnectorLabel)
	}

	if v.ForceDelete {
		ok := object.Key("forceDelete")
		ok.Boolean(v.ForceDelete)
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConnectorProfile struct {
}

func (*awsRestjson1_serializeOpUpdateConnectorProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConnectorProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConnectorProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/update-connector-profile")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConnectorProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConnectorProfileInput(v *UpdateConnectorProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConnectorProfileInput(v *UpdateConnectorProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConnectionMode) > 0 {
		ok := object.Key("connectionMode")
		ok.String(string(v.ConnectionMode))
	}

	if v.ConnectorProfileConfig != nil {
		ok := object.Key("connectorProfileConfig")
		if err := awsRestjson1_serializeDocumentConnectorProfileConfig(v.ConnectorProfileConfig, ok); err != nil {
			return err
		}
	}

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConnectorRegistration struct {
}

func (*awsRestjson1_serializeOpUpdateConnectorRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConnectorRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConnectorRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/update-connector-registration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConnectorRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConnectorRegistrationInput(v *UpdateConnectorRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConnectorRegistrationInput(v *UpdateConnectorRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorLabel != nil {
		ok := object.Key("connectorLabel")
		ok.String(*v.ConnectorLabel)
	}

	if v.ConnectorProvisioningConfig != nil {
		ok := object.Key("connectorProvisioningConfig")
		if err := awsRestjson1_serializeDocumentConnectorProvisioningConfig(v.ConnectorProvisioningConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlow struct {
}

func (*awsRestjson1_serializeOpUpdateFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/update-flow")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowInput(v *UpdateFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowInput(v *UpdateFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DestinationFlowConfigList != nil {
		ok := object.Key("destinationFlowConfigList")
		if err := awsRestjson1_serializeDocumentDestinationFlowConfigList(v.DestinationFlowConfigList, ok); err != nil {
			return err
		}
	}

	if v.FlowName != nil {
		ok := object.Key("flowName")
		ok.String(*v.FlowName)
	}

	if v.MetadataCatalogConfig != nil {
		ok := object.Key("metadataCatalogConfig")
		if err := awsRestjson1_serializeDocumentMetadataCatalogConfig(v.MetadataCatalogConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceFlowConfig != nil {
		ok := object.Key("sourceFlowConfig")
		if err := awsRestjson1_serializeDocumentSourceFlowConfig(v.SourceFlowConfig, ok); err != nil {
			return err
		}
	}

	if v.Tasks != nil {
		ok := object.Key("tasks")
		if err := awsRestjson1_serializeDocumentTasks(v.Tasks, ok); err != nil {
			return err
		}
	}

	if v.TriggerConfig != nil {
		ok := object.Key("triggerConfig")
		if err := awsRestjson1_serializeDocumentTriggerConfig(v.TriggerConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregationConfig(v *types.AggregationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregationType) > 0 {
		ok := object.Key("aggregationType")
		ok.String(string(v.AggregationType))
	}

	if v.TargetFileSize != nil {
		ok := object.Key("targetFileSize")
		ok.Long(*v.TargetFileSize)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmplitudeConnectorProfileCredentials(v *types.AmplitudeConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("apiKey")
		ok.String(*v.ApiKey)
	}

	if v.SecretKey != nil {
		ok := object.Key("secretKey")
		ok.String(*v.SecretKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmplitudeConnectorProfileProperties(v *types.AmplitudeConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentAmplitudeSourceProperties(v *types.AmplitudeSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentApiKeyCredentials(v *types.ApiKeyCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("apiKey")
		ok.String(*v.ApiKey)
	}

	if v.ApiSecretKey != nil {
		ok := object.Key("apiSecretKey")
		ok.String(*v.ApiSecretKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentBasicAuthCredentials(v *types.BasicAuthCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorOAuthRequest(v *types.ConnectorOAuthRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthCode != nil {
		ok := object.Key("authCode")
		ok.String(*v.AuthCode)
	}

	if v.RedirectUri != nil {
		ok := object.Key("redirectUri")
		ok.String(*v.RedirectUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorOperator(v *types.ConnectorOperator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Amplitude) > 0 {
		ok := object.Key("Amplitude")
		ok.String(string(v.Amplitude))
	}

	if len(v.CustomConnector) > 0 {
		ok := object.Key("CustomConnector")
		ok.String(string(v.CustomConnector))
	}

	if len(v.Datadog) > 0 {
		ok := object.Key("Datadog")
		ok.String(string(v.Datadog))
	}

	if len(v.Dynatrace) > 0 {
		ok := object.Key("Dynatrace")
		ok.String(string(v.Dynatrace))
	}

	if len(v.GoogleAnalytics) > 0 {
		ok := object.Key("GoogleAnalytics")
		ok.String(string(v.GoogleAnalytics))
	}

	if len(v.InforNexus) > 0 {
		ok := object.Key("InforNexus")
		ok.String(string(v.InforNexus))
	}

	if len(v.Marketo) > 0 {
		ok := object.Key("Marketo")
		ok.String(string(v.Marketo))
	}

	if len(v.Pardot) > 0 {
		ok := object.Key("Pardot")
		ok.String(string(v.Pardot))
	}

	if len(v.S3) > 0 {
		ok := object.Key("S3")
		ok.String(string(v.S3))
	}

	if len(v.Salesforce) > 0 {
		ok := object.Key("Salesforce")
		ok.String(string(v.Salesforce))
	}

	if len(v.SAPOData) > 0 {
		ok := object.Key("SAPOData")
		ok.String(string(v.SAPOData))
	}

	if len(v.ServiceNow) > 0 {
		ok := object.Key("ServiceNow")
		ok.String(string(v.ServiceNow))
	}

	if len(v.Singular) > 0 {
		ok := object.Key("Singular")
		ok.String(string(v.Singular))
	}

	if len(v.Slack) > 0 {
		ok := object.Key("Slack")
		ok.String(string(v.Slack))
	}

	if len(v.Trendmicro) > 0 {
		ok := object.Key("Trendmicro")
		ok.String(string(v.Trendmicro))
	}

	if len(v.Veeva) > 0 {
		ok := object.Key("Veeva")
		ok.String(string(v.Veeva))
	}

	if len(v.Zendesk) > 0 {
		ok := object.Key("Zendesk")
		ok.String(string(v.Zendesk))
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorProfileConfig(v *types.ConnectorProfileConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorProfileCredentials != nil {
		ok := object.Key("connectorProfileCredentials")
		if err := awsRestjson1_serializeDocumentConnectorProfileCredentials(v.ConnectorProfileCredentials, ok); err != nil {
			return err
		}
	}

	if v.ConnectorProfileProperties != nil {
		ok := object.Key("connectorProfileProperties")
		if err := awsRestjson1_serializeDocumentConnectorProfileProperties(v.ConnectorProfileProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorProfileCredentials(v *types.ConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amplitude != nil {
		ok := object.Key("Amplitude")
		if err := awsRestjson1_serializeDocumentAmplitudeConnectorProfileCredentials(v.Amplitude, ok); err != nil {
			return err
		}
	}

	if v.CustomConnector != nil {
		ok := object.Key("CustomConnector")
		if err := awsRestjson1_serializeDocumentCustomConnectorProfileCredentials(v.CustomConnector, ok); err != nil {
			return err
		}
	}

	if v.Datadog != nil {
		ok := object.Key("Datadog")
		if err := awsRestjson1_serializeDocumentDatadogConnectorProfileCredentials(v.Datadog, ok); err != nil {
			return err
		}
	}

	if v.Dynatrace != nil {
		ok := object.Key("Dynatrace")
		if err := awsRestjson1_serializeDocumentDynatraceConnectorProfileCredentials(v.Dynatrace, ok); err != nil {
			return err
		}
	}

	if v.GoogleAnalytics != nil {
		ok := object.Key("GoogleAnalytics")
		if err := awsRestjson1_serializeDocumentGoogleAnalyticsConnectorProfileCredentials(v.GoogleAnalytics, ok); err != nil {
			return err
		}
	}

	if v.Honeycode != nil {
		ok := object.Key("Honeycode")
		if err := awsRestjson1_serializeDocumentHoneycodeConnectorProfileCredentials(v.Honeycode, ok); err != nil {
			return err
		}
	}

	if v.InforNexus != nil {
		ok := object.Key("InforNexus")
		if err := awsRestjson1_serializeDocumentInforNexusConnectorProfileCredentials(v.InforNexus, ok); err != nil {
			return err
		}
	}

	if v.Marketo != nil {
		ok := object.Key("Marketo")
		if err := awsRestjson1_serializeDocumentMarketoConnectorProfileCredentials(v.Marketo, ok); err != nil {
			return err
		}
	}

	if v.Pardot != nil {
		ok := object.Key("Pardot")
		if err := awsRestjson1_serializeDocumentPardotConnectorProfileCredentials(v.Pardot, ok); err != nil {
			return err
		}
	}

	if v.Redshift != nil {
		ok := object.Key("Redshift")
		if err := awsRestjson1_serializeDocumentRedshiftConnectorProfileCredentials(v.Redshift, ok); err != nil {
			return err
		}
	}

	if v.Salesforce != nil {
		ok := object.Key("Salesforce")
		if err := awsRestjson1_serializeDocumentSalesforceConnectorProfileCredentials(v.Salesforce, ok); err != nil {
			return err
		}
	}

	if v.SAPOData != nil {
		ok := object.Key("SAPOData")
		if err := awsRestjson1_serializeDocumentSAPODataConnectorProfileCredentials(v.SAPOData, ok); err != nil {
			return err
		}
	}

	if v.ServiceNow != nil {
		ok := object.Key("ServiceNow")
		if err := awsRestjson1_serializeDocumentServiceNowConnectorProfileCredentials(v.ServiceNow, ok); err != nil {
			return err
		}
	}

	if v.Singular != nil {
		ok := object.Key("Singular")
		if err := awsRestjson1_serializeDocumentSingularConnectorProfileCredentials(v.Singular, ok); err != nil {
			return err
		}
	}

	if v.Slack != nil {
		ok := object.Key("Slack")
		if err := awsRestjson1_serializeDocumentSlackConnectorProfileCredentials(v.Slack, ok); err != nil {
			return err
		}
	}

	if v.Snowflake != nil {
		ok := object.Key("Snowflake")
		if err := awsRestjson1_serializeDocumentSnowflakeConnectorProfileCredentials(v.Snowflake, ok); err != nil {
			return err
		}
	}

	if v.Trendmicro != nil {
		ok := object.Key("Trendmicro")
		if err := awsRestjson1_serializeDocumentTrendmicroConnectorProfileCredentials(v.Trendmicro, ok); err != nil {
			return err
		}
	}

	if v.Veeva != nil {
		ok := object.Key("Veeva")
		if err := awsRestjson1_serializeDocumentVeevaConnectorProfileCredentials(v.Veeva, ok); err != nil {
			return err
		}
	}

	if v.Zendesk != nil {
		ok := object.Key("Zendesk")
		if err := awsRestjson1_serializeDocumentZendeskConnectorProfileCredentials(v.Zendesk, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorProfileNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentConnectorProfileProperties(v *types.ConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amplitude != nil {
		ok := object.Key("Amplitude")
		if err := awsRestjson1_serializeDocumentAmplitudeConnectorProfileProperties(v.Amplitude, ok); err != nil {
			return err
		}
	}

	if v.CustomConnector != nil {
		ok := object.Key("CustomConnector")
		if err := awsRestjson1_serializeDocumentCustomConnectorProfileProperties(v.CustomConnector, ok); err != nil {
			return err
		}
	}

	if v.Datadog != nil {
		ok := object.Key("Datadog")
		if err := awsRestjson1_serializeDocumentDatadogConnectorProfileProperties(v.Datadog, ok); err != nil {
			return err
		}
	}

	if v.Dynatrace != nil {
		ok := object.Key("Dynatrace")
		if err := awsRestjson1_serializeDocumentDynatraceConnectorProfileProperties(v.Dynatrace, ok); err != nil {
			return err
		}
	}

	if v.GoogleAnalytics != nil {
		ok := object.Key("GoogleAnalytics")
		if err := awsRestjson1_serializeDocumentGoogleAnalyticsConnectorProfileProperties(v.GoogleAnalytics, ok); err != nil {
			return err
		}
	}

	if v.Honeycode != nil {
		ok := object.Key("Honeycode")
		if err := awsRestjson1_serializeDocumentHoneycodeConnectorProfileProperties(v.Honeycode, ok); err != nil {
			return err
		}
	}

	if v.InforNexus != nil {
		ok := object.Key("InforNexus")
		if err := awsRestjson1_serializeDocumentInforNexusConnectorProfileProperties(v.InforNexus, ok); err != nil {
			return err
		}
	}

	if v.Marketo != nil {
		ok := object.Key("Marketo")
		if err := awsRestjson1_serializeDocumentMarketoConnectorProfileProperties(v.Marketo, ok); err != nil {
			return err
		}
	}

	if v.Pardot != nil {
		ok := object.Key("Pardot")
		if err := awsRestjson1_serializeDocumentPardotConnectorProfileProperties(v.Pardot, ok); err != nil {
			return err
		}
	}

	if v.Redshift != nil {
		ok := object.Key("Redshift")
		if err := awsRestjson1_serializeDocumentRedshiftConnectorProfileProperties(v.Redshift, ok); err != nil {
			return err
		}
	}

	if v.Salesforce != nil {
		ok := object.Key("Salesforce")
		if err := awsRestjson1_serializeDocumentSalesforceConnectorProfileProperties(v.Salesforce, ok); err != nil {
			return err
		}
	}

	if v.SAPOData != nil {
		ok := object.Key("SAPOData")
		if err := awsRestjson1_serializeDocumentSAPODataConnectorProfileProperties(v.SAPOData, ok); err != nil {
			return err
		}
	}

	if v.ServiceNow != nil {
		ok := object.Key("ServiceNow")
		if err := awsRestjson1_serializeDocumentServiceNowConnectorProfileProperties(v.ServiceNow, ok); err != nil {
			return err
		}
	}

	if v.Singular != nil {
		ok := object.Key("Singular")
		if err := awsRestjson1_serializeDocumentSingularConnectorProfileProperties(v.Singular, ok); err != nil {
			return err
		}
	}

	if v.Slack != nil {
		ok := object.Key("Slack")
		if err := awsRestjson1_serializeDocumentSlackConnectorProfileProperties(v.Slack, ok); err != nil {
			return err
		}
	}

	if v.Snowflake != nil {
		ok := object.Key("Snowflake")
		if err := awsRestjson1_serializeDocumentSnowflakeConnectorProfileProperties(v.Snowflake, ok); err != nil {
			return err
		}
	}

	if v.Trendmicro != nil {
		ok := object.Key("Trendmicro")
		if err := awsRestjson1_serializeDocumentTrendmicroConnectorProfileProperties(v.Trendmicro, ok); err != nil {
			return err
		}
	}

	if v.Veeva != nil {
		ok := object.Key("Veeva")
		if err := awsRestjson1_serializeDocumentVeevaConnectorProfileProperties(v.Veeva, ok); err != nil {
			return err
		}
	}

	if v.Zendesk != nil {
		ok := object.Key("Zendesk")
		if err := awsRestjson1_serializeDocumentZendeskConnectorProfileProperties(v.Zendesk, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorProvisioningConfig(v *types.ConnectorProvisioningConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Lambda != nil {
		ok := object.Key("lambda")
		if err := awsRestjson1_serializeDocumentLambdaConnectorProvisioningConfig(v.Lambda, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorTypeList(v []types.ConnectorType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentCredentialsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomAuthCredentials(v *types.CustomAuthCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialsMap != nil {
		ok := object.Key("credentialsMap")
		if err := awsRestjson1_serializeDocumentCredentialsMap(v.CredentialsMap, ok); err != nil {
			return err
		}
	}

	if v.CustomAuthenticationType != nil {
		ok := object.Key("customAuthenticationType")
		ok.String(*v.CustomAuthenticationType)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomConnectorDestinationProperties(v *types.CustomConnectorDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomProperties != nil {
		ok := object.Key("customProperties")
		if err := awsRestjson1_serializeDocumentCustomProperties(v.CustomProperties, ok); err != nil {
			return err
		}
	}

	if v.EntityName != nil {
		ok := object.Key("entityName")
		ok.String(*v.EntityName)
	}

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.IdFieldNames != nil {
		ok := object.Key("idFieldNames")
		if err := awsRestjson1_serializeDocumentIdFieldNameList(v.IdFieldNames, ok); err != nil {
			return err
		}
	}

	if len(v.WriteOperationType) > 0 {
		ok := object.Key("writeOperationType")
		ok.String(string(v.WriteOperationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomConnectorProfileCredentials(v *types.CustomConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("apiKey")
		if err := awsRestjson1_serializeDocumentApiKeyCredentials(v.ApiKey, ok); err != nil {
			return err
		}
	}

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("authenticationType")
		ok.String(string(v.AuthenticationType))
	}

	if v.Basic != nil {
		ok := object.Key("basic")
		if err := awsRestjson1_serializeDocumentBasicAuthCredentials(v.Basic, ok); err != nil {
			return err
		}
	}

	if v.Custom != nil {
		ok := object.Key("custom")
		if err := awsRestjson1_serializeDocumentCustomAuthCredentials(v.Custom, ok); err != nil {
			return err
		}
	}

	if v.Oauth2 != nil {
		ok := object.Key("oauth2")
		if err := awsRestjson1_serializeDocumentOAuth2Credentials(v.Oauth2, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomConnectorProfileProperties(v *types.CustomConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OAuth2Properties != nil {
		ok := object.Key("oAuth2Properties")
		if err := awsRestjson1_serializeDocumentOAuth2Properties(v.OAuth2Properties, ok); err != nil {
			return err
		}
	}

	if v.ProfileProperties != nil {
		ok := object.Key("profileProperties")
		if err := awsRestjson1_serializeDocumentProfilePropertiesMap(v.ProfileProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomConnectorSourceProperties(v *types.CustomConnectorSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomProperties != nil {
		ok := object.Key("customProperties")
		if err := awsRestjson1_serializeDocumentCustomProperties(v.CustomProperties, ok); err != nil {
			return err
		}
	}

	if v.EntityName != nil {
		ok := object.Key("entityName")
		ok.String(*v.EntityName)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomerProfilesDestinationProperties(v *types.CustomerProfilesDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainName != nil {
		ok := object.Key("domainName")
		ok.String(*v.DomainName)
	}

	if v.ObjectTypeName != nil {
		ok := object.Key("objectTypeName")
		ok.String(*v.ObjectTypeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomProperties(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentDatadogConnectorProfileCredentials(v *types.DatadogConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("apiKey")
		ok.String(*v.ApiKey)
	}

	if v.ApplicationKey != nil {
		ok := object.Key("applicationKey")
		ok.String(*v.ApplicationKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatadogConnectorProfileProperties(v *types.DatadogConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatadogSourceProperties(v *types.DatadogSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationConnectorProperties(v *types.DestinationConnectorProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomConnector != nil {
		ok := object.Key("CustomConnector")
		if err := awsRestjson1_serializeDocumentCustomConnectorDestinationProperties(v.CustomConnector, ok); err != nil {
			return err
		}
	}

	if v.CustomerProfiles != nil {
		ok := object.Key("CustomerProfiles")
		if err := awsRestjson1_serializeDocumentCustomerProfilesDestinationProperties(v.CustomerProfiles, ok); err != nil {
			return err
		}
	}

	if v.EventBridge != nil {
		ok := object.Key("EventBridge")
		if err := awsRestjson1_serializeDocumentEventBridgeDestinationProperties(v.EventBridge, ok); err != nil {
			return err
		}
	}

	if v.Honeycode != nil {
		ok := object.Key("Honeycode")
		if err := awsRestjson1_serializeDocumentHoneycodeDestinationProperties(v.Honeycode, ok); err != nil {
			return err
		}
	}

	if v.LookoutMetrics != nil {
		ok := object.Key("LookoutMetrics")
		if err := awsRestjson1_serializeDocumentLookoutMetricsDestinationProperties(v.LookoutMetrics, ok); err != nil {
			return err
		}
	}

	if v.Marketo != nil {
		ok := object.Key("Marketo")
		if err := awsRestjson1_serializeDocumentMarketoDestinationProperties(v.Marketo, ok); err != nil {
			return err
		}
	}

	if v.Redshift != nil {
		ok := object.Key("Redshift")
		if err := awsRestjson1_serializeDocumentRedshiftDestinationProperties(v.Redshift, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsRestjson1_serializeDocumentS3DestinationProperties(v.S3, ok); err != nil {
			return err
		}
	}

	if v.Salesforce != nil {
		ok := object.Key("Salesforce")
		if err := awsRestjson1_serializeDocumentSalesforceDestinationProperties(v.Salesforce, ok); err != nil {
			return err
		}
	}

	if v.SAPOData != nil {
		ok := object.Key("SAPOData")
		if err := awsRestjson1_serializeDocumentSAPODataDestinationProperties(v.SAPOData, ok); err != nil {
			return err
		}
	}

	if v.Snowflake != nil {
		ok := object.Key("Snowflake")
		if err := awsRestjson1_serializeDocumentSnowflakeDestinationProperties(v.Snowflake, ok); err != nil {
			return err
		}
	}

	if v.Upsolver != nil {
		ok := object.Key("Upsolver")
		if err := awsRestjson1_serializeDocumentUpsolverDestinationProperties(v.Upsolver, ok); err != nil {
			return err
		}
	}

	if v.Zendesk != nil {
		ok := object.Key("Zendesk")
		if err := awsRestjson1_serializeDocumentZendeskDestinationProperties(v.Zendesk, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationFlowConfig(v *types.DestinationFlowConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiVersion != nil {
		ok := object.Key("apiVersion")
		ok.String(*v.ApiVersion)
	}

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	if v.DestinationConnectorProperties != nil {
		ok := object.Key("destinationConnectorProperties")
		if err := awsRestjson1_serializeDocumentDestinationConnectorProperties(v.DestinationConnectorProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationFlowConfigList(v []types.DestinationFlowConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDestinationFlowConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDynatraceConnectorProfileCredentials(v *types.DynatraceConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiToken != nil {
		ok := object.Key("apiToken")
		ok.String(*v.ApiToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentDynatraceConnectorProfileProperties(v *types.DynatraceConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentDynatraceSourceProperties(v *types.DynatraceSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentErrorHandlingConfig(v *types.ErrorHandlingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.FailOnFirstDestinationError {
		ok := object.Key("failOnFirstDestinationError")
		ok.Boolean(v.FailOnFirstDestinationError)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventBridgeDestinationProperties(v *types.EventBridgeDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentGlueDataCatalogConfig(v *types.GlueDataCatalogConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TablePrefix != nil {
		ok := object.Key("tablePrefix")
		ok.String(*v.TablePrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentGoogleAnalyticsConnectorProfileCredentials(v *types.GoogleAnalyticsConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("clientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentGoogleAnalyticsConnectorProfileProperties(v *types.GoogleAnalyticsConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentGoogleAnalyticsSourceProperties(v *types.GoogleAnalyticsSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentHoneycodeConnectorProfileCredentials(v *types.HoneycodeConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentHoneycodeConnectorProfileProperties(v *types.HoneycodeConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentHoneycodeDestinationProperties(v *types.HoneycodeDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdFieldNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIncrementalPullConfig(v *types.IncrementalPullConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatetimeTypeFieldName != nil {
		ok := object.Key("datetimeTypeFieldName")
		ok.String(*v.DatetimeTypeFieldName)
	}

	return nil
}

func awsRestjson1_serializeDocumentInforNexusConnectorProfileCredentials(v *types.InforNexusConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessKeyId != nil {
		ok := object.Key("accessKeyId")
		ok.String(*v.AccessKeyId)
	}

	if v.Datakey != nil {
		ok := object.Key("datakey")
		ok.String(*v.Datakey)
	}

	if v.SecretAccessKey != nil {
		ok := object.Key("secretAccessKey")
		ok.String(*v.SecretAccessKey)
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentInforNexusConnectorProfileProperties(v *types.InforNexusConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentInforNexusSourceProperties(v *types.InforNexusSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaConnectorProvisioningConfig(v *types.LambdaConnectorProvisioningConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaArn != nil {
		ok := object.Key("lambdaArn")
		ok.String(*v.LambdaArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentLookoutMetricsDestinationProperties(v *types.LookoutMetricsDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentMarketoConnectorProfileCredentials(v *types.MarketoConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("clientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMarketoConnectorProfileProperties(v *types.MarketoConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentMarketoDestinationProperties(v *types.MarketoDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentMarketoSourceProperties(v *types.MarketoSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentMetadataCatalogConfig(v *types.MetadataCatalogConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlueDataCatalog != nil {
		ok := object.Key("glueDataCatalog")
		if err := awsRestjson1_serializeDocumentGlueDataCatalogConfig(v.GlueDataCatalog, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuth2Credentials(v *types.OAuth2Credentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("clientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuth2Properties(v *types.OAuth2Properties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OAuth2GrantType) > 0 {
		ok := object.Key("oAuth2GrantType")
		ok.String(string(v.OAuth2GrantType))
	}

	if v.TokenUrl != nil {
		ok := object.Key("tokenUrl")
		ok.String(*v.TokenUrl)
	}

	if v.TokenUrlCustomProperties != nil {
		ok := object.Key("tokenUrlCustomProperties")
		if err := awsRestjson1_serializeDocumentTokenUrlCustomProperties(v.TokenUrlCustomProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuthCredentials(v *types.OAuthCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("clientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuthProperties(v *types.OAuthProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthCodeUrl != nil {
		ok := object.Key("authCodeUrl")
		ok.String(*v.AuthCodeUrl)
	}

	if v.OAuthScopes != nil {
		ok := object.Key("oAuthScopes")
		if err := awsRestjson1_serializeDocumentOAuthScopeList(v.OAuthScopes, ok); err != nil {
			return err
		}
	}

	if v.TokenUrl != nil {
		ok := object.Key("tokenUrl")
		ok.String(*v.TokenUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuthScopeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPardotConnectorProfileCredentials(v *types.PardotConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientCredentialsArn != nil {
		ok := object.Key("clientCredentialsArn")
		ok.String(*v.ClientCredentialsArn)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentPardotConnectorProfileProperties(v *types.PardotConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BusinessUnitId != nil {
		ok := object.Key("businessUnitId")
		ok.String(*v.BusinessUnitId)
	}

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	if v.IsSandboxEnvironment {
		ok := object.Key("isSandboxEnvironment")
		ok.Boolean(v.IsSandboxEnvironment)
	}

	return nil
}

func awsRestjson1_serializeDocumentPardotSourceProperties(v *types.PardotSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentPathPrefixHierarchy(v []types.PathPrefix, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentPrefixConfig(v *types.PrefixConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PathPrefixHierarchy != nil {
		ok := object.Key("pathPrefixHierarchy")
		if err := awsRestjson1_serializeDocumentPathPrefixHierarchy(v.PathPrefixHierarchy, ok); err != nil {
			return err
		}
	}

	if len(v.PrefixFormat) > 0 {
		ok := object.Key("prefixFormat")
		ok.String(string(v.PrefixFormat))
	}

	if len(v.PrefixType) > 0 {
		ok := object.Key("prefixType")
		ok.String(string(v.PrefixType))
	}

	return nil
}

func awsRestjson1_serializeDocumentProfilePropertiesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentRedshiftConnectorProfileCredentials(v *types.RedshiftConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentRedshiftConnectorProfileProperties(v *types.RedshiftConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.ClusterIdentifier != nil {
		ok := object.Key("clusterIdentifier")
		ok.String(*v.ClusterIdentifier)
	}

	if v.DataApiRoleArn != nil {
		ok := object.Key("dataApiRoleArn")
		ok.String(*v.DataApiRoleArn)
	}

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.DatabaseUrl != nil {
		ok := object.Key("databaseUrl")
		ok.String(*v.DatabaseUrl)
	}

	if v.IsRedshiftServerless {
		ok := object.Key("isRedshiftServerless")
		ok.Boolean(v.IsRedshiftServerless)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.WorkgroupName != nil {
		ok := object.Key("workgroupName")
		ok.String(*v.WorkgroupName)
	}

	return nil
}

func awsRestjson1_serializeDocumentRedshiftDestinationProperties(v *types.RedshiftDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.IntermediateBucketName != nil {
		ok := object.Key("intermediateBucketName")
		ok.String(*v.IntermediateBucketName)
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3DestinationProperties(v *types.S3DestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.S3OutputFormatConfig != nil {
		ok := object.Key("s3OutputFormatConfig")
		if err := awsRestjson1_serializeDocumentS3OutputFormatConfig(v.S3OutputFormatConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3InputFormatConfig(v *types.S3InputFormatConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.S3InputFileType) > 0 {
		ok := object.Key("s3InputFileType")
		ok.String(string(v.S3InputFileType))
	}

	return nil
}

func awsRestjson1_serializeDocumentS3OutputFormatConfig(v *types.S3OutputFormatConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationConfig != nil {
		ok := object.Key("aggregationConfig")
		if err := awsRestjson1_serializeDocumentAggregationConfig(v.AggregationConfig, ok); err != nil {
			return err
		}
	}

	if len(v.FileType) > 0 {
		ok := object.Key("fileType")
		ok.String(string(v.FileType))
	}

	if v.PrefixConfig != nil {
		ok := object.Key("prefixConfig")
		if err := awsRestjson1_serializeDocumentPrefixConfig(v.PrefixConfig, ok); err != nil {
			return err
		}
	}

	if v.PreserveSourceDataTyping != nil {
		ok := object.Key("preserveSourceDataTyping")
		ok.Boolean(*v.PreserveSourceDataTyping)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3SourceProperties(v *types.S3SourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.S3InputFormatConfig != nil {
		ok := object.Key("s3InputFormatConfig")
		if err := awsRestjson1_serializeDocumentS3InputFormatConfig(v.S3InputFormatConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSalesforceConnectorProfileCredentials(v *types.SalesforceConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientCredentialsArn != nil {
		ok := object.Key("clientCredentialsArn")
		ok.String(*v.ClientCredentialsArn)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentSalesforceConnectorProfileProperties(v *types.SalesforceConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	if v.IsSandboxEnvironment {
		ok := object.Key("isSandboxEnvironment")
		ok.Boolean(v.IsSandboxEnvironment)
	}

	return nil
}

func awsRestjson1_serializeDocumentSalesforceDestinationProperties(v *types.SalesforceDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataTransferApi) > 0 {
		ok := object.Key("dataTransferApi")
		ok.String(string(v.DataTransferApi))
	}

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.IdFieldNames != nil {
		ok := object.Key("idFieldNames")
		if err := awsRestjson1_serializeDocumentIdFieldNameList(v.IdFieldNames, ok); err != nil {
			return err
		}
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	if len(v.WriteOperationType) > 0 {
		ok := object.Key("writeOperationType")
		ok.String(string(v.WriteOperationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSalesforceSourceProperties(v *types.SalesforceSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataTransferApi) > 0 {
		ok := object.Key("dataTransferApi")
		ok.String(string(v.DataTransferApi))
	}

	if v.EnableDynamicFieldUpdate {
		ok := object.Key("enableDynamicFieldUpdate")
		ok.Boolean(v.EnableDynamicFieldUpdate)
	}

	if v.IncludeDeletedRecords {
		ok := object.Key("includeDeletedRecords")
		ok.Boolean(v.IncludeDeletedRecords)
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentSAPODataConnectorProfileCredentials(v *types.SAPODataConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BasicAuthCredentials != nil {
		ok := object.Key("basicAuthCredentials")
		if err := awsRestjson1_serializeDocumentBasicAuthCredentials(v.BasicAuthCredentials, ok); err != nil {
			return err
		}
	}

	if v.OAuthCredentials != nil {
		ok := object.Key("oAuthCredentials")
		if err := awsRestjson1_serializeDocumentOAuthCredentials(v.OAuthCredentials, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSAPODataConnectorProfileProperties(v *types.SAPODataConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationHostUrl != nil {
		ok := object.Key("applicationHostUrl")
		ok.String(*v.ApplicationHostUrl)
	}

	if v.ApplicationServicePath != nil {
		ok := object.Key("applicationServicePath")
		ok.String(*v.ApplicationServicePath)
	}

	if v.ClientNumber != nil {
		ok := object.Key("clientNumber")
		ok.String(*v.ClientNumber)
	}

	if v.LogonLanguage != nil {
		ok := object.Key("logonLanguage")
		ok.String(*v.LogonLanguage)
	}

	if v.OAuthProperties != nil {
		ok := object.Key("oAuthProperties")
		if err := awsRestjson1_serializeDocumentOAuthProperties(v.OAuthProperties, ok); err != nil {
			return err
		}
	}

	if v.PortNumber != nil {
		ok := object.Key("portNumber")
		ok.Integer(*v.PortNumber)
	}

	if v.PrivateLinkServiceName != nil {
		ok := object.Key("privateLinkServiceName")
		ok.String(*v.PrivateLinkServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentSAPODataDestinationProperties(v *types.SAPODataDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.IdFieldNames != nil {
		ok := object.Key("idFieldNames")
		if err := awsRestjson1_serializeDocumentIdFieldNameList(v.IdFieldNames, ok); err != nil {
			return err
		}
	}

	if v.ObjectPath != nil {
		ok := object.Key("objectPath")
		ok.String(*v.ObjectPath)
	}

	if v.SuccessResponseHandlingConfig != nil {
		ok := object.Key("successResponseHandlingConfig")
		if err := awsRestjson1_serializeDocumentSuccessResponseHandlingConfig(v.SuccessResponseHandlingConfig, ok); err != nil {
			return err
		}
	}

	if len(v.WriteOperationType) > 0 {
		ok := object.Key("writeOperationType")
		ok.String(string(v.WriteOperationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSAPODataSourceProperties(v *types.SAPODataSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectPath != nil {
		ok := object.Key("objectPath")
		ok.String(*v.ObjectPath)
	}

	return nil
}

func awsRestjson1_serializeDocumentScheduledTriggerProperties(v *types.ScheduledTriggerProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataPullMode) > 0 {
		ok := object.Key("dataPullMode")
		ok.String(string(v.DataPullMode))
	}

	if v.FirstExecutionFrom != nil {
		ok := object.Key("firstExecutionFrom")
		ok.Double(smithytime.FormatEpochSeconds(*v.FirstExecutionFrom))
	}

	if v.FlowErrorDeactivationThreshold != nil {
		ok := object.Key("flowErrorDeactivationThreshold")
		ok.Integer(*v.FlowErrorDeactivationThreshold)
	}

	if v.ScheduleEndTime != nil {
		ok := object.Key("scheduleEndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ScheduleEndTime))
	}

	if v.ScheduleExpression != nil {
		ok := object.Key("scheduleExpression")
		ok.String(*v.ScheduleExpression)
	}

	if v.ScheduleOffset != nil {
		ok := object.Key("scheduleOffset")
		ok.Long(*v.ScheduleOffset)
	}

	if v.ScheduleStartTime != nil {
		ok := object.Key("scheduleStartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ScheduleStartTime))
	}

	if v.Timezone != nil {
		ok := object.Key("timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceNowConnectorProfileCredentials(v *types.ServiceNowConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceNowConnectorProfileProperties(v *types.ServiceNowConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceNowSourceProperties(v *types.ServiceNowSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentSingularConnectorProfileCredentials(v *types.SingularConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("apiKey")
		ok.String(*v.ApiKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentSingularConnectorProfileProperties(v *types.SingularConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentSingularSourceProperties(v *types.SingularSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlackConnectorProfileCredentials(v *types.SlackConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("clientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlackConnectorProfileProperties(v *types.SlackConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlackSourceProperties(v *types.SlackSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentSnowflakeConnectorProfileCredentials(v *types.SnowflakeConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentSnowflakeConnectorProfileProperties(v *types.SnowflakeConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountName != nil {
		ok := object.Key("accountName")
		ok.String(*v.AccountName)
	}

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.PrivateLinkServiceName != nil {
		ok := object.Key("privateLinkServiceName")
		ok.String(*v.PrivateLinkServiceName)
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.Stage != nil {
		ok := object.Key("stage")
		ok.String(*v.Stage)
	}

	if v.Warehouse != nil {
		ok := object.Key("warehouse")
		ok.String(*v.Warehouse)
	}

	return nil
}

func awsRestjson1_serializeDocumentSnowflakeDestinationProperties(v *types.SnowflakeDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.IntermediateBucketName != nil {
		ok := object.Key("intermediateBucketName")
		ok.String(*v.IntermediateBucketName)
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceConnectorProperties(v *types.SourceConnectorProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amplitude != nil {
		ok := object.Key("Amplitude")
		if err := awsRestjson1_serializeDocumentAmplitudeSourceProperties(v.Amplitude, ok); err != nil {
			return err
		}
	}

	if v.CustomConnector != nil {
		ok := object.Key("CustomConnector")
		if err := awsRestjson1_serializeDocumentCustomConnectorSourceProperties(v.CustomConnector, ok); err != nil {
			return err
		}
	}

	if v.Datadog != nil {
		ok := object.Key("Datadog")
		if err := awsRestjson1_serializeDocumentDatadogSourceProperties(v.Datadog, ok); err != nil {
			return err
		}
	}

	if v.Dynatrace != nil {
		ok := object.Key("Dynatrace")
		if err := awsRestjson1_serializeDocumentDynatraceSourceProperties(v.Dynatrace, ok); err != nil {
			return err
		}
	}

	if v.GoogleAnalytics != nil {
		ok := object.Key("GoogleAnalytics")
		if err := awsRestjson1_serializeDocumentGoogleAnalyticsSourceProperties(v.GoogleAnalytics, ok); err != nil {
			return err
		}
	}

	if v.InforNexus != nil {
		ok := object.Key("InforNexus")
		if err := awsRestjson1_serializeDocumentInforNexusSourceProperties(v.InforNexus, ok); err != nil {
			return err
		}
	}

	if v.Marketo != nil {
		ok := object.Key("Marketo")
		if err := awsRestjson1_serializeDocumentMarketoSourceProperties(v.Marketo, ok); err != nil {
			return err
		}
	}

	if v.Pardot != nil {
		ok := object.Key("Pardot")
		if err := awsRestjson1_serializeDocumentPardotSourceProperties(v.Pardot, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsRestjson1_serializeDocumentS3SourceProperties(v.S3, ok); err != nil {
			return err
		}
	}

	if v.Salesforce != nil {
		ok := object.Key("Salesforce")
		if err := awsRestjson1_serializeDocumentSalesforceSourceProperties(v.Salesforce, ok); err != nil {
			return err
		}
	}

	if v.SAPOData != nil {
		ok := object.Key("SAPOData")
		if err := awsRestjson1_serializeDocumentSAPODataSourceProperties(v.SAPOData, ok); err != nil {
			return err
		}
	}

	if v.ServiceNow != nil {
		ok := object.Key("ServiceNow")
		if err := awsRestjson1_serializeDocumentServiceNowSourceProperties(v.ServiceNow, ok); err != nil {
			return err
		}
	}

	if v.Singular != nil {
		ok := object.Key("Singular")
		if err := awsRestjson1_serializeDocumentSingularSourceProperties(v.Singular, ok); err != nil {
			return err
		}
	}

	if v.Slack != nil {
		ok := object.Key("Slack")
		if err := awsRestjson1_serializeDocumentSlackSourceProperties(v.Slack, ok); err != nil {
			return err
		}
	}

	if v.Trendmicro != nil {
		ok := object.Key("Trendmicro")
		if err := awsRestjson1_serializeDocumentTrendmicroSourceProperties(v.Trendmicro, ok); err != nil {
			return err
		}
	}

	if v.Veeva != nil {
		ok := object.Key("Veeva")
		if err := awsRestjson1_serializeDocumentVeevaSourceProperties(v.Veeva, ok); err != nil {
			return err
		}
	}

	if v.Zendesk != nil {
		ok := object.Key("Zendesk")
		if err := awsRestjson1_serializeDocumentZendeskSourceProperties(v.Zendesk, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceFields(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSourceFlowConfig(v *types.SourceFlowConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiVersion != nil {
		ok := object.Key("apiVersion")
		ok.String(*v.ApiVersion)
	}

	if v.ConnectorProfileName != nil {
		ok := object.Key("connectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("connectorType")
		ok.String(string(v.ConnectorType))
	}

	if v.IncrementalPullConfig != nil {
		ok := object.Key("incrementalPullConfig")
		if err := awsRestjson1_serializeDocumentIncrementalPullConfig(v.IncrementalPullConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceConnectorProperties != nil {
		ok := object.Key("sourceConnectorProperties")
		if err := awsRestjson1_serializeDocumentSourceConnectorProperties(v.SourceConnectorProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSuccessResponseHandlingConfig(v *types.SuccessResponseHandlingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTask(v *types.Task, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorOperator != nil {
		ok := object.Key("connectorOperator")
		if err := awsRestjson1_serializeDocumentConnectorOperator(v.ConnectorOperator, ok); err != nil {
			return err
		}
	}

	if v.DestinationField != nil {
		ok := object.Key("destinationField")
		ok.String(*v.DestinationField)
	}

	if v.SourceFields != nil {
		ok := object.Key("sourceFields")
		if err := awsRestjson1_serializeDocumentSourceFields(v.SourceFields, ok); err != nil {
			return err
		}
	}

	if v.TaskProperties != nil {
		ok := object.Key("taskProperties")
		if err := awsRestjson1_serializeDocumentTaskPropertiesMap(v.TaskProperties, ok); err != nil {
			return err
		}
	}

	if len(v.TaskType) > 0 {
		ok := object.Key("taskType")
		ok.String(string(v.TaskType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTaskPropertiesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTasks(v []types.Task, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTask(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTokenUrlCustomProperties(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTrendmicroConnectorProfileCredentials(v *types.TrendmicroConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiSecretKey != nil {
		ok := object.Key("apiSecretKey")
		ok.String(*v.ApiSecretKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentTrendmicroConnectorProfileProperties(v *types.TrendmicroConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentTrendmicroSourceProperties(v *types.TrendmicroSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentTriggerConfig(v *types.TriggerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TriggerProperties != nil {
		ok := object.Key("triggerProperties")
		if err := awsRestjson1_serializeDocumentTriggerProperties(v.TriggerProperties, ok); err != nil {
			return err
		}
	}

	if len(v.TriggerType) > 0 {
		ok := object.Key("triggerType")
		ok.String(string(v.TriggerType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTriggerProperties(v *types.TriggerProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Scheduled != nil {
		ok := object.Key("Scheduled")
		if err := awsRestjson1_serializeDocumentScheduledTriggerProperties(v.Scheduled, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpsolverDestinationProperties(v *types.UpsolverDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("bucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.S3OutputFormatConfig != nil {
		ok := object.Key("s3OutputFormatConfig")
		if err := awsRestjson1_serializeDocumentUpsolverS3OutputFormatConfig(v.S3OutputFormatConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpsolverS3OutputFormatConfig(v *types.UpsolverS3OutputFormatConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationConfig != nil {
		ok := object.Key("aggregationConfig")
		if err := awsRestjson1_serializeDocumentAggregationConfig(v.AggregationConfig, ok); err != nil {
			return err
		}
	}

	if len(v.FileType) > 0 {
		ok := object.Key("fileType")
		ok.String(string(v.FileType))
	}

	if v.PrefixConfig != nil {
		ok := object.Key("prefixConfig")
		if err := awsRestjson1_serializeDocumentPrefixConfig(v.PrefixConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVeevaConnectorProfileCredentials(v *types.VeevaConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentVeevaConnectorProfileProperties(v *types.VeevaConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentVeevaSourceProperties(v *types.VeevaSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentType != nil {
		ok := object.Key("documentType")
		ok.String(*v.DocumentType)
	}

	if v.IncludeAllVersions {
		ok := object.Key("includeAllVersions")
		ok.Boolean(v.IncludeAllVersions)
	}

	if v.IncludeRenditions {
		ok := object.Key("includeRenditions")
		ok.Boolean(v.IncludeRenditions)
	}

	if v.IncludeSourceFiles {
		ok := object.Key("includeSourceFiles")
		ok.Boolean(v.IncludeSourceFiles)
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentZendeskConnectorProfileCredentials(v *types.ZendeskConnectorProfileCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("clientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.OAuthRequest != nil {
		ok := object.Key("oAuthRequest")
		if err := awsRestjson1_serializeDocumentConnectorOAuthRequest(v.OAuthRequest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentZendeskConnectorProfileProperties(v *types.ZendeskConnectorProfileProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceUrl != nil {
		ok := object.Key("instanceUrl")
		ok.String(*v.InstanceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentZendeskDestinationProperties(v *types.ZendeskDestinationProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorHandlingConfig != nil {
		ok := object.Key("errorHandlingConfig")
		if err := awsRestjson1_serializeDocumentErrorHandlingConfig(v.ErrorHandlingConfig, ok); err != nil {
			return err
		}
	}

	if v.IdFieldNames != nil {
		ok := object.Key("idFieldNames")
		if err := awsRestjson1_serializeDocumentIdFieldNameList(v.IdFieldNames, ok); err != nil {
			return err
		}
	}

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	if len(v.WriteOperationType) > 0 {
		ok := object.Key("writeOperationType")
		ok.String(string(v.WriteOperationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentZendeskSourceProperties(v *types.ZendeskSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("object")
		ok.String(*v.Object)
	}

	return nil
}
