// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmsap

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ssmsap/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Register an SAP application with AWS Systems Manager for SAP. You must meet the
// following requirements before registering. The SAP application you want to
// register with AWS Systems Manager for SAP is running on Amazon EC2. AWS Systems
// Manager Agent must be setup on an Amazon EC2 instance along with the required
// IAM permissions. Amazon EC2 instance(s) must have access to the secrets created
// in AWS Secrets Manager to manage SAP applications and components.
func (c *Client) RegisterApplication(ctx context.Context, params *RegisterApplicationInput, optFns ...func(*Options)) (*RegisterApplicationOutput, error) {
	if params == nil {
		params = &RegisterApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterApplication", params, optFns, c.addOperationRegisterApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterApplicationInput struct {

	//
	//
	// This member is required.
	ApplicationId *string

	//
	//
	// This member is required.
	ApplicationType types.ApplicationType

	//
	//
	// This member is required.
	Credentials []types.ApplicationCredential

	//
	//
	// This member is required.
	Instances []string

	//
	SapInstanceNumber *string

	//
	Sid *string

	//
	Tags map[string]string

	noSmithyDocumentSerde
}

type RegisterApplicationOutput struct {

	//
	Application *types.Application

	//
	OperationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRegisterApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRegisterApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRegisterApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ssm-sap",
		OperationName: "RegisterApplication",
	}
}
